Summary   	: Synchronizes system time using the Network Time Protocol (NTP).
Name	  	: ntp
Version	  	: 4.1.2
Release	  	: 1.0.0.%{_hhl_build_id}
Source	  	: ntp-%{version}.tar.gz 
Source1		: ntp.tmpl
Source2		: configure-ntp
Patch		: ntp_4.1.1b-4.diff.gz
Patch2		: ntp-hhl.diff
Patch3		: mvl-ntp-xtensa.patch
Patch4		: ntp-autotools.diff
License 	: Other
Group	  	: System Environment/Daemons
Buildroot 	: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix	  	: %{_hhl_cross_target_dir}
%define _defaultdocdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

#
#	SRPM
#
Obsoletes : hhl-target-ntp
Obsoletes : hhl-%{_hhl_target_arch}-ntp

%description

The Network Time Protocol (NTP) is used to synchronize a computer's
time with another reference time source.  The ntp package contains
utilities and daemons which will synchronize your computer's time to
Coordinated Universal Time (UTC) via the NTP protocol and NTP servers.
The ntp package includes ntpdate (a program for retrieving the date
and time from remote machines via a network) and ntpd (a daemon which
continuously adjusts system time).

Install the ntp package if you need tools for keeping your system's
time synchronized via the NTP protocol.

#
#	RPM
#


%prep

%target_check
%setup -n ntp-%{version}
%patch -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1


%build
PATH=%{_hhl_cross_bin_dir}:$PATH

%target_setup

%target_acplatvars
export ac_cv_sizeof_signed_char=1
%if "%{_hhl_target_cpu_type}" == "mips"
export ac_cv_func_timer_create=no
export ac_cv_func_timer_settime=no
%endif

%target_configure
cp config.h ../include/
make CC="$CC -I../../include -DCLOCK_REALTIME=0"


%install
%target_setup
PATH=%{_hhl_cross_bin_dir}:$PATH
rm -rf %{buildroot}

%target_makeinstall bindir=%{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
cd ..
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/bin/
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1
        for file in ntpq ntpdc ntptrace; do \
                mv %{buildroot}%{_hhl_cross_target_dir}/usr/sbin/$file %{buildroot}%{_hhl_cross_target_dir}/usr/bin/$file; \
        done
        install -m 0755 %{SOURCE2} \
                %{buildroot}%{_hhl_cross_target_dir}/usr/sbin/configure-ntp
        install -m 0644 debian/ntpdate.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpdate.1
        install -m 0644 debian/useless.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntptimeset.1
        install -m 0644 debian/ntpd.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpd.1
        install -m 0644 debian/useless.1 \
                %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man1/ntpdc.1

install -d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d
install -d %{buildroot}%{_hhl_cross_target_dir}/etc/cron.weekly
install -d %{buildroot}%{_hhl_cross_target_dir}/etc/cron.daily
install debian/ntp-simple.init.d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d/ntp
install debian/ntp-simple.cron.weekly %{buildroot}%{_hhl_cross_target_dir}/etc/cron.weekly/ntp
install debian/ntp-simple.cron.daily %{buildroot}%{_hhl_cross_target_dir}/etc/cron.daily/ntp
install debian/ntpdate.init.d %{buildroot}%{_hhl_cross_target_dir}/etc/init.d/ntpdate
gzip -9f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*

cp COPYRIGHT LICENSE


install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ntp

%clean
rm -rf %{buildroot}


%files -n ntp
%defattr(-,root,root)
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.daily/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/cron.weekly/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ntp
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/init.d/ntpdate
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntpdc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntpq
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/ntptrace
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/configure-ntp
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntpd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntp-wait
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntp-genkeys
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntpdate
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntptime
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/ntptimeset
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tickadj
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpd.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpdate.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntpdc.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/ntptimeset.1.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ntp


%changelog
* Mon Jun 03 2002 Joe Green <source@mvista.com>
- Added support for Xtensa architecture.

* Fri Apr 20 2001 Steve Kinneberg <source@mvista.com>
- Added TCT package description files

* Sun Apr 08 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file


