/*
 * cache_test.c
 *
 * This file provides some simple testing of the XScale cache locking code
 *
 * Author: Deepak Saxena <dsaxena@mvista.com>
 *
 * Copyright 2000-2001 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/kernel.h>
#include <linux/cache.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <asm/system.h>
#include <asm/pgtable.h>
#include <asm/hardware.h>
#include <asm/cpu-single.h>
#include <asm/xscale-lock.h>
#include <asm/proc/cache.h>
#include <asm/xscale-pmu.h>

/*
 * The test code is pretty simple.  We allocate a 4096 byte array and
 * than do strides across the array while it locked and unlocked in 
 * cache. We do 100 iterations of the stride loop and in between 
 * each iteration the caches are cleaned/invalidated.  When the data
 * is locked into the cache, the clean/invalidate has no affect,
 * so we should see fewer cache misses.  For the icache test, the
 * loop has been unrolled for 1024 iterations and we just call it
 * with icache locking turned on and off.
 *
 * On my test system (Cyclone IQ-80310), I got the following results:
 *
 * DCACHE
 *
 *              Clock Cycles      Dcache Accesses   Dcache Misses
 * Unlocked     2583673           13186             12982
 * Locked       1322741           12812             12
 *
 * ICACHE
 *
 *              Clock Cycles      Icache Accesses   Icache Misses
 * Unlocked     9571243           1001979           74395
 * Locked       3295418           1001448           499
 *
 * Note that to run this test code, you need to build support for the
 * XScale Performance Monitoring Unit into your kernel.
 *
 */


/*
 * Align the following code
 *
 * It's long and ugly but it usefull to show the benefits of the 
 * cache locking.
 */
asm(".text\n\t.align 5");
void __init icache_test_fn(u8 *dst , u8* src)
{
	int i = 0;

	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
	dst[i+2048] = src[i];
	i++;
}

/*
 * Dummy aligned function is needed to properly calculate length
 * of the above function when calling the cache locking routine
 */
asm(".text\n\t.align 5");
void __init cache_lock_fn_dummy(void)
{
	return;
}

/*
 * Here's the meat of the test code
 */
int __init cache_lock_test(void)
{
	u8 *pfoo;
	unsigned long foo = pmu_claim();
	struct pmu_results results;
	int i = 0;
	int j = 0;

	printk("XScale Cache Lock testing code\n");

       	pfoo = (u8*)kmalloc(1024 * 4, GFP_ATOMIC);

	if(!pfoo) { printk("!pfoo\n"); return 0; }
	if(!foo) { printk("!foo"); return 0; }

	printk("   DCACHE stride from 0->4K no locking\n");
	
	pmu_start(EVT_DCACHE_ACCESS, EVT_DCACHE_MISS);
	for(i = 0; i < 2048; i+=32)
		pfoo[i+2048] = pfoo[i];
	pmu_stop(&results);
	printk("               CCNT: %d\n", results.ccnt);
	printk("      DCACHE ACCESS: %d\n", results.pmn0);
	printk("        DCACHE MISS: %d\n", results.pmn1);

	printk("   Flushing cache\n");
	printk("   DCACHE stride from 0->4K, 100, times, flush in between, no locking\n");
	cpu_cache_clean_invalidate_all();
	
	pmu_start(EVT_DCACHE_ACCESS, EVT_DCACHE_MISS);
	for(j = 0; j < 100; j++ )	
	{
		for(i = 0; i < 2048; i+=32)
			pfoo[i+2048] = pfoo[i];
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);
	printk("               CCNT: %d\n", results.ccnt);
	printk("      DCACHE ACCESS: %d\n", results.pmn0);
	printk("        DCACHE MISS: %d\n", results.pmn1);

	printk("   Locking data\n");
	if(cache_lock(pfoo, 4 * 1024, DCACHE, NULL))
	{
		printk("CACHE LOCK FAILED!\n");
		goto icache_test;
	}
	printk("   Flushing cache\n");
	printk("   DCACHE stride from 0->4K locked\n");
	cpu_cache_clean_invalidate_all();
	
	pmu_start(EVT_DCACHE_ACCESS, EVT_DCACHE_MISS);
	for(j = 0; j < 100; j++ )	
	{
		for(i = 0; i < 2048; i+=32)
			pfoo[i+2048] = pfoo[i];
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);
	printk("               CCNT: %d\n", results.ccnt);
	printk("      DCACHE ACCESS: %d\n", results.pmn0);
	printk("        DCACHE MISS: %d\n", results.pmn1);


	printk("   Unlocking data\n");
	cache_unlock(pfoo);
	printk("   Flushing cache and running loop again\n");
	cpu_cache_clean_invalidate_all();

	pmu_start(EVT_DCACHE_ACCESS, EVT_DCACHE_MISS);
	for(j = 0; j < 100; j++ )	
	{
		for(i = 0; i < 2048; i+=32)
			pfoo[i+2048] = pfoo[i];
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);

	printk("               CCNT: %d\n", results.ccnt);
	printk("      DCACHE ACCESS: %d\n", results.pmn0);
	printk("        DCACHE MISS: %d\n", results.pmn1);

	printk("    DCACHE Testing Complete\n");

icache_test:
	printk("    ICACHE Testing\n");
	printk("       Flushing cache, calling fn\n");
	cpu_cache_clean_invalidate_all();
	pmu_start(EVT_INSTRUCTION, EVT_ICACHE_MISS);
	icache_test_fn(pfoo, pfoo+2048);
	pmu_stop(&results);	

	printk("               CCNT: %d\n", results.ccnt);
	printk("      ICACHE ACCESS: %d\n", results.pmn0);
	printk("        ICACHE MISS: %d\n", results.pmn1);

	printk("      Calling fn 100 times, clean/invalidate in between\n");
	cpu_cache_clean_invalidate_all();
	pmu_start(EVT_INSTRUCTION, EVT_ICACHE_MISS);
	for(j = 0; j < 100; j++)
	{
		icache_test_fn(pfoo, pfoo+2048);
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);	

	printk("               CCNT: %d\n", results.ccnt);
	printk("      ICACHE ACCESS: %d\n", results.pmn0);
	printk("        ICACHE MISS: %d\n", results.pmn1);

	printk("      Locking code into cache\n");
	if(cache_lock(icache_test_fn, (u32)cache_lock_fn_dummy - (u32)icache_test_fn, ICACHE, NULL))
	{
		printk("   Cache locking FAILED!\n");
		goto exit;
	}
	
	printk("      Calling fn 100 times, clean/invalidate in between\n");
	cpu_cache_clean_invalidate_all();
	pmu_start(EVT_INSTRUCTION, EVT_ICACHE_MISS);
	for(j = 0; j < 100; j++)
	{
		icache_test_fn(pfoo, pfoo+2048);
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);	

	printk("               CCNT: %d\n", results.ccnt);
	printk("      ICACHE ACCESS: %d\n", results.pmn0);
	printk("        ICACHE MISS: %d\n", results.pmn1);

	printk("      Unlocking fn\n");
	cache_unlock(icache_test_fn);

	printk("      Calling fn 100 times, clean/invalidate in between\n");
	cpu_cache_clean_invalidate_all();
	pmu_start(EVT_INSTRUCTION, EVT_ICACHE_MISS);
	for(j = 0; j < 100; j++)
	{
		icache_test_fn(pfoo, pfoo+2048);
		cpu_cache_clean_invalidate_all();
	}
	pmu_stop(&results);	

	printk("               CCNT: %d\n", results.ccnt);
	printk("      ICACHE ACCESS: %d\n", results.pmn0);
	printk("        ICACHE MISS: %d\n", results.pmn1);

	printk("   ICACHE Testing Complete\n");

exit:
	printk("Cache Testing Complete\n");

	pmu_release(foo);
	return 0;
}

/*
 * We hook into the initcall loop and get run at initialization time
 * and than dissaper forever.
 */
__initcall(cache_lock_test);

