/* ------------------------------
  Set CheckSum for Bootcode Image
  Composed by Inada.
------------------------------ */
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#include "../../../../../include/buffalo/bootinfo.h"
// ----------------------------------------------------
unsigned short ver_major,ver_minor;
unsigned long  total_size;
unsigned long  checksum;
// ----------------------------------------------------
struct lineinfo {
	char index[16];
	int  id;
	};

#define INFO_VERSION     0x04
#define INFO_ALL         INFO_VERSION

static struct lineinfo info[]={
	{"BOOTVER" ,        INFO_VERSION},
	{"",0x00},
	};
// ----------------------------------------------------
#define STRBUFF_MAX 256*4

/* usage 
   setsum config_file target_file
*/
struct firminfo *information;
unsigned long    information_size;
#if __BYTE_ORDER == __BIG_ENDIAN
#define l2bl(a) a
#define l2bs(a) a
#else
// ----------------------------------------------------
// Little -> Big 
#define l2bl(a) \
	((a & 0xff000000) >> 24) + \
	((a & 0x00ff0000) >> 8 ) + \
	((a & 0x0000ff00) << 8 ) + \
	((a & 0x000000ff) << 24)
#define l2bs(a) \
	((a & 0xff00) >> 8 ) + \
	((a & 0x00ff) << 8)
// ----------------------------------------------------
#endif

void print_usage() 
	{
	int i=0;
	printf("Check sum calicurate mode -----\n");
	printf("    Usage:setsum targetfile\n");
	printf("Add information header mode ---\n");
	printf("    Usage:setbootsum configfile bootfile\n");
	printf("Support infomation tag:\n    ");
	while(info[i].id!=0) {printf("[%s] ",info[i].index);i++;}
	printf("\n");
	return;
	}
void print_info() 
	{
	printf("Bootcode  Version:%d.%d\n",ver_major,ver_minor);
	printf("             Size:%ld\n",   total_size);
	printf("         CheckSum:%08lX\n",   checksum);
	}

void error(char* mes)
	{
	printf("Error:");printf(mes);printf("\n");
	}
void strtrim(char* s)
	{
	int i = strlen(s)-1;
	if(i<0) return;
	while((s[i]==' '||s[i]=='\t') && i>=0) {s[i]='\0';i--;}
	}
void atoA(char* str) 
	{
	while(*str!=0){
		if(*str>='a' && *str<='z') *str = *str-'a'+'A';
		str++;
		}
	}
int atoL(char* str,unsigned long* req)
	{
	int ishex = 0;
	*req = 0;
	if(strlen(str)>2 && str[0]=='0' && str[1]=='X') {
		ishex = 1;
		str  += 2;
		}
	while((*str>='0' && *str<='9') || (ishex && *str>='A' && *str<='F')) {
		if(ishex) *req *= 0x10; else *req *= 10;
		if(*str>='0' && *str<='9') *req += *str-'0';
		if(*str>='A' && *str<='Z') *req += *str-'A'+10;
		str++;
		}
	if(*str!='\0') return(-1);
	return 0;
	}
// ----------------------------------------------------
int setparam(int id,char* cmd)
	{
	unsigned long  val;
	//int            i;
	char           *major,*minor;
	
	switch(id) {
		case INFO_VERSION:
			major  = cmd;
			minor = NULL;
			while(*cmd!='\0') {
				if(*cmd=='.') {minor = cmd+1;*cmd='\0';break;}
				cmd++;
				}
			if(minor == NULL) {
				error("Firm Version incorrect format!");
				return(-1);
				}
			if(atoL(major,&val) || val>99) {
				error("Firm Major Version incorrect format!");
				return(-1);
				}
			ver_major = (unsigned short)val;
			if(atoL(minor,&val) || val>99) {
				error("Firm minor Version incorrect format!");
				return(-1);
				}
			ver_minor = (unsigned short)val;
			break;
		default :
			return(-1);
		}
	return(0);
	}
// ----------------------------------------------------
int readconfig(char* filename)
	{
	FILE          *rfp;
	int           i,j,id;
	int           comp = 0;
	char tmp[STRBUFF_MAX+1],c,sep=0;
	char *index,*command;
	if((rfp = fopen(filename,"r"))==NULL) {
		error("can't open config file!");
		return(-1);
		}
	// line read -----
	while(comp != INFO_ALL) {
		if(fgets(tmp,STRBUFF_MAX,rfp) == NULL) break;
		index   = NULL;
		command = NULL;
		i=0;j=0;
		while(tmp[i]!='\0' && j<4) {
			c = tmp[i];
			switch(j) {
				case 0:
					if((c>='A' && c<='Z') || (c>='a' && c<='z') || (c>='0' && c<='9') || (c=='_')) {
						j++;
						index = &(tmp[i]);
						}
					break;
				case 1:
					if(c=='=') {
						j++;
						tmp[i]='\0';
						}
					if(c>='a' && c<='z') tmp[i] = tmp[i]-'a'+'A';
					break;
				case 2:
					if(c=='"' || c=='\'') {
						sep = c;
						j++;
						tmp[i]='\0';
						}
					break;
				case 3:
					if(c == sep) {
						j++;
						tmp[i]='\0';
						}
					else if(command == NULL) command=&(tmp[i]);
					break;
				}
			++i;
			}
		if(j<4 || index == NULL || command == NULL) continue;
		strtrim(index);
		i = 0;
		id = 0;
		while(info[i].id != 0) {
			if(strcmp(info[i].index,index)==0) {id = info[i].id;break;}
			++i;
			}
		if(id == 0) printf("Warning!:unknown index:%s\n",index);
		else if(setparam(id,command)==0) comp = comp | id;
		}
	if(comp != INFO_ALL) {
		error("incorrect config file!");
		return(-1);
		}
	return 0;
	}
// ----------------------------------------------------
unsigned long chksum(unsigned long nowsum,unsigned char* addr,unsigned long size)
	{
	unsigned long* laddr = (unsigned long*)addr;
	unsigned long  sum    = nowsum,
	               remain = 0;
	int i;
	while(size>=4) {
		sum += l2bl(*laddr);
		laddr++;
		size -= 4;
		}
	addr = (unsigned char*)laddr;
	for(i=0;i<4;++i) {
		remain = remain << 8;
		if(size>i) remain += *addr;
		addr++;
		}
	sum += remain;
	return sum;
	}
// ----------------------------------------------------
unsigned long get_filesize(char* name)
{
	struct stat   filestat;
	if(stat(name,&filestat)) {
		error("can't get target file size!");
		return(-1);
		}
	return (unsigned long)(filestat.st_size);
}

// ----------------------------------------------------
int setinfomation(char* infn,char* outfn) 
	{
	//struct stat   filestat;
	FILE          *rfp,*wfp;
	char          tmp[STRBUFF_MAX+1];
	unsigned long sum      = 0,
	              totallen = 0;
	long          len;
	
	//int           info_size;
	//int           file_size;
	struct bootinfo* info;
	unsigned long    version;
	
	// get long version 
	version = ((unsigned long)ver_major<<16)+((unsigned long)ver_minor);
	// open target file --
	if((rfp = fopen(infn,"r"))==NULL) {
		error("can't open target file!");
		return(-1);
		}
	// count sum from info header --
	sum     = 0;
	info    = NULL;
	// count sum from target file --
	while((len=fread(tmp,1,STRBUFF_MAX,rfp))!=0) {
		if(info == NULL) {
			info = (struct bootinfo*)tmp;
			info->version  = l2bl(version);
			info->size     = l2bl(total_size);
			info->checksum = 0;
			}
		totallen += len;
		sum = chksum(sum,(char*)tmp,len);
		}
	if(totallen != total_size) {
		error("Panic! Read size != infomation file!");
		fclose(rfp);
		return(-1);
		}
	// sum܂ŌvZ0ɂȂlɂ炵
	sum      = (0xffffffff-sum)+1;
	checksum = sum;
	
	// ۂɏ݊Jn
	if(fseek(rfp,0L,SEEK_SET)) {
		error("Target file seeking fail!");
		fclose(rfp);
		return(-1);
		}
	
	if((wfp = fopen(outfn,"w"))==NULL) {
		error("can't open output file!");
		fclose(rfp);
		return(-1);
		}
	info    = NULL;
	while((len=fread(tmp,1,STRBUFF_MAX,rfp))!=0) {
		if(info == NULL) {
			info = (struct bootinfo*)tmp;
			info->version  = l2bl(version);
			info->size     = l2bl(total_size);
			info->checksum = l2bl(checksum);
			}
		if(fwrite((char*)tmp,1,len,wfp)<1) {
			error("can't copy output file from target!");
			fclose(wfp);
			fclose(rfp);
			return(-1);
			}
		}
	fclose(wfp);
	fclose(rfp);
	return(0);
	}
// ----------------------------------------------------
int viewsum(char* infn) 
	{
	//struct stat   filestat;
	FILE          *rfp;
	char          tmp[STRBUFF_MAX+1];
	long          sum      = 0;
	long          len;
	if((rfp = fopen(infn,"r"))==NULL) {
		error("can't open target file!");
		return(-1);
		}
	while((len=fread(tmp,1,STRBUFF_MAX,rfp))!=0) {
		sum = chksum(sum,(char*)tmp,len);
		}
	sum = -sum;
	printf("check sum = %08lX\n",sum);
	fclose(rfp);
	return(0);
	}
// ----------------------------------------------------
static char *dummyfilename = "./bootimg.bin";
//static char *tmpfilename   = "./bootimg.tmp";
// ----------------------------------------------------
int main(int argc, char *argv[])
	{
	char* bootfile   = NULL;
	char* outputfile = NULL;
	char* configfile = NULL;
	
	int    i,
	       infosize;
	//time_t     t;
	//struct tm* date;
	char * str;
	int    opt = 0;
	
	if(argc<2)  {print_usage();return(0);}
	if(argc==2) {viewsum((char*)argv[1]);return(0);}
	for(i=1;i<argc;++i) {
		str = (char*)argv[i];
		if(str[0] == '-') {
			switch(str[1]) {
				case 'o': 
				case 'O': 
					opt = 1;break;
				default:
					error("Invalid option!");printf("> %s\n",str);return(-1);
				}
			continue;
			}
		if(opt>0) {
			switch(opt) {
				case 1:outputfile  = str;break;
				}
			opt = 0;
			continue;
			}
		if(configfile == NULL) {configfile = str;continue;}
		if(bootfile == NULL)   {bootfile   = str;continue;}
		}
	
	if(configfile == NULL || bootfile == NULL) {print_usage();return(0);}
	if(outputfile == NULL) outputfile = dummyfilename;
	
	// CtH[VTCYvZ --
	i = sizeof(struct bootinfo);
	infosize = i/4;
	if((i%4)>0) infosize++;
	infosize *= 4;
	printf("Firm infomation struct size = %d %d\n",infosize,sizeof(short));
	
	// RtBOǂ݂ --
	printf("read config file:%s\n",configfile);
	if(readconfig(configfile)) return(-1);
	
	// u[gt@CTCY擾 --
	total_size = get_filesize(bootfile);
	printf("read boot file:%s(%ld bytes)\n",bootfile,total_size);
	
	if(setinfomation(bootfile,outputfile)) return(-1);
	
	print_info();
	printf("Done..\n");
	return 0;
	}
