/*
 *  LinkStation/TeraStation Micon control Driver (send only)
 *
 *  Copyright (C)  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#include <linux/config.h>

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/proc_fs.h>
#include <linux/miscdevice.h>

#include <asm/string.h>
#include <asm/io.h>
#include <asm/system.h>
#include <asm/uaccess.h>
#include <asm/serial.h>
#include <buffalo/miconcntl.h>	/* 2005.5.10 BUFFALO */

#define bzero(p,sz) memset(p,0,sz)

//#define DEBUG
//#define MICONMSG


#ifdef DEBUG
 #define TRACE(x) x
#else
 #define TRACE(x)
#endif


#if defined(CONFIG_BUFFALO_MICON_VER1) || defined(CONFIG_BUFFALO_MICON_VER2)
//--------------------------------------------------------------
//ppc only
static int MiconPortWrite(const unsigned char *buf, int count)
{
	int i;
	unsigned char ier;
	const unsigned port_ier=SANDPOINT_SERIAL_0+1;
	const unsigned port_lsr=SANDPOINT_SERIAL_0+5;
	const unsigned port_thr=SANDPOINT_SERIAL_0;
	
	#define TX_EMPTY 0x20
	
	ier = readb(port_ier);
	//printk("ier=%x\n",ier);
	writeb(0, port_ier);
	for (i=0; i<count; i++){
		unsigned int status, tmout = 1000000;
		do{
			status = readb(port_lsr);
			if (--tmout == 0)
				break;
		} while ((status & TX_EMPTY) != TX_EMPTY);
		//printk("status=%x tmout=%x\n",status,tmout);
		
		writeb(buf[i],port_thr);
	}
	writeb(ier,port_ier);
	mdelay(4);		//̃R}hƂ̊ԊuƂ
	
	return 0;
}
#endif

//--------------------------------------------------------------
static void miconCntl_SendCmd(unsigned char dat)
{
	unsigned char datas[4];
	TRACE(printk(">%s\n",__FUNCTION__));
	datas[0] = dat;
	datas[1] = dat;
	datas[2] = dat;
	datas[3] = dat;
	MiconPortWrite(datas,4);
}

//--------------------------------------------------------------
void miconCntl_Reboot(void)
{
#ifdef MICONMSG
	printk(">%s\n",__FUNCTION__);
#endif
	while (1){
		miconCntl_SendCmd('C');
		mdelay(200);
		miconCntl_SendCmd('G');
		mdelay(500);
	}
}

//--------------------------------------------------------------
void miconCntl_PowerOff(void)
{
#ifdef MICONMSG
	printk(">%s\n",__FUNCTION__);
#endif
	while (1){
		miconCntl_SendCmd('G');
		mdelay(500);
	}
}

//--------------------------------------------------------------
/*
 * Initialize driver.
 */
int __init BuffaloMiconV1_init (void)
{
	TRACE(printk(">%s\n",__FUNCTION__));
	printk("MICON V1 (C) BUFFALO INC. V.1.00 installed.\n"); 
	
	return 0;
}

//--------------------------------------------------------------
void BuffaloMiconV1_exit(void)
{
	TRACE(printk(">%s\n",__FUNCTION__));
	printk("MICON V1 removed.");
}

module_init(BuffaloMiconV1_init);
module_exit(BuffaloMiconV1_exit);
MODULE_LICENSE("GPL");

