/*
 * include/asm-ppc/sandpoint_serial.h
 * 
 * Definitions for Motorola SPS Sandpoint Test Platform
 *
 * Author: Mark A. Greer
 *         mgreer@mvista.com
 *
 * Copyright 2001 MontaVista Software Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 */

#ifndef __ASMPPC_SANDPOINT_SERIAL_H
#define __ASMPPC_SANDPOINT_SERIAL_H

#include <linux/config.h>

#ifndef CONFIG_BUFFALO_PLATFORM
#define SANDPOINT_SERIAL_0		0xfe0003f8
#define SANDPOINT_SERIAL_1		0xfe0002f8
#else
 #define SANDPOINT_SERIAL_0		0x80004500
 #define SANDPOINT_SERIAL_1		0x80004600
#endif

#ifdef CONFIG_SERIAL_MANY_PORTS
#define RS_TABLE_SIZE  64
#else
#define RS_TABLE_SIZE  2
#endif

#ifndef CONFIG_BUFFALO_PLATFORM

/* Rate for the 1.8432 Mhz clock for the onboard serial chip */
#define BASE_BAUD ( 1843200 / 16 )

#ifdef CONFIG_SERIAL_DETECT_IRQ
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST|ASYNC_AUTO_IRQ)
#else
#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST)
#endif

#define STD_SERIAL_PORT_DFNS \
        { 0, BASE_BAUD, SANDPOINT_SERIAL_0, 4, STD_COM_FLAGS, /* ttyS0 */ \
		iomem_base: (u8 *)SANDPOINT_SERIAL_0,			  \
		io_type: SERIAL_IO_MEM },				  \
        { 0, BASE_BAUD, SANDPOINT_SERIAL_1, 3, STD_COM_FLAGS, /* ttyS1 */ \
		iomem_base: (u8 *)SANDPOINT_SERIAL_1,			  \
		io_type: SERIAL_IO_MEM },

#else // CONFIG_BUFFALO_PLATFORM

#if defined(CONFIG_HGLAN) || defined(CONFIG_HTGL)
//#define BASE_BAUD ( 133000000 / 16)
#define BASE_BAUD ( 130942075 / 16)
#elif defined(CONFIG_HLAN) || defined(CONFIG_LAN)
#define BASE_BAUD ( 100000000 / 16)
#elif defined(CONFIG_HTGLSATA)
#define BASE_BAUD ( 131072000 / 16)
#else
 #error (unknown BUFFALO model.)
#endif

#define STD_COM_FLAGS (ASYNC_BOOT_AUTOCONF|ASYNC_SKIP_TEST)

#define STD_SERIAL_PORT_DFNS \
		{ 0, BASE_BAUD, SANDPOINT_SERIAL_1, 25, STD_COM_FLAGS,/* ttyS0 */ \
		type: PORT_16550A,                                            \
		xmit_fifo_size: 16,                                           \
		iomem_base: (u8 *)SANDPOINT_SERIAL_1,                         \
		io_type: SERIAL_IO_MEM },                                     \
		{ 0, BASE_BAUD, SANDPOINT_SERIAL_0, 24, STD_COM_FLAGS,/* ttyS1 */ \
		type: PORT_16550A,                                            \
		xmit_fifo_size: 16,                                           \
		iomem_base: (u8 *)SANDPOINT_SERIAL_0,                         \
		io_type: SERIAL_IO_MEM },

#endif //CONFIG_BUFFALO_PLATFORM

#define SERIAL_PORT_DFNS \
        STD_SERIAL_PORT_DFNS

#endif /* __ASMPPC_SANDPOINT_SERIAL_H */
