/*
 *  TeraStation FAN driver
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */
#include <linux/module.h>
#include <linux/config.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>
#include <linux/reboot.h>
#include <linux/smp_lock.h>
#include <linux/proc_fs.h>
#include <linux/init.h>
#include <asm/uaccess.h>

#include "buffalo/emc6d102.h"

/********************************/
ssize_t mel_fan_read(struct file *file, char *buf, size_t count, loff_t *ppos)
{
	__cli();
	printk("mel_fan_read\n");
	__sti();
	return 0;
}

/********************************/
ssize_t mel_fan_write(struct file *filp, const char *buf, size_t count, loff_t *offp)
{
	unsigned char val , val2, val3;

	__cli();
	val = simple_strtoul(buf, NULL, 16);
	val2 = simple_strtoul(buf+3, NULL, 16);
	val3 = melco_get_register(val);
	printk("set %02x address data %02x to %02x \n",val,val3,val2);
	melco_set_register(val,val2);
	__sti();

	return count;
}

/********************************/
static int mel_fan_read_proc(char *page, char **start, off_t off,
                             int count, int *eof, void *data)
{
	char *p = page;
	int len;
	//unsigned char address,val;
	unsigned int rpm;
	unsigned int v2p5,v1p8,v3,v5,v12;
	char temp;

#if 0 /* percent */
	v2p5 = 100 * (melco_get_register(0x20)) / 0xc0;
	v1p8 = 100 * (melco_get_register(0x21)) / 0xc0;
	v3   = 100 * (melco_get_register(0x22)) / 0xc0;
	v5   = 100 * (melco_get_register(0x23)) / 0xc0;
	v12  = 100 * (melco_get_register(0x24)) / 0xc0;
#endif
	v2p5 = melco_get_register(0x20) * 3320 / 255;
	v1p8 = melco_get_register(0x21) * 3000 / 255;
	v3   = melco_get_register(0x22) * 4380 / 255;
	v5   = melco_get_register(0x23) * 6640 / 255;
	v12  = melco_get_register(0x24) * 16000 / 255;
	temp = (char)(melco_get_register(0x26));

	rpm = melco_get_register(0x28) + (melco_get_register(0x29) << 8);
	if (rpm == 0xffff)
		rpm = 0; // fan stop
	else
		rpm = (unsigned int)(90000 * 60 / rpm);

	__cli();
	p += sprintf(p, "+2.5V=%01d.%03d\n", (v2p5/1000), (v2p5%1000));
	p += sprintf(p, "+1.8V=%01d.%03d\n", (v1p8/1000), (v1p8%1000));
	p += sprintf(p, "+3.3V=%01d.%03d\n", (v3/1000), (v3%1000));
	p += sprintf(p, "+5V=%01d.%03d\n", (v5/1000), (v5%1000));
	p += sprintf(p, "+12V=%02d.%03d\n", (v12/1000), (v12%1000));
	p += sprintf(p, "rpm=%u\n",rpm);
	p += sprintf(p, "temp.=%d\n",temp);
#if 0
	p += sprintf(p, "\nregister",temp);
	p += sprintf(p, "-- : 00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f");
	for(address = 0x10 ; address < 0xa0 ; address++){
		val = 	melco_get_register(address);
		if(!(address & 0x0f))	p += sprintf(p, "\n%02x :", address);
		p += sprintf(p, " %02x", val);
	}
	p += sprintf(p, "\n");
#endif
	__sti();
	len = (int) (p - page);
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	return len;
}

/********************************/
static int mel_fan_open(struct inode *inode, struct file *file)
{

	MOD_INC_USE_COUNT;

	return 0;
}


/********************************/
static int mel_fan_release(struct inode *inode, struct file *file)
{
	MOD_DEC_USE_COUNT;
	return 0;
}

/********************************/
static int mel_fan_ioctl(struct inode *inode, struct file *file,
	unsigned int cmd, unsigned long arg)
{
	switch (cmd) {
	default:
		return -ENOIOCTLCMD;
	}
}

/********************************/
static struct file_operations mel_fan_fops = {
	owner:		THIS_MODULE,
	read:		mel_fan_read,
	write:		mel_fan_write,
	ioctl:		mel_fan_ioctl,
	open:		mel_fan_open,
	release:	mel_fan_release,
};

/********************************/
static struct miscdevice mel_fan_miscdev = {
	minor:		FAN_MINOR,
	name:		"mel_fan",
	fops:		&mel_fan_fops,
};

static const char banner[] __initdata = KERN_INFO "BUFFALO INC. FAN driver ver 1.00\n";

/*******************************/
static int __init mel_fan_init(void)
{
	int ret;

	ret = misc_register(&mel_fan_miscdev);

	if (ret)
		return ret;
	
	create_proc_read_entry ("driver/fan", 0, 0, mel_fan_read_proc, NULL);

	printk(banner);

	return 0;
}

/********************************/
static void __exit mel_fan_exit(void)
{
	remove_proc_entry("driver/fan", NULL);
	misc_deregister(&mel_fan_miscdev);
}

module_init(mel_fan_init);
module_exit(mel_fan_exit);
