/*
 *
 *
 *    Copyright 2000-2002 MontaVista Software Inc.
 *      Author: MontaVista Software, Inc.
 *      	akuster@mvista.com <source@mvista.com>
 *
 *    "Portions of this file are partially based on earlier efforts by
 *    John F. Davis from IBM Corp"
 *
 *    Module name: rainier.c
 *
 *    Description:
 *      Architecture- / platform-specific boot-time initialization code for
 *      IBM PowerPC 4xx based boards. Adapted from original
 *      code from walnut.c
 *
 *      Revision:
 *      	1.0 - armin
 *		1.1 - John F. Davis
 *
 *      History:
 *		02/05/02 - initial work
 *
 * Please read the COPYING file for all license details.
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/smp.h>
#include <linux/threads.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/rtc.h>
#include <linux/serial.h>

#include <asm/system.h>
#include <asm/pci-bridge.h>
#include <asm/processor.h>
#include <asm/machdep.h>
#include <asm/page.h>
#include <asm/time.h>
#include <asm/io.h>
#include <asm/todc.h>
#include "rainier.h"

#undef DEBUG

#ifdef DEBUG
#define DBG(x...) printk(x)
#else
#define DBG(x...)
#endif

void *rainier_rtc_base;
unsigned int rainier_io_page;

void
*locate_rainier_io(void)
{
	unsigned int temp;

	temp = in_le32((void*)PPC405_PCI_CONFIG_ADDR) & PCI_CONFIG_ADDR_MASK;
	out_le32((void*)PPC405_PCI_CONFIG_ADDR,
			temp | PCI_CONFIG_CYCLE_ENABLE |PCI_BASE_ADDRESS_2);
	temp = in_le32((void*)PPC405_PCI_CONFIG_DATA);

	if (temp == (PCI_BASE_ADDRESS_MEM_CARD2 | PCI_BASE_ADDRESS_MEM_PREFETCH))
		return PPC_405RAINIER2_IO_PAGE;
	else
		return PPC_405RAINIER1_IO_PAGE;
}

int __init
ppc405_map_irq(struct pci_dev *dev, unsigned char idsel, unsigned char pin)
{
	static char pci_irq_table[][4] =
	    /*
	     *      PCI IDSEL/INTPIN->INTLINE
	     *      A       B       C       D
	     */
	{
		{28, 28, 28, 28},	/* IDSEL 1 - PCI slot 1 */
		{29, 29, 29, 29},	/* IDSEL 2 - PCI slot 2 */
		{30, 30, 30, 30},	/* IDSEL 3 - PCI slot 3 */
		{31, 31, 31, 31},	/* IDSEL 4 - PCI slot 4 */
	};

	const long min_idsel = 1, max_idsel = 4, irqs_per_slot = 4;
	return PCI_IRQ_TABLE_LOOKUP;
};

void __init
board_setup_arch(void)
{
	struct serial_struct serialreq = {0};

	serialreq.iomem_base = (void*)PPC405_UART0_IO_BASE;
	serialreq.iomem_base += rainier_io_page;
	serialreq.baud_base = BASE_BAUD;
	serialreq.irq = PPC405_UART0_INT;
	serialreq.flags = STD_COM_FLAGS;
	serialreq.io_type = SERIAL_IO_MEM;

        early_serial_setup(&serialreq);

	/* Setup plb/pci bridge macro IBM C12E514_PLB3_PCI */
	/* plb address 0x8000 0000 will be set to pci address 0x8000 0000 which
	   corresponds to PCI 9030 Dev 0x10 BAR4 */
	out_le32((void*)PMM1LA,0x80000000);
	out_le32((void*)PMM1MA,0xFFFE0001);    /* PLB range is 128KB */
	out_le32((void*)PMM1PCILA,0x80000000);
	out_le32((void*)PMM1PCIHA,0x00000000);

#if 0
	/*
	 * There is no m48t3x RTC code yet.  This is just a framework
	 * in case someone decides to support this piece of hardware.
	 */
	/* RTC step for the rainier */
	rainier_rtc_base = (void *) RAINIER_RTC_VADDR;
	TODC_INIT(TODC_TYPE_DS1743, rainier_rtc_base, rainier_rtc_base,
		  rainier_rtc_base, 8);
#endif
}

void __init
bios_fixup(struct pci_controller *hose, struct pcil0_regs *pcip)
{


#ifdef DEBUG
	int i;

	printk("ioremap PCLIO_BASE = 0x%x, 0x%08x\n", pcip,(unsigned long)PCIL_ADDR[0]);
	//printk("ioremap PCLIO_BASE = 0x%x\n", pcip);
	printk("PCI bridge regs before fixup \n");
	for (i = 0; i < 3; i++) {
		printk(" pmm%dma\t0x%x\n", i, in_le32(&(pcip->pmm[i].ma)));
		printk(" pmm%dla\t0x%x\n", i, in_le32(&(pcip->pmm[i].la)));
		printk(" pmm%dpcila\t0x%x\n", i, in_le32(&(pcip->pmm[i].pcila)));
		printk(" pmm%dpciha\t0x%x\n", i, in_le32(&(pcip->pmm[i].pciha)));
	}
	printk(" ptm1ms\t0x%x\n", in_le32(&(pcip->ptm1ms)));
	printk(" ptm1la\t0x%x\n", in_le32(&(pcip->ptm1la)));
	printk(" ptm2ms\t0x%x\n", in_le32(&(pcip->ptm2ms)));
	printk(" ptm2la\t0x%x\n", in_le32(&(pcip->ptm2la)));

#endif

}

void __init
board_io_mapping(void)
{
	io_block_mapping(RAINIER_IO_PAGE_INTERPOSER_PADDR,
			 RAINIER_IO_PAGE_INTERPOSER_VADDR,PAGE_SIZE , _PAGE_IO);

	io_block_mapping(RAINIER_IO_PAGE_PCI_PADDR,
			 RAINIER_IO_PAGE_PCI_VADDR,PAGE_SIZE , _PAGE_IO);
	
#if 0
	/*
	 * There is no m48t3x RTC code yet.  This is just a framework
	 * in case someone decides to support this piece of hardware.
	 */
	io_block_mapping(RAINIER_RTC_VADDR,
			 RAINIER_RTC_PADDR, RAINIER_RTC_SIZE, _PAGE_IO);
#endif

	rainier_io_page = (unsigned int) locate_rainier_io();
       
	io_block_mapping(rainier_io_page ,
			 rainier_io_page , PAGE_SIZE, _PAGE_IO);

}

void __init
board_setup_irq(void)
{
	mtdcr(DCRN_UIC_PR(UIC0), 0x9FFFFFFF);
	mtdcr(DCRN_UIC_TR(UIC0), 0x80000000); /*IRQ0 is edge sensitive*/
	mtdcr(DCRN_UIC_CR(UIC0), 0x00000000);
	mtdcr(DCRN_UIC_SR(UIC0), 0xFFFFFFFF);

}

void __init
board_init(void)
{
#if 0
	/*
	 * There is no m48t3x RTC code yet.  This is just a framework
	 * in case someone decides to support this piece of hardware.
	 */
	ppc_md.time_init	 	= m48t3x_time_init;
	ppc_md.set_rtc_time	 	= m48t3x_set_rtc_time;
	ppc_md.get_rtc_time	 	= m48t3x_get_rtc_time;
	ppc_md.time_init = todc_time_init;
	ppc_md.nvram_read_val = todc_direct_read_val;
	ppc_md.nvram_write_val = todc_direct_write_val;
#endif
}
