/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002, 2003 Motorola, Inc. All Rights Reserved.
 *
 */

#ifndef _MMA_DCT_INC_H_
#define _MMA_DCT_INC_H_

#include "mma_dct.h"

#define  MMA_DCTCTRL		(*((VUINT32*)(IO_ADDRESS(0x00222400))))
#define  MMA_DCTVER  		(*((VUINT32*)(IO_ADDRESS(0x00222404))))
#define  MMA_DCTIRQENA 		(*((VUINT32*)(IO_ADDRESS(0x00222408))))
#define  MMA_DCTIRQSTAT 	(*((VUINT32*)(IO_ADDRESS(0x0022240C))))
#define  MMA_DCTSRCADD  	(*((VUINT32*)(IO_ADDRESS(0x00222410))))
#define  MMA_DCTDESADD 		(*((VUINT32*)(IO_ADDRESS(0x00222414))))
#define	 MMA_DCTXOFF		(*((VUINT32*)(IO_ADDRESS(0x00222418))))
#define  MMA_DCTYOFF		(*((VUINT32*)(IO_ADDRESS(0x0022241C))))
#define  MMA_DCTXYCNT		(*((VUINT32*)(IO_ADDRESS(0x00222420))))
#define  MMA_DCTSKIP		(*((VUINT32*)(IO_ADDRESS(0x00222424))))
#define  MMA_DCTFIFO 		(*((VUINT32*)(IO_ADDRESS(0x00222500))))


/*regsiters for dma*/
#define DMA_DIMR		(*((VUINT32*)(IO_ADDRESS(0x209008))))
/*dma transmitting*/
#define DMA_SAR(channum)    (*((VUINT32*)(IO_ADDRESS(0x209080 + channum * 0x40))))
#define DMA_DAR(channum)    (*((VUINT32*)(IO_ADDRESS(0x209084 + channum * 0x40))))
#define DMA_CNTR(channum)   (*((VUINT32*)(IO_ADDRESS(0x209088 + channum * 0x40))))
#define DMA_CCR(channum)    (*((VUINT32*)(IO_ADDRESS(0x20908C + channum * 0x40))))
#define DMA_RSSR(channum)   (*((VUINT32*)(IO_ADDRESS(0x209090 + channum * 0x40))))
#define DMA_BLR(channum)    (*((VUINT32*)(IO_ADDRESS(0x209094 + channum * 0x40))))
#define DMA_RTOR(channum)   (*((VUINT32*)(IO_ADDRESS(0x209098 + channum * 0x40))))
#define DMA_BUCR(channum)   (*((VUINT32*)(IO_ADDRESS(0x209098 + channum * 0x40))))
#define DMA_WSRA 			(*((VUINT32*)(IO_ADDRESS(0x00209040))))
#define DMA_WSRB 			(*((VUINT32*)(IO_ADDRESS(0x0020904C))))
#define DMA_XSRA 			(*((VUINT32*)(IO_ADDRESS(0x00209044))))
#define DMA_XSRB 			(*((VUINT32*)(IO_ADDRESS(0x00209050))))
#define DMA_YSRA 			(*((VUINT32*)(IO_ADDRESS(0x00209048))))
#define DMA_YSRB 			(*((VUINT32*)(IO_ADDRESS(0x00209054))))
#define DMA_DCR 			(*((VUINT32*)(IO_ADDRESS(0x00209000))))

#define 	MMA_DCT_INTR_MODE	0
#define		MMA_DCT_IRQ		0x08

/*****************************************************/
//Macro definition for control reg setting
/*****************************************************/
#define DCT_RESET			0x00000020
#define DCT_BYPASS			0x00000010
#define DCT_DCT				0x00000002
#define DCT_START			0x00000001
#define DCT_CLK				0x00000040
#define DCT_XPOSE			0x00000080
/*****************************************************/
//Macro definition for interrupt enable
/*****************************************************/
#define DCT_ERR_IRQ_ENA				0x00000020
#define DCT_DMA_OUT_IRQ_ENA			0x00000010
#define DCT_DMA_IN_IRQ_ENA			0x00000008
#define DCT_DATA_OUT_IRQ_ENA		0x00000004
#define DCT_DATA_IN_IRQ_ENA			0x00000002
#define DCT_COMP_IRQ_ENA			0x00000001

/*****************************************************/
//Macro definition for interrupt setting
/*****************************************************/
#define DCT_FIFO_FULL_IRQ			0x00000020
#define DCT_FIFO_EMP_IRQ			0x00000010
#define DCT_OP_ERR_IRQ				0x00000008
#define DCT_DATA_OUT_IRQ			0x00000004
#define DCT_DATA_IN_IRQ				0x00000002
#define DCT_COMP_IRQ				0x00000001
/**********************************************
Macro definition for trans mode
**********************************************/
#define DCT_TRANS_DMA		0x02
#define DCT_TRANS_POLL		0x01
#define DCT_TRANS_INTR		0x00

/**********************************************
global variables
**********************************************/
BOOLEAN gDctComplete;
BOOLEAN gDctAvail;
struct DCT gDctSrc;
struct DCT gDctDest;
UINT8	gDctDmaInChannum;
UINT8	gDctDmaOutChannum;
UINT32  gDctTransCount;
UINT32  gDctTransBlock;
UINT32*  gDctSrcAddr;
UINT32*	 gDctSrcAddrDma;
UINT32*  gDctDestAddr;
UINT32*  gDctDestAddrDma;
UINT32   gDctDmaInCount;
UINT32   gDctDmaOutCount;
BOOLEAN gDctDmaFlag;
UINT8	gDctTransMode;
int gDctMajor;
dma_addr_t	gDctDmaAddr;//used for MC_MC consistent memory physical address
BOOLEAN gDctUseMC;

#endif
