/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002, 2003 Motorola, Inc. All Rights Reserved.
 *
 */
 
#ifndef	_MMA_MAC_H_INC_
#define _MMA_MAC_H_INC_
#include "mma_mac.h"

/**********************************************
Macro definition
**********************************************/
#define MAC_EN_CACHE	0x00000006
#define	MAC_EN_XINCR	0x20000000
#define MAC_EN_XLOAD	0x10000000
#define MAC_EN_XSIGN_ALT	0x04000000
#define MAC_EN_YINCR	0x00200000
#define MAC_EN_YLOAD	0x00100000
#define MAC_EN_YSIGN_ALT	0x00040000
#define MAC_EN_OP		0x00000001

#define MAC_OP_END_IRQ		0x00000008	//Mac operation complete
#define MAC_FIFO_EMP_IRQ	0x00000004  //Mac FIFO empty
#define MAC_FIFO_HALF_IRQ	0x00000002	//Mac FIFO half full
#define MAC_FIFO_FULL_IRQ	0x00000001  //Mac FIFO full
#define MAC_OP_ERR_IRQ		0x00000010

/**************************************/
//Macro for trans mode
/**************************************/
#define MAC_TRANS_DMA		0x02
#define MAC_TRANS_POLL		0x01
#define MAC_TRANS_INTR		0x00

/*********************************************
*global data declare
*********************************************/
UINT8	gMacTransMode;
UINT32	gMacDataRead;
BOOLEAN gMacAvail;

//struct Mac_Info	gMmaMacInfo;
struct Matrix gMmaMacXMatrix;
struct Matrix gMmaMacYMatrix;
struct Matrix gMmaMacResult;
UINT8 gMmaMacDmaChannum;
BOOLEAN gMmaMacDmaFlag; //to indicate if is now have channel
int MAC_MAJOR_DEV;
//these two flags are used for interrupt transfer
int gMmaMacEndFlag;
UINT32*		gMmaMacResultAddr;


/***********************************************
MMA register address
***********************************************/
//#define MMA_BASE_ADDR          0xF0222000
                              
#define MMA_MAC_MOD 		(*((VUINT32*)(IO_ADDRESS(0x00222000))))
#define MMA_MAC_CTRL  		(*((VUINT32*)(IO_ADDRESS(0x00222004))))
#define  MMA_MAC_MULT		(*((VUINT32*)(IO_ADDRESS(0x00222008))))
#define  MMA_MAC_ACCU		(*((VUINT32*)(IO_ADDRESS(0x0022200C))))
#define  MMA_MAC_INTR		(*((VUINT32*)(IO_ADDRESS(0x00222010))))
#define  MMA_MAC_INTR_MASK	(*((VUINT32*)(IO_ADDRESS(0x00222014))))
#define  MMA_MAC_FIFO		(*((VUINT32*)(IO_ADDRESS(0x00222018))))
#define  MMA_MAC_FIFO_STAT	(*((VUINT32*)(IO_ADDRESS(0x0022201C))))
#define  MMA_MAC_BURST		(*((VUINT32*)(IO_ADDRESS(0x00222020))))
#define  MMA_MAC_BIT_SEL	(*((VUINT32*)(IO_ADDRESS(0x00222024))))
//
#define  MMA_MAC_XBASE		(*((VUINT32*)(IO_ADDRESS(0x00222200))))
#define  MMA_MAC_XINDEX		(*((VUINT32*)(IO_ADDRESS(0x00222204))))
#define  MMA_MAC_XLENGTH	(*((VUINT32*)(IO_ADDRESS(0x00222208))))
#define  MMA_MAC_XMODIFY	(*((VUINT32*)(IO_ADDRESS(0x0022220C))))
#define  MMA_MAC_XINCR		(*((VUINT32*)(IO_ADDRESS(0x00222210))))
#define  MMA_MAC_XCOUNT		(*((VUINT32*)(IO_ADDRESS(0x00222214))))
//
#define  MMA_MAC_YBASE		(*((VUINT32*)(IO_ADDRESS(0x00222300))))
#define  MMA_MAC_YINDEX		(*((VUINT32*)(IO_ADDRESS(0x00222304))))
#define  MMA_MAC_YLENGTH	(*((VUINT32*)(IO_ADDRESS(0x00222308))))
#define  MMA_MAC_YMODIFY	(*((VUINT32*)(IO_ADDRESS(0x0022230C))))
#define  MMA_MAC_YINCR		(*((VUINT32*)(IO_ADDRESS(0x00222310))))
#define  MMA_MAC_YCOUNT		(*((VUINT32*)(IO_ADDRESS(0x00222314))))


/*regsiters for dma*/
#define DMA_DIMR		(*((VUINT32*)(IO_ADDRESS(0x209008))))
#define DMA_DISR		(*((VUINT32*)(IO_ADDRESS(0x209004))))
/*dma transmitting*/
#define DMA_SAR(channum)    (*((VUINT32*)(IO_ADDRESS((0x209080 + channum * 0x40)))))
#define DMA_DAR(channum)    (*((VUINT32*)(IO_ADDRESS((0x209084 + channum * 0x40)))))
#define DMA_CNTR(channum)   (*((VUINT32*)(IO_ADDRESS((0x209088 + channum * 0x40)))))
#define DMA_CCR(channum)    (*((VUINT32*)(IO_ADDRESS((0x20908C + channum * 0x40)))))
#define DMA_RSSR(channum)   (*((VUINT32*)(IO_ADDRESS((0x209090 + channum * 0x40)))))
#define DMA_BLR(channum)    (*((VUINT32*)(IO_ADDRESS((0x209094 + channum * 0x40)))))
#define DMA_RTOR(channum)   (*((VUINT32*)(IO_ADDRESS((0x209098 + channum * 0x40)))))
#define DMA_BUCR(channum)   (*((VUINT32*)(IO_ADDRESS((0x209098 + channum * 0x40)))))

/*************************************************
*Hardware Interrupt information
***************************************************/
#define MAC_INTR_MODE	0 //SA_SHIRQ | SA_INTERRUPT
#define MAC_IRQ			0x07


#endif
