/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002, 2003 Motorola, Inc. All Rights Reserved.
 *
 */

#ifndef _MMA_MAC_DD_H_INC_
#define _MMA_MAC_DD_H_INC_

#define MAC_CMD_SET_XMATRIX	0x2101
#define MAC_CMD_SET_YMATRIX 0x2102
#define MAC_CMD_SET_RESULT	0x2103
#define MAC_CMD_CONST_2D	0x2104
#define MAC_CMD_1D_1D		0x2105
#define MAC_CMD_1D_DEC		0x2106
#define MAC_CMD_1D_2D		0x2107
#define MAC_CMD_2D_2D 		0x2108
#define MAC_CMD_SCALE		0x2109
#define MAC_CMD_DCT64		0x210A

#define MAC_XHIGHBIT		0x08000000
#define MAC_YHIGHBIT		0x00080000
#define MAC_CACHEN			0x00000002

/*********************************************
* structure and typedef
**********************************************/

#ifndef BOOLEAN
typedef signed char BOOLEAN;
typedef unsigned char UINT8;
typedef signed char SINT8;
typedef unsigned short UINT16;
typedef signed short SINT16;
typedef unsigned long UINT32;
typedef signed long SINT32;

typedef volatile BOOLEAN VBOOLEAN;
typedef volatile UINT8 VUINT8;
typedef volatile SINT8 VSINT8;
typedef volatile UINT16 VUINT16;
typedef volatile SINT16 VSINT16;
typedef volatile UINT32 VUINT32;
typedef volatile SINT32 VSINT32;
#endif				/* BOOLEAN */

struct Matrix {
	UINT32 *baseaddr;	//The address got in kernel space
	UINT32 col;		//the column size
	UINT32 row;		//the row size
	UINT32 index;		//the index value to get the first item from the matrix
	UINT32 length;		//the total length of the matrix in the memory, based on byte
	UINT32 modify;		//the number of increment entries after each iteration
	UINT32 count;		//the number of interations before each reload
	UINT32 *ppos;		//the position of read pointer
	UINT8 altersign;
	UINT32 initsign;	//0 is positive,1 is negative
	UINT32 type;		//0 is unsigned,1 is signed
};

struct MAC_DCT64 {
	int *resultbase;	//the user space address
	int resultsize;
	int *ybase;		//y operand address
	int ysize;
};

#endif
