/*
 * $Id: physmap.c,v 1.28 2003/05/28 15:53:43 dwmw2 Exp $
 *
 * Normal mappings of chips in physical memory
 *
 * Copyright (C) 2003 MontaVista Software Inc.
 * Author: Jun Sun, jsun@mvista.com or jsun@junsun.net
 *
 * 031022 - [jsun] add run-time configure and partition setup
 */

#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <asm/io.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/config.h>
#include <linux/mtd/partitions.h>

static struct mtd_info *mymtd;

#ifdef CONFIG_BUFFALO_PLATFORM
// __LS_COMMENT__ BUFFALO change 2004.5.26
struct map_info physmap_map = {
	.name      = "linkstation_flash",
	.size      = 0x400000,
	.buswidth  = 1,
	.phys      = 0xFFC00000,
};
#else
struct map_info physmap_map = {.name = "phys_mapped_flash"};
#endif

#ifdef CONFIG_MTD_PARTITIONS
static struct mtd_partition *mtd_parts;
static int                   mtd_parts_nb;

#ifdef CONFIG_BUFFALO_PLATFORM
// __LS_COMMENT__ BUFFALO change 2004.5.26
int num_physmap_partitions = 5;
static struct mtd_partition physmap_partitions[] = {
	{
		.name   = "mtd0",
		.offset = 0x000000,
		.size   = 0x300000,
	},
	{
		.name   = "mtd1",
		.offset = 0x300000,
		.size   = 0x70000,
	},
	{
		.name   = "mtd2",
		.offset = 0x370000,
		.size   = 0x10000,
	},
	{
		.name   = "mtd3",
		.offset = 0x380000,
		.size   = 0x80000,
	},
	{
		.name   = "mtd4",
		.offset = 0x000000,
		.size   = 0x400000,
	}
};
char *part_probes[] __initdata = {NULL};
#else
static int num_physmap_partitions;
static struct mtd_partition *physmap_partitions;

char *part_probes[] __initdata = {"cmdlinepart", "RedBoot", NULL};
#endif

void physmap_set_partitions(struct mtd_partition *parts, int num_parts)
{
#ifndef CONFIG_BUFFALO_PLATFORM
	// del for buffalo
	physmap_partitions=parts;
	num_physmap_partitions=num_parts;
#endif
}
#endif /* CONFIG_MTD_PARTITIONS */

int __init init_physmap(void)
{
#ifdef CONFIG_BUFFALO_PLATFORM
	static const char *rom_probe_types[] = {
 #ifdef CONFIG_MTD_CFI
	 "cfi_probe", 
 #endif
 #ifdef CONFIG_MTD_JEDECPROBE
	 "jedec_probe",
 #endif
 #ifdef CONFIG_MTD_ROM
	 "map_rom",
 #endif
	 0 };
#else
	static const char *rom_probe_types[] = { "cfi_probe", "jedec_probe", "map_rom", 0 };
#endif
	const char **type;

       	printk(KERN_NOTICE "physmap flash device: %lx at %lx\n", physmap_map.size, physmap_map.phys);
	physmap_map.virt = (unsigned long)ioremap(physmap_map.phys, physmap_map.size);

	if (!physmap_map.virt) {
		printk("Failed to ioremap\n");
		return -EIO;
	}

	simple_map_init(&physmap_map);

	mymtd = 0;
	type = rom_probe_types;
	for(; !mymtd && *type; type++) {
		mymtd = do_map_probe(*type, &physmap_map);
	}
	if (mymtd) {
		mymtd->owner = THIS_MODULE;

#ifdef CONFIG_MTD_PARTITIONS
		mtd_parts_nb = parse_mtd_partitions(mymtd, part_probes, 
						    &mtd_parts, 0);

		if (mtd_parts_nb > 0)
		{
			add_mtd_partitions (mymtd, mtd_parts, mtd_parts_nb);
			return 0;
		}

		if (num_physmap_partitions != 0) 
		{
			printk(KERN_NOTICE 
			       "Using physmap partition definition\n");
			add_mtd_partitions (mymtd, physmap_partitions, num_physmap_partitions);
			return 0;
		}

#endif
		add_mtd_device(mymtd);

		return 0;
	}

	iounmap((void *)physmap_map.virt);
	return -ENXIO;
}

static void __exit cleanup_physmap(void)
{
#ifdef CONFIG_MTD_PARTITIONS
	if (mtd_parts_nb) {
		del_mtd_partitions(mymtd);
		kfree(mtd_parts);
	} else if (num_physmap_partitions) {
		del_mtd_partitions(mymtd);
	} else {
		del_mtd_device(mymtd);
	}
#else
	del_mtd_device(mymtd);
#endif
	map_destroy(mymtd);

	iounmap((void *)physmap_map.virt);
	physmap_map.virt = 0;
}

module_init(init_physmap);
module_exit(cleanup_physmap);


MODULE_LICENSE("GPL");
MODULE_AUTHOR("David Woodhouse <dwmw2@infradead.org>");
MODULE_DESCRIPTION("Generic configurable MTD map driver");
