/*
 * drivers/mtd/maps/smvr4181a-flash.c
 *
 * FlashROM support for NECSMVR4181A (ITModule)
 *
 * 2002 (c) NEC Corporation. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <linux/config.h>
#ifndef CONFIG_NEC_SMVR4181A
#error This is for NEC SMVR418A board only
#else
#include <linux/init.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>

#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>

#include <asm/addrspace.h>
#include <asm/vr4181a/vr4181a.h>

#define WINDOW_ADDR	0x1e000000
#define WINDOW_SIZE	0x02000000

static void
smvr4181a_set_vpp(struct map_info *map, int vpp)
{
	vr4181a_set_gpio_mode(42, GPIO_OUTPUT, GPIO_INPUT_PROHIBIT);

	if (vpp)
		vr4181a_set_gpio_data(42, 1);
	else
		vr4181a_set_gpio_data(42, 0);
}

static struct map_info smvr4181a_map = {
	.name = "SMVR4181A on-board FlashROM",
	.buswidth = 2,
	.size = WINDOW_SIZE,
	.phys = WINDOW_ADDR,
	.virt = KSEG1ADDR(WINDOW_ADDR),
	set_vpp:smvr4181a_set_vpp,
	map_priv_1:WINDOW_ADDR
};

static unsigned long smvr4181a_max_flash_size = 0x02000000;

static struct mtd_partition smvr4181a_partitions[] = {
	{
	      name:"FlashROM",
	      offset:0x00000000,
	      size:0x01c00000,	/* 28M Byte */
	 },
#if 0
	{
	      name:"monitor",
	      offset:0x01c00000,
	      size:0x00100000,	/* 1M Byte */
	      mask_flags:MTD_CAP_ROM,
	 },
	{
	      name:"kernel",
	      offset:0x01d00000,
	      size:0x00300000,	/* 3M Byte */
	 },
#endif
};

#define NB_OF(x)	(sizeof(x)/sizeof(x[0]))

static struct mtd_info *mymtd;

static int __devinit
smvr4181a_mtd_init(void)
{
	struct mtd_partition *parts;
	int nb_parts = 0;

	parts = smvr4181a_partitions;
	nb_parts = NB_OF(smvr4181a_partitions);
	smvr4181a_map.size = smvr4181a_max_flash_size;

	mymtd = do_map_probe("cfi_probe", &smvr4181a_map);
	if (!mymtd)
		return -ENXIO;
	add_mtd_partitions(mymtd, parts, nb_parts);

	printk(KERN_INFO "SMVR181A flash access initialized\n");
	return 0;
}

static void __exit
smvr4181a_mtd_cleanup(void)
{
	if (mymtd) {
		del_mtd_partitions(mymtd);
		map_destroy(mymtd);
	}
}

module_init(smvr4181a_mtd_init);
module_exit(smvr4181a_mtd_cleanup);

#endif				/* CONFIG_NEC_SMVR4181A */
