/*
 * drivers/net/mb86977/camelot_ioctl.h
 *
 * Fujitsu MB86977 ioctl definitions
 *
 * Author: <source@mvista.com>
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

#if 0
#define CM_SET_IPF       _IO('i', 130)
#define CM_DEL_IPF       _IO('i', 131)
#define CM_SET_NAT       _IO('i', 132)
#define CM_DEL_NAT       _IO('i', 133)
#define CM_SET_FLT_IN    _IO('i', 134)
#define CM_DEL_FLT_IN    _IO('i', 135)
#define CM_SET_FLT_OUT   _IO('i', 136)
#define CM_DEL_FLT_OUT   _IO('i', 137)
#define CM_DEL_UNMATCH   _IO('i', 138)
#define CM_PPPOE	 _IO('i', 139)
#define CM_TUNNEL	 _IO('i', 140)

#define CM_FLUSH_FLT	 _IO('i', 150)
#define CM_FLUSH_IPF	 _IO('i', 151)
#define CM_FLUSH_NAT	 _IO('i', 152)
#define CM_FLUSH_PPPOE	 _IO('i', 153)
#define CM_FLUSH_TUNNEL	 _IO('i', 154)
#else
#define CM_SET_IPF       SIOCDEVPRIVATE+0
#define CM_DEL_IPF       SIOCDEVPRIVATE+1
#define CM_SET_NAT       SIOCDEVPRIVATE+2
#define CM_DEL_NAT       SIOCDEVPRIVATE+3
#define CM_SET_FLT_IN    SIOCDEVPRIVATE+4
#define CM_DEL_FLT_IN    SIOCDEVPRIVATE+5
#define CM_SET_FLT_OUT   SIOCDEVPRIVATE+6
#define CM_DEL_FLT_OUT   SIOCDEVPRIVATE+7
#define CM_DEL_UNMATCH   SIOCDEVPRIVATE+8
#define CM_PPPOE	 SIOCDEVPRIVATE+9
#define CM_TUNNEL	 SIOCDEVPRIVATE+10
#define CM_FLUSH	 SIOCDEVPRIVATE+11
#define CM_GET_MATCH	 SIOCDEVPRIVATE+12
#define CM_DEBUG_READ	 SIOCDEVPRIVATE+13
#define CM_SET_FLT_MODE	 SIOCDEVPRIVATE+14
#define CM_SET_DMZ	 SIOCDEVPRIVATE+15

/* ifru_ivalue values for CM_FLUSH */
#define FLUSH_FLT	1
#define FLUSH_IPF	2
#define FLUSH_NAT	3
#define FLUSH_PPPOE	4
#define FLUSH_TUNNEL	5

struct camelot_debug_read {
	int	what;
	int	index;
	void	*data;
};

enum {
	DEBUG_FILTER = 1,
	DEBUG_FILTER_COUNT,
	DEBUG_FILTER_LOG,
	DEBUG_IPFNAT,
	DEBUG_PPPOE,
	DEBUG_TUNNEL
};

#ifdef __KERNEL__
int camelot_ioctl(struct net_device *dev, struct ifreq *rq, int cmd);
#endif

#endif
