/*
 * net/fujitsu_camelot/camelot_reg.h
 *
 * Fujitsu MB86977 register definitions
 *
 * Author: <source@mvista.com>
 *
 * Copyright (c) 2002-2003 by Fujitsu LSI Solution Ltd..  All Rights Reserved.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

#ifndef _CAMELOT_REG_H_
#define _CAMELOT_REG_H_

/*   Camelot Bank Set   */
#define  CAME_BANK1 		0x1000	/*   RX Buffer   */
#define  CAME_BANK0		0x0000	/*   TX Buffer   */

/*   Camelot Registor OFFSET (Word Set)   */
#define  TTL0_BUF_f_OFFSET   	0x28bc
#define  TTL0_BUF_e_OFFSET   	0x28b8
#define  TTL0_BUF_d_OFFSET   	0x28b4
#define  TTL0_BUF_c_OFFSET   	0x28b0
#define  TTL0_BUF_b_OFFSET   	0x28ac
#define  TTL0_BUF_a_OFFSET   	0x28a8
#define  TTL0_BUF_9_OFFSET   	0x28a4
#define  TTL0_BUF_8_OFFSET   	0x28a0
#define  TTL0_BUF_7_OFFSET   	0x289c
#define  TTL0_BUF_6_OFFSET   	0x2898
#define  TTL0_BUF_5_OFFSET   	0x2894
#define  TTL0_BUF_4_OFFSET   	0x2890
#define  TTL0_BUF_3_OFFSET   	0x288c
#define  TTL0_BUF_2_OFFSET   	0x2888
#define  TTL0_BUF_1_OFFSET   	0x2884
#define  TTL0_BUF_0_OFFSET   	0x2880

#define  V4_HEADER_3_4_OFFSET   0x285c
#define  V4_HEADER_3_3_OFFSET   0x2858
#define  V4_HEADER_3_2_OFFSET   0x2854
#define  V4_HEADER_3_1_OFFSET   0x2850
#define  V4_HEADER_3_0_OFFSET   0x284c
#define  V4_HEADER_2_4_OFFSET   0x2848
#define  V4_HEADER_2_3_OFFSET   0x2844
#define  V4_HEADER_2_2_OFFSET   0x2840
#define  V4_HEADER_2_1_OFFSET   0x283c
#define  V4_HEADER_2_0_OFFSET   0x2838
#define  V4_HEADER_1_4_OFFSET   0x2834
#define  V4_HEADER_1_3_OFFSET   0x2830
#define  V4_HEADER_1_2_OFFSET   0x282c
#define  V4_HEADER_1_1_OFFSET   0x2828
#define  V4_HEADER_1_0_OFFSET   0x2824
#define  V4_HEADER_0_4_OFFSET   0x2820
#define  V4_HEADER_0_3_OFFSET   0x281c
#define  V4_HEADER_0_2_OFFSET   0x2818
#define  V4_HEADER_0_1_OFFSET   0x2814
#define  V4_HEADER_0_0_OFFSET   0x2810

#define  PPPOE_HEADER_3_OFFSET  0x280c
#define  PPPOE_HEADER_2_OFFSET  0x2808
#define  PPPOE_HEADER_1_OFFSET  0x2804
#define  PPPOE_HEADER_0_OFFSET  0x2800

#define  FILT_COUNT_1_3f_OFFSET	0x27fc
#define  FILT_COUNT_1_3e_OFFSET	0x27f8
#define  FILT_COUNT_1_3d_OFFSET	0x27f4
#define  FILT_COUNT_1_3c_OFFSET	0x27f0
#define  FILT_COUNT_1_3b_OFFSET	0x27ec
#define  FILT_COUNT_1_3a_OFFSET	0x27e8
#define  FILT_COUNT_1_39_OFFSET	0x27e4
#define  FILT_COUNT_1_38_OFFSET	0x27e0
#define  FILT_COUNT_1_37_OFFSET	0x27dc
#define  FILT_COUNT_1_36_OFFSET	0x27d8
#define  FILT_COUNT_1_35_OFFSET	0x27d4
#define  FILT_COUNT_1_34_OFFSET	0x27d0
#define  FILT_COUNT_1_33_OFFSET	0x27cc
#define  FILT_COUNT_1_32_OFFSET	0x27c8
#define  FILT_COUNT_1_31_OFFSET	0x27c4
#define  FILT_COUNT_1_30_OFFSET	0x27c0

#define  FILT_COUNT_1_2f_OFFSET	0x27bc
#define  FILT_COUNT_1_2e_OFFSET	0x27b8
#define  FILT_COUNT_1_2d_OFFSET	0x27b4
#define  FILT_COUNT_1_2c_OFFSET	0x27b0
#define  FILT_COUNT_1_2b_OFFSET	0x27ac
#define  FILT_COUNT_1_2a_OFFSET	0x27a8
#define  FILT_COUNT_1_29_OFFSET	0x27a4
#define  FILT_COUNT_1_28_OFFSET	0x27a0
#define  FILT_COUNT_1_27_OFFSET	0x279c
#define  FILT_COUNT_1_26_OFFSET	0x2798
#define  FILT_COUNT_1_25_OFFSET	0x2794
#define  FILT_COUNT_1_24_OFFSET	0x2790
#define  FILT_COUNT_1_23_OFFSET	0x278c
#define  FILT_COUNT_1_22_OFFSET	0x2788
#define  FILT_COUNT_1_21_OFFSET	0x2784
#define  FILT_COUNT_1_20_OFFSET	0x2780

#define  FILT_COUNT_1_1f_OFFSET	0x277c
#define  FILT_COUNT_1_1e_OFFSET	0x2778
#define  FILT_COUNT_1_1d_OFFSET	0x2774
#define  FILT_COUNT_1_1c_OFFSET	0x2770
#define  FILT_COUNT_1_1b_OFFSET	0x276c
#define  FILT_COUNT_1_1a_OFFSET	0x2768
#define  FILT_COUNT_1_19_OFFSET	0x2764
#define  FILT_COUNT_1_18_OFFSET	0x2760
#define  FILT_COUNT_1_17_OFFSET	0x275c
#define  FILT_COUNT_1_16_OFFSET	0x2758
#define  FILT_COUNT_1_15_OFFSET	0x2754
#define  FILT_COUNT_1_14_OFFSET	0x2750
#define  FILT_COUNT_1_13_OFFSET	0x274c
#define  FILT_COUNT_1_12_OFFSET	0x2748
#define  FILT_COUNT_1_11_OFFSET	0x2744
#define  FILT_COUNT_1_10_OFFSET	0x2740

#define  FILT_COUNT_1_f_OFFSET	0x273c
#define  FILT_COUNT_1_e_OFFSET	0x2738
#define  FILT_COUNT_1_d_OFFSET	0x2734
#define  FILT_COUNT_1_c_OFFSET	0x2730
#define  FILT_COUNT_1_b_OFFSET	0x272c
#define  FILT_COUNT_1_a_OFFSET	0x2728
#define  FILT_COUNT_1_9_OFFSET	0x2724
#define  FILT_COUNT_1_8_OFFSET	0x2720
#define  FILT_COUNT_1_7_OFFSET	0x271c
#define  FILT_COUNT_1_6_OFFSET	0x2718
#define  FILT_COUNT_1_5_OFFSET	0x2714
#define  FILT_COUNT_1_4_OFFSET	0x2710
#define  FILT_COUNT_1_3_OFFSET	0x270c
#define  FILT_COUNT_1_2_OFFSET	0x2708
#define  FILT_COUNT_1_1_OFFSET	0x2704
#define  FILT_COUNT_1_0_OFFSET	0x2700

#define  FILT_COUNT_0_3f_OFFSET	0x26fc
#define  FILT_COUNT_0_3e_OFFSET	0x26f8
#define  FILT_COUNT_0_3d_OFFSET	0x26f4
#define  FILT_COUNT_0_3c_OFFSET	0x26f0
#define  FILT_COUNT_0_3b_OFFSET	0x26ec
#define  FILT_COUNT_0_3a_OFFSET	0x26e8
#define  FILT_COUNT_0_39_OFFSET	0x26e4
#define  FILT_COUNT_0_38_OFFSET	0x26e0
#define  FILT_COUNT_0_37_OFFSET	0x26dc
#define  FILT_COUNT_0_36_OFFSET	0x26d8
#define  FILT_COUNT_0_35_OFFSET	0x26d4
#define  FILT_COUNT_0_34_OFFSET	0x26d0
#define  FILT_COUNT_0_33_OFFSET	0x26cc
#define  FILT_COUNT_0_32_OFFSET	0x26c8
#define  FILT_COUNT_0_31_OFFSET	0x26c4
#define  FILT_COUNT_0_30_OFFSET	0x26c0

#define  FILT_COUNT_0_2f_OFFSET	0x26bc
#define  FILT_COUNT_0_2e_OFFSET	0x26b8
#define  FILT_COUNT_0_2d_OFFSET	0x26b4
#define  FILT_COUNT_0_2c_OFFSET	0x26b0
#define  FILT_COUNT_0_2b_OFFSET	0x26ac
#define  FILT_COUNT_0_2a_OFFSET	0x26a8
#define  FILT_COUNT_0_29_OFFSET	0x26a4
#define  FILT_COUNT_0_28_OFFSET	0x26a0
#define  FILT_COUNT_0_27_OFFSET	0x269c
#define  FILT_COUNT_0_26_OFFSET	0x2698
#define  FILT_COUNT_0_25_OFFSET	0x2694
#define  FILT_COUNT_0_24_OFFSET	0x2690
#define  FILT_COUNT_0_23_OFFSET	0x268c
#define  FILT_COUNT_0_22_OFFSET	0x2688
#define  FILT_COUNT_0_21_OFFSET	0x2684
#define  FILT_COUNT_0_20_OFFSET	0x2680

#define  FILT_COUNT_0_1f_OFFSET	0x267c
#define  FILT_COUNT_0_1e_OFFSET	0x2678
#define  FILT_COUNT_0_1d_OFFSET	0x2674
#define  FILT_COUNT_0_1c_OFFSET	0x2670
#define  FILT_COUNT_0_1b_OFFSET	0x266c
#define  FILT_COUNT_0_1a_OFFSET	0x2668
#define  FILT_COUNT_0_19_OFFSET	0x2664
#define  FILT_COUNT_0_18_OFFSET	0x2660
#define  FILT_COUNT_0_17_OFFSET	0x265c
#define  FILT_COUNT_0_16_OFFSET	0x2658
#define  FILT_COUNT_0_15_OFFSET	0x2654
#define  FILT_COUNT_0_14_OFFSET	0x2650
#define  FILT_COUNT_0_13_OFFSET	0x264c
#define  FILT_COUNT_0_12_OFFSET	0x2648
#define  FILT_COUNT_0_11_OFFSET	0x2644
#define  FILT_COUNT_0_10_OFFSET	0x2640

#define  FILT_COUNT_0_f_OFFSET	0x263c
#define  FILT_COUNT_0_e_OFFSET	0x2638
#define  FILT_COUNT_0_d_OFFSET	0x2634
#define  FILT_COUNT_0_c_OFFSET	0x2630
#define  FILT_COUNT_0_b_OFFSET	0x262c
#define  FILT_COUNT_0_a_OFFSET	0x2628
#define  FILT_COUNT_0_9_OFFSET	0x2624
#define  FILT_COUNT_0_8_OFFSET	0x2620
#define  FILT_COUNT_0_7_OFFSET	0x261c
#define  FILT_COUNT_0_6_OFFSET	0x2618
#define  FILT_COUNT_0_5_OFFSET	0x2614
#define  FILT_COUNT_0_4_OFFSET	0x2610
#define  FILT_COUNT_0_3_OFFSET	0x260c
#define  FILT_COUNT_0_2_OFFSET	0x2608
#define  FILT_COUNT_0_1_OFFSET	0x2604
#define  FILT_COUNT_0_0_OFFSET	0x2600

#define  FILT_LOG_1_3_f_OFFSET	0x25fc
#define  FILT_LOG_1_3_e_OFFSET	0x25f8
#define  FILT_LOG_1_3_d_OFFSET	0x25f4
#define  FILT_LOG_1_3_c_OFFSET	0x25f0
#define  FILT_LOG_1_3_b_OFFSET	0x25ec
#define  FILT_LOG_1_3_a_OFFSET	0x25e8
#define  FILT_LOG_1_3_9_OFFSET	0x25e4
#define  FILT_LOG_1_3_8_OFFSET	0x25e0
#define  FILT_LOG_1_3_7_OFFSET	0x25dc
#define  FILT_LOG_1_3_6_OFFSET	0x25d8
#define  FILT_LOG_1_3_5_OFFSET	0x25d4
#define  FILT_LOG_1_3_4_OFFSET	0x25d0
#define  FILT_LOG_1_3_3_OFFSET	0x25cc
#define  FILT_LOG_1_3_2_OFFSET	0x25c8
#define  FILT_LOG_1_3_1_OFFSET	0x25c4
#define  FILT_LOG_1_3_0_OFFSET	0x25c0

#define  FILT_LOG_1_2_f_OFFSET	0x25bc
#define  FILT_LOG_1_2_e_OFFSET	0x25b8
#define  FILT_LOG_1_2_d_OFFSET	0x25b4
#define  FILT_LOG_1_2_c_OFFSET	0x25b0
#define  FILT_LOG_1_2_b_OFFSET	0x25ac
#define  FILT_LOG_1_2_a_OFFSET	0x25a8
#define  FILT_LOG_1_2_9_OFFSET	0x25a4
#define  FILT_LOG_1_2_8_OFFSET	0x25a0
#define  FILT_LOG_1_2_7_OFFSET	0x259c
#define  FILT_LOG_1_2_6_OFFSET	0x2598
#define  FILT_LOG_1_2_5_OFFSET	0x2594
#define  FILT_LOG_1_2_4_OFFSET	0x2590
#define  FILT_LOG_1_2_3_OFFSET	0x258c
#define  FILT_LOG_1_2_2_OFFSET	0x2588
#define  FILT_LOG_1_2_1_OFFSET	0x2584
#define  FILT_LOG_1_2_0_OFFSET	0x2580

#define  FILT_LOG_1_1_f_OFFSET	0x257c
#define  FILT_LOG_1_1_e_OFFSET	0x2578
#define  FILT_LOG_1_1_d_OFFSET	0x2574
#define  FILT_LOG_1_1_c_OFFSET	0x2570
#define  FILT_LOG_1_1_b_OFFSET	0x256c
#define  FILT_LOG_1_1_a_OFFSET	0x2568
#define  FILT_LOG_1_1_9_OFFSET	0x2564
#define  FILT_LOG_1_1_8_OFFSET	0x2560
#define  FILT_LOG_1_1_7_OFFSET	0x255c
#define  FILT_LOG_1_1_6_OFFSET	0x2558
#define  FILT_LOG_1_1_5_OFFSET	0x2554
#define  FILT_LOG_1_1_4_OFFSET	0x2550
#define  FILT_LOG_1_1_3_OFFSET	0x254c
#define  FILT_LOG_1_1_2_OFFSET	0x2548
#define  FILT_LOG_1_1_1_OFFSET	0x2544
#define  FILT_LOG_1_1_0_OFFSET	0x2540

#define  FILT_LOG_1_0_f_OFFSET	0x253c
#define  FILT_LOG_1_0_e_OFFSET	0x2538
#define  FILT_LOG_1_0_d_OFFSET	0x2534
#define  FILT_LOG_1_0_c_OFFSET	0x2530
#define  FILT_LOG_1_0_b_OFFSET	0x252c
#define  FILT_LOG_1_0_a_OFFSET	0x2528
#define  FILT_LOG_1_0_9_OFFSET	0x2524
#define  FILT_LOG_1_0_8_OFFSET	0x2520
#define  FILT_LOG_1_0_7_OFFSET	0x251c
#define  FILT_LOG_1_0_6_OFFSET	0x2518
#define  FILT_LOG_1_0_5_OFFSET	0x2514
#define  FILT_LOG_1_0_4_OFFSET	0x2510
#define  FILT_LOG_1_0_3_OFFSET	0x250c
#define  FILT_LOG_1_0_2_OFFSET	0x2508
#define  FILT_LOG_1_0_1_OFFSET	0x2504
#define  FILT_LOG_1_0_0_OFFSET	0x2500

#define  FILT_LOG_0_3_f_OFFSET	0x24fc
#define  FILT_LOG_0_3_e_OFFSET	0x24f8
#define  FILT_LOG_0_3_d_OFFSET	0x24f4
#define  FILT_LOG_0_3_c_OFFSET	0x24f0
#define  FILT_LOG_0_3_b_OFFSET	0x24ec
#define  FILT_LOG_0_3_a_OFFSET	0x24e8
#define  FILT_LOG_0_3_9_OFFSET	0x24e4
#define  FILT_LOG_0_3_8_OFFSET	0x24e0
#define  FILT_LOG_0_3_7_OFFSET	0x24dc
#define  FILT_LOG_0_3_6_OFFSET	0x24d8
#define  FILT_LOG_0_3_5_OFFSET	0x24d4
#define  FILT_LOG_0_3_4_OFFSET	0x24d0
#define  FILT_LOG_0_3_3_OFFSET	0x24cc
#define  FILT_LOG_0_3_2_OFFSET	0x24c8
#define  FILT_LOG_0_3_1_OFFSET	0x24c4
#define  FILT_LOG_0_3_0_OFFSET	0x24c0

#define  FILT_LOG_0_2_f_OFFSET	0x24bc
#define  FILT_LOG_0_2_e_OFFSET	0x24b8
#define  FILT_LOG_0_2_d_OFFSET	0x24b4
#define  FILT_LOG_0_2_c_OFFSET	0x24b0
#define  FILT_LOG_0_2_b_OFFSET	0x24ac
#define  FILT_LOG_0_2_a_OFFSET	0x24a8
#define  FILT_LOG_0_2_9_OFFSET	0x24a4
#define  FILT_LOG_0_2_8_OFFSET	0x24a0
#define  FILT_LOG_0_2_7_OFFSET	0x249c
#define  FILT_LOG_0_2_6_OFFSET	0x2498
#define  FILT_LOG_0_2_5_OFFSET	0x2494
#define  FILT_LOG_0_2_4_OFFSET	0x2490
#define  FILT_LOG_0_2_3_OFFSET	0x248c
#define  FILT_LOG_0_2_2_OFFSET	0x2488
#define  FILT_LOG_0_2_1_OFFSET	0x2484
#define  FILT_LOG_0_2_0_OFFSET	0x2480

#define  FILT_LOG_0_1_f_OFFSET	0x247c
#define  FILT_LOG_0_1_e_OFFSET	0x2478
#define  FILT_LOG_0_1_d_OFFSET	0x2474
#define  FILT_LOG_0_1_c_OFFSET	0x2470
#define  FILT_LOG_0_1_b_OFFSET	0x246c
#define  FILT_LOG_0_1_a_OFFSET	0x2468
#define  FILT_LOG_0_1_9_OFFSET	0x2464
#define  FILT_LOG_0_1_8_OFFSET	0x2460
#define  FILT_LOG_0_1_7_OFFSET	0x245c
#define  FILT_LOG_0_1_6_OFFSET	0x2458
#define  FILT_LOG_0_1_5_OFFSET	0x2454
#define  FILT_LOG_0_1_4_OFFSET	0x2450
#define  FILT_LOG_0_1_3_OFFSET	0x244c
#define  FILT_LOG_0_1_2_OFFSET	0x2448
#define  FILT_LOG_0_1_1_OFFSET	0x2444
#define  FILT_LOG_0_1_0_OFFSET	0x2440

#define  FILT_LOG_0_0_f_OFFSET	0x243c
#define  FILT_LOG_0_0_e_OFFSET	0x2438
#define  FILT_LOG_0_0_d_OFFSET	0x2434
#define  FILT_LOG_0_0_c_OFFSET	0x2430
#define  FILT_LOG_0_0_b_OFFSET	0x242c
#define  FILT_LOG_0_0_a_OFFSET	0x2428
#define  FILT_LOG_0_0_9_OFFSET	0x2424
#define  FILT_LOG_0_0_8_OFFSET	0x2420
#define  FILT_LOG_0_0_7_OFFSET	0x241c
#define  FILT_LOG_0_0_6_OFFSET	0x2418
#define  FILT_LOG_0_0_5_OFFSET	0x2414
#define  FILT_LOG_0_0_4_OFFSET	0x2410
#define  FILT_LOG_0_0_3_OFFSET	0x240c
#define  FILT_LOG_0_0_2_OFFSET	0x2408
#define  FILT_LOG_0_0_1_OFFSET	0x2404
#define  FILT_LOG_0_0_0_OFFSET	0x2400


#define  TBL_FLACPRT_OFFSET  0x2358
#define  TBLDIRECT_VLDIPV_OFFSET  0x2350
#define  TBLDIRECT_DATA_OFFSET  0x2344
#define  TBLDIRECT_CMD_OFFSET   0x2340

#define  LKUP_TBL_49o_OFFSET	0x230c
#define  LKUP_TBL_48o_OFFSET	0x2304
#define  LKUP_TBL_47o_OFFSET	0x22fc
#define  LKUP_TBL_46o_OFFSET	0x22f4
#define  LKUP_TBL_45o_OFFSET	0x22ec
#define  LKUP_TBL_44o_OFFSET	0x22e4
#define  LKUP_TBL_43o_OFFSET	0x22dc
#define  LKUP_TBL_42o_OFFSET	0x22d4
#define  LKUP_TBL_41o_OFFSET	0x22cc
#define  LKUP_TBL_40o_OFFSET	0x22c4
#define  LKUP_TBL_39o_OFFSET	0x22bc
#define  LKUP_TBL_38o_OFFSET	0x22b4
#define  LKUP_TBL_37o_OFFSET	0x22ac
#define  LKUP_TBL_36o_OFFSET	0x22a4
#define  LKUP_TBL_35o_OFFSET	0x229c
#define  LKUP_TBL_34o_OFFSET	0x2294
#define  LKUP_TBL_33o_OFFSET	0x228c
#define  LKUP_TBL_32o_OFFSET	0x2284
#define  LKUP_TBL_31o_OFFSET	0x227c
#define  LKUP_TBL_30o_OFFSET	0x2274
#define  LKUP_TBL_29o_OFFSET	0x226c
#define  LKUP_TBL_28o_OFFSET	0x2264
#define  LKUP_TBL_27o_OFFSET	0x225c
#define  LKUP_TBL_26o_OFFSET	0x2254
#define  LKUP_TBL_25o_OFFSET	0x224c
#define  LKUP_TBL_24o_OFFSET	0x2244
#define  LKUP_TBL_23o_OFFSET	0x223c
#define  LKUP_TBL_22o_OFFSET	0x2234
#define  LKUP_TBL_21o_OFFSET	0x222c
#define  LKUP_TBL_20o_OFFSET	0x2224
#define  LKUP_TBL_19o_OFFSET	0x221c
#define  LKUP_TBL_18o_OFFSET	0x2214
#define  LKUP_TBL_17o_OFFSET	0x220c
#define  LKUP_TBL_16o_OFFSET	0x2204
#define  LKUP_TBL_15o_OFFSET	0x21fc
#define  LKUP_TBL_14o_OFFSET	0x21f4
#define  LKUP_TBL_13o_OFFSET	0x21ec
#define  LKUP_TBL_12o_OFFSET	0x21e4
#define  LKUP_TBL_11o_OFFSET	0x21dc
#define  LKUP_TBL_10o_OFFSET	0x21d4
#define  LKUP_TBL_9o_OFFSET	0x21cc
#define  LKUP_TBL_8o_OFFSET	0x21c4
#define  LKUP_TBL_7o_OFFSET	0x21bc
#define  LKUP_TBL_6o_OFFSET	0x21b4
#define  LKUP_TBL_5o_OFFSET	0x21ac
#define  LKUP_TBL_4o_OFFSET	0x21a4
#define  LKUP_TBL_3o_OFFSET	0x219c
#define  LKUP_TBL_2o_OFFSET	0x2194
#define  LKUP_TBL_1o_OFFSET	0x218c
#define  LKUP_TBL_0o_OFFSET	0x2184

#define  LKUP_TBL_49e_OFFSET	0x2308
#define  LKUP_TBL_48e_OFFSET	0x2300
#define  LKUP_TBL_47e_OFFSET	0x22f8
#define  LKUP_TBL_46e_OFFSET	0x22f0
#define  LKUP_TBL_45e_OFFSET	0x22e8
#define  LKUP_TBL_44e_OFFSET	0x22e0
#define  LKUP_TBL_43e_OFFSET	0x22d8
#define  LKUP_TBL_42e_OFFSET	0x22d0
#define  LKUP_TBL_41e_OFFSET	0x22c8
#define  LKUP_TBL_40e_OFFSET	0x22c0
#define  LKUP_TBL_39e_OFFSET	0x22b8
#define  LKUP_TBL_38e_OFFSET	0x22b0
#define  LKUP_TBL_37e_OFFSET	0x22a8
#define  LKUP_TBL_36e_OFFSET	0x22a0
#define  LKUP_TBL_35e_OFFSET	0x2298
#define  LKUP_TBL_34e_OFFSET	0x2290
#define  LKUP_TBL_33e_OFFSET	0x2288
#define  LKUP_TBL_32e_OFFSET	0x2280
#define  LKUP_TBL_31e_OFFSET	0x2278
#define  LKUP_TBL_30e_OFFSET	0x2270
#define  LKUP_TBL_29e_OFFSET	0x2268
#define  LKUP_TBL_28e_OFFSET	0x2260
#define  LKUP_TBL_27e_OFFSET	0x2258
#define  LKUP_TBL_26e_OFFSET	0x2250
#define  LKUP_TBL_25e_OFFSET	0x2248
#define  LKUP_TBL_24e_OFFSET	0x2240
#define  LKUP_TBL_23e_OFFSET	0x2238
#define  LKUP_TBL_22e_OFFSET	0x2230
#define  LKUP_TBL_21e_OFFSET	0x2228
#define  LKUP_TBL_20e_OFFSET	0x2220
#define  LKUP_TBL_19e_OFFSET	0x2218
#define  LKUP_TBL_18e_OFFSET	0x2210
#define  LKUP_TBL_17e_OFFSET	0x2208
#define  LKUP_TBL_16e_OFFSET	0x2200
#define  LKUP_TBL_15e_OFFSET	0x21f8
#define  LKUP_TBL_14e_OFFSET	0x21f0
#define  LKUP_TBL_13e_OFFSET	0x21e8
#define  LKUP_TBL_12e_OFFSET	0x21e0
#define  LKUP_TBL_11e_OFFSET	0x21d8
#define  LKUP_TBL_10e_OFFSET	0x21d0
#define  LKUP_TBL_9e_OFFSET	0x21c8
#define  LKUP_TBL_8e_OFFSET	0x21c0
#define  LKUP_TBL_7e_OFFSET	0x21b8
#define  LKUP_TBL_6e_OFFSET	0x21b0
#define  LKUP_TBL_5e_OFFSET	0x21a8
#define  LKUP_TBL_4e_OFFSET	0x21a0
#define  LKUP_TBL_3e_OFFSET	0x2198
#define  LKUP_TBL_2e_OFFSET	0x2190
#define  LKUP_TBL_1e_OFFSET	0x2188
#define  LKUP_TBL_0e_OFFSET	0x2180

#define  LKUP_TIMER_OFFSET	0x215c
#define  LKUP_CONTRL_OFFSET	0x2150

#define  TTL0_BUFFUL_OFFSET	0x214c

#define  SWENG_FLWTHSHLD_OFFSET	0x2148
#define  SWENG_CONTRL_OFFSET	0x2144
#define  DO_FRAG_IPF_OFFSET	0x2140

#define  NAT_FINRSTSTA_3_OFFSET	0x213c
#define  NAT_FINRSTSTA_2_OFFSET	0x2138
#define  NAT_FINRSTSTA_1_OFFSET	0x2134
#define  NAT_FINRSTSTA_0_OFFSET	0x2130

#define  NATIPF_MCHSTA_3_OFFSET	0x212c
#define  NATIPF_MCHSTA_2_OFFSET	0x2128
#define  NATIPF_MCHSTA_1_OFFSET	0x2124
#define  NATIPF_MCHSTA_0_OFFSET	0x2120

#define  TBL_QOSSTA_OFFSET	0x2118
#define  TBL_QOSDATA_OFFSET	0x2114
#define  TBL_QOSCMD_OFFSET	0x2110
#define  TBL_NATACPRT_OFFSET	0x210c
#define  TBL_NATSTA_OFFSET	0x2108
#define  TBL_NATDATA_OFFSET	0x2104
#define  TBL_NATCMD_OFFSET	0x2100
#define  TBL_FILTSTA_OFFSET	0x20fc
#define  TBL_FILTDATA_OFFSET	0x20f8
#define  TBL_FILTCMD_OFFSET	0x20f4

#define  FILT_CNTSTA_3_OFFSET	0x20f0
#define  FILT_CNTSTA_2_OFFSET	0x20ec
#define  FILT_CNTSTA_1_OFFSET	0x20e8
#define  FILT_CNTSTA_0_OFFSET	0x20e4

#define  FILT_CNTINTEN_3_OFFSET	0x20e0
#define  FILT_CNTINTEN_2_OFFSET	0x20dc
#define  FILT_CNTINTEN_1_OFFSET	0x20d8
#define  FILT_CNTINTEN_0_OFFSET	0x20d4

#define  FILT_LOGBUFLOCK_OFFSET	0x20d0
#define  FILT_LOGSTATUS_OFFSET	0x20cc
#define  FILT_LOGCONT_OFFSET	0x20c8
#define  FILT_SUBNET_OFFSET	0x20c4
#define  FILT_CONTRL_OFFSET	0x20c0

#define  SMI_POLINTVL_OFFSET	0x20a0
#define  SMI_MDCDIV_OFFSET	0x209c
#define  SMI_PHYADR_OFFSET	0x2098
#define  SMI_CMDST_OFFSET	0x2094
#define  SMI_CMDDATA_OFFSET	0x2090
#define  SMI_COMMAND_OFFSET	0x208c
#define  SMI_INTEN_OFFSET	0x2088
#define  SMI_STATUS_OFFSET	0x2084
#define  SMI_CONTRL_OFFSET	0x2080

#define  HOST_RXPACKNUM_OFFSET	0x205c
#define  HOST_RXCPURDEND_OFFSET	0x2058
#define  HOST_TXSTEN_OFFSET	0x2054
#define  HOST_TXCMBCLR_OFFSET	0x2050
#define  HOST_TXCPUWRSTP_OFFSET	0x204c
#define  HOST_INTEN_OFFSET	0x2048
#define  HOST_STATUS_OFFSET	0x2044
#define  HOST_CONTRL_OFFSET	0x2040

#define  MAC_IPGTMR_OFFSET	0x2030
#define  MAC_MAXLENGTH_OFFSET	0x202c
#define  MAC_MINLENGTH_OFFSET	0x2028

#define  MAC_PAUSETMR_OFFSET	0x2024	/* Pause Timer Value & CRC Calculate */

#define  MAC_3_INTEN_OFFSET	0x2020
#define  MAC_2_INTEN_OFFSET	0x201c
#define  MAC_1_INTEN_OFFSET	0x2018
#define  MAC_0_INTEN_OFFSET	0x2014

#define  MAC_3_STATUS_OFFSET	0x2010
#define  MAC_2_STATUS_OFFSET	0x200c
#define  MAC_1_STATUS_OFFSET	0x2008
#define  MAC_0_STATUS_OFFSET	0x2004

#define  MAC_CONTRL_OFFSET	0x2000

/*   Source Interface   */
#define INTF_LAN0	0x00000001
#define INTF_LAN1	0x00000002
#define INTF_DMZ	0x00000004
#define INTF_DMZ_H	0x00000008
#define INTF_WAN	0x00000010
#define INTF_WAN_H	0x00000020

/*   Camelot Registor Value (reg 0x2000)   */
#define	P4_PART_EN	(1 << 14)
#define	P4_DIS_PORT	(1 << 13)
#define	P4_FLOW_EN	(1 << 12)
#define	P3_PART_EN	(1 << 11)
#define	P3_DIS_PORT	(1 << 10)
#define	P3_FLOW_EN	(1 << 9)
#define	P2_PART_EN	(1 << 8)
#define	P2_DIS_PORT	(1 << 7)
#define	P2_FLOW_EN	(1 << 6)
#define	P1_PART_EN	(1 << 5)
#define	P1_DIS_PORT	(1 << 4)
#define	P1_FLOW_EN	(1 << 3)
#define	P0_PART_EN	(1 << 2)
#define	P0_DIS_PORT	(1 << 1)
#define	P0_FLOW_EN	(1 << 0)

/*   Camelot Registor Value (reg 0x2020)   */
#define MAC_INTEN_3 	0x1fff
#define MAC_INTEN_2 	0x1fff
#define MAC_INTEN_1 	0x1fff
#define MAC_INTEN_0 	0x1fff

/*   Camelot Registor Value (reg 0x2024)   */
#define	PAUSE_TMR	0xffffffff

/*   Camelot Registor Value (reg 0x2028)   */
#define	MAC_MIN_LEN	0x40
/*   Camelot Registor Value (reg 0x202c)   */
#define	MAC_MAX_LEN	0x600

/*   Camelot Registor Value (reg 0x2030)   */
#define	IPG_TMR		0x60

/*   Camelot Registor Value (reg 0x2040)   */
#define ENDIAN		0x1  /* 1: Little   0: Big */

/*   Camelot Registor Value (reg 0x2048)   */
/*#define HOST_INTEN	0xfebf*/
#define HOST_INTEN	0x0001feff
#define HOST_IE_TTL_0		(1 << 16)
#define HOST_IE_FILTER_LOG	(1 << 8)
#define HOST_IE_NAT_FIN_RST	(1 << 7)
#define HOST_IE_SWITCH_FLOW	(1 << 6
#define HOST_IE_SWITCH_FULL	(1 << 5)
#define HOST_IE_HOST_DEADLOCK	(1 << 4)
#define HOST_IE_OVR_TX		(1 << 3)
#define HOST_IE_UNR_RX		(1 << 2)
#define HOST_IE_PACKET_READY	(1 << 1)
#define HOST_IE_TX_EMPTY	(1 << 0)

/*   Camelot Registor Value (reg 0x2080)   */
#define  P3_MII_EN     (1 << 15) /* WAN */
#define  P3_LINK_SP    (1 << 14)
#define  P3_LINK_DX    (1 << 13)
#define  P3_LINK_AT    (1 << 12)

#define  P2_MII_EN     (1 << 11) /* DMZ/LAN2 */
#define  P2_LINK_SP    (1 << 10)
#define  P2_LINK_DX    (1 << 9)
#define  P2_LINK_AT    (1 << 8)

#define  P1_MII_EN     (1 << 7)	/* LAN1 */
#define  P1_LINK_SP    (1 << 6)
#define  P1_LINK_DX    (1 << 5)
#define  P1_LINK_AT    (1 << 4)

#define  P0_MII_EN     (1 << 3) /* LAN0 */
#define  P0_LINK_SP    (1 << 2)
#define  P0_LINK_DX    (1 << 1)
#define  P0_LINK_AT    (1 << 0)

/*   Camelot Registor Value (reg 0x2088)   */
#define	SMI_INT_LINKST3	(1 << 3)
#define	SMI_INT_LINKST2 (1 << 2)
#define	SMI_INT_LINKST1 (1 << 1)
#define	SMI_INT_LINKST0 (1 << 0)

/*   Camelot Registor Value (reg 0x2098)   */
#define  DEV4PHTADD   0x3
#define  DEV3PHTADD   0x2
#define  DEV2PHTADD   0x1
#define  DEV1PHTADD   0x0

/*   Camelot Registor Value (reg 0x209c)   */
#define  MDC_DIV    	0x8

/*   Camelot Registor Value (reg 0x20a0)   */
#define  POLLING_INT    0x10

/*   Camelot Registor Value (reg 0x20c0)   */
/* out-side */
#define	O_TUNNEL_VALID	(1<<19)
#define	O_FRAGMENT	(1<<18)
#define	O_DEFAULT_L34	(1<<17)
#define	O_DEFAULT_PT	(1<<16)
#define	O_PPPOEDST	(1<<15)	/* PPPoE D.Stage */
#define	O_PPPOESS4DN	(1<<14)	/* PPPoE S.Stage With IPv4 Drop/Not   */
#define	O_PPPOESS4PC	(1<<13)	/* PPPoE S.Stage With IPv4 Pass/Comp  */
#define	O_PPPOESS6DN	(1<<12)	/* PPPoE S.Stage With IPv6 Drop/Not   */
#define	O_PPPOESS6PC	(1<<11)	/* PPPoE S.Stage With IPv6 Pass/Comp  */
#define	O_PPPOESSO46	(1<<10)	/* PPPoE S.Stage Without IPv4/6 Field */

/* in-side */
#define	IN_TUNNEL_VALID	(1<<9)
#define	IN_FRAGMENT	(1<<8)
#define	IN_DEFAULT_L34	(1<<7)
#define	IN_DEFAULT_PT	(1<<6)
#define	IN_PPPOEDST	(1<<5)	/* PPPoE D.Stage */
#define	IN_PPPOESS4DN	(1<<4)	/* PPPoE S.Stage With IPv4 Drop/Not   */
#define	IN_PPPOESS4PC	(1<<3)	/* PPPoE S.Stage With IPv4 Pass/Comp  */
#define	IN_PPPOESS6DN	(1<<2)	/* PPPoE S.Stage With IPv6 Drop/Not   */
#define	IN_PPPOESS6PC	(1<<1)	/* PPPoE S.Stage With IPv6 Pass/Comp  */
#define	IN_PPPOESSO46	(1<<0)	/* PPPoE S.Stage Without IPv4/6 Field */

/*   Camelot Registor Value (reg 0x20c4)   */
#define	SUBNET_MASK	0xffff0000

/*   Camelot Registor Value (reg 0x20c8)   */
#define LOG_PPPOE	(1<<2)
#define LOG_FLAGMENT	(1<<1)
#define LOG_UNKOWN	(1<<0)

/*   Camelot Registor Value (reg 0x20d4 - 0x20e0)   */
#define FL_CNT_IN_INTEN_31_0	0xffffffff
#define FL_CNT_IN_INTEN_63_32	0xffffffff
#define FL_CNT_OUT_INTEN_31_0	0xffffffff
#define FL_CNT_OUT_INTEN_63_32	0xffffffff

/*   Camelot Registor Value (reg 0x2140)   */
#define  DO_FLAG_IPF	0x0

/* ?? (reg 0x2148) */
#define  THSWQ		0xfffffff

/*   Camelot Registor Value (reg 0x2150)   */
#define  DMZ_EN		(1<<3)
#define  NO_MATCH_WAN	(1<<2)
#define  NO_MATCH_DMZ	(1<<1)
#define  NO_MATCH_LAN	(1<<0)

/*   Camelot Registor Value (reg 0x215c)   */
#define  LKP_TIMER	0xffffffff

/*   Camelot Registor Value (reg 0x2800 - 0x280c)   */
#define	NO0_SESSION_ID 	0xffff
#define	NO0_CODE 	0xff
#define	NO0_VERTYPE 	0xff
#define	NO1_SESSION_ID 	0xffff
#define	NO1_CODE 	0xff
#define	NO1_VERTYPE 	0xff
#define	NO2_SESSION_ID 	0xffff
#define	NO2_CODE 	0xff
#define	NO2_VERTYPE 	0xff
#define	NO3_SESSION_ID 	0xffff
#define	NO3_CODE 	0xff
#define	NO3_VERTYPE 	0xff


/*   Camelot Registor Value (reg 0x2810 - 0x285c)   */
#define	NO0_LENGTH 	0x00
#define	NO0_TOS 	0x00
#define	NO0_VERSION 	0x4
#define	NO0_IHL		0x5
#define	NO0_FRAG_FLAG	0x00
#define	NO0_ID		0x00
#define	NO0_CHECKSUM	0x00
#define	NO0_PROTOCOL	0x29
#define	NO0_TTL		0x04
#define	NO0_SRCADD	0x00
#define	NO0_DSTADD	0x00

#define	NO1_LENGTH 	0x00
#define	NO1_TOS 	0x00
#define	NO1_VERSION 	0x4
#define	NO1_IHL		0x5
#define	NO1_FRAG_FLAG	0x00
#define	NO1_ID		0x00
#define	NO1_CHECKSUM	0x00
#define	NO1_PROTOCOL	0x29
#define	NO1_TTL		0x04
#define	NO1_SRCADD	0x00
#define	NO1_DSTADD	0x00

#define	NO2_LENGTH 	0x00
#define	NO2_TOS 	0x00
#define	NO2_VERSION 	0x4
#define	NO2_IHL		0x5
#define	NO2_FRAG_FLAG	0x00
#define	NO2_ID		0x00
#define	NO2_CHECKSUM	0x00
#define	NO2_PROTOCOL	0x29
#define	NO2_TTL		0x04
#define	NO2_SRCADD	0x00
#define	NO2_DSTADD	0x00

#define	NO3_LENGTH 	0x00
#define	NO3_TOS 	0x00
#define	NO3_VERSION 	0x4
#define	NO3_IHL		0x5
#define	NO3_FRAG_FLAG	0x00
#define	NO3_ID		0x00
#define	NO3_CHECKSUM	0x00
#define	NO3_PROTOCOL	0x29
#define	NO3_TTL		0x04
#define	NO3_SRCADD	0x00
#define	NO3_DSTADD	0x00

#endif /* _CAMELOT_REG_H_ */

