/*
 * drivers/net/mb86977/camelot_var.h
 *
 * Fujitsu MB86977 driver internal variables
 *
 * Author: <source@mvista.com>
 *
 * Copyright (c) 2002-2003 by Fujitsu LSI Solution Ltd..  All Rights Reserved.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

#ifndef _CAMELOT_VAR_H_
#define _CAMELOT_VAR_H_

/*   Hardware Size Parameter   */
#define  TXBUFSIZE		768     /* TX Buffer Size (word) */
#define  RXBUFSIZE		768     /* TX Buffer Size (word) */

#define  L2ENTRY_NUM		50	/* L2 Table Entry Number */
#define  ENTRY_NUM_NATIPF	128	/* NAT_IP Forwarding Table Entry # */
#define  ENTRY_NUM_L34		64	/* L3_4 Filter Entry Number */
#define  ENTRY_NUM_PRT  	8	/* Protocol Type Table Entry # */
#define  ENTRY_NUM_QOS		8	/* QOS Table Entry Number */

#define  ENTRY_NUM_LOG		4	/* Filter Log Packet Number	*/
#define  ENTRY_NUM_NATMTHLOG	4	/* NAT_IP Match Status Register # */
#define  ENTRY_NUM_RSTFINLOG	4	/* NAT_IP RST Status Register # */
#define  ENTRY_NUM_TTL0LOG	16	/* TTL0 Error LOG Packet Size */

/*   Network Protocols   */
#define WLEN_IP6_AD		4
#define BLEN_MAC_AD		6
#define WK_FTP_PORT		0x15

/*  Filter Table Difinition   */
typedef struct { 
	u_int32_t  control_10;
	u_int32_t  control_11;
	u_int32_t  ipv4addr_src;
	u_int32_t  ipv4addr_dst;
	u_int32_t  upport_src;
	u_int32_t  lowport_src;
	u_int32_t  upport_dst;
	u_int32_t  lowport_dst;
   	u_int32_t ipv6addr_src[4];
   	u_int32_t ipv6addr_dst[4];
} FLT_TBL ;

/*   NAT IP Forwarding Table Difinition   */
typedef struct {
	u_int32_t  control;
	u_int32_t  ipv4addr_inter;
	u_int32_t  nataddr;
	u_int32_t  ipv4addr_exter;
	u_int32_t  portnum_inter;
	u_int32_t  portnum_nat;
	u_int32_t  portnum_exter;
	u_int32_t  intf_inter;
	u_int32_t  intf_exter;
   	u_char macaddr_inter[6];
   	u_char macaddr_exter[6];
   	u_int32_t ipv6addr_inter[4];
   	u_int32_t ipv6addr_exter[4];
} NAT_IPF_TBL ;

/*   Protocol Type Table Difinition   */
typedef int PRT_TBL ;

/*   QOS Table   */
typedef struct {
	u_int32_t  ipv6addr_src[4];
	u_int32_t  ipv6addr_dst[4];
	u_int32_t  tos;
	u_int32_t  flowlabel;
	u_int32_t  port;
	u_int32_t  control;
} QOS_TBL ;

#define LIST_REMOVE_HEAD(head, elm, field) do {        \
        (head)->lh_first = (elm)->field.le_next;       \
} while (/*CONSTCOND*/0)

/*   FEF List   */
struct tbl_fef{
//	LIST_ENTRY(tbl_fef) fef_link;
	u_long st_flags;
#define AFTER_ARP_RESO   0x00000001
#define AFTER_DST_RESO   0x00000002
        u_long ip_dst;
        u_long ip_src;
        u_long ip_nat;
	u_int32_t  ip6_dst[4];
	u_int32_t  ip6_src[4];
	u_char	   mac_dst[6];
	u_char	   mac_src[6];
        u_short port_dst;
        u_short port_src;
        u_short port_nat;
	u_char ip_p;
        int s_cmpt;
        int sa_cmpt;
	struct  rtentry *rt0;
	struct  rtentry *rt1;
};

/*   Camelot variable   */
#define LEN_PPPOE	4
#define LEN_TUNNEL	5
struct common_softc {
	int   txbfull;
	u_int32_t cm_flags;
#define SMI_OK		0x00000010
	caddr_t  dum_buf;
        int tbl_match[ENTRY_NUM_NATIPF];
        int iot;
        u_long ioh;
	void    *ih;
	u_int32_t pppoe_info[LEN_PPPOE];
	u_int32_t tunnel_info[LEN_TUNNEL];
}; 


#ifdef __KERNEL__

struct camelot_softc {
	/*
	 * Memory functions:
	 *	copy to/from buffer
	 */
	void	(*sc_copytobuf)(struct camelot_softc *, void *, int, int);
	void	(*sc_copyfrombuf)(struct camelot_softc *, void *, int, int);

	/*
	 * Machine-dependent functions:
	 */
	u_int32_t (*sc_read)(struct camelot_softc *, u_int32_t);
	void	(*sc_write)(struct camelot_softc *, u_int32_t, u_int32_t);
	u_long	sc_addr;	/* base address of RAM -- CPU's view */
	int     sc_havecarrier; 	/* carrier status */
};

/*
 * Ethernet driver per interface structure
 */
struct cm_softc {
	int unit;
	struct camelot_softc camelot;

	/* protocol/interface state */
	struct net_device	net;
	struct net_device_stats	stats;

	struct semaphore	mutex;
};

void camelot_config(struct camelot_softc *);
void camelot_reset(struct camelot_softc *);
void camelot_init(struct camelot_softc *);
void camelot_intr(int irq, void *dev_id, struct pt_regs *regs);

void camelot_copytobuf_contig(struct camelot_softc *, void *, int, int);
void camelot_copyfrombuf_contig(struct camelot_softc *, void *, int, int);

#endif /* __KERNEL__ */

#endif /* _CAMELOT_VAR_H_ */

