/*
 * drivers/net/mb86977/camelottbl.h
 *
 * Fujitsu MB86977 initial tables
 *
 * Author: <source@mvista.com>
 *
 * Copyright (c) 2002-2003 by Fujitsu LSI Solution Ltd..  All Rights Reserved.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

/*  MAC Address   */
#define CONTROL_L2_CAME		0x0000008d

u_char came_mac_default[6] = {0x00, 0x90, 0x99, 0x18, 0x72, 0x9c};

/* NAT/IP Table Initialize */

#if 0
/* for debugging */
#define ENTRY_NUM_NATIPF_DFLT	1
#define ENTRY_NUM_L34_IN_DFLT	3
#define ENTRY_NUM_L34_OUT_DFLT	1
#else
#define ENTRY_NUM_NATIPF_DFLT	0
#define ENTRY_NUM_L34_IN_DFLT	0
#define ENTRY_NUM_L34_OUT_DFLT	0
#endif

/* WAN <=> LAN0  NAT TCP */
NAT_IPF_TBL  natipf_table[1] = {
	{control: 0x00100000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000, 
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 macaddr_inter: {0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	 macaddr_exter: {0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000},
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000}},
};

/* Filter Table Initialize */
FLT_TBL  flt_table_in[3] = {
        { control_10: 0x0033fff7,
        control_11: 0x00000321,
	ipv4addr_src: 0x00000000,
	ipv4addr_dst: 0x00000000,
	upport_src: 0x00000000,
	lowport_src: 0x00000000,
	upport_dst: 0x00000000,
	lowport_dst: 0x00000000,
	ipv6addr_src: {0x00000000, 0x00000000, 0x00000000, 0x00000000},
	ipv6addr_dst: {0x00000000, 0x00000000, 0x00000000, 0x00000000}},
	/* for debugging only */
        {0x0011ff17,
         0x00000221,
	 0x00000000,
	 0xda2b13e7,/*218.43.19.231*/
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000050,
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000},
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000}},
        {0x0013ff17,
         0x00000211,
	 0x00000000,
	 0xda2b13e7,/*218.43.19.231*/
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000},
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000}}
};
FLT_TBL  flt_table_out[1] = {
        {0x0023fff7,
         0x00000321,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 0x00000000,
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000},
	 {0x00000000, 0x00000000, 0x00000000, 0x00000000}},
};

/*   Camelot Variable   */
struct common_softc came_var;
