/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Copyright (C) 2002 Shane Nay (shane@minirl.com)
 * Copyright (C) 2002 Motorola Semiconductor HK Ltd
 *   - add MX1ADS specific definitions
 * Copyright (C) 2002 Sony Corporation
 * Copyright (C) 2003 MontaVista Software Inc. <source@mvista.com>
 *
 */

/**************************************************************************
 * * Copyright  ARM Limited 1998.  All rights reserved.
 * ***********************************************************************/
/* ************************************************************************
 *
 *   MX1 address map
 *
 * ***********************************************************************/


/* ========================================================================
 *  MX1 definitions
 * ========================================================================
 * ------------------------------------------------------------------------
 *  Memory definitions
 * ------------------------------------------------------------------------
 *  MX1 memory map
 */


#ifndef __MX1ADS_PLATFORM_H__
#define __MX1ADS_PLATFORM_H__

#define MX1_SIC_ID                 0x0021B804

#define MX1ADS_SRAM_BASE           0x00300000
#define MX1ADS_SRAM_SIZE           SZ_128K

#define MX1ADS_SFLASH_BASE         0x0C000000
#define MX1ADS_SFLASH_SIZE         SZ_16M

#define MX1ADS_IO_BASE             0x00200000
#define MX1ADS_IO_SIZE             SZ_256K

#define MX1ADS_VID_BASE            0x00300000
#define MX1ADS_VID_SIZE            0x26000

#define MX1ADS_VID_START           IO_ADDRESS(MX1ADS_VID_BASE)

#define    MX1_GPIO_BASE                0x0021C000    /* GPIO */
#define    MX1_EXT_UART_BASE            0x15000000    /* external UART */
#define    MX1_TMR1_BASE                0x00202000    /* Timer1 */
#define    MX1ADS_FLASH_BASE            0x0C000000    /* sync FLASH */
#define    MX1_ESRAM_BASE                0x00300000    /* embedded SRAM */
#define    MX1ADS_SDRAM_DISK_BASE    0x0B000000    /* SDRAM disk base (last 16M of SDRAM) */

/* ------------------------------------------------------------------------
 *  Motorola MX1 system registers
 * ------------------------------------------------------------------------
 *
 */

/*
 *  Register offests.
 *
 */

#define MX1ADS_AIPI1_OFFSET             0x00000
#define MX1ADS_WDT_OFFSET               0x01000
#define MX1ADS_TIM1_OFFSET              0x02000
#define MX1ADS_TIM2_OFFSET              0x03000
#define MX1ADS_RTC_OFFSET               0x04000
#define MX1ADS_LCDC_OFFSET              0x05000
#define MX1ADS_UART1_OFFSET             0x06000
#define MX1ADS_UART2_OFFSET             0x07000
#define MX1ADS_PWM_OFFSET               0x08000
#define MX1ADS_DMAC_OFFSET              0x09000
#define MX1ADS_AIPI2_OFFSET             0x10000
#define MX1ADS_SIM_OFFSET               0x11000
#define MX1ADS_USBD_OFFSET              0x12000
#define MX1ADS_SPI1_OFFSET              0x13000
#define MX1ADS_MMC_OFFSET               0x14000
#define MX1ADS_ASP_OFFSET               0x15000
#define MX1ADS_BTA_OFFSET               0x16000
#define MX1ADS_I2C_OFFSET               0x17000
#define MX1ADS_SSI_OFFSET               0x18000
#define MX1ADS_SPI2_OFFSET              0x19000
#define MX1ADS_MSHC_OFFSET              0x1A000
#define MX1ADS_PLL_OFFSET               0x1B000
#define MX1ADS_GPIO_OFFSET              0x1C000
#define MX1ADS_EIM_OFFSET               0x20000
#define MX1ADS_SDRAMC_OFFSET            0x21000
#define MX1ADS_MMA_OFFSET               0x22000
#define MX1ADS_AITC_OFFSET              0x23000
#define MX1ADS_CSI_OFFSET               0x24000


/*
 *  Register BASEs, based on OFFSETs
 *
 */

#define MX1ADS_AIPI1_BASE             (MX1ADS_AIPI1_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_WDT_BASE               (MX1ADS_WDT_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_TIM1_BASE              (MX1ADS_TIM1_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_TIM2_BASE              (MX1ADS_TIM2_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_RTC_BASE               (MX1ADS_RTC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_LCDC_BASE              (MX1ADS_LCDC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_UART1_BASE             (MX1ADS_UART1_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_UART2_BASE             (MX1ADS_UART2_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_PWM_BASE               (MX1ADS_PWM_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_DMAC_BASE              (MX1ADS_DMAC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_AIPI2_BASE             (MX1ADS_AIPI2_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_SIM_BASE               (MX1ADS_SIM_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_USBD_BASE              (MX1ADS_USBD_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_SPI1_BASE              (MX1ADS_SPI1_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_MMC_BASE               (MX1ADS_MMC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_ASP_BASE               (MX1ADS_ASP_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_BTA_BASE               (MX1ADS_BTA_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_I2C_BASE               (MX1ADS_I2C_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_SSI_BASE               (MX1ADS_SSI_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_SPI2_BASE              (MX1ADS_SPI2_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_MSHC_BASE              (MX1ADS_MSHC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_PLL_BASE               (MX1ADS_PLL_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_GPIO_BASE              (MX1ADS_GPIO_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_EIM_BASE               (MX1ADS_EIM_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_SDRAMC_BASE            (MX1ADS_SDRAMC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_MMA_BASE               (MX1ADS_MMA_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_AITC_BASE              (MX1ADS_AITC_OFFSET + MX1ADS_IO_BASE)
#define MX1ADS_CSI_BASE               (MX1ADS_CSI_OFFSET + MX1ADS_IO_BASE)


/*
 *  MX1 Interrupt numbers
 *
 */
#define INT_SOFTINT                 0
#define CSI_INT                     6
#define DSPA_MAC_INT                7
#define DSPA_INT                    8
#define COMP_INT                    9
#define MSHC_XINT                   10
#define GPIO_INT_PORTA              11
#define GPIO_INT_PORTB              12
#define GPIO_INT_PORTC              13
#define LCDC_INT                    14
#define SIM_INT                     15
#define SIM_DATA_INT                16
#define RTC_INT                     17
#define RTC_SAMINT                  18
#define UART2_MINT_PFERR            19
#define UART2_MINT_RTS              20
#define UART2_MINT_DTR              21
#define UART2_MINT_UARTC            22
#define UART2_MINT_TX               23
#define UART2_MINT_RX               24
#define UART1_MINT_PFERR            25
#define UART1_MINT_RTS              26
#define UART1_MINT_DTR              27
#define UART1_MINT_UARTC            28
#define UART1_MINT_TX               29
#define UART1_MINT_RX               30
#define VOICE_DAC_INT               31
#define VOICE_ADC_INT               32
#define PEN_DATA_INT                33
#define PWM_INT                     34
#define SDHC_INT                    35
#define I2C_INT                     39
#define CSPI_INT                    41
#define SSI_TX_INT                  42
#define SSI_TX_ERR_INT              43
#define SSI_RX_INT                  44
#define SSI_RX_ERR_INT              45
#define TOUCH_INT                   46
#define USBD_INT0                   47
#define USBD_INT1                   48
#define USBD_INT2                   49
#define USBD_INT3                   50
#define USBD_INT4                   51
#define USBD_INT5                   52
#define USBD_INT6                   53
#define BTSYS_INT                   55
#define BTTIM_INT                   56
#define BTWUI_INT                   57
#define TIMER2_INT                  58
#define TIMER1_INT                  59
#define DMA_ERR                     60
#define DMA_INT                     61
#define GPIO_INT_PORTD              62




#define MAXIRQNUM                       62
#define MAXFIQNUM                       62
#define MAXSWINUM                       62

#define TICKS_PER_uSEC                  24

/*
 *  These are useconds NOT ticks.
 *
 */
#define mSEC_1                          1000
#define mSEC_5                          (mSEC_1 * 5)
#define mSEC_10                         (mSEC_1 * 10)
#define mSEC_25                         (mSEC_1 * 25)
#define SEC_1                           (mSEC_1 * 1000)


#define IO32_RAW(a)    (*(volatile __u32 *)(a))
#define IO16_RAW(a)    (*(volatile __u16 *)(a))
#define IO8_RAW(a)     (*(volatile __u8  *)(a))

/* CSD / CS setting */
#define CSD0_BASE          0x08000000
#define CSD1_BASE          0x0c000000
#define CS0_BASE           0x10000000
#define CS1_BASE           0x12000000
#define CS2_BASE           0x13000000
#define CS3_BASE           0x14000000
#define CS4_BASE           0x15000000
#define CS5_BASE           0x16000000
            
#define CSD0_SIZE          0x04000000 /* 64MB */
#define CSD1_SIZE          0x04000000 /* 64MB */
#define CS0_SIZE           0x02000000 /* 32MB */
#define CS1_SIZE           0x01000000 /* 16MB */
#define CS2_SIZE           0x01000000 /* 16MB */
#define CS3_SIZE           0x01000000 /* 16MB */
#define CS4_SIZE           0x01000000 /* 16MB */
#define CS5_SIZE           0x01000000 /* 16MB */

/* CPU Internal Registers */
#define REGISTER_BASE      0x00200000
#define REGISTER_SIZE      0x00100000 /* top 156KB */

/* ESRAM : Embedded SRAM */
#define ESRAM_BASE         0x00300000
#define ESRAM_SIZE         0x00040000 /* 256kB */

/* AIPI : AHB to Motorola IP Interface */
#define AIPI1_BASE         0x00200000
#define AIPI2_BASE         0x00210000
#define AIPI_PSR0                0x00 /* Peripheral Size Reg 1 */
#define AIPI_PSR1                0x04 /* Peripheral Size Reg 2 */
#define AIPI_PAR                 0x08 /* Peripheral Access Reg */


/* PLL : Phase Locked Loop and Clock Controller */
#define PLL_BASE           0x0021B000
/*     Reset Module */
#define PLL_CSCR                 0x00 /*Clock Source Control Register */
#define   CSCR_CLK0SEL_BIT         29
#define   CSCR_CLK0SEL_MASK      (0x7 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_PERCLK1     (0 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_HCLK        (1 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_CLK48M      (2 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_CLK16M      (3 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_PREEMCLK    (4 << CSCR_CLK0SEL_BIT)
#define   CSCR_CLK0SEL_FCLK        (5 << CSCR_CLK0SEL_BIT)
#define   CSCR_USBDIV_BIT          26
#define   CSCR_USBDIV_MASK       (0x7 << CSCR_USBDIV_BIT)
#define   CSCR_SDCNT_BIT           24
#define   CSCR_SDCNT_MASK        (0x3 << CSCR_SDCNT_BIT)
#define   CSCR_SDCNT_00            (0 << CSCR_SDCNT_BIT)
#define   CSCR_SDCNT_01            (1 << CSCR_SDCNT_BIT)
#define   CSCR_SDCNT_10            (2 << CSCR_SDCNT_BIT)
#define   CSCR_SDCNT_11            (3 << CSCR_SDCNT_BIT)
#define   CSCR_UPLL_RESTART        (1 << 22)
#define   CSCR_MPLL_RESTART        (1 << 21)
#define   CSCR_CLK16_SEL           (1 << 18)
#define   CSCR_OSC_EN              (1 << 17)
#define   CSCR_USB_SEL             (1 << 16)
#define   CSCR_PRESC               (1 << 15)
#define   CSCR_BCLKDIV_BIT         10
#define   CSCR_BCLKDIV_MASK      (0xF << CSCR_BCLKDIV_BIT)
#define   CSCR_UPEN                (1 << 1)
#define   CSCR_MPEN                (1 << 0)

#define PLL_PCDR                 0x20 /*Peripherial Clock Divider Register */
#define   PCDR_PCLKDIV3_BIT        16
#define   PCDR_PCLKDIV3_MASK    (0x7F << PCDR_PCLKDIV3_BIT)
#define   PCDR_PCLKDIV2_BIT         4
#define   PCDR_PCLKDIV2_MASK     (0xF << PCDR_PCLKDIV2_BIT)
#define   PCDR_PCLKDIV1_BIT         0
#define   PCDR_PCLKDIV1_MASK     (0xF << PCDR_PCLKDIV1_BIT)


/*     PLL & Clock Controller */
#define PLL_MCTL0                0x04 /*MCU PLL Control Register 0 */
#define PLL_MCTL1                0x08 /*MCU PLL Control Register 1 */
#define PLL_UPCTL0               0x0C /*USB PLL Control Register 0 */
#define PLL_UPCTL1               0x10 /*USB PLL Control Register 1 */
#define   PLL_PD_BIT               26
#define   PLL_PD_MASK            (0xF << PLL_PD_BIT)
#define   PLL_MFD_BIT              16
#define   PLL_MFD_MASK         (0x3FF << PLL_MFD_BIT)
#define   PLL_MFI_BIT              10
#define   PLL_MFI_MASK           (0xF << PLL_MFI_BIT)
#define   PLL_MFN_BIT               0
#define   PLL_MFN_MASK         (0x3FF << PLL_MFN_BIT)


/* System Control */
#define SYSCON_BASE        0x0021B800
#define SYSCON_RSR                0x0 /*Reset Source Register */
#define   RESET_WDR                (1 << 1) /* Watch Dog Reset */
#define   RESET_EXR                (1 << 0) /* Reset-In Reset */
#define SYSCON_SIDR               0x4 /*Silicon ID Register */
#define SYSCON_FMCR               0x8 /*Function Muxing Control Register */
#define FMCR_SDCS1_BIT              1
#define FMCR_SDCS0_BIT              0
#define   FMCR_SELECT_CSD1         (1 << FMCR_SDCS1_BIT) /* 1: CSD1, 0: CS3 */
#define   FMCR_SELECT_CSD0         (1 << FMCR_SDCS0_BIT) /* 1: CSD0, 0: CS2 */
#define SYSCON_GPCR               0xC /*Global Peripherial Control Regiser */
#define   GPCR_BTAEN               (1 << 12)
#define   GPCR_DS_SLOW_BIT         10
#define   GPCR_DS_SLOW_MASK      (0x3 << GPCR_DS_SLOW_BIT)
#define   GPCR_DS_CNTL_BIT          8
#define   GPCR_DS_CNTL_MASK      (0x3 << GPCR_DS_CNTL_BIT)
#define   GPCR_DS_ADDR_BIT          6
#define   GPCR_DS_ADDR_MASK      (0x3 << GPCR_DS_ADDR_BIT)
#define   GPCR_DS_DATA_BIT          4
#define   GPCR_DS_DATA_MASK      (0x3 << GPCR_DS_DATA_BIT)
#define   GPCR_MMA_PROT_EN         (1 << 1)
#define   GPCR_CSI_PROT_EN         (1 << 0)




/* EIM */
#define EIM_BASE           0x00220000
#define EIM_CS0U                 0x00
#define EIM_CS0L                 0x04
#define EIM_CS1U                 0x08
#define EIM_CS1L                 0x0C
#define EIM_CS2U                 0x10
#define EIM_CS2L                 0x14
#define EIM_CS3U                 0x18
#define EIM_CS3L                 0x1C
#define EIM_CS4U                 0x20
#define EIM_CS4L                 0x24
#define EIM_CS5U                 0x28
#define EIM_CS5L                 0x2C
#define EIM_EIM                  0x30
/*  CSx Upper register */
#define   EIM_BCD_BIT              28
#define   EIM_BCD_MASK           (0x3 << EIM_BCD_BIT)
#define   EIM_BCS_BIT              24
#define   EIM_BCS_MASK           (0xF << EIM_BCS_BIT)
#define   EIM_PSZ_BIT              22
#define   EIM_PSZ_MASK           (0x3 << EIM_PSZ_BIT)
#define   EIM_PME                  (1 << 21)
#define   EIM_SYNC                 (1 << 20)
#define   EIM_DOL_BIT              16
#define   EIM_DOL_MASK           (0xF << EIM_DOL_BIT)
#define   EIM_CNC_BIT              14
#define   EIM_CNC_MASK           (0x3 << EIM_CNC_BIT)
#define   EIM_WSC_BIT               8
#define   EIM_WSC_MASK          (0x3F << EIM_WSC_BIT)
#define   EIM_WWS_BIT               4
#define   EIM_WWS_MASK           (0x7 << EIM_WWS_BIT)
#define   EIM_EDC_BIT               0
#define   EIM_EDC_MASK           (0xF << EIM_EDC_BIT)
/*  CSx Lower register */
#define   EIM_OEA_BIT              28
#define   EIM_OEA_MASK           (0xF << EIM_OEA_BIT)
#define   EIM_OEN_BIT              24
#define   EIM_OEN_MASK           (0xF << EIM_OEN_BIT)
#define   EIM_WEA_BIT              20
#define   EIM_WEA_MASK           (0xF << EIM_WEA_BIT)
#define   EIM_WEN_BIT              16
#define   EIM_WEN_MASK           (0xF << EIM_WEN_BIT)
#define   EIM_CSA_BIT              12
#define   EIM_CSA_MASK           (0xF << EIM_CSA_BIT)
#define   EIM_EBC                  (1 << 11)
#define   EIM_DSZ_BIT               8
#define   EIM_DSZ_MASK           (0x7 << EIM_DSZ_BIT)
#define     DSZ_8BIT_31_24        0x0
#define     DSZ_8BIT_23_16        0x1
#define     DSZ_8BIT_15_8         0x2
#define     DSZ_8BIT_7_0          0x3
#define     DSZ_16BIT_31_16       0x4
#define     DSZ_16BIT_15_0        0x5
#define     DSZ_32BIT             0x6
#define   EIM_SP                   (1 << 6)
#define   EIM_WP                   (1 << 4)
#define   EIM_CSEN                 (1 << 0)


/* GPIO : On-chip GPIO */
#define GPIO_PTA_BASE      0x0021C000
#define GPIO_PTB_BASE      0x0021C100
#define GPIO_PTC_BASE      0x0021C200
#define GPIO_PTD_BASE      0x0021C300
#define   GPIO_PORT_A      GPIO_PTA_BASE
#define   GPIO_PORT_B      GPIO_PTB_BASE
#define   GPIO_PORT_C      GPIO_PTC_BASE
#define   GPIO_PORT_D      GPIO_PTD_BASE

#define GPIO_DDIR                0x00
#define   GPIO_INPUT                0
#define   GPIO_OUTPUT               1
#define GPIO_OCR1                0x04
#define GPIO_OCR2                0x08
#define   OCR_A_IN                0x0
#define   OCR_B_IN                0x1
#define   OCR_C_IN                0x2
#define   OCR_DATA_REG            0x3
#define GPIO_ICONFA1             0x0C
#define GPIO_ICONFA2             0x10
#define GPIO_ICONFB1             0x14
#define GPIO_ICONFB2             0x18
#define   ICONF_GPIO_IN           0x0
#define   ICONF_ISR               0x1
#define   ICONF_0                 0x2
#define   ICONF_1                 0x3
#define GPIO_DR                  0x1C
#define GPIO_GIUS                0x20
#define GPIO_SSR                 0x24
#define GPIO_ICR1                0x28
#define GPIO_ICR2                0x2C
#define   ICR_POSITIVE_EDGE       0x0
#define   ICR_NEGATIVE_EDGE       0x1
#define   ICR_POSITIVE_LEVEL      0x2
#define   ICR_NEGATIVE_LEVEL      0x3
#define GPIO_IMR                 0x30
#define GPIO_ISR                 0x34
#define GPIO_GPR                 0x38
#define   GPR_PRIMARY               0
#define   GPR_SECONDARY             1
#define GPIO_SWR                 0x3C
#define GPIO_PUEN                0x40
#define   PUEN_TRISTATE             0
#define   PUEN_PULLUP               1


/* SDRAMC */
#define SDRAMC_BASE        0x00221000
#define SDRAMC_SDCTL0            0x00
#define SDRAMC_SDCTL1            0x04
#define SDRAMC_MISC              0x14
#define SDRAMC_RESET             0x18


/* AITC : Interrupt Controller */
#define AITC_BASE          0x00223000
#define AITC_INTCNTL             0x00 /*Interrupt Control Register */
#define AITC_NIMASK              0x04 /*Normal Interrupt Mask Register */
#define AITC_INTENNUM            0x08 /*Interrupt Enable Number Register */
#define AITC_INTDISNUM           0x0C /*Interrupt Disable Number Register */
#define AITC_INTENABLEH          0x10 /*Interrupt Enable Register High */
#define AITC_INTENABLEL          0x14 /*Interrupt Enable Register Low */
#define AITC_INTTYPEH            0x18
#define AITC_INTTYPEL            0x1C
#define AITC_NIPRIORITY7         0x20
#define AITC_NIPRIORITY6         0x24
#define AITC_NIPRIORITY5         0x28
#define AITC_NIPRIORITY4         0x2C
#define AITC_NIPRIORITY3         0x30
#define AITC_NIPRIORITY2         0x34
#define AITC_NIPRIORITY1         0x38
#define AITC_NIPRIORITY0         0x3C
#define AITC_NIVECSR             0x40
#define AITC_FIVECSR             0x44
#define AITC_INTSRCH             0x48
#define AITC_INTSRCL             0x4C
#define AITC_INTFRCH             0x50
#define AITC_INTFRCL             0x54
#define AITC_NIPNDH              0x58
#define AITC_NIPNDL              0x5C
#define AITC_FIPNDH              0x60
#define AITC_FIPNDL              0x64


/* Timer : General Purpose Timer */
#define TIMER1_BASE            0x00202000
#define TIMER2_BASE            0x00203000
#define TIMER_TCTL                   0x00
#define   TIMER_SRESET                 (1 << 15)
#define   TIMER_FRR                    (1 <<  8)
#define   TIMER_CAP_BIT                 6
#define   TIMER_CAP_MASK             (0x3 << TIMER_CAP_BIT)
#define   TIMER_OM                     (1 << 5)
#define   TIMER_IRQEN                  (1 << 4)
#define   TIMER_CLKSRC_BIT              1
#define   TIMER_CLKSRC_MASK          (0x7 << TIMER_CLKSRC_BIT)
#define   TIMER_CLKSRC_STOP          (0x0 << TIMER_CLKSRC_BIT)
#define   TIMER_CLKSRC_PERCLK1       (0x1 << TIMER_CLKSRC_BIT)
#define   TIMER_CLKSRC_PERCLK1DIV16  (0x2 << TIMER_CLKSRC_BIT)
#define   TIMER_CLKSRC_TIN           (0x3 << TIMER_CLKSRC_BIT)
#define   TIMER_CLKSRC_CLK32         (0x7 << TIMER_CLKSRC_BIT)
#define   TIMER_ENABLE                 (1 << 0)
#define TIMER_TPRER                  0x04
#define   TIMER_PRESC_BIT               0
#define   TIMER_PRESC_MASK          (0xFF << TIMER_PRESC_BIT)
#define TIMER_TCMP                   0x08 /* Timer Compare regiser */
#define TIMER_TCR                    0x0C /* Timer Capture register */
#define TIMER_TCN                    0x10 /* Timer Counter register */
#define TIMER_TSTAT                  0x14 /* Timer Status register */
#define   TIMER_CAPT                   (1 << 1)
#define   TIMER_COMP                   (1 << 0)

/* UART */
#define UART1_BASE         IO_ADDRESS( 0x00206000 )
#define UART2_BASE         IO_ADDRESS( 0x00207000 )
#define UART_RXDATA              0x00
#define   UART_CHARRDY             (1 << 15)
#define   UART_ERR                 (1 << 14)
#define   UART_OVRRUN              (1 << 13)
#define   UART_FRMERR              (1 << 12)
#define   UART_BRK                 (1 << 11)
#define   UART_PRERR               (1 << 10)
#define   UART_RXDATA_BIT           0
#define   UART_RXDATA_MASK      (0xFF << UART_RXDATA_BIT)
#define UART_TXDATA              0x40
#define   UART_TXDATA_BIT           0
#define   UART_TXDATA_MASK      (0xFF << UART_TXDATA_BIT)
#define UART_CR1                 0x80
#define   UART_ADEN                (1 << 15)
#define   UART_ADBR                (1 << 14)
#define   UART_TRDYEN              (1 << 13)
#define   UART_IDEN                (1 << 12)
#define   UART_ICD_BIT             10
#define   UART_ICD_MASK          (0x3 << UART_ICD_BIT)
#define   UART_ICD_4FRAME          (0 << UART_ICD_BIT)
#define   UART_ICD_8FRAME          (1 << UART_ICD_BIT)
#define   UART_ICD_16FRAME         (2 << UART_ICD_BIT)
#define   UART_ICD_32FRAME         (3 << UART_ICD_BIT)
#define   UART_RRDYEN              (1 <<  9)
#define   UART_RDMAEN              (1 <<  8)
#define   UART_IREN                (1 <<  7)
#define   UART_TXEMPTYEN           (1 <<  6)
#define   UART_RTSDEN              (1 <<  5)
#define   UART_SNDBRK              (1 <<  4)
#define   UART_TDMAEN              (1 <<  3)
#define   UART_UARTCLKEN           (1 <<  2)
#define   UART_DOZE                (1 <<  1)
#define   UART_UARTEN              (1 <<  0)
#define UART_CR2                 0x84
#define   UART_ESCI                (1 << 15)
#define   UART_IRTS                (1 << 14)
#define   UART_CTSC                (1 << 13)
#define   UART_CTS                 (1 << 12)
#define   UART_ESCEN               (1 << 11)
#define   UART_RTEC_BIT             9
#define   UART_RTEC_MASK         (0x3 << UART_RTEC_BIT)
#define   UART_PREN                (1 << 8)
#define     UART_NON_PARITY        (0 << 8)
#define   UART_PROE                (1 << 7)
#define     UART_PARITY_ODD        (1 << 7)
#define     UART_PARITY_EVEN       (0 << 7)
#define   UART_STPB                (1 << 6)
#define     UART_STOPBIT_1         (0 << 6)
#define     UART_STOPBIT_2         (1 << 6)
#define   UART_WS                  (1 << 5)
#define     UART_7BIT              (0 << 5)
#define     UART_8BIT              (1 << 5)
#define   UART_RTSEN               (1 << 4)
#define   UART_TXEN                (1 << 2)
#define   UART_RXEN                (1 << 1)
#define   UART_SRST                (1 << 0)
#define UART_CR3                 0x88
#define   UART_DPEC_BIT            14
#define   UART_DPEC_MASK         (0x3 << UART_DPEC_BIT)
#define   UART_DTREN               (1 << 13) /* only on UART2 */
#define   UART_PARERREN            (1 << 12)
#define   UART_FRAERREN            (1 << 11)
#define   UART_DSR                 (1 << 10) /* only on UART2 */
#define   UART_DCD                 (1 <<  9) /* only on UART2 */
#define   UART_RI                  (1 <<  8) /* only on UART2 */
#define   UART_TIMEOUTEN           (1 <<  7)
#define   UART_RXDSEN              (1 <<  6)
#define   UART_AIRINTEN            (1 <<  5)
#define   UART_AWAKEN              (1 <<  4)
#define   UART_REF25               (1 <<  3)
#define   UART_REF30               (1 <<  2)
#define   UART_INVT                (1 <<  1)
#define   UART_BPEN                (1 <<  0)
#define UART_CR4                 0x8C
#define   UART_CTSTL_BIT           10
#define   UART_CTSTL_MASK       (0x3F << UART_CTSTL_BIT)
#define   UART_INVR                (1 << 9)
#define   UART_ENIRI               (1 << 8)
#define   UART_WKEN                (1 << 7)
#define   UART_REF16               (1 << 6)
#define   UART_IRSC                (1 << 5)
#define   UART_TCEN                (1 << 3)
#define   UART_BKEN                (1 << 2)
#define   UART_OREN                (1 << 1)
#define   UART_DREN                (1 << 0)
#define UART_UFCR                0x90
#define   UART_TXTL_BIT            10
#define   UART_TXTL_MASK        (0x3F << UART_TXTL_BIT)
#define   UART_RFDIV_BIT            7
#define   UART_RFDIV_MASK        (0x7 << UART_RFDIV_BIT)
#define   UART_RFDIV_7           (0x6 << UART_RFDIV_BIT)
#define   UART_RFDIV_6           (0x0 << UART_RFDIV_BIT)
#define   UART_RFDIV_5           (0x1 << UART_RFDIV_BIT)
#define   UART_RFDIV_4           (0x2 << UART_RFDIV_BIT)
#define   UART_RFDIV_3           (0x3 << UART_RFDIV_BIT)
#define   UART_RFDIV_2           (0x4 << UART_RFDIV_BIT)
#define   UART_RFDIV_1           (0x5 << UART_RFDIV_BIT)
#define   UART_RXTL_BIT             0
#define   UART_RXTL_MASK        (0x3F << UART_RXTL_BIT)
#define UART_SR1                 0x94
#define   UART_PARITY_ERR          (1 << 15)
#define   UART_RTSS                (1 << 14)
#define   UART_TRDY                (1 << 13)
#define   UART_RTSD                (1 << 12)
#define   UART_ESCF                (1 << 11)
#define   UART_FRAMERR             (1 << 10)
#define   UART_RRDY                (1 << 9)
#define   UART_TIMEOUT             (1 << 7)
#define   UART_RXDS                (1 << 6)
#define   UART_AIRINT              (1 << 5)
#define   UART_AWAKE               (1 << 4)
#define UART_SR2                 0x98
#define   UART_ADET                (1 << 15)
#define   UART_TXFE                (1 << 14)
#define   UART_DTRF                (1 << 13)
#define   UART_IDLE                (1 << 12)
#define   UART_IRINT               (1 << 8)
#define   UART_WAKE                (1 << 7)
#define   UART_RTSF                (1 << 4)
#define   UART_TXDC                (1 << 3)
#define   UART_BRCD                (1 << 2)
#define   UART_ORE                 (1 << 1)
#define   UART_RDR                 (1 << 0)
#define UART_ESC                 0x9C
#define UART_TIM                 0xA0
#define UART_BIR                 0xA4
#define UART_BMR                 0xA8
#define UART_BRC                 0xAC
#define UART_BIPR1               0xB0
#define UART_BMPR1               0xB4
#define UART_BIPR2               0xB8
#define UART_BMPR2               0xBC
#define UART_BIPR3               0xC0
#define UART_BMPR3               0xC4
#define UART_BIPR4               0xC8
#define UART_BMPR4               0xCC
#define UART_TS                  0xD0


/* RTC */
#define RTC_BASE           0x00204000
#define RTC_HOURMIN              0x00
#define RTC_SECOND               0x04
#define RTC_ALRM_HM              0x08
#define RTC_ALRM_SEC             0x0C
#define RTC_RTCCTL               0x10
#define RTC_RTCISR               0x14
#define RTC_RTCIENR              0x18
#define RTC_STPWCH               0x1C
#define RTC_DAYR                 0x20
#define RTC_DAYALARM             0x24
#define RTC_TEST1                0x28
#define RTC_TEST2                0x2C
#define RTC_TEST3                0x30


/* DMA */
#define DMA_BASE           0x00209000
#define DMA_DCR                 0x000 /* control register */
#define DMA_DISR                0x004 /* interrupt status  */
#define DMA_DIMR                0x008 /* interrupt mask */
#define DMA_DBTOSR              0x00C /* burst timeout status */
#define DMA_DRTOSR              0x010 /* request timeout status */
#define DMA_DSESR               0x014 /* transfer error status */
#define DMA_DBOSR               0x018 /* buffer overflow status */
#define DMA_DBTOCR              0x01C /* burst timeout control */
/*     DMA: 2D Memory Registers */
#define DMA_2D_A_BASE      0x00209040
#define DMA_2D_B_BASE      0x0020904C
#define DMA_WSR                 0x000 /* window size */
#define DMA_XSR                 0x004 /* x size */
#define DMA_YSR                 0x008 /* y size */
/*     DMA: Source Address Registers */
#define DMA_CH0_BASE  (DMA_BASE+0x080)
#define DMA_CH1_BASE  (DMA_BASE+0x0C0)
#define DMA_CH2_BASE  (DMA_BASE+0x100)
#define DMA_CH3_BASE  (DMA_BASE+0x140)
#define DMA_CH4_BASE  (DMA_BASE+0x180)
#define DMA_CH5_BASE  (DMA_BASE+0x1C0)
#define DMA_CH6_BASE  (DMA_BASE+0x200)
#define DMA_CH7_BASE  (DMA_BASE+0x240)
#define DMA_CH8_BASE  (DMA_BASE+0x280)
#define DMA_CH9_BASE  (DMA_BASE+0x2C0)
#define DMA_CH10_BASE (DMA_BASE+0x300)
#define DMA_SAR                 0x000 /* source address */
#define DMA_DAR                 0x004 /* destination address */
#define DMA_CNTR                0x008 /* count */
#define DMA_CCR                 0x00C /* control */
#define   DMA_DMOD_BIT             12
#define   DMA_DMOD_MASK           (0x3 << DMA_DMOD_BIT)
#define   DMA_SMOD_BIT             10
#define   DMA_SMOD_MASK           (0x3 << DMA_SMOD_BIT)
#define     DMA_LINEAR_MEM          0
#define     DMA_2D_MEM              1
#define     DMA_FIFO                2
#define     DMA_END_OF_BURST_FIFO   3
#define   DMA_MDIR                 (1 << 9)
#define   DMA_MDIR_INCREMENT       (0 << 9)
#define   DMA_MDIR_DECREMENT       (1 << 9)
#define   DMA_MSEL                 (1 << 9)
#define   DMA_MSEL_2DMEM_A         (0 << 8)
#define   DMA_MSEL_2DMEM_B         (1 << 8)
#define   DMA_DSIZ_BIT              6
#define   DMA_DSIZ_MASK          (0x3 << DMA_DSIZ_BIT)
#define   DMA_SSIZ_BIT              4
#define   DMA_SSIZ_MASK          (0x3 << DMA_SSIZ_BIT)
#define     DMA_32BIT               0
#define     DMA_8BIT                1
#define     DMA_16BIT               2
#define   DMA_REN                  (1 << 3)
#define   DMA_REN_DISABLE          (0 << 3)
#define   DMA_REN_ENABLE           (1 << 3)
#define   DMA_RPT                  (1 << 2)
#define   DMA_RPT_DISABLE          (0 << 2)
#define   DMA_RPT_ENABLE           (1 << 2)
#define   DMA_FRC                  (1 << 1)
#define   DMA_CEN                  (1 << 0)
#define DMA_RSSR                0x010 /* request source select */
#define DMA_BLR                 0x014 /* burst length */
#define DMA_RTOR                0x018 /* request timeout */
#define   DMA_RTO_EN_BIT           15 /* timeout enable */
#define   DMA_RTO_DISABLE          (0 << DMA_RTO_EN_BIT)
#define   DMA_RTO_ENABLE           (1 << DMA_RTO_EN_BIT)
#define   DMA_RTO_CLK_BIT          14 /* timeout clock source */
#define   DMA_RTO_SYSCLK           (0 << DMA_RTO_CLK_BIT)
#define   DMA_RTO_CLK32            (1 << DMA_RTO_CLK_BIT) /* 32.768 kHz*/
#define   DMA_RTO_PRESC_BIT        13 /* timeout clock prescaler */
#define   DMA_RTO_PRESC_DIV1       (0 << DMA_RTO_PRESC_BIT)
#define   DMA_RTO_PRESC_DIV256     (1 << DMA_RTO_PRESC_BIT)

#define DMA_BUCR                0x018 /* bus utilization control */
/*    DMA: Test Control Registers */
#define DMA_TST_BASE       0x00209340
#define DMA_TCR                 0x000
#define DMA_TFIFOA              0x004
#define DMA_TDRR                0x008
#define DMA_TDIPR               0x00C
#define DMA_TFIFOB              0x010

/* ASP : Analog Signal Processing */
#define ASP_BASE           0x00215000
#define ASP_PADFIFO              0x00
#define ASP_VADFIFO              0x04
#define ASP_VDAFIFO              0x08
#define ASP_VADCOEF              0x0C
#define ASP_ACNTLCR              0x10
#define ASP_PSMPLRG              0x14
#define ASP_ICNTLR               0x18
#define ASP_ISTATR               0x1C
#define ASP_VADGAIN              0x20
#define ASP_VDAGAIN              0x24
#define ASP_VDACOEF              0x28
#define ASP_CLKDIV               0x2C
#define ASP_CMPCNTL              0x30
#define ASP_PTRREG               0x34


/* BTA : Bluetooth Accelerator */
#define BTA_BASE           0x00216000
#define BTA_COMMAND              0x00
#define BTA_STATUS               0x00
#define BTA_PACKETHEAD           0x04
#define BTA_PAYLOADHEAD          0x08
/*     BT clocks */
#define BTA_NATIVECNT            0x0C
#define BTA_ESTCNT               0x10
#define BTA_OFFSETCNT            0x14
#define BTA_NATIVECLK_L          0x18
#define BTA_NATIVECLK_H          0x1C
#define BTA_ESTCLK_L             0x20
#define BTA_ESTCLK_H             0x24
#define BTA_OFFSETCLK_L          0x28
#define BTA_OFFSETCLK_H          0x2C
/*     BT pipeline */
#define BTA_HECCRC               0x30
#define BTA_WHITE                0x34
#define BTA_ENCRYPT              0x38
/*     Radio Control */
#define BTA_CORR_TIME            0x40
#define BTA_RF_GPO               0x48
#define BTA_RSSI                 0x4C
#define BTA_TIME_AB              0x50
#define BTA_TIME_CD              0x54
#define BTA_PWM_TX               0x58
#define BTA_RF_CTRL              0x5C
#define BTA_RF_STATUS            0x5C
#define BTA_RX_TIME              0x60
#define BTA_TX_TIME              0x64
/*     Bit Reverse */
#define BTA_WORD_REV             0x17
#define BTA_BYTE_REV             0x17
/*     Timer */
#define BTA_TIMER                0x68
/* */
//     Correlator
#define BTA_THRESHOLD            0x6C
#define BTA_CORR_MAX             0x6C
#define BTA_SYNCHWORD_0          0x70
#define BTA_SYNCHWORD_1          0x74
#define BTA_SYNCHWORD_2          0x78
#define BTA_SYNCHWORD_3          0x7C
/*     BitBUF */
#define BTA_BUF_WORD_0           0x80
#define BTA_BUF_WORD_1           0x84
#define BTA_BUF_WORD_2           0x88
#define BTA_BUF_WORD_3           0x8C
#define BTA_BUF_WORD_4           0x90
#define BTA_BUF_WORD_5           0x94
#define BTA_BUF_WORD_6           0x98
#define BTA_BUF_WORD_7           0x9C
#define BTA_BUF_WORD_8           0xA0
#define BTA_BUF_WORD_9           0xA4
#define BTA_BUF_WORD_10          0xA8
#define BTA_BUF_WORD_11          0xAC
#define BTA_BUF_WORD_12          0xB0
#define BTA_BUF_WORD_13          0xB4
#define BTA_BUF_WORD_14          0xB8
#define BTA_BUF_WORD_15          0xBC
#define BTA_BUF_WORD_16          0xC0
#define BTA_BUF_WORD_17          0xC4
#define BTA_BUF_WORD_18          0xC8
#define BTA_BUF_WORD_19          0xCC
#define BTA_BUF_WORD_20          0xD0
#define BTA_BUF_WORD_21          0xD4
#define BTA_BUF_WORD_22          0xD8
#define BTA_BUF_WORD_23          0xDC
#define BTA_BUF_WORD_24          0xE0
#define BTA_BUF_WORD_25          0xE4
#define BTA_BUF_WORD_26          0xE8
#define BTA_BUF_WORD_27          0xEC
#define BTA_BUF_WORD_28          0xF0
#define BTA_BUF_WORD_29          0xF4
#define BTA_BUF_WORD_30          0xF8
#define BTA_BUF_WORD_31          0xFC
/*     Wakeup */
#define BTA_WU_1                0x100
#define BTA_WU_2                0x104
#define BTA_WU_3                0x108
#define BTA_WU_DELTA3           0x108
#define BTA_WU_4                0x10C
#define BTA_WU_DELTA4           0x10C
#define BTA_WU_CTRL             0x110
#define BTA_WU_STATUS           0x110
#define BTA_WU_COUNT            0x114
/*     Clock control */
#define BTA_CLK_CTRL            0x118
/*     SPI */
#define BTA_SPI_WORD_0          0x120
#define BTA_SPI_WORD_1          0x124
#define BTA_SPI_WORD_2          0x128
#define BTA_SPI_WORD_3          0x12C
#define BTA_SPI_WADDR           0x130
#define BTA_SPI_RADDR           0x134
#define BTA_SPI_CTRL            0x138
#define BTA_SPI_STATUS          0x138
/*     Frequency Hopping */
#define BTA_HOPWORDS_0          0x140
#define BTA_FREQ_OUT            0x140
#define BTA_HOPWORDS_1          0x144
#define BTA_HOPWORDS_2          0x148
#define BTA_HOPWORDS_3          0x14C
#define BTA_HOPWORDS_4          0x150
/*     Interrupt */
#define BTA_INTERRUPT           0x160
/*     MLSE */
#define BTA_SYNC_METRIC         0x170
#define BTA_SYNC_FC             0x174


/* CSI : CMOS Sensor Interface */
#define CSI_BASE           0x00224000
#define CSI_CTRL_REG1            0x00
#define CSI_CTRL_REG2            0x04
#define CSI_STS_REG              0x08
#define CSI_STAT_FIFO            0x0C
#define CSI_RX_FIFO              0x10


/* SPI : Serial Periperal Interface Units */
#define SPI1_BASE          0x00213000
#define SPI2_BASE          0x00219000
#define SPI_RXD                  0x00
#define SPI_TXD                  0x04
#define SPI_CONT                 0x08
#define SPI_INT                  0x0C
#define SPI_TEST                 0x10
#define SPI_PERIOD               0x14
#define SPI_DMA                  0x18
#define SPI_RESET                0x1C


/* MMA : Multimedia Accelerator */
#define DSPA_BASE          0x00222000
#define DSPA_MAC_MOD           0x0000
#define DSPA_MAC_CTRL          0x0004
#define DSPA_MAC_MULT          0x0008
#define DSPA_MAC_ACCU          0x000C
#define DSPA_MAC_INTR          0x0010
#define DSPA_MAC_INTR_MAS  K   0x0014
#define DSPA_MAC_FIFO          0x0018
#define DSPA_MAC_FIFO_STA  T   0x001C
#define DSPA_MAC_BURST         0x0020
#define DSPA_MAC_BIT_SEL       0x0024

#define DSPA_MAC_XBASE         0x0200
#define DSPA_MAC_XINDEX        0x0204
#define DSPA_MAC_XLENGTH       0x0208
#define DSPA_MAC_XMODIFY       0x020C
#define DSPA_MAC_XINCR         0x0210
#define DSPA_MAC_XCOUNT        0x0214

#define DSPA_MAC_YBASE         0x0300
#define DSPA_MAC_YINDEX        0x0304
#define DSPA_MAC_YLENGTH       0x0308
#define DSPA_MAC_YMODIFY       0x030C
#define DSPA_MAC_YINCR         0x0310
#define DSPA_MAC_YCOUNT        0x0314

#define DSPA_DCTCTRL           0x0400
#define DSPA_DCTVER            0x0404
#define DSPA_DCTIRQENA         0x0408
#define DSPA_DCTIRQSTAT        0x040C
#define DSPA_DCTSRCADD         0x0410
#define DSPA_DCTDESADD         0x0414
#define DSPA_DCTFIFO           0x0500


/* I2C */
#define I2C_BASE           0x00217000
#define I2C_IADR                 0x00
#define I2C_IFDR                 0x04
#define I2C_I2CR                 0x08
#define I2C_I2SR                 0x0C
#define I2C_I2DR                 0x10


/* SSI */
#define SSI_BASE           0x00218000
#define SSI_STX                  0x00
#define SSI_SRX                  0x04
#define SSI_SCSR                 0x08
#define SSI_STCR                 0x0C
#define SSI_SRCR                 0x10
#define SSI_STCCR                0x14
#define SSI_SRCCR                0x18
#define SSI_STSR                 0x1C
#define SSI_SFCSR                0x20
#define SSI_STR                  0x24
#define SSI_SOR                  0x28


/* MMC */
#define MMC_BASE           0x00214000
#define MMC_STR_STP_CLK          0x00
#define MMC_STATUS               0x04
#define MMC_CLK_RATE             0x08
#define MMC_CMD_DAT_CONT         0x0C
#define MMC_RESPONSE_TO          0x10
#define MMC_READ_TO              0x14
#define MMC_BLK_LEN              0x18
#define MMC_NOB                  0x1C
#define MMC_REV_NO               0x20
#define MMC_INT_MASK             0x24
#define MMC_CMD                  0x28
#define MMC_ARGH                 0x2C
#define MMC_ARGL                 0x30
#define MMC_RES_FIFO             0x34
#define MMC_BUFFER_ACCESS        0x38
#define MMC_BUF_PART_FULL        0x3C
#define MMC_OTHERS_REGS_1        0x40
#define MMC_OTHERS_REGS_2        0x80
#define MMC_OTHERS_REGS_3       0x100
#define MMC_OTHERS_REGS_4       0x200
#define MMC_OTHERS_REGS_5       0x400
#define MMC_OTHERS_REGS_6       0x800


/* MSHC */
#define MSHC_BASE          0x0021A000
#define MSHC_MSCMD               0x00 /* ; Command Reg */
#define MSHC_MSCS                0x02 /* ; Control/Status Reg */
#define   MS_RST                   (1 << 15)
#define   MS_PWS                   (1 << 14)
#define   MS_SIEN                  (1 << 13)
#define   MS_DAKEN                 (1 << 12)
#define   MS_NOCRC                 (1 << 11)
#define   MS_BSYCNT_BIT             8
#define   MS_BSYCNT_NEVER          (0 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_6              (1 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_10             (2 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_14             (3 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_18             (4 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_22             (5 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_26             (6 << MS_BSYCNT_BIT)
#define   MS_BSYCNT_30             (7 << MS_BSYCNT_BIT)
#define   MS_INT                   (1 << 7)
#define   MS_DMARQ                 (1 << 6)
#define   MS_RBE                   (1 << 3)
#define   MS_RBF                   (1 << 2)
#define   MS_TBE                   (1 << 1)
#define   MS_TBF                   (1 << 0)
#define MSHC_MSDATA              0x04 /* ; Tx/Rx FIFO Reg */
#define MSHC_MSICS               0x06 /* ; Interrupt Control/Status Reg */
#define   MS_INTEN                 (1 << 15)
#define   MS_DRQSL                 (1 << 14)
#define   MS_PINEN                 (1 << 13)
#define   MS_RDY                   (1 <<  7)
#define   MS_SIF                   (1 <<  6)
#define   MS_DATARQ                (1 <<  5)
#define   MS_PIN                   (1 <<  4)
#define   MS_FAE                   (1 <<  2)
#define   MS_CRC                   (1 <<  1)
#define   MS_TOE                   (1 <<  0)
#define MSHC_MSPPCD              0x08 /* ; Parallel Port Control/Data Reg */
#define   MS_PIEN1                 (1 << 13)
#define   MS_PIEN0                 (1 << 12)
#define   MS_XPIN1                 (1 <<  5)
#define   MS_XPIN9                 (1 <<  4)
#define MSHC_MSC2                0x0A /* ; Control2 Reg */
#define   MS_ACD                   (1 << 15)
#define   MS_RED                   (1 << 14)
#define   MS_LEND                  (1 <<  1)
#define   MS_MSCEN                 (1 <<  0)
#define MSHC_MSACMD              0x0C /* ; Auto Command Reg */
#define   MS_APID_BIT              12
#define   MS_APID_MASK           (0xf << MS_APID_BIT)
#define   MS_ADATASIZE_BIT          0
#define   MS_ADATASIZE_MASK    (0x3ff << MS_ADATASIZE_BIT)
#define MSHC_MSFAECS             0x0E /* ; FIFO Acc Err Ctrl/Status Reg */
#define   MS_FAEEN                 (1 << 8)
#define   MS_RUN                   (1 << 1)
#define   MS_TOV                   (1 << 0)
#define MSHC_MSCLKD              0x10 /* ; Serial Clock Div Control Reg */
#define   MS_SRC                   (1 << 15)
#define   MS_SRC_HCLK              (0 << 15)
#define   MS_SRC_SCLKI             (1 << 15)
#define   MS_DIV_BIT                0
#define   MS_DIV_MASK            (0x3 << MS_DIV_BIT)
#define   MS_DIV_1                 (0 << MS_DIV_BIT)
#define   MS_DIV_2                 (1 << MS_DIV_BIT)
#define   MS_DIV_4                 (2 << MS_DIV_BIT)
#define   MS_DIV_8                 (3 << MS_DIV_BIT)
#define MSHC_MSDRQC              0x12 /* ; DMA Request Control Reg */
#define   MS_DRQEN                 (1 << 15)
#define   MS_REF                   (1 <<  4)
#define   MS_TFE                   (1 <<  0)

/* PWM : Pulse Width Modulator */
#define PWM_BASE           0x00208000
#define PWMC                     0x00
#define PWMS                     0x04
#define PWMP                     0x08
#define PWMCNT                   0x0C
#define PWMTST                   0x10


/* SIM : Smart Card Interface */
#define SIM_BASE           0x00211000
#define SIM_PORT_CNTL            0x00
#define SIM_CNTL                 0x04
#define SIM_RCV_THRESHOLD        0x08
#define SIM_ENABLE               0x0C
#define SIM_XMT_STATUS           0x10
#define SIM_RCV_STATUS           0x14
#define SIM_INT_MASK             0x18
#define SIM_PORT_XMT_BUF         0x1C
#define SIM_PORT_RCV_BUF         0x20
#define SIM_PORT_DETECT          0x24
#define SIM_XMT_THRESHOLD        0x28
#define SIM_GUARD_CNTL           0x2C
#define SIM_OD_CONFIG            0x30
#define SIM_RESET_CNTL           0x34
#define SIM_CHAR_WAIT            0x38
#define SIM_GPCNT                0x3C
#define SIM_DIVISOR              0x40


/* USBD */
#define USBD_FRAME                       0x00212000
#define USBD_FRAME_MATCH_MASK         (0x7ff << 16)
#define USBD_FRAME_MATCH_BIT                     16
#define USBD_FRAME_FRAME_MASK          (0x7ff << 0)
#define USBD_FRAME_FRAME_BIT                      0

#define USBD_SPEC                        0x00212004
#define USBD_SPEC_UDC_BUFADRPTR_MASK (0xffff << 16)
#define USBD_SPEC_UDC_BUFADRPTR_BIT              16
#define USBD_SPEC_RELEASE_MASK       (0xf000 << 12)
#define USBD_SPEC_RELEASE_BIT                    12
#define USBD_SPEC_SPEC_MASK            (0xfff << 0)
#define USBD_SPEC_SPEC_BIT                        0

#define USBD_STAT                        0x00212008
#define USBD_STAT_UDC_SETUP               (1 << 21)
#define USBD_STAT_UDC_XFRACK              (1 << 20)
#define USBD_STAT_UDC_XFRNACK             (1 << 19)
#define USBD_STAT_UDC_RWL                 (1 << 18)
#define USBD_STAT_UDC_DS                  (1 << 17)
#define USBD_STAT_UDC_AS                  (1 << 16)
#define USBD_STAT_RST                      (1 << 8)
#define USBD_STAT_SUSP                     (1 << 7)
#define USBD_STAT_CFG_MASK               (0x3 << 5)
#define USBD_STAT_CFG_BIT                         5
#define USBD_STAT_INTF_MASK              (0x3 << 3)
#define USBD_STAT_INTF_BIT                        3
#define USBD_STAT_ALTSET_MASK            (0x3 << 0)
#define USBD_STAT_ALTSET_BIT                      0

#define USBD_CTRL                        0x0021200C
#define USBD_CTRL_DEVSTALL                (1 << 31)
#define USBD_CTRL_DEVBUFOK                (1 << 30)
#define USBD_CTRL_DEVDTACK                (1 << 29)
#define USBD_CTRL_DEBUG                    (1 << 7)
#define USBD_CTRL_CMD_OVER                 (1 << 6)
#define USBD_CTRL_CMD_ERROR                (1 << 5)
#define USBD_CTRL_USB_SPD                  (1 << 4)
#define USBD_CTRL_USB_ENA                  (1 << 3)
#define USBD_CTRL_UDC_RST                  (1 << 2)
#define USBD_CTRL_AFE_ENA                  (1 << 1)
#define USBD_CTRL_RESUME                   (1 << 0)

#define USBD_DADR                        0x00212010
#define USBD_DADR_CFG                     (1 << 31)
#define USBD_DADR_BSY                     (1 << 30)
#define USBD_DADR_DADR_MASK             (0x1f << 0)
#define USBD_DADR_DADR_BIT                        0

#define USBD_DDAT                        0x00212014

#define USBD_INTR                        0x00212018
#define USBD_INTR_WAKEUP                  (1 << 31)
#define USBD_INTR_MSOF                     (1 << 7)
#define USBD_INTR_SOF                      (1 << 6)
#define USBD_INTR_RESET_STOP               (1 << 5)
#define USBD_INTR_RESET_START              (1 << 4)
#define USBD_INTR_RES                      (1 << 3)
#define USBD_INTR_SUSP                     (1 << 2)
#define USBD_INTR_FRAME_MATCH              (1 << 1)
#define USBD_INTR_CFG_CHG                  (1 << 0)

#define USBD_MASK                        0x0021201C
#define USBD_MASK_WAKEUP                  (1 << 31)
#define USBD_MASK_MSOF                     (1 << 7)
#define USBD_MASK_SOF                      (1 << 6)
#define USBD_MASK_RESET_STOP               (1 << 5)
#define USBD_MASK_RESET_START              (1 << 4)
#define USBD_MASK_RES                      (1 << 3)
#define USBD_MASK_SUSP                     (1 << 2)
#define USBD_MASK_FRAME_MATCH              (1 << 1)
#define USBD_MASK_CFG_CHG                  (1 << 0)

#define USBD_MCTL                        0x00212020
#define USBD_MCTL_MEMC                    (1 << 24)

#define USBD_ENAB                        0x00212024
#define USBD_ENAB_RST                     (1 << 31)
#define USBD_ENAB_ENAB                    (1 << 30)
#define USBD_ENAB_SUSPEND                 (1 << 29)
#define USBD_ENAB_TSIZE                    (1 << 0)

#define USBD_EP_STAT(ep)     (0x00212030+(ep*0x30))
#define USBD_EP_STAT_BYTE_COUNT_MASK   (0x7f << 16)
#define USBD_EP_STAT_BYTE_COUNT_BIT              16
#define USBD_EP_STAT_SIP                   (1 << 8)
#define USBD_EP_STAT_DIR                   (1 << 7)
#define USBD_EP_STAT_MAX_MASK            (0x3 << 5)
#define USBD_EP_STAT_MAX_BIT                      5
#define USBD_EP_STAT_MAX_8                      0x0
#define USBD_EP_STAT_MAX_16                     0x1
#define USBD_EP_STAT_MAX_32                     0x2
#define USBD_EP_STAT_MAX_64                     0x3
#define USBD_EP_STAT_TYP_MASK            (0x3 << 3)
#define USBD_EP_STAT_TYP_BIT                      3
#define USBD_EP_STAT_ZLPS                  (1 << 2)
#define USBD_EP_STAT_FLUSH                 (1 << 1)
#define USBD_EP_STAT_FORCE_STALL           (1 << 0)

#define USBD_EP_INTR(ep)     (0x00212034+(ep*0x30))
#define USBD_EP_INTR_FIFO_FULL             (1 << 8)
#define USBD_EP_INTR_FIFO_EMPTY            (1 << 7)
#define USBD_EP_INTR_FIFO_ERROR            (1 << 6)
#define USBD_EP_INTR_FIFO_HIGH             (1 << 5)
#define USBD_EP_INTR_FIFO_LOW              (1 << 4)
#define USBD_EP_INTR_MDEVREQ               (1 << 3)
#define USBD_EP_INTR_EOT                   (1 << 2)
#define USBD_EP_INTR_DEVREQ                (1 << 1)
#define USBD_EP_INTR_EOF                   (1 << 0)

#define USBD_EP_MASK(ep)     (0x00212038+(ep*0x30))
#define USBD_EP_MASK_FIFO_FULL             (1 << 8)
#define USBD_EP_MASK_FIFO_EMPTY            (1 << 7)
#define USBD_EP_MASK_FIFO_ERROR            (1 << 6)
#define USBD_EP_MASK_FIFO_HIGH             (1 << 5)
#define USBD_EP_MASK_FIFO_LOW              (1 << 4)
#define USBD_EP_MASK_MDEVREQ               (1 << 3)
#define USBD_EP_MASK_EOT                   (1 << 2)
#define USBD_EP_MASK_DEVREQ                (1 << 1)
#define USBD_EP_MASK_EOF                   (1 << 0)

#define USBD_EP_FDAT(ep)     (0x0021203C+(ep*0x30))

#define USBD_EP_FSTAT(ep)    (0x00212040+(ep*0x30))
#define USBD_EP_FSTAT_FRAME0              (1 << 27)
#define USBD_EP_FSTAT_FRAME1              (1 << 26)
#define USBD_EP_FSTAT_FRAME2              (1 << 25)
#define USBD_EP_FSTAT_FRAME3              (1 << 24)
#define USBD_EP_FSTAT_ERROR               (1 << 22)
#define USBD_EP_FSTAT_OF                  (1 << 21)
#define USBD_EP_FSTAT_UF                  (1 << 20)
#define USBD_EP_FSTAT_FR                  (1 << 19)
#define USBD_EP_FSTAT_FULL                (1 << 18)
#define USBD_EP_FSTAT_ALARM               (1 << 17)
#define USBD_EP_FSTAT_EMPTY               (1 << 16)

#define USBD_EP_FCTRL(ep)    (0x00212044+(ep*0x30))
#define USBD_EP_FCTRL_WFR                 (1 << 29)
#define USBD_EP_FCTRL_FRAME               (1 << 27)
#define USBD_EP_FCTRL_GR_MASK           (0x6 << 24)
#define USBD_EP_FCTRL_GR_BIT                     24

#define USBD_EP_LRFP(ep)     (0x00212048+(ep*0x30))
#define USBD_EP_LWFP(ep)     (0x0021204c+(ep*0x30))
#define USBD_EP_FALRM(ep)    (0x00212050+(ep*0x30))
#define USBD_EP_FRDP(ep)     (0x00212054+(ep*0x30))
#define USBD_EP_FWRP(ep)     (0x00212058+(ep*0x30))


/* WDT : Watchdog Timer */
#define WDOG_BASE          0x00201000
#define WDOG_WCR                 0x00
#define WDOG_WSR                 0x04
#define WDOG_WSTR                0x08


/* 	END */
#endif
