/*
* include/asm-arm/arch-mx1ads/preem_latency.h
*
* Inrerrupt latency for the MX1 board
*
* Author: MontaVista Software Inc. <source@mvista.com>
*
* 1999-2003 (c) MontaVista Software, Inc. This file is licensed under
* the terms of the GNU General Public License version 2. This program
* is licensed "as is" without any warranty of any kind, whether express
* or implied.
*/
#include <asm/hardware.h>

extern unsigned int read_mputimer1(void);

#define readclock_init()
#define readclock(x)             x = read_mputimer1()
#define clock_to_usecs(x)        ((x) / 6)

#define PSR_I_BIT               0x80    /* IRQ unmask/mask (0/1) */
#define INTERRUPTS_ENABLED(x)   (!(x & PSR_I_BIT))
/* mputimer 1 runs @ 6Mhz  6 ticks = 1 microsecond */
#define TICKS_PER_USEC		6
