/*
 * linux/include/asm-arm/arch-s3c2800/irqs.h
 *
 * Copyright (C) 2002 SAMSUNG ELECTRONIS  
 *                        SW.LEE (hitchcar@sec.samsung.com)
 * 2003 (c) MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __S3C2800_IRQS_H
#define __S3C2800_IRQS_H                        1

/* bits in interrupt register */
#define BIT_SHIFT_EINT0		(0)
#define BIT_SHIFT_EINT1		(1)
#define BIT_SHIFT_EINT2		(2)
#define BIT_SHIFT_EINT3		(3)
#define BIT_SHIFT_EINT4		(4)
#define BIT_SHIFT_EINT5		(5)
#define BIT_SHIFT_EINT6		(6)
#define BIT_SHIFT_EINT7		(7)
#define BIT_SHIFT_PCI		(8)
#define BIT_SHIFT_RESERVED	(9)
#define BIT_SHIFT_DMA0		(10)
#define BIT_SHIFT_DMA1		(11)
#define BIT_SHIFT_DMA2		(12)
#define BIT_SHIFT_DMA3		(13)
#define BIT_SHIFT_TIMER0	(14)
#define BIT_SHIFT_TIMER1	(15)
#define BIT_SHIFT_TIMER2	(16)
#define BIT_SHIFT_IIC0		(17)
#define BIT_SHIFT_IIC1		(18)
#define BIT_SHIFT_RXD0		(19)
#define BIT_SHIFT_RXD1		(20)
#define BIT_SHIFT_TXD0		(21)
#define BIT_SHIFT_TXD1		(22)
#define BIT_SHIFT_UERR0		(23)
#define BIT_SHIFT_UERR1		(24)
#define BIT_SHIFT_RMT		(25)
#define BIT_SHIFT_FULL  	(26)
#define BIT_SHIFT_TICK  	(27)
#define BIT_SHIFT_RTC   	(28)

#define IRQ_EINT0	BIT_SHIFT_EINT0
#define IRQ_EINT1	BIT_SHIFT_EINT1
#define IRQ_EINT2	BIT_SHIFT_EINT2
#define IRQ_EINT3	BIT_SHIFT_EINT3
#define IRQ_EINT4	BIT_SHIFT_EINT4
#define IRQ_EINT5	BIT_SHIFT_EINT5
#define IRQ_EINT6	BIT_SHIFT_EINT6
#define IRQ_EINT7	BIT_SHIFT_EINT7
#define IRQ_PCI		BIT_SHIFT_PCI
#define IRQ_DMA0	BIT_SHIFT_DMA0
#define IRQ_DMA1	BIT_SHIFT_DMA1
#define IRQ_DMA2	BIT_SHIFT_DMA2
#define IRQ_DMA3	BIT_SHIFT_DMA3
#define IRQ_TIMER0	BIT_SHIFT_TIMER0
#define IRQ_TIMER1	BIT_SHIFT_TIMER1
#define IRQ_TIMER2	BIT_SHIFT_TIMER2
#define IRQ_IIC0	BIT_SHIFT_IIC0
#define IRQ_IIC1	BIT_SHIFT_IIC1
#define IRQ_RXD0	BIT_SHIFT_RXD0
#define IRQ_RXD1	BIT_SHIFT_RXD1
#define IRQ_TXD0	BIT_SHIFT_TXD0
#define IRQ_TXD1	BIT_SHIFT_TXD1
#define IRQ_UERR0	BIT_SHIFT_UERR0
#define IRQ_UERR1	BIT_SHIFT_UERR1
#define IRQ_RMT		BIT_SHIFT_RMT
#define IRQ_FULL	BIT_SHIFT_FULL
#define IRQ_TICK	BIT_SHIFT_TICK
#define IRQ_RTC		BIT_SHIFT_RTC

#define NoIntBase	  32  /* Normal Interrupt Base */

#define IRQ_DUMMY	(NoIntBase+1)
#define NR_IRQS		(NoIntBase+1)

//#define OS_TIMER	  IRQ_TIMER4 /* Used in irq.c */

#if 0
/****************   This External IRQ **********/
#define IRQ_EINT4	 (NoIntBase+0)
#define IRQ_EINT5	 (NoIntBase+1)
#define IRQ_EINT6	 (NoIntBase+2)
#define IRQ_EINT7	 (NoIntBase+3)
#define IRQ_EINT8	 (NoIntBase+4)
#define IRQ_EINT9	 (NoIntBase+5)
#define IRQ_EINT10	(NoIntBase+6)
#define IRQ_EINT11	(NoIntBase+7)
#define IRQ_EINT12	(NoIntBase+8)
#define IRQ_EINT13	(NoIntBase+9) 
#define IRQ_EINT14	(NoIntBase+10)
#define IRQ_EINT15	(NoIntBase+11)
#define IRQ_EINT16	(NoIntBase+12) 
#define IRQ_EINT17	(NoIntBase+13) 
#define IRQ_EINT18	(NoIntBase+14) 
#define IRQ_EINT19	(NoIntBase+15) 
#define IRQ_EINT20	(NoIntBase+16) 
#define IRQ_EINT21	(NoIntBase+17) 
#define IRQ_EINT22	(NoIntBase+18) 
#define IRQ_EINT23	(NoIntBase+19)
/*************************************************/

#define IRQ_RXD0	  (NoIntBase+20)
#define IRQ_TXD0	  (NoIntBase+21)
#define IRQ_ERR0	  (NoIntBase+22)
#define IRQ_RXD1	  (NoIntBase+23)
#define IRQ_TXD1	  (NoIntBase+24) 
#define IRQ_ERR1	  (NoIntBase+25)
#define IRQ_RXD2	  (NoIntBase+26)
#define IRQ_TXD2	  (NoIntBase+27)
#define IRQ_ERR2	  (NoIntBase+28) 
#define IRQ_TC		(NoIntBase+29)  
#define IRQ_ADCDone	 (NoIntBase+30)  /* 62 */
#define IRQ_DUMMY	 (NoIntBase+31)
#define NR_IRQS	   ((NoIntBase+30)+1)
#endif


#endif /* __S3C2800_IRQS_H */
