/*
 * include/asm-arm/arch-s3c2800/preem_latency.h
 *
 * Support for preemptible kernel latency measurement times
 *
 * The readclock() macro must return the contents of a monotonic incremental
 * counter.
 *
 * NOTES:
 *
 * 1. This implementation uses the S3C2800 TIMER0 exclusively for
 *    preemptible latency measurements. It must not be used for any other
 *    purpose during preemptible kernel latency measurement.
 *
 * 2. Due to limited range of the timers, it is necessary to make tradeoffs
 *    between min/max latency periods. As currently configured, the min/max
 *    latency which can be measured is approximately 667nS/43.7mS respectively.
 *    If latency times exceed approx 43.7 milliseconds, overflow will occur.
 *
 * Author: George G. Davis <gdavis@mvista.com>
 *
 * Copyright 2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any  warranty of any kind, whether express
 * or implied.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <asm/hardware.h>

/* (50,750,000 / 4) / 14 = 1.1us */
#define TIMER0_PRESCALER	14

#define readclock_init()	do {					\
	rTMCNT0 = 0; 							\
	rTMCON0 = SYS_TIMER_MUX_1_4 | SYS_TIMER_INT_DMA_ENA; 		\
	rTMDATA0 = (TIMER0_PRESCALER << 16) | 0xffff;			\
	rTMCON0 |= SYS_TIMER_COUNT_ENA; 				\
	} while (0)

#define readclock(x)	do {						\
		/* 32-bit left justify so the math just works. */	\
		x = (~(rTMCNT0)) << 16;					\
	} while (0)

#define clock_to_usecs(x)	((x) >> 16)

#define TICKS_PER_USEC          1	/* approx 1/precisely 1.1  : ( */
