/*
 * linux/include/asm-arm/arch-s3c2800/uncompress.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* physical addresses */
#define PA_GPIO_BASE	0x10100000
#define PA_UART_BASE	0x10170000

/* gpio ports */
#define rPCONA  (*(volatile unsigned *)(PA_GPIO_BASE+0x00)) //Port A control
#define rPDATA  (*(volatile unsigned *)(PA_GPIO_BASE+0x04)) //Port A data
#define rPUPA	(*(volatile unsigned *)(PA_GPIO_BASE+0x04)) //Port A data
                        
#define rPCONB  (*(volatile unsigned *)(PA_GPIO_BASE+0x0c)) //Port B control
#define rPDATB  (*(volatile unsigned *)(PA_GPIO_BASE+0x10)) //Port B data
                        
#define rPCONC  (*(volatile unsigned *)(PA_GPIO_BASE+0x18)) //Port C control
#define rPDATC  (*(volatile unsigned *)(PA_GPIO_BASE+0x1c)) //Port C data
#define rPUPC   (*(volatile unsigned *)(PA_GPIO_BASE+0x20)) //Pull-up control C
                        
#define rPCOND  (*(volatile unsigned *)(PA_GPIO_BASE+0x24)) //Port D control
#define rPDATD  (*(volatile unsigned *)(PA_GPIO_BASE+0x28)) //Port D data
#define rPUPD   (*(volatile unsigned *)(PA_GPIO_BASE+0x2c)) //Pull-up control D
                        
#define rPCONE  (*(volatile unsigned *)(PA_GPIO_BASE+0x30)) //Port E control
#define rPDATE  (*(volatile unsigned *)(PA_GPIO_BASE+0x34)) //Port E data
#define rPUPE   (*(volatile unsigned *)(PA_GPIO_BASE+0x38)) //Pull-up control E
                        
#define rPCONF  (*(volatile unsigned *)(PA_GPIO_BASE+0x3c)) //Port F control
#define rPDATF  (*(volatile unsigned *)(PA_GPIO_BASE+0x40)) //Port F data
#define rPUPFF  (*(volatile unsigned *)(PA_GPIO_BASE+0x44)) //Pull-up control F

#define rSPUCR  (*(volatile unsigned *)(PA_GPIO_BASE+0x4c)) //Special pull-up control

/* level trigger and edge trigger */
#define rEXTINTR   (*(volatile unsigned *)(PA_GPIO_BASE+0x48)) //External interrupt control register

/*  UART */
#define rULCON0     (*(volatile unsigned *)(PA_UART_BASE+0x00)) //UART 0 Line control
#define rUCON0      (*(volatile unsigned *)(PA_UART_BASE+0x04)) //UART 0 Control
#define rUFCON0     (*(volatile unsigned *)(PA_UART_BASE+0x08)) //UART 0 FIFO control
#define rUMCON0     (*(volatile unsigned *)(PA_UART_BASE+0x0c)) //UART 0 Modem control
#define rUTRSTAT0   (*(volatile unsigned *)(PA_UART_BASE+0x10)) //UART 0 Tx/Rx status
#define rUTXH0	    (*(volatile unsigned char *)(PA_UART_BASE+0x20))

#define rUBRDIV0    (*(volatile unsigned *)(PA_UART_BASE+0x28)) //UART 0 Baud rate divisor

#define SER_BAUD_9600    9600 
#define SER_BAUD_14400   11400
#define SER_BAUD_19200   19200
#define SER_BAUD_38400   38400
#define SER_BAUD_57600   57600
#define SER_BAUD_115200  115200
#define CURRENT_BAUD_RATE  SER_BAUD_115200

/* clock parameters */
#define  FCLK 202800000
#define  HCLK (FCLK/2)
#define  PCLK (HCLK/2)

/********************************************/


/* led on chamelot board */
static void led_display(int data)
{
	rPDATF = (data & 0xf) << 4;
}

static void uart_putc(int data) 
{ 
        if (data == '\n')
		uart_putc('\r');

	/* wait until THR is empty */
        while (!(rUTRSTAT0 & 0x2))
		;
{ volatile long l; for (l = 0; l < 5000; l++); }

        rUTXH0 = data; 
}                

static void putc(const char c)
{
	uart_putc(c);
}

static void puts(const char *s)
{
	while (*s) 
		uart_putc(*s++);
}


static void uart_init(int pclk, int baud) 
{ 
	rUFCON0 = 0x0;   /* UART 0 FIFO control register, FIFO disable */
	rUMCON0 = 0x0;   /* UART  0 MODEM control register, AFC disable */
	rULCON0 = 0x3;
	rUCON0  = 0x245; /* control register */
	rUBRDIV0 = ((int)(pclk/16/baud) - 1); /* baud rate div register 0 */

	{
		volatile int i; 
		for (i = 0; i < 100; i++) ; 
	}
} 

#define arch_decomp_wdog()

static void port_init(void)
{
	/* setup gpio's */
	rPCONA = 0x0000003f;
	rPCONB = 0x0000f0ff;
	rPCONC = 0x00000000;
	rPCOND = 0x00000f0f;
	rPCONE = 0x00000000;
	rPUPE = 0x000000ff;
	rPCONF = 0x0000550f;

#if 0
	/* external interrupt will be falling edge triggered. */
	rEXTINTR = 0x00000000;
#endif
}

static void arch_decomp_setup()
{
	port_init();
	led_display(6);
	uart_init(PCLK, CURRENT_BAUD_RATE);
}

