/*
 * Robert Lembree, lembree@metrolink.com
 * Copyright (C) 2001 Metro Link, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 */
#ifndef _MIPS_XILLEON_H
#define _MIPS_XILLEON_H

#include <asm/addrspace.h>
#include <asm/io.h>

#include <asm/ati/xilleonreg_kernel.h>


#define CRASH_ME __asm__("lw $1,0($0)\n")

/* 
 * Xilleon I/O ports base address. 
*/

#define XILLEON_PORT_BASE    KSEG1

#define XILLEON_HBIUBASE     (KSEG1ADDR(0x08000000))
#define XILLEON_PCIC1BASE    (KSEG1ADDR(0x10000000))
#define XILLEON_REGBASE      (KSEG1ADDR(0x18000000))
#define XILLEON_PCIC2BASE    (KSEG1ADDR(0x1a000000))
#define XILLEON_PCUBASE      (KSEG1ADDR(0x1c000000))

#define XILLEON_MEMSIZE     0x08000000
#define XILLEON_HBIUSIZE    0x08000000
#define XILLEON_PCIC1SIZE   0x08000000
#define XILLEON_REGSIZE     0x00010000
#define XILLEON_PCIC2SIZE   0x02000000
#define XILLEON_PCUSIZE     0x04000000

/*
 * PCU memory map
 */

#define PCU_BASE                0x1c000000
#define XILLEON_CORE_FLASH_BASE 0x1c200000
#define XILLEON_DOC_BASE        0x1c400000
#define XILLEON_LCD_BASE        0x1c500000


#define XILLEON_NAND_FLASH_BASE 0x1c002c40



/*
#define XILLEON_IPA_BASE  (XILLEON_PCUBASE +  (GETFLD_REGMM32(APER_PCU_IPA_ADDR, BASE_ADDRESS) << 16)) 
*/

#ifdef CONFIG_STW4X225
#define XILLEON_IPA_BASE        0x1e000000
#else
#define XILLEON_IPA_BASE        0x1c600000
#endif

#define XILLEON_UART0_REGS_BASE  (XILLEON_IPA_BASE + 0x10 + KSEG1)
#define XILLEON_UART1_REGS_BASE  (XILLEON_IPA_BASE + 0x0 + KSEG1)
#define XILLEON_UIRT_REGS_BASE  (XILLEON_IPA_BASE + 0x80 + KSEG1)

/* used to hardcoded IPA_BASE for STW3X22X boards */
#define XILLEON_STW3_IPA_BASE        0x1c600000 
#define XILLEON_STW3_UART0_REGS_BASE  (XILLEON_STW3_IPA_BASE + 0x10 + KSEG1)
#define XILLEON_STW3_UART1_REGS_BASE  (XILLEON_STW3_IPA_BASE + 0x0 + KSEG1)


#define XILLEON_NIM1_BASE       0x1c800000
#define XILLEON_NIM2_BASE       0x1cc00000
#define XILLEON_USER_FLASH_BASE 0x1d000000

#define XILLEON_CORE_FLASH_SIZE 0x00200000  // 2M
#define XILLEON_DOC_SIZE        0x00100000  // 1M
#define XILLEON_LCD_SIZE        0x00100000  // 1M
#define XILLEON_IPA_SIZE        0x00010000  // 64K
#define XILLEON_NIM1_SIZE       0x00400000  // 4M
#define XILLEON_NIM2_SIZE       0x00400000  // 4M
#define XILLEON_USER_FLASH_SIZE 0x01000000  // 16M


#define XILLEON_NAND_FLASH_SIZE 0x02000000


#ifdef CONFIG_IKOS
#define XILLEON_BASE_BAUD ( 97323 / 16 ) 
#else
#define XILLEON_BASE_BAUD ( 48000000 / 16 ) 
#endif
/*
 * Internal macros
 */
#define VAL2FLD(reg, field, val)		(((unsigned long)(val) << reg##__##field##__SHIFT) & reg##__##field##__MASK)
#define FLD2VAL(reg, field, val)		(((val) & reg##__##field##__MASK) >> reg##__##field##__SHIFT)
#define MODIFYFLD(var, reg, field, val)		(var = (var & (~reg##__##field##__MASK)) | (((unsigned long)(val) << reg##__##field##__SHIFT) & reg##__##field##__MASK))

/*
 * Macros for APER space access
 */

#define APER_READ_32(base,offset)  (*(volatile u32 *)((KSEG1)+(base)+(offset)))
#define APER_READ_16(base,offset)  (*(volatile u16 *)((KSEG1)+(base)+(offset)))
#define APER_READ_8(base,offset)   (*(volatile u8 *)((KSEG1)+(base)+(offset)))

#define APER_WRITE_32(base,offset,data)  (*(volatile u32 *)((KSEG1)+(base)+(offset)) = (data))
#define APER_WRITE_16(base,offset,data)  (*(volatile u16 *)((KSEG1)+(base)+(offset)) = (data))
#define APER_WRITE_8(base,offset,data)  (*(volatile u8 *)((KSEG1)+(base)+(offset)) = (data))


/* Macros for PFLASH access */
#define PFLASH_BASE             0x0

#define PFLASH_READ_32(offset)  APER_READ_32((PCU_BASE+PFLASH_BASE),offset)
#define PFLASH_READ_16(offset)  APER_READ_16((PCU_BASE+PFLASH_BASE),offset)
#define PFLASH_READ_8(offset)   APER_READ_8((PCU_BASE+PFLASH_BASE),offset)

#define PFLASH_WRITE_32(offset,data) APER_WRITE_32((PCU_BASE+PFLASH_BASE),offset,data)
#define PFLASH_WRITE_16(offset,data) APER_WRITE_16((PCU_BASE+PFLASH_BASE),offset,data)
#define PFLASH_WRITE_8(offset,data)  APER_WRITE_8((PCU_BASE+PFLASH_BASE),offset,data)

#define GETMEM_PFLASH_32(offset) PFLASH_READ_32(offset)
#define GETMEM_PFLASH_16(offset) PFLASH_READ_16(offset)
#define GETMEM_PFLASH_8(offset)  PFLASH_READ_8(offset)

#define SETMEM_PFLASH_32(offset,data) PFLASH_WRITE_32(offset,data)
#define SETMEM_PFLASH_16(offset,data) PFLASH_WRITE_16(offset,data)
#define SETMEM_PFLASH_8(offset,data) PFLASH_WRITE_8(offset,data)

/* Macros for SFLASH access */

#define SFLASH_BASE             0x0

#define SFLASH_READ_32(offset)  APER_READ_32((PCU_BASE+SFLASH_BASE),offset)
#define SFLASH_READ_16(offset)  APER_READ_16((PCU_BASE+SFLASH_BASE),offset)
#define SFLASH_READ_8(offset)   APER_READ_8((PCU_BASE+SFLASH_BASE),offset)

#define SFLASH_WRITE_32(offset,data) APER_WRITE_32((PCU_BASE+SFLASH_BASE),offset,data)
#define SFLASH_WRITE_16(offset,data) APER_WRITE_16((PCU_BASE+SFLASH_BASE),offset,data)
#define SFLASH_WRITE_8(offset,data)  APER_WRITE_8((PCU_BASE+SFLASH_BASE),offset,data)

#define GETMEM_SFLASH_32(offset) SFLASH_READ_32(offset)
#define GETMEM_SFLASH_16(offset) SFLASH_READ_16(offset)
#define GETMEM_SFLASH_8(offset)  SFLASH_READ_8(offset)

#define SETMEM_SFLASH_32(offset,data) SFLASH_WRITE_32(offset,data)
#define SETMEM_SFLASH_16(offset,data) SFLASH_WRITE_16(offset,data)
#define SETMEM_SFLASH_8(offset,data) SFLASH_WRITE_8(offset,data)


/*
 * Macros for "register" I/O space
 */
#define GETREG_REGMM32(reg)       (*(volatile u32 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM32(reg,value) (*(volatile u32 *)(XILLEON_REGBASE + mm##reg) = value)
#define GETREG_REGMM16(reg)       (*(volatile u16 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM16(reg,value) (*(volatile u16 *)(XILLEON_REGBASE + mm##reg) = value)
#define GETREG_REGMM8(reg)        (*(volatile u8 *)(XILLEON_REGBASE + mm##reg))
#define SETREG_REGMM8(reg,value)  (*(volatile u8 *)(XILLEON_REGBASE + mm##reg) = value)

#define GETFLD_REGMM32(reg, field)	  (FLD2VAL(reg, field, GETREG_REGMM32(reg)))
#define SETFLD_REGMM32(reg, field, val)	  SETREG_REGMM32(reg, (GETREG_REGMM32(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM32(reg,field)	  (GETREG_REGMM32(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM32(reg,field)	  SETREG_REGMM32(reg, GETREG_REGMM32(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM32(reg,field)	  SETREG_REGMM32(reg, GETREG_REGMM32(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM32(reg,field)     SETREG_REGMM32(reg, GETREG_REGMM32(reg) ^ reg##__##field##__MASK)

#define GETFLD_REGMM16(reg, field)	  (FLD2VAL(reg, field, GETREG_REGMM16(reg)))
#define SETFLD_REGMM16(reg, field, val)	  SETREG_REGMM16(reg, (GETREG_REGMM16(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM16(reg,field)	  (GETREG_REGMM16(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM16(reg,field)	  SETREG_REGMM16(reg, GETREG_REGMM16(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM16(reg,field)	  SETREG_REGMM16(reg, GETREG_REGMM16(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM16(reg,field)     SETREG_REGMM16(reg, GETREG_REGMM16(reg) ^ reg##__##field##__MASK)

#define GETFLD_REGMM8(reg, field)	 (FLD2VAL(reg, field, GETREG_REGMM8(reg)))
#define SETFLD_REGMM8(reg, field, val)	 SETREG_REGMM8(reg, (GETREG_REGMM8(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_REGMM8(reg,field)	 (GETREG_REGMM8(reg) & reg##__##field##__MASK)
#define SETFLAG_REGMM8(reg,field)	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) | reg##__##field##__MASK)
#define CLEARFLAG_REGMM8(reg,field)	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_REGMM8(reg,field)   	 SETREG_REGMM8(reg, GETREG_REGMM8(reg) ^ reg##__##field##__MASK)
/*
 * Registers for PCU IPA I/O space
 */
#define GETREG_PCUIPAMM32(reg)       (*(volatile u32 *)(KSEG1ADDR(XILLEON_IPA_BASE) + mmpcuipa##reg))
#define SETREG_PCUIPAMM32(reg,value) (*(volatile u32 *)(KSEG1ADDR(XILLEON_IPA_BASE) + mmpcuipa##reg) = value)
#define GETFLD_PCUIPAMM32(reg, field)	  (FLD2VAL(reg, field, GETREG_PCUIPAMM32(reg)))
#define SETFLD_PCUIPAMM32(reg, field, val)	  SETREG_PCUIPAMM32(reg, (GETREG_PCUIPAMM32(reg) & ~reg##__##field##__MASK) | VAL2FLD(reg, field, val))
#define GETFLAG_PCUIPAMM32(reg,field)	  (GETREG_PCUIPAMM32(reg) & reg##__##field##__MASK)
#define SETFLAG_PCUIPAMM32(reg,field)	  SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) | reg##__##field##__MASK)
#define CLEARFLAG_PCUIPAMM32(reg,field)	  SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) & ~reg##__##field##__MASK)
#define TOGGLEFLAG_PCUIPAMM32(reg,field)     SETREG_PCUIPAMM32(reg, GETREG_PCUIPAMM32(reg) ^ reg##__##field##__MASK)

#endif /* !(_MIPS_XILLEON_H) */
