/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Definitions for Dallas DS1501 RTC present on IDT 79EB355 board.
 *
 * Author: Steve Longerbeam <stevel@mvista.com, or source@mvista.com>
 *
 * 2002 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef _DS1501RTC_H_
#define _DS1501RTC_H_

/* Image of DS1501 registers */
typedef struct {
	u8 secs;
	u8 mins;
	u8 hours;
	u8 weekday;
	u8 date;
	u8 month;
	u8 year;
	u8 century;
	u8 alarm_secs;
	u8 alarm_mins;
	u8 alarm_hours;
	u8 alarm_day_date;
	u8 watchdog_a;
	u8 watchdog_secs;
	u8 control_a;
	u8 control_b;
	u8 nvram_addr;
	u8 dummy[2];
	u8 nvram_data;
} ds1501_regs_t;

#define rtc ((ds1501_regs_t*)KSEG1ADDR(RTC_BASE))

/*
 * Control register bit definitions
 */
#define TDC_ENA_BUFF    0x80
#define TDC_DIS_BUFF    0x7f

#define TDS_STOP    	0x80

#endif /* _DS1501RTC_H */
