#ifndef __IDT_OCM_H__
#define __IDT_OCM_H__

/*******************************************************************************
 *
 * Copyright 2002 Integrated Device Technology, Inc.
 *		All rights reserved.
 *
 * On-chip memory register definitions.
 *
 * File   : $Id: ocm.h,v 1.2 2003/07/30 18:20:38 stevel Exp $
 *
 * Author : Allen.Stichter@idt.com
 * Date   : 20011005
 * Update :
 *	    $Log: ocm.h,v $
 *	    Revision 1.2  2003/07/30 18:20:38  stevel
 *	    MR: 1-2IQL9
 *	
 *	    Add IDT and ATI Xilleon LSP's, and update related drivers.
 *	
 *	    Revision 1.1.2.1  2003/02/15 00:06:01  stevel
 *	    New IDT board support: 79EB438 and 79RP355. Also support for
 *	    boot from PROM on 79S334A, 79EB355, 79RP355, and 79EB438.
 *	
 *	    Revision 1.2  2002/06/06 18:34:04  astichte
 *	    Added XXX_PhysicalAddress and XXX_VirtualAddress
 *	
 *	    Revision 1.1  2002/05/29 17:33:23  sysarch
 *	    jba File moved from vcode/include/idt/acacia
 *	
 *
 ******************************************************************************/

enum
{
	OCM0_PhysicalAddress	= 0x18098000,
	OCM_PhysicalAddress	= OCM0_PhysicalAddress,

	OCM0_VirtualAddress	= 0xb8098000,
	OCM_VirtualAddress	= OCM0_VirtualAddress,
} ;

typedef struct OCM_s
{
	unsigned int	ocmbase ;
	unsigned int	ocmmask ;
} volatile *OCM_t ;

enum
{
	OCMBASE_baseaddr_b	= 0,
	OCMBASE_baseaddr_m	= 0xffff0000,
	OCMMASK_mask_b		= 0,
	OCMMASK_mask_m		= 0xffff0000,
} ;

#endif	// __IDT_OCM_H__
