#ifndef TX4925_TOSHIBA_RBTX4925
#define TX4925_TOSHIBA_RBTX4925

/*
 * linux/include/asm-mips/tx4925/toshiba_rbtx4925.h
 *
 * rbtx4925 defs
 *
 * Author: MontaVista Software, Inc.  source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#include <asm/addrspace.h>

#ifdef CONFIG_PCI
#include <asm/tx4925/tx4925_pci.h>
#endif

#define TOSHIBA_RBTX4925_WR08(a,b) do { TX4925_WR08(a,b); wbflush(); } while ( 0 )

#define TX4925_PCIMEM           0x08000000
#define TX4925_PCIMEM_SIZE      0x08000000
#define TX4925_PCIIO            0x04000000
#define TX4925_PCIIO_SIZE       0x01000000

/*
 *  * PCMCIA Mapping
 *   */
#define RBTX4925_PCMCIA_ATTR            0x08000000
#define RBTX4925_PCMCIA_ATTR_SIZE       0x04000000
#define RBTX4925_PCMCIA_MEM             0x0c000000
#define RBTX4925_PCMCIA_MEM_SIZE        0x04000000
#define RBTX4925_PCMCIA_IO              0x10000000
#define RBTX4925_PCMCIA_IO_SIZE         0x01000000

#define RBTX4925_PCMCIA_IO_OFFSET (RBTX4925_PCMCIA_IO+RBTX4925_PCMCIA_IO_SIZE)

#ifndef CONFIG_PCMCIA_RBTX4925
#ifdef CONFIG_PCI
#define RBTX4925_ISA_IO_OFFSET TX4925_PCIIO
#else
#define RBTX4925_ISA_IO_OFFSET 0
#endif
#else
#define RBTX4925_ISA_IO_OFFSET RBTX4925_PCMCIA_IO_OFFSET
#endif

#define RBTX4925_SW_RESET_DO         0xbb007000
#define RBTX4925_SW_RESET_DO_SET                0x01

#define RBTX4925_SW_RESET_ENABLE     0xbb007002
#define RBTX4925_SW_RESET_ENABLE_SET            0x01

#define RBTX4925_SW_RESET_PCI        0xbb007004
#define RBTX4925_SW_RESET_PCI_SET                0x01

#define RBTX4925_RTL_8019_BASE (0x1b020280-RBTX4925_ISA_IO_OFFSET)
#define RBTX4925_RTL_8019_IRQ  (27)
#define RBTX4925_PCMCIA_IRQ 64

/*
 *  * for IO-C
 *   */
#define RBTX4925_IOC_BASE               KSEG1ADDR( 0x1b000000 )

#define RBTX4925_IOC_BD_DEF             0x0000
#define RBTX4925_IOC_FNC_DEF            0x0002
#define RBTX4925_IOC_CONF1              0x0004
#define RBTX4925_IOC_CONF2              0x0006
#define RBTX4925_IOC_LED                0x1000
#define RBTX4925_IOC_DIPSW              0x1002
#define RBTX4925_IOC_INT_MASK           0x2000
#define RBTX4925_IOC_INT_POLE           0x2002
#define RBTX4925_IOC_INT_STAT1          0x2004
#define RBTX4925_IOC_INT_STAT2          0x2006
#define RBTX4925_IOC_SWI                0x3000
#define RBTX4925_IOC_SIO0_DTR           0x3002
#define RBTX4925_IOC_PCMCIA_INT_MASK    0x4000
#define RBTX4925_IOC_PCMCIA_INT_POLE    0x4002
#define RBTX4925_IOC_PCMCIA_INT_STAT1   0x4004
#define RBTX4925_IOC_PCMCIA_INT_STAT2   0x4006
#define RBTX4925_IOC_PIOSEL             0x5000
#define RBTX4925_IOC_NDF_WP             0x5002
#define RBTX4925_IOC_SEEPROM_CS         0x6000
#define RBTX4925_IOC_SEEPROM_SK         0x6002
#define RBTX4925_IOC_SEEPROM_DO         0x6004
#define RBTX4925_IOC_SEEPROM_DI         0x6006
#define RBTX4925_IOC_MPU_SWRST          0x7000
#define RBTX4925_IOC_MPU_SWRST_LOCK     0x7002
#define RBTX4925_IOC_PCI_SWRST          0x7004

#define RBTX4925_IOC_REG_ADDR( reg )    ( RBTX4925_IOC_BASE + RBTX4925_IOC_##reg )
#define RBTX4925_IOC_REG( reg )         ( *(volatile u8*)RBTX4925_IOC_REG_ADDR( reg ) )

#define RBTX4925_PIOSEL              0xbb005000

/* bits for PIOSEL */
#define TX4925_PIOSEL_SIO(ch)        (0x01<<(ch))
#define TX4925_PIOSEL_NOPCTOE        0x04
#define TX4925_PIOSEL_NOSMART        0x08
#define TX4925_PIOSEL_NOACLINK       0x10
#define TX4925_PIOSEL_NOPCMCIA       0x20

#define tx4925_pioselptr        ((volatile unsigned char *)RBTX4925_PIOSEL)

/* bits for PIOSEL */
#define RBTX4925_PIOSEL_NOPCMCIA        0x20
#define RBTX4925_PIOSEL_NOACLINK        0x10
#define RBTX4925_PIOSEL_NOSMART         0x08
#define RBTX4925_PIOSEL_NOPCTOE         0x04
#define RBTX4925_PIOSEL_SIO1            0x02
#define RBTX4925_PIOSEL_SIO0            0x01
#define RBTX4925_PIOSEL_SIO( ch )       ( RBTX4925_PIOSEL_SIO0 << ch )

/*
 *  * for PCMCIA
 *   */
#define RBTX4925_PCMCIA_BASE            KSEG1ADDR( 0x1b010000 )

/* LinkUp L1121 register definitions. */
#define L1121_IDR1                      0x00
#define L1121_IDR2                      0x04
#define L1121_IDR3                      0x08
#define L1121_IDR4                      0x0c
#define L1121_SR                        0x10
#define L1121_ISR                       0x14
#define L1121_EISR                      0x18
#define L1121_CR1                       0x24
#define L1121_CR2                       0x28
#define L1121_IER                       0x2c
#define L1121_ESNR                      0x30
#define L1121_ITSR                      0x34
#define L1121_ECLR                      0x38
#define L1121_CR3                       0x3c
#define L1121_DACCR                     0x40
#define L1121_DACDR                     0x44

#define L1121_IDR1_VAL                  0x01
#define L1121_IDR2_VAL                  0x10
#define L1121_IDR3_VAL                  0x12
#define L1121_IDR4_VAL                  0x01
/* for SR, ISR, EISR, IER, ESNR, ITSR, ECLR */
#define L1121_CD1                       7
#define L1121_CD2                       6
#define L1121_IOIS16                    5	/* IOIS16/WRP */
#define L1121_VS1                       4
#define L1121_VS2                       3
#define L1121_BVD1                      2
#define L1121_BVD2                      1
#define L1121_RDY                       0
#define L1121_SR_CD1                    (1<<L1121_CD1)
#define L1121_SR_CD2                    (1<<L1121_CD2)
#define L1121_SR_IOIS16                 (1<<L1121_IOIS16)
#define L1121_SR_VS1                    (1<<L1121_VS1)
#define L1121_SR_VS2                    (1<<L1121_VS2)
#define L1121_SR_BVD1                   (1<<L1121_BVD1)
#define L1121_SR_BVD2                   (1<<L1121_BVD2)
#define L1121_SR_RDY                    (1<<L1121_RDY)
#define L1121_CR1_SOE                   0x80
#define L1121_CR1_APOE                  0x20
#define L1121_CR1_RESET                 0x10
#define L1121_CR1_STOE                  0x08
#define L1121_CR1_BIG                   0x04
#define L1121_CR1_IRQP                  0x02
#define L1121_CR1_DIRP                  0x01
#define L1121_CR2_PDCS                  0x80
#define L1121_CR2_RTRIM2                0x40
#define L1121_CR2_RTRIM1                0x20
#define L1121_CR2_DISS                  0x10
#define L1121_CR2_S4                    0x08
#define L1121_CR2_S3                    0x04
#define L1121_CR2_S2                    0x02
#define L1121_CR2_S1                    0x01
#define L1121_CR3_MIO                   0x10
#define L1121_CR3_CCDIE                 0x08
#define L1121_CR3_WIRQE                 0x04
#define L1121_CR3_WOR16E                0x02
#define L1121_CR3_WORWE                 0x01
#define L1121_INT_CD1                   (1<<L1121_CD1)
#define L1121_INT_CD2                   (1<<L1121_CD2)
#define L1121_INT_IOIS16                (1<<L1121_IOIS16)
#define L1121_INT_VS1                   (1<<L1121_VS1)
#define L1121_INT_VS2                   (1<<L1121_VS2)
#define L1121_INT_BVD1                  (1<<L1121_BVD1)
#define L1121_INT_BVD2                  (1<<L1121_BVD2)
#define L1121_INT_RDY                   (1<<L1121_RDY)

#define L1121_inb(reg)                  (*(volatile unsigned char *)(RBTX4925_PCMCIA_BASE + (reg)))
#define L1121_outb(val, reg)            (*(volatile unsigned char *)(RBTX4925_PCMCIA_BASE + (reg)) = (val))

#endif
