/*
 * include/asm-mips/vr4181a/smvr4181a.h
 *
 * Include file for NEC SMVR4181A board.
 *
 * Author: Yoichi Yuasa <yyuasa@mvista.com, or source@mvista.com>
 *
 * 2002,2003 (c) MontaVista, Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */
#ifndef __NEC_SMVR4181A_H
#define __NEC_SMVR4181A_H

#include <asm/addrspace.h>

/*
 * Board specific address mapping
 */
#define INTERNAL_REGISTERS_BASE		KSEG1ADDR(0x0a000000)

#define DRAM_BASE			0x00000000
#define DRAM_SIZE			0x04000000

#define INTERNAL_PCI_WINDOW0_BASE	0x10000000
#define INTERNAL_PCI_WINDOW0_SIZE	0x02000000

#define EXTERNAL_ISA_MEMORY_BASE	0x14000000
#define EXTERNAL_ISA_MEMORY_SIZE	0x02000000

#define EXTERNAL_ISA_IO_BASE		0x16000000
#define EXTERNAL_ISA_IO_SIZE		0x02000000

#define INTERNAL_PCI_WINDOW1_BASE	0x18000000
#define INTERNAL_PCI_WINDOW1_SIZE	0x00200000

#define EXTERNAL_PCS3_BASE		0x18200000
#define EXTERNAL_PCS3_SIZE		0x00200000

#define ROM_BASE			0x1e000000
#define ROM_SIZE			0x02000000

#define IO_PORT_BASE			KSEG1ADDR(EXTERNAL_ISA_IO_BASE)
#define IO_PORT_RESOURCE_START		0
#define IO_PORT_RESOURCE_END		(EXTERNAL_PCS3_BASE +		\
					 EXTERNAL_PCS3_SIZE -		\
					 EXTERNAL_ISA_IO_BASE - 1)
#define IO_MEM_RESOURCE_START		INTERNAL_PCI_WINDOW0_BASE
#define IO_MEM_RESOURCE_END		(EXTERNAL_ISA_MEMORY_BASE +	\
					 EXTERNAL_ISA_MEMORY_SIZE - 1)

#define PCI_IO_RESOURCE_START		(INTERNAL_PCI_WINDOW1_BASE -	\
					 EXTERNAL_ISA_IO_BASE)
#define PCI_IO_RESOURCE_END		(INTERNAL_PCI_WINDOW1_BASE -	\
					 EXTERNAL_ISA_IO_BASE +		\
					 INTERNAL_PCI_WINDOW1_SIZE - 1)
#define PCI_MEM_RESOURCE_START		INTERNAL_PCI_WINDOW0_BASE
#define PCI_MEM_RESOURCE_END		(INTERNAL_PCI_WINDOW0_BASE +	\
					 INTERNAL_PCI_WINDOW0_SIZE - 1)

/*
 * ECU SysClock & LClock Max.
 */
#define ECU_SYSCLOCK_MAX		17000000
#define LCLOCK_MAX			33000000

#endif /* __NEC_SMVR4181A_H */
