/*
 *  RTC Control Driver for RS5C372
 *
 *  Copyright (C) 2001-2004  BUFFALO INC.
 *
 *  This software may be used and distributed according to the terms of
 *  the GNU General Public License (GPL), incorporated herein by reference.
 *  Drivers based on or derived from this code fall under the GPL and must
 *  retain the authorship, copyright and license notice.  This file is not
 *  a complete program and may only be used when the entire operating
 *  system is licensed under the GPL.
 *
 */

#ifndef MELCO_RTC_H
#define MELCO_RTC_H
#include <linux/rtc.h>

long melco_rtc_init(void);
unsigned long melco_get_rtc(void);
struct rtc_time melco_get_rtc2(void);
unsigned char melco_get_sec(void);
int melco_set_rtc(unsigned long nowtime);
int melco_set_rtc2(struct rtc_time tm);
void melco_caribrate_decr(void);

#ifndef BCD_TO_BIN
#define BCD_TO_BIN(val) ((val)=((val)&15) + ((val)>>4)*10)
#endif

#ifndef BIN_TO_BCD
#define BIN_TO_BCD(val) ((val)=(((val)/10)<<4) + (val)%10)
#endif

#define	MELCO_RTC_SUCCESS		0
#define	MELCO_RTC_FAIL			-1

#endif
