/*
 * IPCOMP zlib interface code.
 * Copyright (C) 2000  Svenning Soerensen <svenning@post5.tele.dk>
 * Copyright (C) 2000, 2001  Richard Guy Briggs <rgb@conscoop.ottawa.on.ca>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.

 RCSID $Id: ipcomp.h,v 1.9 2001/11/26 09:23:47 rgb Exp $

 */

#ifndef _IPCOMP_H
#define _IPCOMP_H

#include <net/spd.h>

/* Prefix all global deflate symbols with "ipcomp_" to avoid collisions with ppp_deflate & ext2comp */
#define IPCOMP_PREFIX

#ifndef IPPROTO_COMP
#define IPPROTO_COMP 108
#endif /* IPPROTO_COMP */

#ifndef NEXTHDR_COMP 
#define NEXTHDR_COMP 108
#endif /* NEXTHDR_COMP */

/* IPCOMP header */
struct ipcomphdr {		
    __u8    ipcomp_nh;		/* Next header (protocol) */
    __u8    ipcomp_flags;	/* Reserved, must be 0 */
    __u16   ipcomp_cpi;		/* Compression Parameter Index */
};

/* CPI : same value as IPComp trasnform ID */
#define IPCOMP_RESERVED			0
#define IPCOMP_OUI                      1
#define IPCOMP_DEFLATE                  2
#define IPCOMP_LZS                      3
#define IPCOMP_LZJH                     4
#define IPCOMP_V42BIS         IPCOMP_LZJH  /* compatibility for freeswan */
#define IPCOMP_MAX			5

#ifdef __KERNEL__
/* Threshold */
#define IPCOMP_THRESHOLD_DEFLATE	90

struct ipcomp_algo_func {
	int (*compress)(void *data_in, u32 len_in, void **data_out, u32 len_out);
	int (*decompress)(void *data_in, u32 len_in, void **data_out, u32 len_out);
	int threshold;
};

/* Function prototypes */
const struct ipcomp_algo_func *ipcomp_algo_lookup(u32 cpi);
void ipsec6_compress(/* const */ void *data, u32 len, u8 proto, void **newdata, u32 *newlen, struct ipsec_sp *policy);
int ipsec6_input_check_comp(struct sk_buff **skb, u8 *nexthdr, struct ipcomphdr *comphdr, struct sa_index *sa_idx);
#endif /* __KERNEL__ */

#endif /* _IPCOMP_H */
