#! /bin/sh

. ./config.sh

ccsymbols=''
cppccsymbols=''
cppsymbols=''

: set up the translation script tr, must be called with ./tr of course
cat >tr <<EOSC
$startsh
case "\$1\$2" in
'[A-Z][a-z]') exec $tr '$up' '$low';;
'[a-z][A-Z]') exec $tr '$low' '$up';;
esac
exec $tr "\$@"
EOSC
chmod +x tr

#echo " "
#$echo "Guessing which symbols your C compiler and preprocessor define..."
$cat <<'EOSH' > Cppsym.know
a29k ABI64 aegis AES_SOURCE AIX AIX32 AIX370
AIX41 AIX42 AIX43 AIX_SOURCE aixpc ALL_SOURCE
alliant alpha am29000 AM29000 AMD64 amiga AMIGAOS AMIX
ansi ANSI_C_SOURCE apollo ardent ARM32 atarist att386 att3b
BeOS BIG_ENDIAN BIT_MSF bsd BSD bsd43 bsd4_2 bsd4_3 BSD4_3 bsd4_4
BSD_4_3 BSD_4_4 BSD_NET2 BSD_TIME BSD_TYPES BSDCOMPAT bsdi
bull c cadmus clipper CMU COFF COMPILER_VERSION
concurrent convex cpu cray CRAY CRAYMPP ctix CX_UX
CYGWIN DGUX DGUX_SOURCE DJGPP dmert DOLPHIN DPX2 DSO
Dynix DynixPTX ELF encore EPI EXTENSIONS FILE_OFFSET_BITS
FreeBSD GCC_NEW_VARARGS gcos gcx gimpel
GNU_SOURCE GNUC GNUC_MINOR GO32 gould GOULD_PN
H3050R H3050RX hbullx20 hcx host_mips
hp200 hp300 hp700 HP700 hp800 hp9000
hp9000s200 hp9000s300 hp9000s400 hp9000s500
hp9000s700 hp9000s800 hp9k8 hp_osf hppa hpux HPUX_SOURCE
i186 i286 i386 i486 i586 i686 i8086 i80960 i860 I960
IA64 iAPX286 ibm ibm032 ibmesa IBMR2 ibmrt ILP32 ILP64
INLINE_INTRINSICS INTRINSICS INT64 interdata is68k ksr1
LANGUAGE_C LARGE_FILE_API LARGEFILE64_SOURCE
LARGEFILE_SOURCE LFS64_LARGEFILE LFS_LARGEFILE
Linux LITTLE_ENDIAN LONG64 LONG_DOUBLE LONG_LONG
LONGDOUBLE LONGLONG LP64 luna luna88k Lynx
M68000 m68k m88100 m88k M88KBCS_TARGET M_COFF
M_I186 M_I286 M_I386 M_I8086 M_I86 M_I86SM M_SYS3
M_SYS5 M_SYSIII M_SYSV M_UNIX M_XENIX MACH machine MachTen
MATH_HAS_NO_SIDE_EFFECTS
mc300 mc500 mc68000 mc68010 mc68020 mc68030 mc68040
mc68060 mc68k mc68k32 mc700 mc88000 mc88100 merlin
mert MiNT mips MIPS_FPSET MIPS_ISA MIPS_SIM MIPS_SZINT
MIPS_SZLONG MIPS_SZPTR MIPSEB MIPSEL MODERN_C motorola
mpeix MSDOS MTXINU MULTIMAX mvs MVS n16 ncl_el ncl_mr
NetBSD news1500 news1700 news1800 news1900 news3700
news700 news800 news900 NeXT NLS nonstopux ns16000 ns32000
ns32016 ns32332 ns32k nsc32000
OCS88 OEMVS OpenBSD os OS2 OS390 osf OSF1 OSF_SOURCE
pa_risc PA_RISC1_1 PA_RISC2_0 PARAGON parisc
pc532 pdp11 PGC PIC plexus PORTAR posix
POSIX1B_SOURCE POSIX2_SOURCE POSIX4_SOURCE
POSIX_C_SOURCE POSIX_SOURCE POWER
PROTOTYPES PWB pyr QNX R3000 REENTRANT RES Rhapsody RISC6000
riscix riscos RT S390 SA110 scs SCO sequent sgi SGI_SOURCE SH3 sinix
SIZE_INT SIZE_LONG SIZE_PTR SOCKET_SOURCE SOCKETS_SOURCE
sony sony_news sonyrisc sparc sparclite spectrum
stardent stdc STDC_EXT stratos sun sun3 sun386
Sun386i svr3 svr4 SVR4_2 SVR4_SOURCE svr5
SX system SYSTYPE_BSD SYSTYPE_BSD43 SYSTYPE_BSD44
SYSTYPE_SVR4 SYSTYPE_SVR5 SYSTYPE_SYSV SYSV SYSV3 SYSV4 SYSV5
sysV68 sysV88 Tek4132 Tek4300 titan
TM3200 TM5400 TM5600
tower tower32 tower32_200 tower32_600 tower32_700
tower32_800 tower32_850 tss
u370 u3b u3b2 u3b20 u3b200 u3b20d u3b5
ultrix UMAXV UnicomPBB UnicomPBD UNICOS UNICOSMK
unix UNIX95 UNIX99 unixpc unos USGr4 USGr4_2
Utek UTek UTS UWIN uxpm uxps vax venix VMESA vms xenix Xenix286
XOPEN_SOURCE XOPEN_SOURCE_EXTENDED XPG2 XPG2_EXTENDED
XPG3 XPG3_EXTENDED XPG4 XPG4_EXTENDED
z8000
EOSH
# Maybe put other stuff here too.
cat <<EOSH >>Cppsym.know
$osname
EOSH
./tr '[a-z]' '[A-Z]' < Cppsym.know > Cppsym.a
./tr '[A-Z]' '[a-z]' < Cppsym.know > Cppsym.b
$cat Cppsym.know > Cppsym.c
$cat Cppsym.a Cppsym.b Cppsym.c | $tr ' ' $trnl | $sort | $uniq > Cppsym.know
$rm -f Cppsym.a Cppsym.b Cppsym.c
cat <<EOSH > Cppsym
$startsh
if $test \$# -gt 0; then
    echo \$* | $tr " " "$trnl" | ./Cppsym.try > Cppsym.got
    if $test -s Cppsym.got; then
        $rm -f Cppsym.got
        exit 0
    fi
    $rm -f Cppsym.got
    exit 1
else
    $tr " " "$trnl" | ./Cppsym.try
    exit 0
fi
EOSH
chmod +x Cppsym
$eunicefix Cppsym
cat <<EOSH > Cppsym.try
$startsh
cat <<'EOCP' > try.c
#include <stdio.h>
int main() {
EOCP
$awk \\
EOSH
cat <<'EOSH' >> Cppsym.try
'length($1) > 0 {
    printf "#ifdef %s\n#if %s+0\nprintf(\"%s=%%ld\\n\", %s);\n#else\nprintf(\"%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef _%s\n#if _%s+0\nprintf(\"_%s=%%ld\\n\", _%s);\n#else\nprintf(\"_%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef __%s\n#if __%s+0\nprintf(\"__%s=%%ld\\n\", __%s);\n#else\nprintf(\"__%s\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
    printf "#ifdef __%s__\n#if __%s__+0\nprintf(\"__%s__=%%ld\\n\", __%s__);\n#else\nprintf(\"__%s__\\n\");\n#endif\n#endif\n", $1, $1, $1, $1, $1
}'	 >> try.c
echo '}' >> try.c
EOSH
cat <<EOSH >> Cppsym.try
ccflags="$ccflags"
case "$osname-$gccversion" in
irix-) ccflags="\$ccflags -woff 1178" ;;
os2-*) ccflags="\$ccflags -Zlinker /PM:VIO" ;;
esac
#$cc -o try $optimize \$ccflags $ldflags try.c $libs && ./try$exe_ext
$cc -o try $optimize \$ccflags $ldflags try.c $libs -save-temps
gcc -o try try.i && ./try$exe_ext
EOSH
chmod +x Cppsym.try
$eunicefix Cppsym.try
./Cppsym < Cppsym.know > Cppsym.true
: now check the C compiler for additional symbols
postprocess_cc_v=''
case "$osname" in
aix) postprocess_cc_v="|$tr , ' '" ;;
esac
$cat >ccsym <<EOS
$startsh
$cat >tmp.c <<EOF
extern int foo;
EOF
for i in \`$cc -v -c tmp.c 2>&1 $postprocess_cc_v\`
do
	case "\$i" in
	-D*) echo "\$i" | $sed 's/^-D//';;
	-A*) $test "$gccversion" && echo "\$i" | $sed 's/^-A\(.*\)(\(.*\))/\1=\2/';;
	esac
done
$rm -f try.c
EOS
postprocess_cc_v=''
chmod +x ccsym
$eunicefix ccsym
./ccsym > ccsym1.raw
if $test -s ccsym1.raw; then
       $sort ccsym1.raw | $uniq >ccsym.raw
else
       mv ccsym1.raw ccsym.raw
fi

$awk '/\=/ { print $0; next }
	{ print $0"=1" }' ccsym.raw >ccsym.list
$awk '/\=/ { print $0; next }
	{ print $0"=1" }' Cppsym.true >ccsym.true
$comm -13 ccsym.true ccsym.list >ccsym.own
$comm -12 ccsym.true ccsym.list >ccsym.com
$comm -23 ccsym.true ccsym.list >ccsym.cpp

also=''
if $test -z ccsym.raw; then
#	echo "Your C compiler doesn't seem to define any symbols!"
#	echo " "
#	echo "However, your C preprocessor defines the following symbols:"
#	$cat Cppsym.true
    	ccsymbols=''
	cppsymbols=`$cat Cppsym.true`
        cppsymbols=`echo $cppsymbols`
	cppccsymbols="$cppsymbols"
else
	if $test -s ccsym.com; then
#		echo "Your C compiler and pre-processor define these symbols:"
#		$sed -e 's/\(..*\)=.*/\1/' ccsym.com
		also='also '
		symbols='ones'
		cppccsymbols=`$cat ccsym.com`
		cppccsymbols=`echo $cppccsymbols`
		$test "$silent" || sleep 1
	fi
	if $test -s ccsym.cpp; then
#		$test "$also" && echo " "
#		echo "Your C pre-processor ${also}defines the following symbols:"
#		$sed -e 's/\(..*\)=.*/\1/' ccsym.cpp
		also='further '
		cppsymbols=`$cat ccsym.cpp`
		cppsymbols=`echo $cppsymbols`
		$test "$silent" || sleep 1
	fi
	if $test -s ccsym.own; then
#		$test "$also" && echo " "
#		echo "Your C compiler ${also}defines the following cpp symbols:"
#		$sed -e 's/\(..*\)=1/\1/' ccsym.own
#		$sed -e 's/\(..*\)=.*/\1/' ccsym.own | $uniq >>Cppsym.true
	        ccsymbols=`$cat ccsym.own`
	        ccsymbols=`echo $ccsymbols`
		$test "$silent" || sleep 1
	fi
fi
$rm -f ccsym* Cppsym.*

$rm -f ./tr

echo "ccsymbols='$ccsymbols'"
echo "cppccsymbols='$cppccsymbols'"
echo "cppsymbols='$cppsymbols'"
