Summary: Contains the utilities ping, tracepath, and arping
Name: iputils
Version: 20020124
Release: 3.0.0.%{_hhl_build_id}
Source: iputils_20020124.orig.tar.gz
Source1: iputils-ping.tmpl
Source2: iputils-tracepath.tmpl
Source3: iputils-arping.tmpl
Patch: iputils_20020124-1.diff.gz
Patch1: iputils-makefile.patch
Patch2: iputils-man.patch
Patch3: iputils-mips-sock.patch
License: Other
Group: net
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir         %{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-iputils

%description
The iputils package contains a collection of IP related tools, ping, 
tracepath, and arping.


%package -n iputils-ping
Summary: The ping utility from iputils
Group: net
Obsoletes: netkit-ping
Obsoletes : hhl-%{_hhl_target_arch}-iputils-ping

%description -n iputils-ping
The ping command sends ICMP ECHO_REQUEST packets to a host in order to
test if the host is reachable via the network.

This package includes a ping6 utility which supports IPv6 network
connections.  Aside from that, it is essentially functionally identical
to the netkit-ping package.


%package -n iputils-tracepath
Summary: The tracepath utility from iputils
Group: net
Obsoletes : hhl-%{_hhl_target_arch}-iputils-tracepath

%description -n iputils-tracepath
The tracepath utility is similar to the traceroute utility, but also   
attempts to discover the MTU of the path.

This package also includes tracepath6 and traceroute6 utilities, which
may be used on IPv6 networks.


%package -n iputils-arping
Summary: Send ICMP echo requests to an ARP address
Group: net
Obsoletes : hhl-%{_hhl_target_arch}-iputils-arping

%description -n iputils-arping
The arping command acts like the standard ping command except it pings
a machine by its ARP address instead of its IP address.  It is typically
used to locate a machine if its hardware address is known but its IP
address is unknown.


%prep
%target_check
%setup -n iputils-20020124
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%target_setup
%make CC=$CC | tee -a build.log

#this requires a bunch of sgml garbage that we don't typically come on most systems
#patch2 actuall patches properly generated ones in to the package..
#%make man


%install
rm -rf %{buildroot}
%target_setup
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/bin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}

mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8

install -m 4755 ping %{buildroot}%{_hhl_cross_target_dir}/bin
install -m 4755 ping6 %{buildroot}%{_hhl_cross_target_dir}/bin
install -m 4755 traceroute6 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
install -m 0755 tracepath %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
install -m 0755 tracepath6 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}
install -m 4755 arping %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}

install -m 0644 doc/arping.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8
install -m 0644 doc/ping.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8
install -m 0644 doc/tracepath.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8
install -m 0644 doc/traceroute6.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/*
ln -s ping.8.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ping6.8.gz
ln -s tracepath.8.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tracepath6.8.gz

cp debian/copyright LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ping
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tracepath
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/arping


%clean
rm -rf %{buildroot}


%files -n iputils-ping
%defattr(-,root,root)
%doc LICENSE
%{_hhl_cross_target_dir}/bin/ping
%{_hhl_cross_target_dir}/bin/ping6
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ping.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/ping6.8.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ping


%files -n iputils-tracepath
%defattr(-,root,root)
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/traceroute6
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tracepath
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tracepath6
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/traceroute6.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tracepath.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tracepath6.8.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tracepath


%files -n iputils-arping
%defattr(-,root,root)
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/arping
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/arping.8.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/arping


