Summary   	: The GNU Bourne Again shell (bash).
Name	  	: bash
Version	  	: 2.05a
Release	  	: 3.0.0.%{_hhl_build_id}
Source	  	: bash_%{version}.orig.tar.gz
Source1	  	: hhl-bash.pml
Source2		: bash_profile
Source3		: bashrc
Source4		: bash_logout
Patch	  	: bash_2.05a-4.diff.gz
# If this package is moved forward you _MUST_ edit patch3 as it contains
# the bash version and patch number!
Patch1		: bash-2.05a-random.patch
Patch2		: bash-noautoconf.patch
Patch3		: mvl-cross-signal-%{version}-0.patch
Patch4		: bash-version.patch
License 	: GPL
Group	  	: base
Buildroot 	: %{_tmppath}/%{name}-target-%{_hhl_target_arch}-root
Prefix	  	: %{_hhl_cross_target_dir}
%define _defaultdocdir	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}
Provides	: /bin/bash
Requires	: hardhatutils
#
#	SRPM
#

Obsoletes : hhl-target-bash
Obsoletes : hhl-%{_hhl_target_arch}-bash

%description
Bash is a GNU project sh-compatible shell or command language
interpreter. Bash (Bourne Again shell) incorporates useful features
from the Korn shell (ksh) and the C shell (csh). Most sh scripts
can be run by bash without modification.

Bash offers several improvements over sh, including command line
editing, unlimited size command history, job control, shell
functions and aliases, indexed arrays of unlimited size and
integer arithmetic in any base from two to 64. Bash is ultimately
intended to conform to the IEEE POSIX P1003.2/ISO 9945.2 Shell and
Tools standard.

#
#	RPM
#


%prep
%target_check
%setup -q -n bash-%{version}.orig
%patch -p1
#	random \

patches="\
	arrayfunc \
	bashbug-editor \
	deb-bash-config \
	deb-examples \
	man-vx-opts \
	man-arithmetic \
	man-fignore \
	privmode \
	various \
	headers \
	rl-examples \
	rl-symlinked-dirs \
	rl-inputrc \
	rl-del-backspace-policy \
	"
for p in $patches; do
  chmod u+x debian/patches/$p.dpatch
  debian/patches/$p.dpatch -patch -d `pwd`
done
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1


%build
%target_setup

export ac_cv_func_getpgrp_void='yes'
export ac_cv_func_setvbuf_reversed='no'
export ac_cv_sys_restartable_syscalls='yes'
export bash_cv_sys_siglist='yes'
export bash_cv_under_sys_siglist='yes'
export bash_cv_ulimit_maxfds='yes'
export bash_cv_func_sigsetjmp='present'
export bash_cv_job_control_missing='present'
export bash_cv_sys_named_pipes='present'
export cross_compiling='yes'

%target_configure

../support/mkversion.sh -b -d %{version} -p 0 -o newversion.h
mv newversion.h version.h
%make CFLAGS_FOR_CROSS=-I%{_hhl_cross_target_dir}%{_hhl_target_include_dir}


%install
PATH=%{_hhl_cross_bin_dir}:$PATH
rm -rf %{buildroot}
%target_setup

%target_makeinstall bindir=%{buildroot}%{_hhl_cross_target_dir}/bin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/
mv %{buildroot}%{_hhl_cross_target_dir}/bin/bashbug %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bash
install -d  %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel
install %{SOURCE2} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bash_profile
install %{SOURCE3} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bashrc
install %{SOURCE4} %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bash_logout
cd ..
cp COPYING LICENSE

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*


%clean
rm -rf %{buildroot}

%post -n bash
%target_script_prefix_setup

# Register the shell
(%{_hhl_target_toolprefix}shellconfig --add /bin/bash 1) &> /dev/null || echo "Unable to register shell"

%preun -n bash
%target_script_prefix_setup

# Unregister the shell
(%{_hhl_target_toolprefix}shellconfig --del /bin/bash) &> /dev/null || echo "Unable to unregister shell"


%files -n bash
%defattr(-,root,root)
%{_hhl_cross_target_dir}/bin/bash
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/bashbug
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bash_profile
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bashrc
%config %{_hhl_cross_target_dir}%{_hhl_target_sysconf_dir}/skel/.bash_logout
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/bash.info.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/bash.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/bashbug.1.gz
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/bash

%doc LICENSE


%changelog
* Mon Apr 09 2001 Joe Green <source@mvista.com>
- Add pml description file generation.

* Tue Feb 14 2001 Jeremy Puhlman <jpuhlman@mvista.com>
- first-cut hhl spec file




