Summary: GNU Compiler Collection
Name: gcc
Version: 3.3.1
Release: 3.0.10.%{_hhl_build_id}
%define tarversion 3.3.1
Source0: gcc-%{tarversion}.tar.gz
Source1: gcc-license.txt
Source4: gcc3.3.tmpl
Source6: cpp-doc.tmpl
Source7: g++.tmpl
Source9: libstdc++5.tmpl
Source10: libstdc++5-dev.tmpl
Source11: gcc-doc.tmpl
Source12: libgcc1.tmpl
Source13: gcc_xtensa_linux_be.tar
Source14: gcc_xtensa_linux_le.tar
Source15: gcc_xtensa_linux_test.tar

# Monta Vista patches
Patch1: gcc-3.3-libstdc-automake.patch
Patch3: hhl-gcc3.1-target-nls.patch
Patch4: gcc-3.1-visibility.patch
Patch5: gcc-3.3-with-cpu.patch
Patch6: gcc-3.3-cross.patch
Patch7: gcc-3.3.1-make-relative-prefix.patch

#Patch9: hhl-gcc3.3.1-version.patch

Patch10: hhl-gcc3.3-include-poison.patch
Patch11: gcc-3.3-softfloat.patch
Patch13: hhl-gcc3.3-license.patch
Patch14: gcc-3.3-ifcvt-test.patch
Patch15: gcc-3.3-lifetimes.patch

Patch203: gcc-3.3-sysroot.patch
Patch204: gcc-3.3-mips-libspec.patch
Patch205: mvl-gcc-nptl.patch
Patch206: gcc-3.2-compoundlit.patch
Patch208: gcc-3.3-sysroot-no-prefix-lib.patch

Patch209: gcc-3.3-declone-apple.patch
Patch210: gcc-3.3-declone-mvista.patch
Patch211: gcc-3.3.1-noabi_check.patch
Patch212: gcc-3.3-declone-mvista2.patch
Patch213: gcc-3.3.1-intl.patch

# Community patches
# This patch is no longer necessary, however I need to verify that
# our tools do cause __PPC405__ to be defined properly.  Depends on fixed
# with-cpu support.
###Patch20: gcc-3.1-powerpc-atomicity.patch
Patch23: gcc-3.3-powerpc-tls.patch

# MIPS patches
Patch40: gcc-3.3-mips_nfp.patch
Patch41: gcc-3.3-mips_pcrel.patch
# There used to be a patch to prevent passing -march=sb1 to the assembler. 
# That will have to be revisited.  The problem involved incompatible tags on
# binaries, but recent linkers (2.13, and post-2.13) have some changes in
# this area.

# ARM patches
Patch50: gcc-3.3-arm_be_nfp.patch
Patch51: gcc-3.2-arm-link-spec.patch

# SH patches
Patch60: gcc-3.3.1-sh.patch
Patch61: gcc-3.3.1-sh_reload.patch
Patch62: gcc-3.3-sh_constpool.patch
Patch63: gcc-3.3.1-sh-pic.patch

# PPC patches
Patch70: gcc-3.3_ppc440.patch
#Patch71: gcc-3.3-ppc440_libgcc.patch

# Patches which have not been evaluated for 3.1 or later yet:
####gcc-2.95.3-barrier_codegen.patch
####  See http://gcc.gnu.org/ml/gcc-patches/2002-04/msg00631.html

# Xtensa patches
Patch80: gcc-3.3-xtensa_with_float.patch

License: GPL/LGPL
Group: devel
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir          %{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}
Requires: binutils
Obsoletes: hhl-%{_hhl_target_arch}-gcc
Obsoletes: cpp, hhl-%{_hhl_target_arch}-cpp
%description
This is the GNU C compiler, a fairly portable optimizing compiler which
supports multiple languages.  This package includes support for C.  It also
includes the GNU C preprocessor.

%package -n cpp-doc
Summary: Documentation for the GNU C preprocessor (cpp).
Group: devel
Obsoletes: hhl-%{_hhl_target_arch}-cpp-doc

%description -n cpp-doc
Documentation for the GNU C preprocessor in info format.

# g++
%package -n g++
Summary: The GNU C++ compiler
Group: devel
Requires: gcc = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-g++

%description -n g++
This is the GNU C++ compiler, a fairly portable optimizing compiler for C++.

# libgcc1
%package -n libgcc1
Summary: The GNU GCC support library
Group: devel
Obsoletes: hhl-%{_hhl_target_arch}-libgcc1

%description -n libgcc1
This package contains a required runtime library for all programs
built with the GNU compiler.

# libstdc++5
%package -n libstdc++5
Summary: The GNU stdc++ library
Group: devel
Obsoletes: hhl-%{_hhl_target_arch}-libstdc++5

%description -n libstdc++5
This package contains an additional runtime library for C++ programs
built with the GNU compiler.

# libstdc++5-dev
%package -n libstdc++5-dev
Summary: The GNU stdc++ library (development files)
Group: devel
Requires: g++ = %{version}
Obsoletes: hhl-%{_hhl_target_arch}-libstdc++5-dev

%description -n libstdc++5-dev
This package contains the headers and static library files necessary for
building C++ programs which use libstdc++.

# gcc-doc
%package -n gcc-doc
Summary: Documentation for the GNU compilers (gcc, g++)
Group: devel
Obsoletes: hhl-%{_hhl_target_arch}-gcc-doc

%description -n gcc-doc
Documentation for the GNU compilers in info format.

%define _gccdir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gcc-lib/%{_hhl_target_toolconfig}/%{version}

#####
%prep
#####
%target_check
%setup -n gcc-%{tarversion} -q

%patch1 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
	
##%patch6 -p1
%patch7 -p1
#%patch9 -p1
##%patch10 -p1
%patch11 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

# xtensa patches
%if "%{_hhl_target_arch}" == "xtensa_linux_be"
tar -xf %{SOURCE13}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_le"
tar -xf %{SOURCE14}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_test"
tar -xf %{SOURCE15}
%endif

##%if "%{_hhl_target_cpu_type}_%{_hhl_target_cpu_id}" == "ppc_405"
##%patch20 -p1
##%endif

%patch23 -p1

# Patches for MIPS
%patch40 -p1
%patch41 -p1

# Patches for ARM
%patch50 -p1
%patch51 -p1

# Patches for SH
%patch60 -p1
%patch61 -p1
%patch62 -p1
%patch63 -p1

# Patches for PPC
%patch70 -p1
#%if "%{_hhl_target_cpu_type}_%{_hhl_target_cpu_id}" == "ppc_440"
#%patch71 -p1
#%endif

# Patches for Xtensa
%patch80 -p1

%patch203 -p1
%patch204 -p1
%patch205 -p1
%patch206 -p1
%patch208 -p1
%patch209 -p1
%patch210 -p1
%patch211 -p1
%patch212 -p1
%patch213 -p1

# we don't need to build texinfo on a current Linux installation
rm -rf texinfo

# Update version number
%define _dt %(date +%%F)
(cd gcc ; sed "/version_string/s#\";\$# (MontaVista %{version}-%{release} %_dt)\";#" \
       < version.c > version.n && mv version.n version.c)

######
%build
######
%target_setup

# This will make GCC configure using the features of the cross assembler,
# rather than the host assembler.  Of course we want the features of the
# target assembler... but this is closer.
# This is necessary for things like .file/.loc to be correctly configured.
export AS=%{_hhl_cross_bin_dir}/%{_hhl_target_toolprefix}as

# Ditto for the cross linker.
# This is necessary for PT_GNU_EH_FRAME support.
export LD=%{_hhl_cross_bin_dir}/%{_hhl_target_toolprefix}ld

export CPP="$CC -E"
export CC_FOR_TARGET=$CC
export AS_FOR_TARGET=$AS
export LD_FOR_TARGET=$LD
export NM_FOR_TARGET=$NM
export RANLIB_FOR_TARGET=$RANLIB
export AR_FOR_TARGET=$AR
export CPP_FOR_TARGET=$CPP
export LD_LIBRARY_PATH=%{buildroot}%{_hhl_cross_target_dir}/usr/lib/

# See the comment in libstdc++-v3/src/Makefile.am.  GCC can compile
# C++ files, and this prevents libtool trying to link libstdc++ with
# -lstdc++.  Only a problem in host-x-host builds.
# Note that we must explicitly add -shared-libgcc or libstdc++ won't
# be linked to libgcc_s.so.
export CXX_FOR_TARGET="$CC -shared-libgcc"
export CXX="$CC -shared-libgcc"

# Update configure in the gcc directory
(cd gcc ; autoconf )
(cd libstdc++-v3 ; autoconf; automake)

# Protect from funky auto* deps.
(cd gcc ; autoheader )

# Remove unneeded zlib
rm -rf zlib

%if "%{_mvl_uclibc}" == "yes"
# Work around some limitations of uClibc.
perl -i -p -e "s,defined.*_GLIBCPP_USE_C99.*,1,g;" libstdc++-v3/config/locale/generic/c_locale.cc
cp libstdc++-v3/config/os/generic/bits/ctype_base.h \
              libstdc++-v3/config/os/gnu-linux/bits/
cp libstdc++-v3/config/os/generic/bits/ctype_inline.h \
              libstdc++-v3/config/os/gnu-linux/bits/
cp libstdc++-v3/config/os/generic/bits/ctype_noninline.h \
              libstdc++-v3/config/os/gnu-linux/bits/
%endif

%target_tool_configure \
	--target=%{_hhl_target_toolconfig} \
%if "%{_mvl_uclibc}" == "yes"
	--disable-__cxa_atexit \
	--enable-clocale=generic \
%else
	--enable-__cxa_atexit \
%endif
	--enable-shared \
	--enable-languages=c,c++ \
	--enable-threads=posix \
	--disable-multilib \
%if "%{_hhl_target_fpu}" == "no"
	--with-float=soft \
%endif
%if "%{_hhl_target_cpu_type}" == "mips"
%if "%{_hhl_target_cpu_id}" != "%%%%{_hhl_target_cpu_id}"
	--with-arch=%{_hhl_target_cpu_id} \
	--with-tune=%{_hhl_target_cpu_id} \
	--with-abi=32 \
%endif
%else
%if "%{_hhl_target_cpu}" != "xtensa"
%if "%{_hhl_target_cpu_id}" != "%%%%{_hhl_target_cpu_id}"
	--with-cpu=%{_hhl_target_cpu_id} \
%endif
%endif
%endif
%if "%{_hhl_target_gcc_config}" != "%%%%{_hhl_target_gcc_config}"
	%{_hhl_target_gcc_config} \
%endif
        2>&1 | tee ../build.log

# Add SYSTEM_HEADER_DIR so that we find <limits.h> from glibc
# FIXME - there should be a better way...
echo "SYSTEM_HEADER_DIR=%{_hhl_cross_target_dir}%{_hhl_target_include_dir}" \
	>> gcc/Makefile

%dmake \
	2>&1 | tee -a ../build.log

# Fix the specs file to not think we are a cross compiler.
# Do this in %build so that tests run out of the build directory will
# find a fixed specs file.

cat gcc/specs | awk \
	'BEGIN {found = 0; done = 0}
	 /^\*cross_compile:$/ {found = 1}
	 /^1$/ {if (found == 1 && done == 0) {print "0"; done = 1} else {print}}
	 !/^1$/ {print}' \
	> gcc/specs.new
mv -f gcc/specs.new gcc/specs

%install
rm -rf %{buildroot}

%target_setup
mkdir -p %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}

# Use install-no-fixedincludes, because we don't want any fixed headers, and
# because it creates syslimits.h as a side-effect.
cmd=`echo "%{target_makeinstall}" | sed 's/install$/install-no-fixedincludes/'`
eval $cmd \
	SYSTEM_HEADER_DIR=%{_hhl_cross_target_dir}/%{_hhl_target_include_dir} \
	2>&1 | tee -a build.log

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/gcov.1
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/gcc.1
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/cpp.1

# Put libgcc_s in the right place.
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/%{_hhl_target_lib}
mv %{buildroot}%{_hhl_cross_target_dir}/usr/lib/libgcc_s.so.1 \
	%{buildroot}%{_hhl_cross_target_dir}/%{_hhl_target_lib}/libgcc_s.so.1
mv %{buildroot}%{_hhl_cross_target_dir}/usr/lib/libgcc_s.so \
	%{buildroot}%{_hhl_cross_target_dir}/%{_hhl_target_lib}/libgcc_s.so

# For -print-file-name=cpp
mkdir -p  %{buildroot}%{_hhl_cross_target_dir}/lib
ln -s ../usr/bin/cpp %{buildroot}%{_hhl_cross_target_dir}/lib/cpp

# Setup "cc" symlink to gcc
ln -s gcc %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/cc
# Setup "c++" symlink to g++
rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/c++
ln -s g++ %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/c++

gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/g++.1
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

cp %{SOURCE1} LICENSE

pushd %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}
for i in cpp g++ gcc gcov ; do
  ln -s $i %{_hhl_target_toolprefix}$i
done
popd

# Remove PPC EABI startup files.
rm -f %{buildroot}%{_gccdir}/ecrt*
rm -f %{buildroot}%{_gccdir}/ncrt*

# Remove some other files we don't ship.
rm -rf %{buildroot}%{_gccdir}/install-tools

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gcc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE6} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/cpp-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE7} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/g++
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE9} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libstdc++5
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE10} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libstdc++5-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE11} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gcc-doc
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE12} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgcc1

%clean
rm -rf %{buildroot}

%files -n libgcc1
%defattr(-,root,root)
%{_hhl_cross_target_dir}/%{_hhl_target_lib}/libgcc_s.so
%{_hhl_cross_target_dir}/%{_hhl_target_lib}/libgcc_s.so.1
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libgcc1
%doc LICENSE

%files -n gcc
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/cc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/gcc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolprefix}gcc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolconfig}-gcc
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/gcov
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolprefix}gcov
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale
%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gcc-lib
%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gcc-lib/%{_hhl_target_toolconfig}
%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gcc-lib/%{_hhl_target_toolconfig}/%{version}
%dir %{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/gcc-lib/%{_hhl_target_toolconfig}/%{version}/include
%{_gccdir}/include/*
%{_gccdir}/collect2
%{_gccdir}/specs
%{_gccdir}/cc1
%{_gccdir}/libgcc.a
%{_gccdir}/libgcc_eh.a
%{_gccdir}/crt*
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/gcc.1.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/gcov.1.gz
%doc build.log COPYING COPYING.LIB ChangeLog gcc/NEWS
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gcc
# CPP requires cc1 now, so include it in the GCC package.
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/cpp
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolprefix}cpp
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/cpp.1.gz
%{_hhl_cross_target_dir}/lib/cpp

%files -n cpp-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/cpp.info*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/cpp-doc

%files -n g++
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/c++
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/g++
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolprefix}g++
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/g++.1.gz
%{_gccdir}/cc1plus
#%{_gccdir}/include/exception
#%{_gccdir}/include/new
#%{_gccdir}/include/new.h
#%{_gccdir}/include/typeinfo
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/g++

%files -n libstdc++5
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libstdc++.so.5.*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libstdc++.so.5
%if "%{_mvl_uclibc}" != "yes"
# uClibc uses the generic locale code, so this file is not built.
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale/*/LC_MESSAGES/libstdc++.mo
%endif
%doc libstdc++-v3/ChangeLog
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libstdc++5

%files -n libstdc++5-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/c++/%{version}
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libstdc++.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libsupc++.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libstdc++.la
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libsupc++.la
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libstdc++.so
%doc libstdc++-v3/docs/html
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libstdc++5-dev

%files -n gcc-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/gcc.info*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/gcc-doc

%changelog
* Tue Nov 25 2003 Michael Eager <eager@mvista.com>
- Clean up version number.
* Mon Nov 17 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-3.8
- Delete install-tools directory before packaging.
* Fri Nov 7 2003 Michael Eager <eager@mvista.com>
- Add date/build to version number.
* Fri Nov 7 2003 Daniel Jacobowitz <drow@mvista.com> 3.3.1-2.7
- Make libgcc PIC on SH targets.
* Mon Oct 20 2003 Daniel Jacobowitz <drow@mvista.com> 3.3.1-2.6
- Use a linker script for SH4 instead of calling __sdivsi3_i4 through the
  PLT.
* Mon Sep 29 2003 Michael Eager <eager@mvista.com>
- Remove IBM PPC 4xx patches.
* Wed Sep 24 2003 Daniel Jacobowitz <drow@mvista.com> 3.3.1-2.3
- Add support for locale catalogs.
* Wed Sep 17 2003 Daniel Jacobowitz <drow@mvista.com> 3.3.1-2.2
- Add -nptl for PowerPC also.
* Mon Sep 15 2003 Daniel Jacobowitz <drow@mvista.com> 3.3.1-2.1
- Fix a C++ argument passing bug triggered by decloned constructors.
* Fri Aug 29 2003 Michael Eager <eager@mvista.com>
- Port sh_reload patch to gcc-3.3.1.
* Tue Aug 26 2003 Michael Eager <eager@mvista.com>
- Upgrade to gcc-3.3.1.
* Wed Aug 20 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-20
- Add and enable -fno-clone-structors.
* Tue Aug 19 2003 Michael Eager <eager@mvista.com>
- Fix bad branch gen in mips.
* Tue Aug 12 2003 Michael Eager <eager@mvista.com>
- Fix bad const pool generation for SH.
* Tue Aug 5 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-16
- Add a missing "test" to gcc-3.3-sysroot.patch.
* Mon Jul 28 2003 Michael Eager <eager@mvista.com>
- Fix SH ICE in reload_cse_simplify_operands.
* Wed Jul 23 2003 Michael Eager <eager@mvista.com>
- Add IBM PPC 440 libgcc patches.
* Wed Jul 16 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-13
- Don't search $prefix/lib for cross compilers.
* Thu Jul 10 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-12
- Add __thread support for PowerPC.
* Mon Jul 7 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-11
- Disable --with-cpu for Xtensa.
* Thu Jun 26 2003 Michael Eager <eager@mvista.com>
- PPC 440 support.
* Wed Jun 25 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-8
- Add __attribute__((cleanup)) support.
* Wed Jun 25 2003 Michael Eager <eager@mvista.com>
- Fix 1-1BY8B - ICE in mips propagate_one_insn
* Wed Jun 25 2003 Michael Eager <eager@mvista.com>
- Fix 1-1UHM8 - don't gen debug info for generated compound literal.
* Tue Jun 24 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-7
- Add a command line option for experimental NPTL support.
* Fri Jun 20 2003 Michael Eager <eager@mvista.com> 3.3-6
- Fix 1-208QS - Remove ecrt and ncrt from install, if present in PPC build.
* Thu Jun 19 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-5
- Export __sdivsi3_i4 and __udivsi3_i4 from libgcc_s.so.1 on SH.
* Mon Jun 9 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-4
- Weaken an overzealous abort in reload.
- Remove an incorrect MIPS SB-1 patch.
* Thu May 22 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-3
- Correct OPTION_DEFAULT_SPEC again for x86.
- Set the include directory for the cross C++ compiler.
* Mon May 19 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-2
- Correct LIB_SPEC for MIPS.
- Correct OPTION_DEFAULT_SPEC for x86.
* Fri May 16 2003 Daniel Jacobowitz <drow@mvista.com> 3.3-1
- Update to 3.3 release.
* Fri May 16 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.99.20030506-4
- Port install relocation fixes to GCC 3.3.
* Thu May 15 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.99.20030506-3
- Switch from local hacks to a backport of --with-sysroot.
* Wed May 14 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.99.20030506-2
- Re-add support for --with-cpu and --with-float=soft.
* Wed May 7 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.99.20030506-1
- Update to GCC 3.3 prerelease.

* Tue May 6 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-12
- Correct visibility problems in the SH libgcc.
* Wed Apr 23 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-11
- Link libstdc++.so to libgcc_s.so by fixing CXX_FOR_TARGET.
* Fri Apr 11 2003 Michael Eager <eager@mvista.com>
- Rename __mempcpy to mempcpy for cygwin builds.
* Wed Apr 2 2003 Daniel Jacobowitz <drow@mvista.com>
- Fix a conditional store bug found on ARM targets.
* Fri Mar 28 2003 Daniel Jacobowitz <drow@mvista.com>
- Fix a bug involving complex constant generation (seen on Xscale).
* Thu Mar 6 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-8
- Fix a debug info problem for DWARF-2 and global register variables.
* Thu Mar 6 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-7
- Fix another install relocation bug involving symlinks.
* Tue Mar 4 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-6
- Fix an install relocation bug.
* Tue Feb 25 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-5
- Fix a structure initialization problem on ARM.
* Thu Feb 20 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-3
- Include generated info documentation in the source package.
* Tue Feb 18 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-2
- Add a patch to fix an ICE on PowerPC.
* Tue Feb 18 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.2-1
- Update to GCC 3.2.2.
- Add a patch for DWARF-2 type information.
* Mon Feb 03 2003 Michael Eager <eager@mvista.com>
- Fix Xtensa memory corruption bug.
* Mon Jan 27 2003 Daniel Jacobowitz <drow@mvista.com> 3.2.1-21
- Add support for uClibc targets.
* Thu Dec 19 2002 Daniel Jacobowitz <drow@mvista.com> 3.2.1-19
- Update to 3.2.1 release.

* Thu Dec  5 2002 Michael Eager <eager@mvista.com>
- Fix 1-18G8d - comment out abort() in reload1.c
* Mon Nov 25 2002 John Kwan <jkwan@mvista.com>
- Fix the use of "poisoned" identifers in xtensa target gcc.
* Mon Nov 25 2002 Daniel Jacobowitz <drow@mvista.com>
- Specify $LD as a full path and clarify comments about why.
* Sun Nov 17 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix a compiler crash on SH.
* Thu Nov 14 2002 John Kwan <jkwan@mvista.com>
- Move patch14 from under xtensa only test
* Wed Nov 13 2002 John Kwan <jkwan@mvista.com>
- Add support for xtensa builds.
* Tue Nov 12 2002 Michael Eager <eager@mvista.com>
- Fix defect 1-16KVD -- reload bug.
* Fri Nov  1 2002 Michael Eager <eager@mvista.com>
- Obsolete protoize.
* Thu Oct 24 2002 Michael Eager <eager@mvista.com>
- Add support for MVL_LICENSE and --MVlicense option.
* Wed Oct 23 2002 Daniel Jacobowitz <drow@mvista.com>
- Define LINK_EH_SPEC for ARM.
* Mon Oct 21 2002 Michael Eager <eager@mvista.com>
- Add tmpl for libgcc1
* Thu Oct 17 2002 Daniel Jacobowitz <drow@mvista.com>
- Recognize the "sb1" processor for MIPS.
- Add a symlink for /usr/bin/c++ on the target.
- .tmpl updates.
* Wed Oct 16 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix a sibcall bug on SH which caused target-gcc to be miscompiled.
* Mon Oct 14 2002 Daniel Jacobowitz <drow@mvista.com>
- Enable profiling in cross-gcc.
* Tue Oct  8 2002 Daniel Jacobowitz <drow@mvista.com>
- XScale big-endian defaults fix.
* Wed Sep 25 2002 Daniel Jacobowitz <drow@mvista.com>
- Tweak ARM --with-cpu handling to respect -march=.
- Use ll/sc on MIPS
* Fri Sep 20 2002 Daniel Jacobowitz <drow@mvista.com>
- Update from GCC 3.2 CVS
* Fri Sep 13 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix a compiler error on SH4
* Thu Sep 12 2002 Michael Eager <eager@mvista.com>
- Fix for soft float unnormalized rounding error.
* Tue Sep 10 2002 Daniel Jacobowitz  <drow@mvista.com>
- Update to GCC 3.2.
* Wed Sep  4 2002 Daniel Jacobowitz  <drow@mvista.com>
- SH optimization fix.
* Tue Aug  8 2002 Michael Eager <eager@mvista.com>
- ARM big endian and soft-float support.
* Mon Aug  5 2002 Daniel Jacobowitz <drow@mvista.com>
- Merge to GCC 3.1.1
- Relocation fixes
* Mon Jul 29 2002 Daniel Jacobowitz <drow@mvista.com>
- Generalize with-cpu patch for all architectures.
* Fri Jul 26 2002 Michael Eager <eager@mvista.com>
- Rewrite -with-cpu patch for mips.
* Wed Jul 24 2002 Daniel Jacobowitz <drow@mvista.com>
- Correct check for binutils 2.12.1 and .hidden
- Add MIPS DWARF-2 support
- PowerPC atomicity fixes (for the 405)
* Fri Jul 19 2002 Michael Eager <eager@mvista.com>
- Add MIPS nfp support.
* Mon Jul 15 2002 Daniel Jacobowitz <drow@mvista.com>
- Miscellaneous 3.1 fixes
- Generate correct limits.h and syslimits.h
* Fri Jun 28 2002 Michael Eager <eager@mvista.com>
- Initial GCC-3.1 version.
* Fri Jun 21 2002 Daniel Jacobowitz <drow@mvista.com>
- Update SiByte patch
- Pass -m7400 to the assembler
* Wed Jun 19 2002 Michael Eager <eager@mvista.com>
- Make libgcc_s.so incluce lib1asmfuncs.
* Wed Jun 12 2002 Michael Eager <eager@mvista.com>
- Add configuration for ARM BE.
* Mon Mar  4 2002 Michael Eager <eager@mvista.com>
- Suppress linking libgcc_s.so against libc.
* Fri Feb 22 2002 Michael Eager <eager@mvista.com>
- Remove zlib.
* Tue Feb 12 2002 Michael Eager <eager@mvista.com>
- Add Tensilica patch
* Thu Jan 31 2002 Michael Eager <eager@mvista.com>
- Fix incompatibility with stdio.h -- define _GNU_SOURCE.
* Fri Nov 16 2001 Michael Eager <eager@mvista.com>
- Add MIPS with-cpu support and Broadcom/Sibyte support.
* Wed Nov  7 2001 Michael Eager <eager@mvista.com>
- Soft float support for ARM
* Fri Jun 15 2001 Michael Eager <eager@mvista.com>
- Adapt for gcc-2.97-sh
 
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Thu Feb 22 2001 Daniel Jacobowitz <source@mvista.com>
- Don't let the target compiler think it is a cross-compiler
* Mon Feb 19 2001 Mark Hatle <fray@mvista.com>
- First cut
