Summary: High level tools to configure network interfaces
Name: ifupdown
Version: 0.6.4
Release: 3.0.0.%{_hhl_build_id}
Source: ifupdown-%{version}.tar.gz
Source1: ifupdown.tmpl
Patch: ifupdown_0.6.4-4.diff.gz
Patch1: ifupdown-initd.diff
Patch2: ifupdown-interface.diff
License: GPL
Group: base 
%define pkgname ifupdown
Buildroot: %{_tmppath}/%{pkgname}-root
%define targetroot %{_hhl_cross_target_dir}
Prefix: %{targetroot}
Requires: hardhatutils
%define _sbin		%{targetroot}/sbin
%define _etcdir		%{targetroot}%{_hhl_target_sysconf_dir}
%define _datadir	%{targetroot}%{_hhl_target_data_dir}
%define _mandir		%{targetroot}%{_hhl_target_man_dir}
%define _docdir		%{targetroot}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-ifupdown
Obsoletes : hhl-%{_hhl_target_arch}-ifupdown

%description
This package provides the tools ifup and ifdown which may be used to
configure (or, respectively, deconfigure) network interfaces, based on
the file /etc/network/interfaces.


%prep
%target_check
%setup -q -n ifupdown-%{version}
%patch -p1
%patch1 -p1
%patch2 -p1


%build
%target_setup

chmod a+rx defn2c.pl defn2man.pl makecdep.sh makenwdep.sh
%make CC=${CC}


%install
%target_setup
rm -rf %{buildroot}

%make install BASEDIR=%{buildroot}%{targetroot}

install -d %{buildroot}%{_etcdir}/network/if-{up,down,pre-up,post-down}.d

install -d %{buildroot}%{_etcdir}/network
install -d %{buildroot}%{_etcdir}/init.d
install -d %{buildroot}%{_mandir}/man{5,8}

install -m 755 debian/ifupdown.init %{buildroot}%{_etcdir}/init.d/ifupdown
install -m 644 interfaces.5 %{buildroot}%{_mandir}/man5/interfaces.5
install -m 644 ifup.8 %{buildroot}%{_mandir}/man8/ifup.8

gzip -9f %{buildroot}%{_mandir}/man*/*

ln -s ifup.8.gz %{buildroot}%{_mandir}/man8/ifdown.8.gz

install -m 644 examples/network-interfaces %{buildroot}%{_etcdir}/network/interfaces
install -m 755 examples/*.sh %{buildroot}%{_etcdir}/network/
cp COPYING LICENSE

install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ifupdown

%clean
rm -rf %{buildroot}

%post -n %{pkgname}
%target_script_prefix_setup
# Register the service
(%{_hhl_target_toolprefix}initdconfig --add ifupdown) &> /dev/null \
        || echo "Unable to enable initd service: ifupdown"

# We only register services, not un-register them.


%files -n %{pkgname}
%defattr(-,root,root)
%{_sbin}/ifdown
%{_sbin}/ifup
%config %{_etcdir}/init.d/ifupdown
%config %dir %{_etcdir}/network
%config %dir %{_etcdir}/network/if-up.d
%config %dir %{_etcdir}/network/if-down.d
%config %dir %{_etcdir}/network/if-pre-up.d
%config %dir %{_etcdir}/network/if-post-down.d
%config %{_etcdir}/network/interfaces
%config %{_etcdir}/network/*.sh
%doc %{_mandir}/man*/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/ifupdown
%doc LICENSE

%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Tue Mar 13 2001 Matthew McLean <source@mvista.com>
- First cut


