/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 3.4 2003/04/20 21:39:14 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_net.h"

MU_net_config_t config;

static void
get_info_net(void)
{
	if (get_interface(&config) == INVALID)
		exit(1);
}

static void
end_net(struct mu_op *opp,int timing)
{
	exec_device_script(opp,timing);
#ifdef KERNEL_JOB
	free(((MU_net_config_t *)opp->config)->name);
#endif	/* KERNEL_JOB */
}

struct mu_op mu_op = {
	device: net,
	device_name: MU_ARG_NET,
	command: MU_MURASAKI "." MU_ARG_NET,
	mappath: NULL,
	default_mapname: NULL,
	action: ACTION_NONE,
	config: &config,
	get_info: get_info_net,
	get_list: NULL,
	match_map: NULL,
	run: NULL,
	prepare: exec_device_script,
	end: end_net,
};
