/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.3 2003/04/20 21:40:05 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

MU_pci_config_t config;

static void
get_info_pci(void)
{
	if (get_id_pci_class(&config) == INVALID)
		exit(1);
	if (get_id_pci_id(&config) == INVALID)
		exit(1);
	if (get_id_pci_slot(&config) == INVALID)
		exit(1);
}


static void
end_pci(struct mu_op *opp,int timing)
{
	exec_script(opp,timing);
#ifdef	KERNEL_JOB
	free(((MU_pci_config_t *)opp->config)->slot);
#endif
}


struct mu_op mu_op = {
	device: pci,
	device_name: MU_ARG_PCI,
	command: MU_MURASAKI "." MU_ARG_PCI,
	mappath: MU_CONF_DIR "/" MU_PCIMAP,
	default_mapname: MU_DEFAULT_PCIMAP,
	action: ACTION_NONE,
	config: &config,
	get_info: get_info_pci,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: end_pci,
};
