/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: type.c,v 3.3 2002/03/04 05:34:55 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define		SEP	'/'

/*
 * format: d/d/d
 */

static int
get_type_sub(MU_usb_type_t *tp,char *ptr)
{
	char *sep;

	tp->class = strtoul(ptr,&sep,10);	/* class */
	DPRINTF(LOG_LEVEL,"class 0x%x",tp->class);
	if (*sep != SEP)
		return INVALID;

	ptr = sep+1;
	tp->subclass = strtoul(ptr,&sep,10);	/* subclass */
	DPRINTF(LOG_LEVEL,"subclass 0x%x",tp->subclass);
	if (*sep != SEP)
		return INVALID;

	ptr = sep+1;
	tp->protocol = strtoul(ptr,NULL,10);	/* protocol */
	DPRINTF(LOG_LEVEL,"protocol 0x%x",tp->protocol);

	return GOOD;	
}

int
get_id_usb_type(MU_usb_config_t *config)
{
	char *ptr;
	MU_usb_type_t face;

	ptr = getenv("TYPE");
	if (ptr == NULL)
		return INVALID;
	if (get_type_sub (&face, ptr) == INVALID)
		return INVALID;
	config->device = face;

	if (config->device.class == 0) {
		ptr = getenv("INTERFACE");
		if (ptr == NULL)
			return INVALID;
		if (get_type_sub(&face, ptr) == INVALID)
			return INVALID;
		config->interface = face;
	} else {
		config->interface.class = 0;
		config->interface.subclass = 0;
		config->interface.protocol = 0;
	}

	return GOOD;
}

