Summary: Wietse Venema's TCP wrappers library
Name: tcp-wrappers
Version: 7.6
Release: 5.0.0.%{_hhl_build_id}
Source: tcp-wrappers_7.6.orig.tar.gz
Source1: libwrap.tmpl
Source2: libwrap-dev.tmpl
Source3: tcpd.tmpl
Patch: tcp-wrappers_7.6-9.diff.gz
Patch1: tcp-wrappers-usagi-20020514.diff
Patch10: tcp-wrappers-owner.diff
Patch11: tcp-wrapper-usagi-fix.diff
License: Other
Group: base
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir 	%{_hhl_cross_target_dir}%{_hhl_target_doc_dir}

Obsoletes : hhl-target-tcp-wrappers

%description
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# libwrap

%package -n libwrap
Summary: Wietse Venema's TCP wrappers library
Group: base
Obsoletes : hhl-%{_hhl_target_arch}-libwrap

%description -n libwrap
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# libwrap-dev

%package -n libwrap-dev
Summary: Wietse Venema's TCP wrappers library, development files
Group: base
Requires: libwrap = %{version}
Obsoletes : hhl-%{_hhl_target_arch}-libwrap-dev

%description -n libwrap-dev
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.

# tcpd

%package -n tcpd
Summary: Wietse Venema's TCP wrappers utilities
Group: base
Obsoletes : hhl-%{_hhl_target_arch}-tcpd

%description -n tcpd
Wietse Venema's network logger, also known as TCPD or LOG_TCP.

These programs log the client host name of incoming telnet,
ftp, rsh, rlogin, finger etc. requests. Security options are:
access control per host, domain and/or service; detection of
host name spoofing or host address spoofing; booby traps to
implement an early-warning system.


%prep
%target_check
%setup -q -n tcp_wrappers_%{version}
%patch -p1
%patch1 -p1
%patch10 -p1
%patch11 -p1


%build
%target_setup
%make 	REAL_DAEMON_DIR=%{_hhl_target_sbin_dir} \
	CC=%{_hhl_target_toolprefix}gcc \
	GLIBC=4 \
	linux \
	| tee build.log


%install
rm -rf %{buildroot}
%target_setup

mkdir -p %{buildroot}%{_hhl_cross_target_dir}/lib
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man3
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man5
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/share/man/man8
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/sbin
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/lib
mkdir -p %{buildroot}%{_hhl_cross_target_dir}/usr/include

make install-lib DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log
make install-bin DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log
make install-dev DESTDIR=%{buildroot}%{_hhl_cross_target_dir} | tee -a ../build.log

install -m 0644 debian/try-from.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/try-from.8
install -m 0644 debian/safe_finger.8 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/safe_finger.8

rm %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so
ln -s ../../lib/libwrap.so.0 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so

rm -f %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/{hosts_ctl.3,request_init.3,request_set.3}
gzip -v9 %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man*/*
ln -s hosts_access.3.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/hosts_ctl.3.gz
ln -s hosts_access.3.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/request_init.3.gz
ln -s hosts_access.3.gz %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/request_set.3.gz

cp debian/copyright LICENSE


install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE1} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE2} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tcpd

%clean
rm -rf %{buildroot}


%files -n libwrap
%defattr(-,root,root)
%{_hhl_cross_target_dir}/lib/libwrap.so.0
%{_hhl_cross_target_dir}/lib/libwrap.so.0.7.6
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/hosts_access.5.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man5/hosts_options.5.gz
%doc BLURB CHANGES DISCLAIMER README README.NIS
%doc debian/README.Debian debian/changelog
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap


%files -n libwrap-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/tcpd.h
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libwrap.so
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/hosts_access.3.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/hosts_ctl.3.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/request_init.3.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man3/request_set.3.gz
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/libwrap-dev


%files -n tcpd
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpd
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpdchk
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/tcpdmatch
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/try-from
%{_hhl_cross_target_dir}%{_hhl_target_sbin_dir}/safe_finger
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpdmatch.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/try-from.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/safe_finger.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpd.8.gz
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man8/tcpdchk.8.gz
%doc LICENSE

%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/tcpd


%changelog
* Fri Apr 20 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Thu Jan 25 2001 Mark Hatle <source@mvista.com>
- Fixed an incorrect lib .../usr/lib/libwrap.so

* Tue Jan 23 2001 Mark Hatle <source@mvista.com>
- First cut



