Name: kernel-headers
Version: %{_hhl_kernel_base_version}_%{_hhl_kernel_hhl_version}
Release: 19.0.0.%{_hhl_build_id}
#Source0 from installed package
Source10: arm_sa_le-defconfig
Source11: arm_sa_be-defconfig
Source12: arm_xscale_le-defconfig
Source13: arm_720t_le-defconfig
Source14: arm_720t_be-defconfig
Source15: arm_920t_le-defconfig
Source16: arm_920t_be-defconfig
Source17: arm_xscale_be-defconfig
Source20: mips_fp_be-defconfig
Source21: mips_fp_le-defconfig
Source22: mips_nfp_be-defconfig
Source23: mips_nfp_le-defconfig
Source24: lexra_fp_be-defconfig
Source25: mips_sb1_fp_be-defconfig
Source26: mips_sb1_fp_le-defconfig
Source27: mips_sony_fp_le-defconfig
Source28: mips_sony_fp_be-defconfig
Source30: ppc_405-defconfig
Source31: ppc_7xx-defconfig
Source32: ppc_74xx-defconfig
Source33: ppc_82xx-defconfig
Source34: ppc_8xx-defconfig
Source35: ppc_403-defconfig
Source36: ppc_440-defconfig
Source40: sparc_ultra-defconfig
Source41: BuildASM
Source50: x86_386-defconfig
Source51: x86_486-defconfig
Source52: x86_586-defconfig
Source53: x86_athlon-defconfig
Source54: x86_crusoe-defconfig
Source55: x86_k6-defconfig
Source56: x86_pentium-defconfig
Source57: x86_pentium2-defconfig
Source58: x86_pentium3-defconfig
Source59: x86_pentium4-defconfig
Source60: sh_sh3_be-defconfig
Source61: sh_sh3_le-defconfig
Source62: sh_sh4_be-defconfig
Source63: sh_sh4_le-defconfig
Source64: xtensa_linux_be-defconfig
Source65: arm_v4t_be-defconfig
Source66: arm_v4t_le-defconfig
Source67: xtensa_linux_le-defconfig
Source68: xtensa_linux_test-defconfig
Source70: ia64_i2-defconfig

License: GPL
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
BuildRequires: host-rpmconfig host-kernel = %{version}
%define _docdir         %{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}

#
#  PACKAGE:  SRPM
#
Summary: Linux kernel headers for Hard Hat Linux.
Group: devel

Obsoletes : hhl-target-kernel-headers
Obsoletes : hhl-%{_hhl_target_arch}-kernel-headers

%description
The Linux kernel headers are used by various tools, such as GCC.  They
are required if you wish to compile any software.

#
#  PACKAGE:  kernel-headers
#

%prep
%target_check

SRCDIR="$PWD"/linux
rm -rf ${SRCDIR}
mkdir -p ${SRCDIR}
cd ${SRCDIR}

CONFIG="Target Missing"

cp -a %{_hhl_kernel_dir}/linux-%{version}/* ${SRCDIR}/.

rm -f .hhl_target_cpu
echo %{_hhl_target_cpu} > .hhl_target_cpu

rm -f .hhl_cross_compile
echo %{_hhl_target_toolprefix} > .hhl_cross_compile

%if "%{_hhl_target_arch}" == "arm_sa_le"
CONFIG=%{SOURCE10}
%endif
%if "%{_hhl_target_arch}" == "arm_sa_be"
CONFIG=%{SOURCE11}
%endif
%if "%{_hhl_target_arch}" == "arm_xscale_le" || "%{_hhl_target_arch}" == "arm_xscale_le_uclibc"
CONFIG=%{SOURCE12}
%endif
%if "%{_hhl_target_arch}" == "arm_iwmmxt_le"
CONFIG=%{SOURCE12}
%endif
%if "%{_hhl_target_arch}" == "arm_720t_le"
CONFIG=%{SOURCE13}
%endif
%if "%{_hhl_target_arch}" == "arm_720t_be"
CONFIG=%{SOURCE14}
%endif
%if "%{_hhl_target_arch}" == "arm_920t_le"
CONFIG=%{SOURCE15}
%endif
%if "%{_hhl_target_arch}" == "arm_920t_be"
CONFIG=%{SOURCE16}
%endif
%if "%{_hhl_target_arch}" == "arm_xscale_be"
CONFIG=%{SOURCE17}
%endif
%if "%{_hhl_target_arch}" == "mips_fp_be"
CONFIG=%{SOURCE20}
%endif
%if "%{_hhl_target_arch}" == "mips_fp_le"
CONFIG=%{SOURCE21}
%endif
%if "%{_hhl_target_arch}" == "mips_nfp_be"
CONFIG=%{SOURCE22}
%endif
%if "%{_hhl_target_arch}" == "mips_nfp_le"
CONFIG=%{SOURCE23}
%endif
%if "%{_hhl_target_arch}" == "mips_lexra_fp_be"
CONFIG=%{SOURCE24}
%endif
%if "%{_hhl_target_arch}" == "mips_sb1_fp_be"
CONFIG=%{SOURCE25}
%endif
%if "%{_hhl_target_arch}" == "mips_sb1_fp_le"
CONFIG=%{SOURCE26}
%endif
%if "%{_hhl_target_arch}" == "mips_sony_fp_le"
CONFIG=%{SOURCE27}
%endif
%if "%{_hhl_target_arch}" == "mips_sony_fp_be"
CONFIG=%{SOURCE28}
%endif
%if "%{_hhl_target_arch}" == "ppc_405" || "%{_hhl_target_arch}" == "ppc_405_uclibc"
CONFIG=%{SOURCE30}
%endif
%if "%{_hhl_target_arch}" == "ppc_7xx"
CONFIG=%{SOURCE31}
%endif
%if "%{_hhl_target_arch}" == "ppc_74xx"
CONFIG=%{SOURCE32}
%endif
%if "%{_hhl_target_arch}" == "ppc_82xx"
CONFIG=%{SOURCE33}
%endif
%if "%{_hhl_target_arch}" == "ppc_8xx"
CONFIG=%{SOURCE34}
%endif
%if "%{_hhl_target_arch}" == "ppc_403"
CONFIG=%{SOURCE35}
%endif
%if "%{_hhl_target_arch}" == "ppc_440"
CONFIG=%{SOURCE36}
%endif
%if "%{_hhl_target_arch}" == "x86_386"
CONFIG=%{SOURCE50}
%endif
%if "%{_hhl_target_arch}" == "x86_486"
CONFIG=%{SOURCE51}
%endif
%if "%{_hhl_target_arch}" == "x86_586"
CONFIG=%{SOURCE52}
%endif
%if "%{_hhl_target_arch}" == "x86_athlon"
CONFIG=%{SOURCE53}
%endif
%if "%{_hhl_target_arch}" == "x86_crusoe"
CONFIG=%{SOURCE54}
%endif
%if "%{_hhl_target_arch}" == "x86_k6"
CONFIG=%{SOURCE55}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium"
CONFIG=%{SOURCE56}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium2"
CONFIG=%{SOURCE57}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium3"
CONFIG=%{SOURCE58}
%endif
%if "%{_hhl_target_arch}" == "x86_pentium4"
CONFIG=%{SOURCE59}
%endif
%if "%{_hhl_target_arch}" == "sh_sh3_be"
CONFIG=%{SOURCE60}
%endif
%if "%{_hhl_target_arch}" == "sh_sh3_le"
CONFIG=%{SOURCE61}
%endif
%if "%{_hhl_target_arch}" == "sh_sh4_be"
CONFIG=%{SOURCE62}
%endif
%if "%{_hhl_target_arch}" == "sh_sh4_le"
CONFIG=%{SOURCE63}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_be"
CONFIG=%{SOURCE64}
%endif
%if "%{_hhl_target_arch}" == "arm_v4t_be" || "%{_hhl_target_arch}" == "arm_v4t_be_uclibc"
CONFIG=%{SOURCE65}
%endif
%if "%{_hhl_target_arch}" == "arm_v4t_le" || "%{_hhl_target_arch}" == "arm_v4t_le_uclibc"
CONFIG=%{SOURCE66}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_le"
CONFIG=%{SOURCE67}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_test"
CONFIG=%{SOURCE68}
%endif
%if "%{_hhl_target_arch}" == "ia64_i2"
CONFIG=%{SOURCE70}
%endif
%if "%{_hhl_target_arch}" == "mips2_fp_be"
CONFIG=%{SOURCE20}
%endif
%if "%{_hhl_target_arch}" == "mips2_fp_le"
CONFIG=%{SOURCE21}
%endif
%if "%{_hhl_target_arch}" == "mips2_nfp_be"
CONFIG=%{SOURCE22}
%endif
%if "%{_hhl_target_arch}" == "mips2_nfp_le"
CONFIG=%{SOURCE23}
%endif
%if "%{_hhl_target_arch}" == "mips64_fp_be"
CONFIG=%{SOURCE20}
%endif
%if "%{_hhl_target_arch}" == "mips64_fp_le"
CONFIG=%{SOURCE21}
%endif
%if "%{_hhl_target_arch}" == "mips64_nfp_be"
CONFIG=%{SOURCE22}
%endif
%if "%{_hhl_target_arch}" == "mips64_nfp_le"
CONFIG=%{SOURCE23}
%endif


%if "%{_hhl_target_arch}" == "sparc_ultra"
# The sparc doesn't look like it needs to be configured to have valid 
# headers...
#cp %{SOURCE40} .config
CONFIG=SOURCE10

rm -rf include/asm
mkdir -p include/asm
cp %{SOURCE41} include/asm/.
chmod +x include/asm/BuildASM

%else
# Copy configuration (or fail if none available)
cp $CONFIG .config
%endif

#
#  BUILD
#

%build
%target_setup

SRCDIR="$PWD"/linux
cd ${SRCDIR}

%if "%{_hhl_target_arch}" == "sparc_ultra"
./include/asm/BuildASM ./include
%else
HHL_CONFIG_DEFAULTNEW=y %make oldconfig
%dmake include/linux/version.h
%endif

#
#  INSTALL
#

%install
%target_setup
SRCDIR="$PWD"/linux
cp ${SRCDIR}/COPYING LICENSE
cd ${SRCDIR}

rm -rf %{buildroot}
mkdir -p %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}
cp -a include/linux %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}
%if "%{_hhl_target_arch}" == "sparc_ultra"
cp -a include/asm-generic %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-sparc %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-sparc64 %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%else
ln -s asm-%{_hhl_target_cpu} %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
cp -a include/asm-generic %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
cp -a include/asm-%{_hhl_target_cpu} %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%if "%{_hhl_cpu_type}" == "ppc"
cp -a include/asm-m68k %{buildroot}/%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/.
%endif
%endif

#
#  CLEAN
#
%clean
rm -rf %{buildroot}


%files -n kernel-headers
%defattr(-,root,root)
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/linux
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/linux/*

%if "%{_hhl_target_arch}" == "sparc_ultra"
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc64
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-sparc64/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic/*
%else
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic/*
%{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-%{_hhl_target_cpu}/*
%if "%{_hhl_cpu_type}" == "ppc"
%{_hhl_cross_target_dir}/%{_hhl_target_includedir}/asm-m68k/*
%dir %{_hhl_cross_target_dir}/%{_hhl_target_includedir}/asm-m68k
%endif
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-generic
%dir %{_hhl_cross_target_dir}/%{_hhl_target_include_dir}/asm-%{_hhl_target_cpu}
%endif
%doc LICENSE

#
#  CHANGELOG
#

%changelog
* Wed Sep 03 2003 Michael Eager <eager@mvista.com>
- Add MIPS64 targets.
* Thu Jun 26 2003 Michael Eager <eager@mvista.com>
- Add PPC_440.
* Tue Jan 28 2003 Daniel Jacobowitz <drow@mvista.com>
- Add uClibc targets.

* Thu Oct 31 2002 John Kwan <jkwan@mvista.com>
- Remove all xtensa patches and add new defconfig files.
* Fri Oct 25 2002 John Kwan <jkwan@mvista.com>
- add patch to fix atomic.h for xtensa
* Fri Oct 11 2002 John Kwan <jkwan@mvista.com>
- Build headers for xtensa_linux_test.
* Wed Sep 27 2002 John Kwan <jkwan@mvista.com>
- Build headers for xtensa_linux_be and xtensa_linux_le uisng "tar" files
* Wed Sep 18 2002 John Kwan <jkwan@mvista.com>
- Add support for xtensa_linux_le
* Wed Aug 28 2002 John Kwan <jkwan@mvista.com>
- Add arm_v4t_le and arm_v4t_be architecture

* Thu Jul 11 2002 Joe Green <source@mvista.com>
- Add xtensa_linux_be architecture.

* Mon May 20 2002 Michael Eager <eager@mvista.com>
- Add mips_sony_fp_be architecture.

* Mon Oct 29 2001 Michael Eager <eager@mvista.com>
- Add Sibyte and PPC-403 targets.

* Mon Feb 19 2001 Mark Hatle <source@mvista.com>
- Stupid sparc requires something special to work!

* Mon Jan 22 2001 Mark Hatle <fray@mvista.com>
- Initial HHL 2.0 version

* Tue Sep 26 2000 Joe Green <jgreen@mvista.com>
- Moved into kernel directory.  Use _hhl_target_cpu instead of _hhl_cpu_type.

* Wed Jun 14 2000 Mark Hatle <mhatle@mvista.com>
- Started this package


