Summary: The GNU assembler, linker and binary utilities.
Name: binutils
Version: 2.14
Release: 8.0.3.%{_hhl_build_id}

Source: ftp://ftp.gnu.org/gnu/binutils/binutils-2.14.tar.bz2
Source3: binutils-2.13.tmpl
Source4: binutils-dev.tmpl
Source5: binutils-doc-2.13.tmpl

# Note 2003-05-03: these files should be updated for binutils 2.14, but
# the old versions appear to be functionally identical.
Source6: binutils_xtensa_linux_be.tar
Source7: binutils_xtensa_linux_le.tar
Source8: binutils_xtensa_linux_test.tar

Patch1: binutils-2.14-nohoststrip.patch
Patch2: binutils-2.12.1-sh.patch
Patch3: binutils-2.14-arm_be.patch
Patch4: binutils-2.12.1-arm_nofpu.patch
Patch5: hhl-binutils-license.patch
Patch6: binutils-2.14_ppc440.patch
Patch7: binutils-2.14-cfi.patch
Patch8: binutils-2.14-cfi-arm.patch
Patch9: binutils-2.14-cfi-ppc.patch
Patch10: binutils-2.14-arm-got.patch
Patch11: binutils-2.12.1-unified-constructors.patch
Patch17: binutils-2.14-intl.patch
Patch18: binutils-2.14-arm-sbss.patch

License: GPL/LGPL
Group: devel
Buildroot: %{_tmppath}/%{name}-%{_hhl_target_arch}-root
Prefix: %{_hhl_cross_target_dir}
%define _docdir		%{_hhl_cross_target_dir}/%{_hhl_target_doc_dir}
Obsoletes: hhl-%{_hhl_target_arch}-binutils

%description
The programs in this package are used to assemble, link and manipulate
binary and object files.  They may be used in conjunction with a compiler
and various libraries to build programs for Linux.

# Target Package
%package -n binutils-dev
Summary: The GNU binary utilities (BFD development files)
Group: devel
Obsoletes: hhl-%{_hhl_target_arch}-binutils-dev

%description -n binutils-dev
This package includes header files and static libraries necessary to build 
programs which use the GNU BFD library, which is part of binutils.

# Documentation Package
%package -n binutils-doc
Summary: Documentation for the GNU assembler, linker and binary utilities.
Group: doc
Obsoletes: hhl-%{_hhl_target_arch}-binutils-doc

%description -n binutils-doc
This package consists of the documentation for the GNU assembler,
linker and binary utilities.

%prep
%target_check
%setup -n binutils-%{version} -q

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch17 -p1
%patch18 -p1

%if "%{_hhl_target_arch}" == "xtensa_linux_be"
tar -xf  %{SOURCE6}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_le"
tar -xf  %{SOURCE7}
%endif
%if "%{_hhl_target_arch}" == "xtensa_linux_test"
tar -xf  %{SOURCE8}
%endif

# Update version number
%define _dt %(date +%%F)
%define verstring (MontaVista %{version}-%{release} %_dt)
sed -e \
  "/bfd_version_string=/ s/\\\\\"\"$/ %{verstring}\\\\\"\"/" \
  bfd/configure.in > bfd/configure.in.tmp
mv -f bfd/configure.in.tmp bfd/configure.in
sed -e \
  "/bfd_version_string=/ s/\\\\\"\"$/ %{verstring}\\\\\"\"/" \
  bfd/configure > bfd/configure.tmp
mv -f bfd/configure.tmp bfd/configure
chmod a+x bfd/configure

%build

%target_setup
%target_tool_configure --target=%{_hhl_target_toolconfig} \
	--enable-install-libiberty --enable-install-libbfd \
	--enable-shared \
	| tee ../build.log

%dmake 2>&1 | tee -a ../build.log

%install
rm -rf %{buildroot}

cp COPYING LICENSE

%target_setup
%target_makeinstall \
	install-info 2>&1 | tee -a ../build.log
%demangle_libtool

gzip -v9 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man?/*
gzip -v9 %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*

for i in addr2line ar as c++filt gprof ld nm \
	objcopy objdump ranlib readelf strip; do 
  ln -s $i %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/%{_hhl_target_toolprefix}$i
done

# Replace some hardlinks with symlinks.  The symlinks are friendlier to
# relocation.
for prog in ar as ld nm ranlib strip; do 
  rm -f %{buildroot}%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/${prog}
  ln -s ../../bin/${prog} %{buildroot}%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/${prog}
done

install  ../include/dis-asm.h %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
install ../include/libiberty.h %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_include_dir}
install -d %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages
export HHL_TOOL_PREFIX=%{_hhl_target_toolprefix}
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE3} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE4} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-dev
genpkgdesc %{buildroot}%{_hhl_cross_target_dir} %{SOURCE5} > %{buildroot}%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-doc

rm -rf %{buildroot}/%{_hhl_cross_target_dir}%{_hhl_target_info_dir}/dir.gz

%clean
rm -rf %{buildroot}

%files -n binutils
%defattr(-,root,root)
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/bin
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib
%dir %{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib/ldscripts
%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/bin/*
%{_hhl_cross_target_dir}/usr/%{_hhl_target_toolconfig}/lib/ldscripts/*
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libbfd-*.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libopcodes-*.so
%{_hhl_cross_target_dir}%{_hhl_target_bin_dir}/*
%{_hhl_cross_target_dir}%{_hhl_target_data_dir}/locale
%doc %{_hhl_cross_target_dir}%{_hhl_target_man_dir}/man1/*.1.gz
%doc COPYING COPYING.LIB build.log
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils

%files -n binutils-dev
%defattr(-,root,root)
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libbfd.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libbfd.la
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libbfd.so
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libiberty.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libopcodes.a
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libopcodes.la
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/libopcodes.so
%{_hhl_cross_target_dir}%{_hhl_target_include_dir}/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-dev

%files -n binutils-doc
%defattr(-,root,root)
%doc %{_hhl_cross_target_dir}%{_hhl_target_info_dir}/*
%doc LICENSE
%{_hhl_cross_target_dir}%{_hhl_target_lib_dir}/pml/packages/binutils-doc

%changelog
* Fri Nov 07 2003 Michael Eager <eager@mvista.com>
- Add date/buildno to version.
* Fri Sep 26 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-7.3
- Don't generate empty .sbss sections on ARM.
* Wed Sep 24 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-7.2
- Add support for locale catalogs.
* Tue Sep 16 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-7.1
- Add a missing item to the list of demangled destructor types.
* Thu Aug 21 2003 Michael Eager <eager@mvista.com>
- Fix 1-14VM1 -- add libiberty.h to binutils-dev.
* Wed Aug 20 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-6
- Support demangling of unified constructors/destructors.
* Tue Aug 5 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-5
- Add a bugfix for hidden symbols on ARM.
* Thu Jul 10 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-4
- Add CFI support for PowerPC.
* Wed Jul 2 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-3
- Add CFI support to the assembler.
* Thu Jun 26 2003 Michael Eager <eager@mvista.com>
- Add support for PPC 440.
* Fri Jun 13 2003 Daniel Jacobowitz <drow@mvista.com> 2.14-1
- Update to binutils 2.14.
* Mon May 5 2003 Daniel Jacobowitz <drow@mvista.com> 2.13.91-1
- Update to first 2.14 prerelease.
* Wed Apr 16 2003 Daniel Jacobowitz <drow@mvista.com> 2.13.2-4
- Update libiberty to include make_relative_prefix and lrealpath.
* Fri Feb 21 2003 Daniel Jacobowitz <drow@mvista.com> 2.13.2-3
- Support tlbre on ppc_405.
* Thu Jan 30 2003 Michael Eager <eager@mvista.com>
- Remove pushd/popd.
* Thu Dec 19 2002 Daniel Jacobowitz <drow@mvista.com> 2.13.2-1
- Update to binutils 2.13.2.
- Disable gasp.
* Tue Dec 10 2002 John kwan <jkwan@mvista.com>
- Give a more meaningful name to the patch that fixes xtensa linker bug.
* Mon Dec 9 2002 John kwan <jkwan@mvista.com>
- Add a new patch for binutils-2.12.1 to fix a minor ld bug in xtensa
* Mon Dec 9 2002 John kwan <jkwan@mvista.com>
- Update with yet another patch for binutils-2.12.1 from Tensilica
* Thu Nov 28 2002 John kwan <jkwan@mvista.com>
- Fix an error in extensa build (wrong source file).
* Tue Nov 19 2002 Michael Eager <eager@mvista.com>
- Add pml/binutils-dev to binutils-dev package.
* Thu Nov 14 2002 John kwan <jkwan@mvista.com>
- Update with new patch for xtensa.
* Thu Oct 24 2002 Michael Eager <eager@mvista.com>
- Add support for MVL_LICENSE and --MVlicense option.
* Wed Oct 23 2002 Daniel Jacobowitz <drow@mvista.com>
- Default gas to big-endian on big-endian ARM platforms
* Thu Oct 10 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix a linker bug on MIPS which corrupted DWARF-2 information.
* Tue Oct  1 2002 Daniel Jacobowitz <drow@mvista.com>
- Fix DWARF-2 information in shared libraries for PowerPC.
* Wed Sep 25 2002 Michael Eager <eager@mvista.com>
- Make gas for ARM default to no-fpu.
* Fri Sep  6 2002 John Kwan <jkwan@mvista.com>
- Fix an error in the help menu of size in ppc_405
* Wed Aug 28 2002 Daniel Jacobowitz <drow@mvista.com>
- ARM PLT allocation fix (1-ZVD7)
* Thu Aug 22 2002 Daniel Jacobowitz <drow@mvista.com>
- More miscellaneous SH fixes
* Wed Aug 21 2002 Daniel Jacobowitz <drow@mvista.com>
- Refcounting fixes for ARM and SH
* Wed Jul 24 2002 Daniel Jacobowitz <drow@mvista.com>
- Merge ARM, SH, and architecture-independent binutils patches
- Add MIPS DWARF-2 support
* Wed Jul 10 2002 Daniel Jacobowitz <drow@mvista.com>
- Move shared libraries into binutils package.
* Fri Jun 28 2002 Michael Eager <eager@mvista.com>
- Convert to binutils-2.12.1.
* Wed May 22 2002 Michael Eager <eager@mvista.com>
- Sony Patches:
  MIPS inline info patch -- Bug 1-PQNA
* Fri Mar 22 2002 Michael Eager <eager@mvista.com>
- Xtensa support.
* Fri Feb 15 2002 Michael Eager <eager@mvista.com> 
- Defect 1-GE7F -- fix libtool problem.
* Wed Feb 13 2002 Michael Eager <eager@mvista.com>
- Build shared versions of libopcodes, etc.
- Include dis-asm.h in binutils-dev package. 
* Thu Nov  1 2001 Michael Eager <eager@mvista.com>
- Fix Xscale asm bug 1347.
* Tue Sep 25 2001 Michael Eager <eager@mvista.com>
- Upgrade to binutils-2.11.2
* Mon Aug 13 2001 Michael Eager <eager@mvista.com>
- Convert to use target_tool_config and  hhl_target_toolconfig.

* Wed Aug 01 2001 Daniel Jacobowitz <source@mvista.com>
- Added SH relocation fixes.
* Thu Apr 19 2001 Automated script (run by Steve Kinneberg <skinneberg@mvista.com>)
- Added TCT package description files
* Mon Feb 19 2001 Mark Hatle <source@mvista.com>
- First cut
