/*
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 *
 */

/*
 * Broadcom 802.11b DCF-only Networking Controller.
 * Chip-specific hardware definitions.
 *
 * Copyright 2001, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * $Id: d11.h,v 13.174.2.4 2003/06/27 22:04:57 noname Exp $
 */

#ifndef	_D11_H
#define	_D11_H

#include <bcmdevs.h>
#include <hnddma.h>

/* enable structure packing */
#if !defined(__GNUC__)
#pragma pack(1)
#endif

/* some platforms require stronger medicine */
#if defined(__GNUC__)
#define	PACKED	__attribute__((packed))
#else
#define	PACKED
#endif

/* cpp contortions to concatenate w/arg prescan */
#ifndef	PAD
#define	_PADLINE(line)	pad ## line
#define	_XSTR(line)	_PADLINE(line)
#define	PAD		_XSTR(__LINE__)
#endif

/* length of the BCN template area */
#define	BCN_TMPL_LEN	512

/* phy types */
#define	PHY_TYPE_A		0
#define	PHY_TYPE_B		1
#define	PHY_TYPE_G		2
#define PHY_TYPE_NULL		0xf

#undef PACKED
#if !defined(__GNUC__)
#pragma pack()
#endif

#endif	/* _D11_H */
