/* Register settings for SiS 300 series */

typedef struct _SiS300_StStruct
{
	UCHAR St_ModeID;
	USHORT St_ModeFlag;
	UCHAR St_StTableIndex;
	UCHAR St_CRT2CRTC;
	UCHAR St_ResInfo;
	UCHAR VB_StTVFlickerIndex;
	UCHAR VB_StTVEdgeIndex;
	UCHAR VB_StTVYFilterIndex;
} SiS300_StStruct;

static const SiS300_StStruct  SiS300_SModeIDTable[]=
{
	{0x01,0x9208,0x01,0x00,0x00,0x00,0x00,0x00},
	{0x01,0x1210,0x14,0x01,0x01,0x00,0x00,0x00},
	{0x01,0x1010,0x17,0x02,0x02,0x00,0x00,0x00},
	{0x03,0x8208,0x03,0x00,0x00,0x00,0x00,0x00},
	{0x03,0x0210,0x16,0x01,0x01,0x00,0x00,0x00},
	{0x03,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x05,0x9209,0x05,0x00,0x00,0x00,0x00,0x00},
	{0x06,0x8209,0x06,0x00,0x00,0x00,0x00,0x00},
	{0x07,0x0000,0x07,0x03,0x03,0x00,0x00,0x00},
	{0x07,0x0000,0x19,0x02,0x02,0x00,0x00,0x00},
	{0x0d,0x920a,0x0d,0x00,0x00,0x00,0x00,0x00},
	{0x0e,0x820a,0x0e,0x00,0x00,0x00,0x00,0x00},
	{0x0f,0x0202,0x11,0x01,0x01,0x00,0x00,0x00},
	{0x10,0x0212,0x12,0x01,0x01,0x00,0x00,0x00},
	{0x11,0x0212,0x1a,0x04,0x04,0x00,0x00,0x00},
	{0x12,0x0212,0x1b,0x04,0x04,0x00,0x00,0x00},
	{0x13,0x021b,0x1c,0x00,0x00,0x00,0x00,0x00},
	/* {0x12,0x0210,0x18,0x00,0x00,0x00,0x00,0x00}, */  /* <--- Different in BIOS */
	{0x12,0x0010,0x18,0x02,0x02,0x00,0x00,0x00},
	{0x12,0x0210,0x18,0x01,0x01,0x00,0x00,0x00},
	{0xff,0,0,0,0,0,0,0}
};

typedef struct _SiS300_StandTableStruct
{
	UCHAR CRT_COLS;
	UCHAR ROWS;
	UCHAR CHAR_HEIGHT;
	USHORT CRT_LEN;
	UCHAR SR[4];
	UCHAR MISC;
	UCHAR CRTC[0x19];
	UCHAR ATTR[0x14];
	UCHAR GRC[9];
} SiS300_StandTableStruct;

static const SiS300_StandTableStruct  SiS300_StandTable[]=
{ /* TW: @ 0x38d4 in BIOS */
 {0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x08,0x0800,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x08,0x1000,
  {0x01,0x03,0x00,0x02},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0xc7,0x06,0x07,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff} },
 {0x28,0x18,0x08,0x4000,
  {0x09,0x03,0x00,0x02},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xa2,
   0xff},
  {0x00,0x13,0x15,0x17,0x02,0x04,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x03,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x30,0x0f,0x00,
   0xff} },
 {0x50,0x18,0x08,0x4000,
  {0x01,0x01,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0xc1,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xc2,
   0xff},
  {0x00,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
   0x01,0x00,0x01,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x0d,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x00,0x03,0x00,0x03},
  0xa6,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0d,0x63,0xba,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff} },
/* MDA_DAC*/
 {0x00,0x00,0x00,0x0000,
  {0x00,0x00,0x00,0x15},
  0x15,
  {0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
   0x15,0x15,0x15,0x15},
  {0x15,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f} },
/* CGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x00},
  0x10,
  {0x04,0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x2a,0x3a,
   0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x10,
   0x04},
  {0x14,0x01,0x11,0x09,0x15,0x00,0x10,0x04,
   0x14,0x01,0x11,0x09,0x15,0x2a,0x3a,0x2e,
   0x3e,0x2b,0x3b,0x2f},
  {0x3f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f} },
/* EGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x05,0x15,0x20},
  0x30,
  {0x24,0x34,0x21,0x31,0x25,0x35,0x08,0x18,
   0x0c,0x1c,0x09,0x19,0x0d,0x1d,0x28,0x38,
   0x2c,0x3c,0x29,0x39,0x2d,0x3d,0x02,0x12,
   0x06},
  {0x16,0x03,0x13,0x07,0x17,0x22,0x32,0x26,
   0x36,0x23,0x33,0x27,0x37,0x0a,0x1a,0x0e,
   0x1e,0x0b,0x1b,0x0f},
  {0x1f,0x2a,0x3a,0x2e,0x3e,0x2b,0x3b,0x2f,
   0x3f} },
/* VGA_DAC*/
 {0x00,0x10,0x04,0x0114,
  {0x11,0x09,0x15,0x2a},
  0x3a,
  {0x2e,0x3e,0x2b,0x3b,0x2f,0x3f,0x00,0x05,
   0x08,0x0b,0x0e,0x11,0x14,0x18,0x1c,0x20,
   0x24,0x28,0x2d,0x32,0x38,0x3f,0x00,0x10,
   0x1f},
  {0x2f,0x3f,0x1f,0x27,0x2f,0x37,0x3f,0x2d,
   0x31,0x36,0x3a,0x3f,0x00,0x07,0x0e,0x15,
   0x1c,0x0e,0x11,0x15},
  {0x18,0x1c,0x14,0x16,0x18,0x1a,0x1c,0x00,
   0x04} },
 {0x08,0x0c,0x10,0x0a08,
  {0x0c,0x0e,0x10,0x0b},
  0x0c,
  {0x0d,0x0f,0x10,0x10,0x01,0x08,0x00,0x00,
   0x00,0x00,0x01,0x00,0x02,0x02,0x01,0x00,
   0x04,0x04,0x01,0x00,0x05,0x02,0x05,0x00,
   0x06},
  {0x01,0x06,0x05,0x06,0x00,0x08,0x01,0x08,
   0x00,0x07,0x02,0x07,0x06,0x07,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00} },
 {0x28,0x18,0x08,0x2000,
  {0x09,0x0f,0x00,0x06},
  0x63,
  {0x2d,0x27,0x28,0x90,0x2b,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x50,0x18,0x08,0x4000,
  {0x01,0x0f,0x00,0x06},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x00,0x96,0xb9,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x00,0x00,0x00,0x0000,	/* TW: Standtable for VGA modes */
  {0x01,0x0f,0x00,0x0e},	/*    (identical to BIOS) */
  0x23,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x01,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff} },
 {0x4a,0x36,0x00,0x00c0,
  {0x00,0x00,0x00,0x00},
  0x00,
  {0x00,0x00,0x00,0x00,0x00,0x00,0x66,0x3a,
   0x00,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x1a,0x00,0x57,0x39,0x00,0xc0,
   0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00} },
 {0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa2,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,
   0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
   0x0b,0x00,0x05,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,
   0xff} },
 {0x50,0x18,0x0e,0x8000,
  {0x01,0x0f,0x00,0x06},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x0f,0x63,0xba,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x0e,0x0800,
  {0x09,0x03,0x00,0x02},
  0xa3,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x14,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x0e,0x1000,
  {0x01,0x03,0x00,0x02},
  0xa3,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4d,0x0b,0x0c,0x00,0x00,0x00,0x00,
   0x83,0x85,0x5d,0x28,0x1f,0x63,0xba,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x08,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x28,0x18,0x10,0x0800,
  {0x08,0x03,0x00,0x02},
  0x67,
  {0x2d,0x27,0x28,0x90,0x2b,0xa0,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x14,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x67,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x1f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x0c,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0e,0x00,
   0xff} },
 {0x50,0x18,0x10,0x1000,
  {0x00,0x03,0x00,0x02},
  0x66,
  {0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
   0x00,0x4f,0x0d,0x0e,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x0f,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
   0x10,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
   0x0e,0x00,0x0f,0x08},
  {0x00,0x00,0x00,0x00,0x00,0x10,0x0a,0x00,
   0xff} },
 {0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x00,0xe7,0x04,0xc3,
   0xff},
  {0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x01,
   0xff} },
 {0x50,0x1d,0x10,0xa000,
  {0x01,0x0f,0x00,0x06},
  0xe3,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,
   0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,
   0xea,0x8c,0xdf,0x28,0x00,0xe7,0x04,0xe3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
   0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
   0x01,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0f,
   0xff} },
 {0x28,0x18,0x08,0x2000,
  {0x01,0x0f,0x00,0x0e},
  0x63,
  {0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,
   0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
   0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
   0xff},
  {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
   0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
   0x41,0x00,0x0f,0x00},
  {0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,
   0xff} }
};

typedef struct _SiS300_ExtStruct
{
	UCHAR Ext_ModeID;
	USHORT Ext_ModeFlag;
	USHORT Ext_ModeInfo;
	USHORT Ext_Point;
	USHORT Ext_VESAID;
	UCHAR Ext_VESAMEMSize;
	UCHAR Ext_RESINFO;
	UCHAR VB_ExtTVFlickerIndex;
	UCHAR VB_ExtTVEdgeIndex;
	UCHAR VB_ExtTVYFilterIndex;
	UCHAR REFindex;
} SiS300_ExtStruct;

static const SiS300_ExtStruct  SiS300_EModeIDTable[]=
{
	{0x6a,0x2212,0x47,0x3563,0x0102,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */  /* 800x600x? */
	{0x2e,0x0a1b,0x36,0x3539,0x0101,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
	{0x2f,0x021b,0x35,0x3532,0x0100,0x08,0x05,0x00,0x00,0x00,0x10},  /* 37bc */
	{0x30,0x2a1b,0x47,0x3563,0x0103,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */
	{0x31,0x0a1b,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */ /* 720x480x8 */
	{0x32,0x2a1b,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */ /* 720x576x8 */
	{0x33,0x0a1d,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */ /* 720x480x16 */
	{0x34,0x2a1d,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */ /* 720x576x16 */
	{0x35,0x0a1f,0xad,0x3630,0x0000,0x08,0x0c,0x00,0x00,0x00,0x11},  /* 38ba */ /* 720x480x32 */
	{0x36,0x2a1f,0xae,0x3637,0x0000,0x08,0x0d,0x00,0x00,0x00,0x12},  /* 38c1 */ /* 720x576x32 */
	{0x37,0x0212,0x58,0x358d,0x0104,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */ /* 1024x768x? */
	{0x38,0x0a1b,0x58,0x358d,0x0105,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */ /* 1024x768x8 */
	{0x3a,0x0e3b,0x69,0x35be,0x0107,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */ /* 1280x1024x8 */
	{0x3c,0x063b,0x7a,0x35d4,0x0130,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
	{0x3d,0x067d,0x7a,0x35d4,0x0131,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
	{0x40,0x921c,0x00,0x3516,0x010d,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
	{0x41,0x921d,0x00,0x3516,0x010e,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
	{0x43,0x0a1c,0x36,0x3539,0x0110,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
	{0x44,0x0a1d,0x36,0x3539,0x0111,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
	{0x46,0x2a1c,0x47,0x3563,0x0113,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */ /* 800x600 */
	{0x47,0x2a1d,0x47,0x3563,0x0114,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */ /* 800x600 */
	{0x49,0x0a3c,0x58,0x358d,0x0116,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
	{0x4a,0x0a3d,0x58,0x358d,0x0117,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
	{0x4c,0x0e7c,0x69,0x35be,0x0119,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
	{0x4d,0x0e7d,0x69,0x35be,0x011a,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
	{0x50,0x921b,0x01,0x351d,0x0132,0x08,0x01,0x00,0x00,0x00,0x24},  /* 37a7 */
	{0x51,0xb21b,0x13,0x3524,0x0133,0x08,0x03,0x00,0x00,0x00,0x25},  /* 37ae */ /* 400x300 */
	{0x52,0x921b,0x24,0x352b,0x0134,0x08,0x04,0x00,0x00,0x00,0x26},  /* 37b5 */
	{0x56,0x921d,0x01,0x351d,0x0135,0x08,0x01,0x00,0x00,0x00,0x24},  /* 37a7 */
	{0x57,0xb21d,0x13,0x3524,0x0136,0x08,0x03,0x00,0x00,0x00,0x25},  /* 37ae */ /* 400x300 */
	{0x58,0x921d,0x24,0x352b,0x0137,0x08,0x04,0x00,0x00,0x00,0x26},  /* 37b5 */
	{0x59,0x921b,0x00,0x3516,0x0138,0x08,0x00,0x00,0x00,0x00,0x23},  /* 37a0 */
	{0x5c,0x921f,0x24,0x352b,0x0000,0x08,0x04,0x00,0x00,0x00,0x26},  /* TW: inserted 512x384x32 */
	{0x5d,0x021d,0x35,0x3532,0x0139,0x08,0x05,0x00,0x00,0x00,0x10},  /* 37bc */
	{0x62,0x0a3f,0x36,0x3539,0x013a,0x08,0x06,0x00,0x00,0x00,0x08},  /* 37c3 */
	{0x63,0x2a3f,0x47,0x3563,0x013b,0x08,0x07,0x00,0x00,0x00,0x00},  /* 37ed */  /* 800x600 */
	{0x64,0x0a7f,0x58,0x358d,0x013c,0x08,0x08,0x00,0x00,0x00,0x13},  /* 3817 */
	{0x65,0x0eff,0x69,0x35be,0x013d,0x08,0x09,0x00,0x00,0x00,0x1a},  /* 3848 */
	{0x66,0x06ff,0x7a,0x35d4,0x013e,0x08,0x0a,0x00,0x00,0x00,0x1e},  /* 385e */
	{0x68,0x067b,0x8b,0x35ef,0x013f,0x08,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
	{0x69,0x06fd,0x8b,0x35ef,0x0140,0x08,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
	{0x6b,0x07ff,0x8b,0x35ef,0x0000,0x10,0x0b,0x00,0x00,0x00,0x27},  /* 3879 */
	{0x6c,0x067b,0x9c,0x35f6,0x0000,0x08,0x0c,0x00,0x00,0x00,0x28},  /* 3880 */
	{0x6d,0x06fd,0x9c,0x35f6,0x0000,0x10,0x0c,0x00,0x00,0x00,0x28},  /* 3880 */
	{0x6e,0x0e3b,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */  /* 1280x960x8 */
	{0x6f,0x0e7d,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */  /* 1280x960x16 */
	{0x7b,0x0eff,0x6f,0x35b2,0x0000,0x08,0x0e,0x00,0x00,0x00,0x29},  /* 383c */  /* 1280x960x32 */
	{0x20,0x0a1b,0x54,0x0000,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},              /* 1024x600 */
	{0x21,0x0a3d,0x54,0x0000,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},
	{0x22,0x0a7f,0x54,0x0000,0x0000,0x08,0x0f,0x00,0x00,0x00,0x2b},
	{0x23,0x0a1b,0xc5,0x0000,0x0000,0x08,0x10,0x00,0x00,0x00,0x2c},              /* 1152x768 */
	{0x24,0x0a3d,0xc5,0x431d,0x0000,0x08,0x10,0x00,0x00,0x00,0x2c},
	{0x25,0x0a7f,0xc5,0x431d,0x0000,0x08,0x10,0x00,0x00,0x00,0x2c},
	{0xff,0x0000,0x00,0x0000,0xffff,0x00,0x00,0x00,0x00,0x00,0x00}
};

typedef struct _SiS300_Ext2Struct
{
	USHORT Ext_InfoFlag;
	UCHAR Ext_CRT1CRTC;  /* TW: Index in SiS300_CRT1Table */
	UCHAR Ext_CRTVCLK;
	UCHAR Ext_CRT2CRTC;  /* TW: Index in LCD Paneltype arrays (&3f) */
	UCHAR  ModeID;
	USHORT XRes;
	USHORT YRes;
	USHORT ROM_OFFSET;
} SiS300_Ext2Struct;

static const SiS300_Ext2Struct  SiS300_RefIndex[]=
{ /* TW: Don't ever insert anything here, table is indexed */
	{0x085f,0x0d,0x03,0x05,0x6a, 800, 600,0x3563}, /* 00 */
	{0x0467,0x0e,0x44,0x05,0x6a, 800, 600,0x3568}, /* 01 */
	{0x0067,0x4f,0x07,0x48,0x6a, 800, 600,0x356d}, /* 02 */
	{0x0067,0x10,0x06,0x8b,0x6a, 800, 600,0x3572}, /* 03 */
	{0x0147,0x11,0x08,0x00,0x6a, 800, 600,0x3577}, /* 04 */
	{0x0147,0x12,0x0c,0x00,0x6a, 800, 600,0x357c}, /* 05 */
	{0x0047,0x51,0x4e,0x00,0x6a, 800, 600,0x3581}, /* 06 */
	{0x0047,0x11,0x13,0x00,0x6a, 800, 600,0x3586}, /* 07 */
	{0xc85f,0x05,0x00,0x04,0x2e, 640, 480,0x3539}, /* 08 */
	{0xc067,0x06,0x02,0x04,0x2e, 640, 480,0x353e}, /* 09 */
	{0xc067,0x07,0x02,0x47,0x2e, 640, 480,0x3543}, /* 0a */
	{0xc067,0x08,0x03,0x8a,0x2e, 640, 480,0x3548}, /* 0b */
	{0xc047,0x09,0x05,0x00,0x2e, 640, 480,0x354d}, /* 0c */
	{0xc047,0x0a,0x08,0x00,0x2e, 640, 480,0x3552}, /* 0d */
	{0xc047,0x0b,0x0a,0x00,0x2e, 640, 480,0x3557}, /* 0e */
	{0xc047,0x0c,0x10,0x00,0x2e, 640, 480,0x355c}, /* 0f */
	{0x487f,0x04,0x00,0x00,0x2f, 640, 400,0x3532}, /* 10 */
	{0xc00f,0x31,0x01,0x06,0x31, 720, 480,0x3630}, /* 11 */
	{0x000f,0x32,0x03,0x06,0x32, 720, 576,0x3637}, /* 12 */
	{0x0187,0x15,0x05,0x00,0x37,1024, 768,0x358d}, /* 13 */
        {0xc877,0x16,0x09,0x06,0x37,1024, 768,0x3592}, /* 14 */
	{0xc067,0x97,0x0b,0x49,0x37,1024, 768,0x3597}, /* 15 */
	{0x0267,0x18,0x0d,0x00,0x37,1024, 768,0x359c}, /* 16 */
	{0x0047,0x59,0x11,0x8c,0x37,1024, 768,0x35a1}, /* 17 */
	{0x0047,0x1a,0x52,0x00,0x37,1024, 768,0x35a6}, /* 18 */
	{0x0047,0x5b,0x16,0x00,0x37,1024, 768,0x35ab}, /* 19 */
	{0x0387,0x5c,0x4d,0x00,0x3a,1280,1024,0x35be}, /* 1a */
	{0x0077,0x1d,0x14,0x07,0x3a,1280,1024,0x35c3}, /* 1b */
	{0x0047,0x1e,0x17,0x00,0x3a,1280,1024,0x35c8}, /* 1c */
	{0x0007,0x1f,0x98,0x00,0x3a,1280,1024,0x35cd}, /* 1d */
	{0x0007,0x60,0x59,0x00,0x3c,1600,1200,0x35d4}, /* 1e */
	{0x0007,0x21,0x5a,0x00,0x3c,1600,1200,0x35d9}, /* 1f */
	{0x0007,0x22,0x1b,0x00,0x3c,1600,1200,0x35de}, /* 20 */
	{0x0007,0x63,0x1d,0x00,0x3c,1600,1200,0x35e3}, /* 21 */
	{0x0007,0x24,0x1e,0x00,0x3c,1600,1200,0x35e8}, /* 22 */
	{0x407f,0x00,0x00,0x00,0x40, 320, 200,0x3516}, /* 23 */
	{0xc07f,0x01,0x00,0x04,0x50, 320, 240,0x351d}, /* 24 */
	{0x0077,0x02,0x04,0x05,0x51, 400, 300,0x3524}, /* 25 */
	{0xc877,0x03,0x09,0x06,0x52, 512, 384,0x352b}, /* 26 */  /* was c077 */
	{0x8207,0x25,0x1f,0x00,0x68,1920,1440,0x35ef}, /* 27 */
	{0x0007,0x26,0x20,0x00,0x6c, 720, 480,0x35f6}, /* 28 */
	{0x0027,0x27,0x14,0x08,0x6e,1280, 960,0x35b2}, /* 29 */
	{0x0027,0x27,0x14,0x08,0x6e,1280, 960,0x35b7}, /* 2a */
	{0xc077,0x33,0x09,0x06,0x20,1024, 600,0x0000}, /* 2b */
	{0xc077,0x34,0x09,0x06,0x23,1152, 768,0x0000}, /* 2c */
	{0xffff,0,0,0,0,0,0,0}
};

/*add for 300 oem util*/
typedef struct _SiS_VBModeIDTableStruct
{
	UCHAR  ModeID;
	UCHAR  VB_TVDelayIndex;
	UCHAR  VB_TVFlickerIndex;
	UCHAR  VB_TVPhaseIndex;
	UCHAR  VB_TVYFilterIndex;
	UCHAR  VB_LCDDelayIndex;
	UCHAR  _VB_LCDHIndex;
	UCHAR  _VB_LCDVIndex;
}SiS_VBModeIDTableStruct;

static const SiS_VBModeIDTableStruct  SiS300_VBModeIDTable[]=
{
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, /* TW: Identical to 630/301B 2.04.50 BIOS */
	{0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x01},
	{0x01,0x00,0x00,0x00,0x01,0x00,0x01,0x02},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x00},
	{0x03,0x00,0x00,0x00,0x02,0x00,0x02,0x01},
	{0x03,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x05,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x06,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x01},
	{0x07,0x00,0x00,0x00,0x03,0x00,0x03,0x02},
	{0x0d,0x00,0x00,0x01,0x04,0x00,0x00,0x00},
	{0x0e,0x00,0x00,0x01,0x05,0x00,0x02,0x00},
	{0x0f,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x10,0x00,0x00,0x01,0x05,0x00,0x02,0x01},
	{0x11,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x12,0x00,0x00,0x01,0x05,0x00,0x02,0x03},
	{0x13,0x00,0x00,0x01,0x04,0x00,0x04,0x00},
	{0x6a,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x2e,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x2f,0x00,0x00,0x01,0x05,0x00,0x06,0x06},
	{0x30,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x31,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x32,0x00,0x00,0x01,0x06,0x00,0x00,0x00},
	{0x37,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x38,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x3a,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x40,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x41,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x43,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x44,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x46,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x47,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x49,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4a,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x4c,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x4d,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x50,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x51,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x52,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x56,0x00,0x00,0x01,0x04,0x00,0x05,0x07},
	{0x57,0x00,0x00,0x01,0x07,0x00,0x07,0x09},
	{0x58,0x00,0x00,0x01,0x00,0x00,0x09,0x0b},
	{0x59,0x00,0x00,0x01,0x04,0x00,0x05,0x05},
	{0x5d,0x00,0x00,0x01,0x07,0x00,0x06,0x06},
	{0x62,0x00,0x00,0x01,0x05,0x00,0x06,0x08},
	{0x63,0x00,0x00,0x01,0x07,0x00,0x08,0x0a},
	{0x64,0x00,0x00,0x01,0x00,0x00,0x0a,0x0c},
	{0x65,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6e,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x6f,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0x7b,0x00,0x00,0x01,0x00,0x00,0x0b,0x0d},
	{0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00}  /* TW: added! */
};
/*end*/

typedef struct _SiS300_CRT1TableStruct
{
	UCHAR CR[17];
} SiS300_CRT1TableStruct;

static const SiS300_CRT1TableStruct  SiS300_CRT1Table[]=
{
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0xbf,0x1f,    /* 0x00 */
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x00,
  0x00}},
 {{0x2d,0x27,0x28,0x90,0x2c,0x80,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x00,
  0x00}},
 {{0x3d,0x31,0x31,0x81,0x37,0x1f,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x05,
  0x01}},
 {{0x4f,0x3f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x01,
  0x01}},
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0xbf,0x1f,
  0x9c,0x8e,0x8f,0x96,0xb9,0x30,0x00,0x05,
  0x00}},
 {{0x5f,0x4f,0x50,0x82,0x55,0x81,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
 {{0x63,0x4f,0x50,0x86,0x56,0x9b,0x06,0x3e,
  0xe8,0x8b,0xdf,0xe7,0xff,0x10,0x00,0x01,
  0x00}},
 {{0x64,0x4f,0x4f,0x88,0x55,0x9d,0xf2,0x1f,
  0xe0,0x83,0xdf,0xdf,0xf3,0x10,0x00,0x01,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x5a,0x81,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x05,
  0x00}},
 {{0x66,0x4f,0x4f,0x86,0x56,0x9e,0x03,0x3e,
  0xe4,0x87,0xdf,0xdf,0x04,0x00,0x00,0x01,
  0x00}},
 {{0x6c,0x4f,0x4f,0x83,0x59,0x9e,0x00,0x3e,    /* 0x0a */
  0xe5,0x8d,0xdf,0xdf,0x01,0x00,0x00,0x01,
  0x00}},
 {{0x63,0x4f,0x4f,0x87,0x56,0x9d,0xfb,0x1f,
  0xe0,0x83,0xdf,0xdf,0xfc,0x10,0x00,0x01,
  0x00}},
 {{0x65,0x4f,0x4f,0x89,0x57,0x9f,0xfb,0x1f,
  0xe6,0x8a,0xe5,0xe5,0xfc,0x00,0x00,0x01,
  0x00}},
 {{0x7b,0x63,0x63,0x9f,0x6a,0x93,0x6f,0xf0,
  0x58,0x8a,0x57,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xf0,
  0x58,0x8c,0x57,0x57,0x73,0x20,0x00,0x06,
  0x01}},
 {{0x7d,0x63,0x63,0x81,0x6e,0x1d,0x98,0xf0,
  0x7c,0x82,0x57,0x57,0x99,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xf0,
  0x58,0x8b,0x57,0x57,0x70,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6b,0x13,0x75,0xf0,
  0x58,0x8b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x8c,0x63,0x63,0x87,0x72,0x16,0x7e,0xf0,
  0x59,0x8d,0x57,0x57,0x7f,0x00,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x7e,0x63,0x63,0x82,0x6c,0x14,0x75,0xe0,   /* 0x14 */
  0x58,0x0b,0x57,0x57,0x76,0x20,0x00,0x06,
  0x01}},
 {{0x99,0x7f,0x7f,0x9d,0x84,0x1a,0x96,0x1f,
  0x7f,0x83,0x7f,0x7f,0x97,0x10,0x00,0x02,
  0x00}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0xa1,0x7f,0x7f,0x85,0x86,0x97,0x24,0xf5,
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf5,
  0x00,0x83,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x8b,0x89,0x95,0x26,0xf5,
  0x00,0x83,0xff,0xff,0x27,0x10,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x83,0x93,0x1e,0xf5,
  0x00,0x84,0xff,0xff,0x1f,0x10,0x00,0x02,
  0x01}},
 {{0xa2,0x7f,0x7f,0x86,0x84,0x94,0x37,0xf5,
  0x0b,0x82,0xff,0xff,0x38,0x10,0x00,0x02,
  0x01}},
 {{0xcf,0x9f,0x9f,0x93,0xb2,0x01,0x14,0xba,
  0x00,0x83,0xff,0xff,0x15,0x00,0x00,0x03,
  0x00}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0x5a,
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0x5a,  /* 0x1e */
  0x00,0x83,0xff,0xff,0x29,0x09,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0x5a,
  0x00,0x83,0xff,0xff,0x2f,0x09,0x00,0x07,
  0x01}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x09,0xc7,0xc7,0x8d,0xd3,0x0b,0xe0,0x10,  /* 36: 1600x1200x85Hz */
  0xb0,0x83,0xaf,0xaf,0xe1,0x2f,0x01,0x04,
  0x00}},
 {{0x3f,0xef,0xef,0x83,0xfd,0x1a,0xda,0x1f,  /* 37: 1920x1440x60Hz */
  0xa0,0x84,0x9f,0x9f,0xdb,0x1f,0x01,0x01,
  0x00}},
 {{0x55,0xff,0xff,0x99,0x0d,0x0c,0x3e,0xba,
  0x00,0x84,0xff,0xff,0x3f,0x0f,0x41,0x05,
  0x00}},
 {{0xdc,0x9f,0x9f,0x00,0xab,0x19,0xe6,0xef,
  0xc0,0xc3,0xbf,0xbf,0xe7,0x10,0x00,0x07,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x6c,0x1c,0x72,0xba,  /* 0x28 */
  0x27,0x8b,0xdf,0xdf,0x73,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x83,0x69,0x13,0x6f,0xba,
  0x26,0x89,0xdf,0xdf,0x6f,0x00,0x00,0x06,
  0x01}},
 {{0x7f,0x63,0x63,0x82,0x6b,0x13,0x75,0xba,
  0x29,0x8c,0xdf,0xdf,0x75,0x00,0x00,0x06,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf1,
  0xaf,0x85,0x3f,0x3f,0x25,0x30,0x00,0x02,
  0x01}},
 {{0x9f,0x7f,0x7f,0x83,0x85,0x91,0x1e,0xf1,
  0xad,0x81,0x3f,0x3f,0x1f,0x30,0x00,0x02,
  0x01}},
 {{0xa7,0x7f,0x7f,0x88,0x89,0x15,0x26,0xf1,
  0xb1,0x85,0x3f,0x3f,0x27,0x30,0x00,0x02,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa9,0x17,0x28,0xc4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xce,0x9f,0x9f,0x92,0xa5,0x17,0x28,0xd4,
  0x7a,0x8e,0xcf,0xcf,0x29,0x21,0x00,0x07,
  0x01}},
 {{0xd3,0x9f,0x9f,0x97,0xab,0x1f,0x2e,0xd4,
  0x7d,0x81,0xcf,0xcf,0x2f,0x21,0x00,0x07,
  0x01}},
 {{0x6b,0x59,0x59,0x8f,0x5e,0x8c,0x0b,0x3e,
  0xe9,0x8b,0xdf,0xe7,0x04,0x00,0x00,0x05,
  0x00}},
 {{0x7b,0x59,0x63,0x9f,0x6a,0x93,0x6f,0xf0,  /* 0x32 */
  0x58,0x8a,0x3f,0x57,0x70,0x20,0x00,0x05,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x1e,0xf1,  /* 0x33 - 1024x600 */
  0xae,0x85,0x57,0x57,0x1f,0x30,0x00,0x02,
  0x01}},
 {{0xa3,0x7f,0x7f,0x87,0x86,0x97,0x24,0xf5,  /* 0x34 - 1152x768 */
  0x02,0x88,0xff,0xff,0x25,0x10,0x00,0x02,
  0x01}}
};

typedef struct _SiS300_MCLKDataStruct
{
	UCHAR SR28,SR29,SR2A;
	USHORT CLOCK;
} SiS300_MCLKDataStruct;

static const SiS300_MCLKDataStruct  SiS300_MCLKData_630[] =	/* 630 */
{ /* TW: at 0x54 in BIOS */
	{ 0x5a,0x64,0x80, 66},
	{ 0xb3,0x45,0x80, 83},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x22,0x80,133},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100}
};

static const SiS300_MCLKDataStruct  SiS300_MCLKData_300[] =  /* 300 */
{ /* TW: at 0x54 in BIOS */
	{ 0x68,0x43,0x80,125},
	{ 0x68,0x43,0x80,125},
	{ 0x68,0x43,0x80,125},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100},
	{ 0x37,0x61,0x80,100}
};

typedef struct _SiS300_ECLKDataStruct
{
	UCHAR SR2E,SR2F,SR30;
	USHORT CLOCK;
} SiS300_ECLKDataStruct;

static const SiS300_ECLKDataStruct  SiS300_ECLKData[]=
{
	{ 0x54,0x43,0x80,100},
	{ 0x53,0x43,0x80,100},
	{ 0x55,0x43,0x80,100},
	{ 0x52,0x43,0x80,100},
	{ 0x3f,0x42,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100},
	{ 0x54,0x43,0x80,100}
};

typedef struct _SiS300_VCLKDataStruct
{
	UCHAR SR2B,SR2C;
	USHORT CLOCK;
} SiS300_VCLKDataStruct;

static const SiS300_VCLKDataStruct  SiS300_VCLKData[]=
{
	{ 0x1b,0xe1, 25},
	{ 0x4e,0xe4, 28},
	{ 0x57,0xe4, 32},
	{ 0xc3,0xc8, 36},
	{ 0x42,0xc3, 40},
	{ 0x5d,0xc4, 45},
	{ 0x52,0x65, 50},
	{ 0x53,0x65, 50},
	{ 0x6d,0x66, 56},
	{ 0x5a,0x64, 65},
	{ 0x46,0x44, 68},
	{ 0x3e,0x43, 75},
	{ 0x6d,0x46, 76}, /* 0x0c: 800x600 | LVDS_2(CH), MITAC(CH);  - LVDS2(CH), A901(301B): 0xb1,0x46, 76 */
	{ 0x41,0x43, 79},
	{ 0x31,0x42, 79},
	{ 0x46,0x25, 85},
	{ 0x78,0x29, 87}, /* 0x10 */
	{ 0x62,0x44, 95},
	{ 0x2b,0x22,105},
	{ 0x49,0x24,106},
	{ 0xc3,0x28,108},
	{ 0x3c,0x23,109},
	{ 0xf7,0x2c,132},
	{ 0xd4,0x28,136},
	{ 0x41,0x05,158},
	{ 0x43,0x05,162},
	{ 0xe1,0x0f,175},
	{ 0xfc,0x12,189},
	{ 0xde,0x26,194},
	{ 0x54,0x05,203},
	{ 0x3f,0x03,230},
	{ 0x30,0x02,234},
	{ 0x24,0x01,266},  /* 0x20 */
	{ 0x52,0x2a, 54},  /* 301 TV */
	{ 0x52,0x6a, 27},  /* 301 TV */
	{ 0x62,0x24, 70},  /* 301 TV */
	{ 0x62,0x64, 70},  /* 301 TV */
	{ 0xa8,0x4c, 30},  /* 301 TV */
	{ 0x20,0x26, 33},  /* 301 TV */
	{ 0x31,0xc2, 39},
	{ 0xbf,0xc8, 35},  /* 0x28 */
	{ 0x60,0x36, 30},  /* 0x29  CH/UNTSC TEXT | LVDS_2(CH) - LVDS2(CH), A901(301B), Mitac(CH): 0xe0, 0xb6, 30 */
	{ 0x40,0x4a, 28},
	{ 0x9f,0x46, 44},
	{ 0x97,0x2c, 26},
	{ 0x44,0xe4, 25},
	{ 0x7e,0x32, 47},
	{ 0x8a,0x24, 31},  /* 0x2f  CH/PAL TEXT | LVDS_2(CH), Mitac(CH) -  LVDS2(CH), A901(301B): 0x57, 0xe4, 31 */
	{ 0x97,0x2c, 26},
	{ 0xce,0x3c, 39},
	{ 0x52,0x4a, 36},
	{ 0x34,0x61, 95},
	{ 0x78,0x27,108},
	{ 0xce,0x25,189},
	{ 0x45,0x6b, 21},  /* 0x36 */  /* TW: Added from Mitac */
	{ 0xff,0x00,  0}
};

static const UCHAR  SiS300_ScreenOffset[] =
{
	0x14,0x19,0x20,0x28,0x32,0x40,0x50,
        0x64,0x78,0x80,0x2d,0x35,0x48,0xff
};

typedef struct _SiS300_StResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
} SiS300_StResInfoStruct;

static const SiS300_StResInfoStruct  SiS300_StResInfo[] =
{
	{ 640,400},
	{ 640,350},
	{ 720,400},
	{ 720,350},
	{ 640,480}
};

typedef struct _SiS300_ModeResInfoStruct
{
	USHORT HTotal;
	USHORT VTotal;
	UCHAR  XChar;
	UCHAR  YChar;
} SiS300_ModeResInfoStruct;

static const SiS300_ModeResInfoStruct  SiS300_ModeResInfo[] =
{
	{  320, 200, 8, 8},  /* 0x00 */
	{  320, 240, 8, 8},  /* 0x01 */
	{  320, 400, 8, 8},  /* 0x02 */
	{  400, 300, 8, 8},  /* 0x03 */
	{  512, 384, 8, 8},  /* 0x04 */
	{  640, 400, 8,16},  /* 0x05 */
	{  640, 480, 8,16},  /* 0x06 */
	{  800, 600, 8,16},  /* 0x07 */
	{ 1024, 768, 8,16},  /* 0x08 */
	{ 1280,1024, 8,16},  /* 0x09 */
	{ 1600,1200, 8,16},  /* 0x0a */
	{ 1920,1440, 8,16},  /* 0x0b */
	{  720, 480, 8,16},  /* 0x0c */
	{  720, 576, 8,16},  /* 0x0d */
	{ 1280, 960, 8,16},  /* 0x0e */
	{ 1024, 600, 8,16},  /* 0x0f */
	{ 1152, 768, 8,16}   /* 0x10 */
};

static const UCHAR SiS300_OutputSelect = 0x40;

static const UCHAR SiS300_SoftSetting = 30;

#ifndef LINUX_XF86
static UCHAR SiS300_SR07 = 0x10;
#endif

static const UCHAR  SiS300_SR15[8][4] =
{
	{0x01,0x09,0xa3,0x00},
	{0x43,0x43,0x43,0x00},
	{0x1e,0x1e,0x1e,0x00},
	{0x2a,0x2a,0x2a,0x00},
	{0x06,0x06,0x06,0x00},
	{0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00}
};

#ifndef LINUX_XF86
static UCHAR SiS300_SR1F = 0x00;
static UCHAR SiS300_SR21 = 0x16;
static UCHAR SiS300_SR22 = 0xb2;
static UCHAR SiS300_SR23 = 0xf6;
static UCHAR SiS300_SR24 = 0x0d;
static UCHAR SiS300_SR25[] = {0x0,0x0};
static UCHAR SiS300_SR31 = 0x00;
static UCHAR SiS300_SR32 = 0x11;
static UCHAR SiS300_SR33 = 0x00;
static UCHAR SiS300_CRT2Data_1_2 = 0x40;
static UCHAR SiS300_CRT2Data_4_D = 0x00;
static UCHAR SiS300_CRT2Data_4_E = 0x00;
static UCHAR SiS300_CRT2Data_4_10 = 0x80;

static const USHORT SiS300_RGBSenseData = 0xd1;
static const USHORT SiS300_VideoSenseData = 0xb3;
static const USHORT SiS300_YCSenseData = 0xb9;
static const USHORT SiS300_RGBSenseData2 = 0x0190;     /*301b*/
static const USHORT SiS300_VideoSenseData2 = 0x0174;
static const USHORT SiS300_YCSenseData2 = 0x016b;

static const UCHAR SiS300_CR40[5][4];

static UCHAR SiS300_CR49[2];
#endif

static const UCHAR SiS300_NTSCPhase[]  = {0x21,0xed,0xba,0x08};  /* TW: Was {0x21,0xed,0x8a,0x08}; */
static const UCHAR SiS300_PALPhase[]   = {0x2a,0x05,0xe3,0x00};  /* TW: Was {0x2a,0x05,0xd3,0x00};  */
static const UCHAR SiS300_PALMPhase[]  = {0x21,0xE4,0x2E,0x9B};  /* palmn */
static const UCHAR SiS300_PALNPhase[]  = {0x21,0xF4,0x3E,0xBA};
static const UCHAR SiS300_NTSCPhase2[] = {0x21,0xF0,0x7B,0xD6};  /* 301b */
static const UCHAR SiS300_PALPhase2[]  = {0x2a,0x09,0x86,0xe9};  /* 301b */
static const UCHAR SiS300_PALMPhase2[] = {0x21,0xE6,0xEF,0xA4}; /* TW: palm 301b*/
static const UCHAR SiS300_PALNPhase2[] = {0x21,0xF6,0x94,0x46}; /* TW: paln 301b*/

typedef struct _SiS300_PanelDelayTblStruct
{
	UCHAR timer[2];
} SiS300_PanelDelayTblStruct;

static const SiS300_PanelDelayTblStruct  SiS300_PanelDelayTbl[] =
{
	{{0x05,0xaa}}, /* TW: From 2.04.5a */
	{{0x05,0x14}},
	{{0x05,0x36}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x90}},
	{{0x05,0x90}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x20,0x80}},
	{{0x05,0x14}},
	{{0x05,0x40}},
	{{0x05,0x60}}
};

static const SiS300_PanelDelayTblStruct  SiS300_PanelDelayTblLVDS[] =
{
	{{0x05,0xaa}},
	{{0x05,0x14}},
	{{0x05,0x36}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x90}},
	{{0x05,0x90}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},
	{{0x05,0x14}},  /* 2.07a (JVC): 14,96 */
	{{0x05,0x28}},  /* 2.04.5c: 20, 80 - Clevo (2.04.2c): 05, 28 */
	{{0x05,0x14}},
	{{0x05,0x14}},  /* Some BIOSes: 05, 40 */
	{{0x05,0x60}}
};

typedef struct _SiS300_LCDDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LCDDataStruct;

static const SiS300_LCDDataStruct  SiS300_StLCD1024x768Data[]=
{
	{   66,  31, 992, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{  176,  75, 900, 510,1320, 816},
	{   66,  31, 992, 510,1320, 816},
	{   27,  16,1024, 650,1350, 832},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1024x768Data[]=
{
	{   12,   5, 896, 512,1344, 806},
	{   12,   5, 896, 510,1344, 806},
	{   32,  15,1008, 505,1344, 806},
	{   32,  15,1008, 514,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806},
	{   12,   5, 896, 500,1344, 806},
	{   42,  25,1024, 625,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_St2LCD1024x768Data[]=
{
	{   62,  25, 800, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{   32,  15, 930, 546,1344, 806},
	{  104,  45, 945, 496,1344, 806},
	{   62,  25, 800, 546,1344, 806},
	{   31,  18,1008, 624,1344, 806},
	{    1,   1,1344, 806,1344, 806}
};

static const SiS300_LCDDataStruct  SiS300_StLCD1280x1024Data[]=
{
	{    4,   1, 880, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{    4,   1, 880, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1280x1024Data[]=
{
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 501,1688,1066},
	{  211,  60,1024, 508,1688,1066},
	{  211,  60,1024, 500,1688,1066},
	{  211,  75,1024, 625,1688,1066},
	{  211, 120,1280, 798,1688,1066},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_St2LCD1280x1024Data[]=
{
	{   22,   5, 800, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{  176,  45, 900, 510,1650,1088},
	{   22,   5, 800, 510,1650,1088},
	{   13,   5,1024, 675,1560,1152},
	{   16,   9,1266, 804,1688,1072},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1024x768[]=
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1280x1024[]=  /* TW: Fake */
{
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 800, 449, 800, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 900, 449, 900, 449},
	{    1,   1, 800, 525, 800, 525},
	{    1,   1,1056, 628,1056, 628},
	{    1,   1,1344, 806,1344, 806},
	{    1,   1,1688,1066,1688,1066}
};

static const SiS300_LCDDataStruct  SiS300_LCD1280x960Data[]=
{
	{    9,   2, 800, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    4,   1, 900, 500,1800,1000},
	{    9,   2, 800, 500,1800,1000},
	{   30,  11,1056, 625,1800,1000},
	{    5,   3,1350, 800,1800,1000},
	{    1,   1,1576,1050,1576,1050},
	{    1,   1,1800,1000,1800,1000}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1400x1050Data[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

static const SiS300_LCDDataStruct  SiS300_ExtLCD1600x1200Data[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

static const SiS300_LCDDataStruct  SiS300_StLCD1400x1050Data[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

static const SiS300_LCDDataStruct  SiS300_StLCD1600x1200Data[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1400x1050[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

static const SiS300_LCDDataStruct  SiS300_NoScaleData1600x1200[] =  /* TW: New */
{
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0},
	{    0,   0,   0,   0,   0,   0}
};

typedef struct _SiS300_TVDataStruct
{
	USHORT RVBHCMAX;
	USHORT RVBHCFACT;
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT TVHDE;
	USHORT TVVDE;
	USHORT RVBHRS;
	UCHAR FlickerMode;
	USHORT HALFRVBHRS;
	UCHAR RY1COE;
	UCHAR RY2COE;
	UCHAR RY3COE;
	UCHAR RY4COE;
} SiS300_TVDataStruct;

static const SiS300_TVDataStruct  SiS300_StPALData[]=
{
	{    1,   1, 864, 525,1270, 400, 100,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 350, 100,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
	{    1,   1, 864, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
	{    1,   1, 864, 525,1270, 480,  50,   0, 760,0xf4,0xff,0x1c,0x22},
	{    1,   1, 864, 525,1270, 600,  50,   0,   0,0xf4,0xff,0x1c,0x22}
};

static const SiS300_TVDataStruct  SiS300_ExtPALData[]=
{
	{   27,  10, 848, 448,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
	{  108,  35, 848, 398,1270, 530,  50,   0,  50,0xf4,0xff,0x1c,0x22},
	{   12,   5, 954, 448,1270, 530,  50,   0,  50,0xf1,0x04,0x1f,0x18},
	{    9,   4, 960, 463,1644, 438,  50,   0,  50,0xf4,0x0b,0x1c,0x0a},
	{    9,   4, 848, 528,1270, 530,   0,   0,  50,0xf5,0xfb,0x1b,0x2a},
	{   36,  25,1060, 648,1316, 530, 438,   0, 438,0xeb,0x05,0x25,0x16},
	{    3,   2,1080, 619,1270, 540, 438,   0, 438,0xf3,0x00,0x1d,0x20},
	{    1,   1,1170, 821,1270, 520, 686,   0, 686,0xF3,0x00,0x1D,0x20}

};

static const SiS300_TVDataStruct  SiS300_StNTSCData[]=
{
	{    1,   1, 858, 525,1270, 400,  50,   0, 760,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 350,  50,   0, 640,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 400,   0,   0, 720,0xf1,0x04,0x1f,0x18},
	{    1,   1, 858, 525,1270, 350,   0,   0, 720,0xf4,0x0b,0x1c,0x0a},
	{    1,   1, 858, 525,1270, 480,   0,   0, 760,0xf1,0x04,0x1f,0x18}
};

static const SiS300_TVDataStruct  SiS300_ExtNTSCData[]=
{
	{  143,  65, 858, 443,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
	{   88,  35, 858, 393,1270, 440, 171,   0, 171,0xf1,0x04,0x1f,0x18},
	{  143,  70, 924, 443,1270, 440,  92,   0,  92,0xf1,0x04,0x1f,0x18},
	{  143,  70, 924, 393,1270, 440,  92,   0,  92,0xf4,0x0b,0x1c,0x0a},
	{  143,  76, 836, 523,1270, 440, 224,   0,   0,0xf1,0x05,0x1f,0x16},
	{  143, 120,1056, 643,1270, 440,   0, 128,   0,0xf4,0x10,0x1c,0x00},
	{  143,  76, 836, 523,1270, 440,   0, 128,   0,0xee,0x0c,0x22,0x08},
	{   65,  64,1056, 791,1270, 480, 638,   0,   0,0xf1,0x04,0x1f,0x18}
};

static const SiS_TVDataStruct  SiS300_St1HiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS300_St2HiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

static const SiS_TVDataStruct  SiS300_ExtHiTVData[]=
{
 	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
};

static const UCHAR SiS300_NTSCTiming[] = {
	0x17,0x1d,0x03,0x09,0x05,0x06,0x0c,0x0c,
	0x94,0x49,0x01,0x0a,0x06,0x0d,0x04,0x0a,
	0x06,0x14,0x0d,0x04,0x0a,0x00,0x85,0x1b,
/*	0x0c,0x50,0x00,0x97,0x00,0xda,0x4a,0x17,   - old */
	0x0c,0x50,0x00,0x99,0x00,0xec,0x4a,0x17,  /* new (2.04.5a) */
/*	0x7d,0x05,0x4b,0x00,0x00,0xe2,0x00,0x02,   - old */
	0x88,0x00,0x4b,0x00,0x00,0xe2,0x00,0x02,  /* new */
	0x03,0x0a,0x65,0x9d,0x08,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x50,
	0x00,0x40,0x44,0x00,0xdb,0x02,0x3b,0x00
};

static const UCHAR SiS300_PALTiming[] = {
	0x19,0x52,0x35,0x6e,0x04,0x38,0x3d,0x70,
	0x94,0x49,0x01,0x12,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0x45,0x2b,
/*      0x70,0x50,0x00,0x9b,0x00,0xd9,0x5d,0x17,   - old */
	0x70,0x50,0x00,0x97,0x00,0xd7,0x5d,0x17,  /* new */
/*	0x7d,0x05,0x45,0x00,0x00,0xe8,0x00,0x02,   -old */
	0x88,0x00,0x45,0x00,0x00,0xe8,0x00,0x02,  /* new */
	0x0d,0x00,0x68,0xb0,0x0b,0x92,0x8f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x63,
	0x00,0x40,0x3e,0x00,0xe1,0x02,0x28,0x00
};

#ifdef oldHV
static const UCHAR SiS300_HiTVExtTiming[] = {   /* TW: New */
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS300_HiTVSt1Timing[] = {   /* TW: New */
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0x7b,0xa8,0x03,0xf0,0x87,0x03,
	0x11,0x15,0x11,0xcf,0x10,0x11,0xcf,0x10,
	0x35,0x35,0x3b,0x69,0x1d,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x86,
	0xaf,0x5d,0x0e,0x00,0xfc,0xff,0x2d,0x00
};

static const UCHAR SiS300_HiTVSt2Timing[] = {   /* TW: New */
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x64,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x64,0x90,0x33,0x8c,0x18,0x36,0x3e,0x13,
	0x2a,0xde,0x2a,0x44,0x40,0x2a,0x44,0x40,
	0x8e,0x8e,0x82,0x07,0x0b,0x92,0x0f,0x40,
	0x60,0x80,0x14,0x90,0x8c,0x60,0x14,0x3d,
	0x63,0x4f,0x27,0x00,0xfc,0xff,0x6a,0x00
};

static const UCHAR SiS300_HiTVTextTiming[] = {   /* TW: New */
        0x32,0x65,0x2c,0x5f,0x08,0x31,0x3a,0x65,
	0x28,0x02,0x01,0x3d,0x06,0x3e,0x35,0x6d,
	0x06,0x14,0x3e,0x35,0x6d,0x00,0xc5,0x3f,
	0x65,0x90,0xe7,0xbc,0x03,0x0c,0x97,0x03,
	0x14,0x78,0x14,0x08,0x20,0x14,0x08,0x20,
	0xc8,0xc8,0x3b,0xd2,0x26,0x92,0x0f,0x40,
        0x60,0x80,0x14,0x90,0x8c,0x60,0x04,0x96,
	0x72,0x5c,0x11,0x00,0xfc,0xff,0x32,0x00
};

static const UCHAR SiS300_HiTVGroup3Data[] = {   /* TW: New */
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x5f,
	0x05,0x21,0xb2,0xb2,0x55,0x77,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x2e,0x58,0x48,0x72,0x44,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x4f,0x7f,0x03,0xa8,0x7d,0x20,0x1a,0xa9,
	0x14,0x05,0x03,0x7e,0x64,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS300_HiTVGroup3Simu[] = {   /* TW: New */
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0x95,
	0xdb,0x20,0xb8,0xb8,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x15,0x26,0xd3,0xe4,0x11,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x67,0x36,0x01,0x47,0x0e,0x10,0xbe,0xb4,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};

static const UCHAR SiS300_HiTVGroup3Text[] = {   /* TW: New */
        0x00,0x1a,0x22,0x63,0x62,0x22,0x08,0xa7,
	0xf5,0x20,0xce,0xce,0x55,0x47,0x2a,0xa6,
	0x25,0x2f,0x47,0xfa,0xc8,0xff,0x8e,0x20,
	0x8c,0x6e,0x60,0x18,0x2c,0x0c,0x20,0x22,
	0x56,0x36,0x4f,0x6e,0x3f,0x80,0x00,0x80,
	0x93,0x3c,0x01,0x50,0x2f,0x10,0xf4,0xca,
	0x01,0x05,0x03,0x7e,0x65,0x31,0x14,0x75,
	0x18,0x05,0x18,0x05,0x4c,0xa8,0x01
};
#endif

typedef struct _SiS300_LVDSDataStruct
{
	USHORT VGAHT;
	USHORT VGAVT;
	USHORT LCDHT;
	USHORT LCDVT;
} SiS300_LVDSDataStruct;

static const SiS300_LVDSDataStruct  SiS300_LVDS320x480Data_1[]=
{
	{848, 433,400, 525},
	{848, 389,400, 525},
	{848, 433,400, 525},
	{848, 389,400, 525},
	{848, 518,400, 525},
	{1056,628,400, 525},
	{400, 525,400, 525},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS800x600Data_1[]=
{
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 433,1060, 629},
	{848, 389,1060, 629},
	{848, 518,1060, 629},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS800x600Data_2[]=
{
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{800, 449,1000, 644},
	{800, 525,1000, 635}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1024x768Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1024x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1280x1024Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1280x1024Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1400x1050Data_1[]=   /* TW: New */
{
        {928, 416, 1688, 1066},
	{928, 366, 1688, 1066},
	{928, 416, 1688, 1066},
	{928, 366, 1688, 1066},
	{928, 496, 1688, 1066},
	{1088, 616, 1688, 1066},
	{1312, 784, 1688, 1066},
	{1568, 1040, 1688, 1066},
	{1688, 1066, 1688, 1066}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1400x1050Data_2[]=   /* TW: New */
{
        {1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
	{1688,1066, 1688,1066},
};

/* TW: New: */
static const SiS300_LVDSDataStruct  SiS300_LVDS1024x600Data_1[]=
{
	{840, 604,1344, 800},
	{840, 560,1344, 800},
	{840, 604,1344, 800},
	{840, 560,1344, 800},
	{840, 689,1344, 800},
	{1050, 800,1344, 800},
	{1344, 800,1344, 800},
	{800, 449,1280, 789},
	{800, 525,1280, 785}
};

/* TW: New: */
static const SiS300_LVDSDataStruct  SiS300_LVDS1024x600Data_2[]=
{
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{1344, 800,1344, 800},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

/* TW: New: */
static const SiS300_LVDSDataStruct  SiS300_LVDS1152x768Data_1[]=
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

/* TW: New: */
static const SiS300_LVDSDataStruct  SiS300_LVDS1152x768Data_2[]=
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

/* TW: New in 650/LVDS BIOS - resolution unknown */
static const SiS300_LVDSDataStruct  SiS300_LVDSXXXxXXXData_1[]=   /* TW: New */
{
        { 800, 449, 800, 449},
	{ 800, 449, 800, 449},
	{ 900, 449, 900, 449},
	{ 900, 449, 900, 449},
	{ 800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1344, 806,1344, 806},
	{1688, 806,1688, 806}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS640x480Data_1[]=
{
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 449, 800, 449},
	{800, 525, 800, 525},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628},
	{1056, 628,1056, 628}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1280x960Data_1[]=   /* TW: New */
{
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 438,1344, 806},
	{840, 409,1344, 806},
	{840, 518,1344, 806},
	{1050, 638,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LVDS1280x960Data_2[]=   /* TW: New */
{
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LCDA1400x1050Data_1[]=   /* TW: New */
{	/* TW: Might be temporary (invalid) data */
        {928, 416, 1688, 1066},
	{928, 366, 1688, 1066},
	{1008, 416, 1688, 1066},
	{1008, 366, 1688, 1066},
	{1200, 530, 1688, 1066},
	{1088, 616, 1688, 1066},
	{1312, 784, 1688, 1066},
	{1568, 1040, 1688, 1066},
	{1688, 1066, 1688, 1066}
};

static const SiS300_LVDSDataStruct  SiS300_LCDA1400x1050Data_2[]=   /* TW: New */
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LCDA1600x1200Data_1[]=   /* TW: New */
{	/* TW: Temporary data. Not valid */
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{1344, 806,1344, 806},
	{800, 449,1280, 801},
	{800, 525,1280, 813}
};

static const SiS300_LVDSDataStruct  SiS300_LCDA1600x1200Data_2[]=   /* TW: New */
{	/* TW: Temporary data. Not valid */
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0}
};

/* TW: New: */
static const SiS300_LVDSDataStruct  SiS300_CHTVUNTSCData[]=
{
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{840, 600, 840, 600},
	{784, 600, 784, 600},
	{1064, 750,1064, 750}
};

static const SiS300_LVDSDataStruct  SiS300_CHTVONTSCData[]=
{
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{840, 525, 840, 525},
	{784, 525, 784, 525},
	{1040, 700,1040, 700}
};

static const SiS300_LVDSDataStruct  SiS300_CHTVUPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 750, 840, 750},
	{936, 836, 936, 836}
};

static const SiS300_LVDSDataStruct  SiS300_CHTVOPALData[]=
{
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{1008, 625,1008, 625},
	{840, 625, 840, 625},
	{960, 750, 960, 750}
};
/* TW: new end */

typedef struct _SiS300_LVDSDesStruct
{
	USHORT LCDHDES;
	USHORT LCDVDES;
} SiS300_LVDSDesStruct;

static const SiS300_LVDSDesStruct  SiS300_PanelType00_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType01_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType02_1[]=
{
	{0, 626},
	{0, 624},
	{0, 626},
	{0, 624},
	{0, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType03_1[]=
{
	{ 8, 436},
	{ 8, 440},
	{ 8, 436},
	{ 8, 440},
	{ 8, 512},
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType05_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType06_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType07_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType08_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType09_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0a_1[]=
{
	{1059, 626},
	{1059, 624},
	{1059, 626},
	{1059, 624},
	{1059, 624},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0b_1[]=
{
	{1343, 0},
	{1343, 0},
	{1343, 0},
	{1343, 0},
	{1343, 0},   /* 640x480 - BIOS 1343, 0 */
	{1343, 0},
	{ 0, 799},
	{ 0, 0},
	{ 0, 0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0c_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0d_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0e_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},  /* 640x480 */
	{1343,   0},  /* 800x600 */
	{ 0, 805},    /* 1024x768 */
	{ 0, 794},    /* 1280x1024 */
	{ 0,   0}     /* 1280x960 - not applicable */
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0f_1[]=
{
	{1343, 798},
	{1343, 794},
	{1343, 798},
	{1343, 794},
	{1343,   0},
	{1343,   0},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType00_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType01_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{ 0, 805},
	{ 0, 794},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType02_2[]=
{
	{976, 527},
	{976, 502},
	{976, 527},
	{976, 502},
	{976, 567},
	{ 0, 627},
	{ 0, 627},
	{ 0,   0},
	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType03_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{1152, 622},
	{1152, 597}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType04_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType05_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType06_2[]=
{
	{1152, 622},
	{1152, 597},
	{1152, 622},
	{1152, 597},
	{1152, 662},
	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType07_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
	{   0, 805},
	{   0, 794},
	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType08_2[]=
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType09_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0a_2[]=
{
 	{976, 527},
 	{976, 502},
 	{976, 527},
 	{976, 502},
 	{976, 567},
 	{  0, 627},
 	{  0, 627},
 	{  0,   0},
 	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0b_2[]=
{
 	{ 1152, 700},
 	{ 1152, 675},
 	{ 1152, 700},
 	{ 1152, 675},
 	{ 1152, 740},
 	{ 1232, 799},
 	{    0, 799},
 	{    0,   0},
 	{    0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0c_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0d_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0e_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_PanelType0f_2[]=
{
 	{1152, 622},
 	{1152, 597},
 	{1152, 622},
 	{1152, 597},
 	{1152, 662},
 	{1232, 722},
 	{   0, 805},
 	{   0, 794},
 	{   0,   0}
};

static const SiS300_LVDSDesStruct SiS300_PanelType1076_1[]=   /* TW: New */
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS300_LVDSDesStruct SiS300_PanelType1076_2[]=   /* TW: New */
{
	{ 1152, 622 },
	{ 1152, 597 },
	{ 1152, 622 },
	{ 1152, 597 },
	{ 1152, 622 },
	{ 1232, 722 },
	{    0, 0   },
	{    0, 794 },
	{    0, 0   }
};

static const SiS300_LVDSDesStruct SiS300_PanelType1210_1[]=   /* TW: New */
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS300_LVDSDesStruct SiS300_PanelType1210_2[]=   /* TW: New */
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS300_LVDSDesStruct SiS300_PanelType1296_1[]=   /* TW: New */
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

static const SiS300_LVDSDesStruct SiS300_PanelType1296_2[]=   /* TW: New */
{
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0},
	{ 0 , 0}
};

/* TW: New */
static const SiS300_LVDSDesStruct  SiS300_CHTVUNTSCDesData[]=
{
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_CHTVONTSCDesData[]=
{
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0},
 	{ 0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_CHTVUPALDesData[]=
{
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{  0,   0},
 	{  0,   0}
};

static const SiS300_LVDSDesStruct  SiS300_CHTVOPALDesData[]=
{
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{256,   0},
 	{  0,   0},
 	{  0,   0}
};
/* TW: New end */

typedef struct _SiS300_LVDSCRT1DataStruct
{
UCHAR CR[15];
} SiS300_LVDSCRT1DataStruct;

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1[]=
{
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x05,
	  0x00 }},
	{{0x65,0x4f,0x89,0x56,0x83,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x05,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1[]=
{ 
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
	{{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01} }
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1[]=
{
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00 }},
	{{0x63,0x4f,0x87,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00 }},
	{{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_1_H[]=
{
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0xaf,0x1f,
	  0x90,0x85,0x8f,0xab,0x30,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x83,0x1f,
	  0x5e,0x83,0x5d,0x79,0x10,0x00,0x04,
	  0x00 }},
	{{0x30,0x27,0x94,0x2c,0x92,0x04,0x3e,
	  0xe0,0x85,0xdf,0xfb,0x10,0x00,0x04,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_1_H[]=
{
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00 }},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x97,0x1f,
	  0x60,0x87,0x5D,0x83,0x01,0x00,0x44,
	  0x00}},
	{{0x37,0x27,0x9B,0x2b,0x94,0x04,0x3e,
	  0xE2,0x89,0xDf,0x05,0x00,0x00,0x44,
	  0x00}},
	{{0x41,0x31,0x85,0x35,0x1d,0x7c,0xf0,
	  0x5A,0x8F,0x57,0x7D,0x20,0x00,0x55,
	  0x01}},
	{{0x4f,0x3F,0x93,0x45,0x0D,0x24,0xf5,
	  0x02,0x88,0xFf,0x25,0x10,0x00,0x01,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_1_H[]=
{
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0xb4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x82,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x04,
	  0x00 }},
	{{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x04,
	  0x00 }},
	{{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2[]=
{
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x06,
	  0x00 }},
	{{0x7f,0x4f,0x83,0x62,0x12,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x06,
	  0x00 }},
	{{0x7f,0x63,0x83,0x6c,0x1c,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2[]=
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2[]=
{
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00 }},
	{{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01 }},
	{{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT1800x600_2_H[]=
{
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0x3e,
	  0xf4,0x88,0x8f,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x3a,0x1a,0x72,0x3e,
	  0xdb,0x8f,0x5d,0x73,0x20,0x00,0x05,
	  0x00 }},
	{{0x3d,0x27,0x81,0x32,0x1a,0x72,0xba,
	  0x1c,0x80,0xdf,0x73,0x00,0x00,0x05,
	  0x00 }},
	{{0x3d,0x31,0x81,0x37,0x1f,0x72,0xf0,
	  0x58,0x8c,0x57,0x73,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x768_2_H[]=
{
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11280x1024_2_H[]=
{
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x27,0x93,0x39,0x81,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00 }},
	{{0x4f,0x31,0x93,0x3e,0x86,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01 }},
	{{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x600_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x5a,0x3e,
	  0xe8,0x8f,0x8f,0x5b,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x2e,0x3e,
	  0xb9,0x80,0x5d,0x2f,0x00,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xaf,0xba,
	  0x3b,0x82,0xdf,0xb0,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x1e,0xf1,
	  0xae,0x85,0x57,0x1f,0x30,0x00,0x02,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x600_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
          0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x600_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
          0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11024x600_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11152x768_1[] =
{
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x01,
	  0x00}},
        {{0x64,0x4f,0x88,0x54,0x9f,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x01,
	  0x00}},
        {{0x7e,0x63,0x82,0x68,0x15,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x26,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11152x768_1_H[] =
{
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0xc4,0x1f,
	  0x92,0x89,0x8f,0xb5,0x30,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x97,0x1f,
	  0x60,0x87,0x5d,0x83,0x10,0x00,0x44,
	  0x00}},
        {{0x2f,0x27,0x93,0x2b,0x90,0x04,0x3e,
	  0xe2,0x89,0xdf,0x05,0x00,0x00,0x44,
	  0x00}},
        {{0x3c,0x31,0x80,0x35,0x1c,0x7c,0xf0,
	  0x5a,0x8f,0x57,0x7d,0x20,0x00,0x55,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11152x768_2[] =
{
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x4f,0x87,0x6e,0x9f,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x06,
	  0x00}},
        {{0xa3,0x63,0x87,0x78,0x89,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x02,
	  0x01}},
        {{0xa3,0x7f,0x87,0x86,0x97,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x02,
	  0x01}}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_LVDSCRT11152x768_2_H[] =
{
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x4a,0x80,0x8f,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x31,0x87,0x5d,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x27,0x93,0x39,0x01,0x24,0xbb,
	  0x72,0x88,0xdf,0x25,0x30,0x00,0x01,
	  0x00}},
        {{0x4f,0x31,0x93,0x3e,0x06,0x24,0xf1,
	  0xae,0x84,0x57,0x25,0x30,0x00,0x01,
	  0x01}},
        {{0x4f,0x3f,0x93,0x45,0x0d,0x24,0xf5,
	  0x02,0x88,0xff,0x25,0x10,0x00,0x01,
	  0x01}}
};

/* TW: New */
static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UNTSC[]=
{
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xe8,0x84,0x8f,0x57,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x56,0x9f,0x56,0x3e,
	  0xd0,0x82,0x5d,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x53,0x9c,0x56,0xba,
	  0x18,0x84,0xdf,0x57,0x00,0x00,0x01,
	  0x00 }},
	{{0x80,0x63,0x84,0x6c,0x17,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1ONTSC[]=
{
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xc0,0x84,0x8f,0x0c,0x20,0x00,0x01,
	  0x00 }},
	{{0x64,0x4f,0x88,0x5a,0x9f,0x0b,0x3e,
	  0xb0,0x8d,0x5d,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x5d,0x4f,0x81,0x56,0x9c,0x0b,0x3e,
	  0xe8,0x84,0xdf,0x0c,0x00,0x00,0x01,
	  0x00 }},
	{{0x7d,0x63,0x81,0x6a,0x16,0xba,0xf0,
	  0x7f,0x86,0x57,0xbb,0x00,0x00,0x06,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1UPAL[]=
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf8,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0xec,0xba,
	  0x50,0x84,0xdf,0xed,0x00,0x00,0x05,
	  0x00 }},
	{{0x70,0x63,0x94,0x68,0x8d,0x42,0xf1,
	  0xc8,0x8c,0x57,0xe9,0x20,0x00,0x05,
	  0x01 }}
};

static const SiS300_LVDSCRT1DataStruct  SiS300_CHTVCRT1OPAL[]=
{
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xf0,0x83,0x8f,0x70,0x20,0x00,0x05,
	  0x00 }},
	{{0x79,0x4f,0x9d,0x5a,0x90,0x6f,0x3e,
	  0xde,0x81,0x5d,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x64,0x4f,0x88,0x55,0x80,0x6f,0xba,
	  0x20,0x83,0xdf,0x70,0x00,0x00,0x05,
	  0x00 }},
	{{0x73,0x63,0x97,0x69,0x8e,0xec,0xf0,
	  0x90,0x8c,0x57,0xed,0x20,0x00,0x05,
	  0x01 }}
};
/* TW: New end */

/* TW: New */
typedef struct _SiS300_CHTVRegDataStruct
{
	UCHAR Reg[16];
} SiS300_CHTVRegDataStruct;

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_UNTSC[] = {
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x4a,0x94,0x00,0x48,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x6a,0x6a,0x00,0x2d,0xfa,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 17: 640x480 NTSC 7/8  */
	{{0x8d,0xc4,0x00,0x3b,0xfb,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 24: 800x600 NTSC 7/10 */
};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_ONTSC[] = {
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x49,0x94,0x00,0x34,0xfe,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x69,0x6a,0x00,0x1e,0xfd,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 16: 640x480 NTSC 1/1 */
	{{0x8c,0xb4,0x00,0x32,0xf9,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 23: 800x600 NTSC 3/4 */
};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_UPAL[] = {
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x63,0x94,0x01,0x50,0x30,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 15: 640x480 PAL 5/6 */
	/* TW: For 800x600, 3/4 is VERY underscan */
	{{0x84,0x64,0x01,0x4e,0x2f,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 21: 800x600 PAL 3/4 */
	/* TW: Mode 20 is still underscan, use it instead? */
	/* {{0x83,0x76,0x01,0x40,0x31}} */ /* Mode 20: 800x600 PAL 5/6 */
};

static const SiS300_CHTVRegDataStruct SiS300_CHTVReg_OPAL[] = {
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 9: 640x400 PAL 1/1 */
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x01,0x50,0x34,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x41,0x12,0x00,0x50,0x00,0,0,0,0,0,0,0,0,0,0,0}},
	{{0x61,0x94,0x01,0x36,0x30,0,0,0,0,0,0,0,0,0,0,0}}, /* Mode 14: 640x480 PAL 1/1 */
	{{0x83,0x76,0x01,0x40,0x31,0,0,0,0,0,0,0,0,0,0,0}}  /* Mode 20: 800x600 PAL 5/6 */
	/* {{0x81,0x12,0x01,0x50,0x34}}  */ /* TW: (test) Mode 19: 800x600 PAL 1/1 */
};
/* TW: New end */

/* TW: New */
static const UCHAR SiS300_CHTVVCLKUNTSC[] = {0x29,0x29,0x29,0x29,0x2a,0x2e};

static const UCHAR SiS300_CHTVVCLKONTSC[] = {0x2c,0x2c,0x2c,0x2c,0x2d,0x2b};

static const UCHAR SiS300_CHTVVCLKUPAL[]  = {0x2f,0x2f,0x2f,0x2f,0x2f,0x31};

static const UCHAR SiS300_CHTVVCLKOPAL[]  = {0x2f,0x2f,0x2f,0x2f,0x30,0x32};
/* TW: New end */
