/*
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 *
 */

/*
 * Network services
 *
 * Copyright 2003, Broadcom Corporation
 * All Rights Reserved.                
 *                                     
 *
 * $Id: network.c,v 1.71.4.2 2003/07/03 01:18:56 noname Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <syslog.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if_arp.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <wlutils.h>
#include <rc.h>

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)

#define wlconfig(name)	eval("wlconfig", name)

void
start_lan(void)
{
	char *lan_ifname = nvram_safe_get("lan_ifname");
	char name[80], *next;
	int s;
	struct ifreq ifr;

	dprintf("%s\n", lan_ifname);

	if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
		return;

 	/* Bring up bridged interfaces */
	if (strncmp(lan_ifname, "br", 2) == 0) {
		eval("brctl", "addbr", lan_ifname);
		eval("brctl", "setfd", lan_ifname, "0");
		if (nvram_match("router_disable", "1") || nvram_match("lan_stp", "0"))
			eval("brctl", "stp", lan_ifname, "dis");
		foreach(name, nvram_safe_get("lan_ifnames"), next) {
			/* Bring up interface */
			ifconfig(name, IFUP, "0.0.0.0", NULL);
			/* Set the logical bridge address to that of the first interface */
			strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
			if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0 &&
			    memcmp(ifr.ifr_hwaddr.sa_data, "\0\0\0\0\0\0", ETHER_ADDR_LEN) == 0) {
				strncpy(ifr.ifr_name, name, IFNAMSIZ);
				if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
					strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
					ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER;
					ioctl(s, SIOCSIFHWADDR, &ifr);
				}
			}
			/* If not a wl i/f then simply add it to the bridge */
			if (wlconfig(name))
				eval("brctl", "addif", lan_ifname, name);
			else {
				/* get the instance number of the wl i/f */
				char wl_name[] = "wlXXXXXXXXXX_mode";
				int unit;
				wl_ioctl(name, WLC_GET_INSTANCE, &unit, sizeof(unit));
				snprintf(wl_name, sizeof(wl_name), "wl%d_mode", unit);
				/* Receive all multicast frames in WET mode */
				if (nvram_match(wl_name, "wet"))
					ifconfig(name, IFUP | IFF_ALLMULTI, "0.0.0.0", NULL);
				/* Do not attach the main wl i/f if in wds mode */
				if (nvram_invmatch(wl_name, "wds"))
					eval("brctl", "addif", lan_ifname, name);
			}
		}
	}

	/* Bring up and configure LAN interface */
	ifconfig(lan_ifname, IFUP,
		 nvram_safe_get("lan_ipaddr"), nvram_safe_get("lan_netmask"));

	/* Get current LAN hardware address */
	strncpy(ifr.ifr_name, lan_ifname, IFNAMSIZ);
	if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
		char eabuf[32];
		nvram_set("lan_hwaddr", ether_etoa(ifr.ifr_hwaddr.sa_data, eabuf));
	}

	close(s);

	/* Start remote syslogd if log_ipaddr is set */
	if (nvram_invmatch("log_ipaddr", ""))
		eval("syslogd", "-R", nvram_get("log_ipaddr"));

	dprintf("%s %s\n",
		nvram_safe_get("lan_ipaddr"),
		nvram_safe_get("lan_netmask"));

	/* Bring up local host interface */
	ifconfig("lo", IFUP, "127.0.0.1", NULL);
}

void
stop_lan(void)
{
	char *lan_ifname = nvram_safe_get("lan_ifname");
	char name[80], *next;

	dprintf("%s\n", lan_ifname);

	/* Stop the syslogd daemon */
	eval("killall", "syslogd");

	/* Bring down LAN interface */
	ifconfig(lan_ifname, 0, NULL, NULL);

	/* Bring down bridged interfaces */
	if (strncmp(lan_ifname, "br", 2) == 0) {
		foreach(name, nvram_safe_get("lan_ifnames"), next) {
			ifconfig(name, 0, NULL, NULL);
			eval("brctl", "delif", lan_ifname, name);
		}
		eval("brctl", "delbr", lan_ifname);
	}

	dprintf("done\n");
}

#define sin_addr(s) (((struct sockaddr_in *)(s))->sin_addr)

void
start_wan(void)
{
	char *wan_ifname = nvram_safe_get("wan_ifname");
	char *wan_proto = nvram_safe_get("wan_proto");
	int s;
	struct ifreq ifr;
	pid_t pid;

	dprintf("%s %s\n", wan_ifname, wan_proto);

	if (nvram_match("router_disable", "1") || strcmp(wan_proto, "disabled") == 0) {
		start_wan_done(wan_ifname);
		return;
	}

	if ((s = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
		return;
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);

	/* Set WAN hardware address before bringing interface up */
	memset(ifr.ifr_hwaddr.sa_data, 0, ETHER_ADDR_LEN);
	if (!nvram_invmatch("wan_hwaddr", "") ||
	    !ether_atoe(nvram_safe_get("wan_hwaddr"), ifr.ifr_hwaddr.sa_data))
		ether_atoe(nvram_safe_get("et1macaddr"), ifr.ifr_hwaddr.sa_data);
	if (memcmp(ifr.ifr_hwaddr.sa_data, "\0\0\0\0\0\0", ETHER_ADDR_LEN)) {
		ifr.ifr_hwaddr.sa_family = ARPHRD_ETHER;
		ioctl(s, SIOCSIFHWADDR, &ifr);
	}
	
	/* Bring up WAN interface */
	ifconfig(wan_ifname, IFUP, NULL, NULL);

	/* Configure WAN interface */
	if (strcmp(wan_proto, "pppoe") == 0) {
		char *pppoe_argv[] = { "pppoecd",
				       wan_ifname,
				       "-u", nvram_safe_get("pppoe_username"),
				       "-p", nvram_safe_get("pppoe_passwd"),
				       "-r", nvram_safe_get("pppoe_mru"),
				       "-t", nvram_safe_get("pppoe_mtu"),
				       "-i", nvram_match("pppoe_demand", "1") ? nvram_safe_get("pppoe_idletime") : "0",
				       "-d",
				       NULL, NULL,	/* pppoe_service */
				       NULL, NULL,	/* pppoe_ac */
				       NULL,		/* pppoe_keepalive */
				       NULL
		}, **arg;
		int timeout = 5;

		/* Add optional arguments */
		for (arg = pppoe_argv; *arg; arg++);
		if (nvram_invmatch("pppoe_service", "")) {
			*arg++ = "-s";
			*arg++ = nvram_safe_get("pppoe_service");
		}
		if (nvram_invmatch("pppoe_ac", "")) {
			*arg++ = "-a";
			*arg++ = nvram_safe_get("pppoe_ac");
		}
		if (nvram_match("pppoe_demand", "1") || nvram_match("pppoe_keepalive", "1"))
			*arg++ = "-k";

		mkdir("/tmp/ppp", 0777);
		symlink("/sbin/rc", "/tmp/ppp/ip-up");
		symlink("/sbin/rc", "/tmp/ppp/ip-down");

		_eval(pppoe_argv, NULL, 0, &pid);

		/* Pretend that the WAN interface is up */
		if (nvram_match("pppoe_demand", "1")) {
			/* Wait for ppp0 to be created */
			while (ifconfig("ppp0", IFUP, NULL, NULL) && timeout--)
				sleep(1);
			strncpy(ifr.ifr_name, "ppp0", IFNAMSIZ);

			/* Set temporary IP address */
			if (ioctl(s, SIOCGIFADDR, &ifr))
				perror("ppp0");
			nvram_set("wan_ipaddr", inet_ntoa(sin_addr(&ifr.ifr_addr)));
			nvram_set("wan_netmask", "255.255.255.255");

			/* Set temporary P-t-P address */
			if (ioctl(s, SIOCGIFDSTADDR, &ifr))
				perror("ppp0");
			nvram_set("wan_gateway", inet_ntoa(sin_addr(&ifr.ifr_dstaddr)));

			start_wan_done("ppp0");
		}

	} else if (strcmp(wan_proto, "dhcp") == 0) {
		char *wan_hostname = nvram_get("wan_hostname");
		char *dhcp_argv[] = { "udhcpc",
				      "-i", wan_ifname,
				      "-p", "/var/run/udhcpc.pid",
				      "-s", "/tmp/udhcpc",
				      wan_hostname && *wan_hostname ? "-H" : NULL,
				      wan_hostname && *wan_hostname ? wan_hostname : NULL,
				      NULL
		};

		symlink("/sbin/rc", "/tmp/udhcpc");

		_eval(dhcp_argv, NULL, 0, &pid);
		
	} else {
		ifconfig(wan_ifname, IFUP,
			 nvram_safe_get("wan_ipaddr"), nvram_safe_get("wan_netmask"));
		start_wan_done(wan_ifname);
	}

	/* Get current WAN hardware address */
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);
	if (ioctl(s, SIOCGIFHWADDR, &ifr) == 0) {
		char eabuf[32];
		nvram_set("wan_hwaddr", ether_etoa(ifr.ifr_hwaddr.sa_data, eabuf));
	}

	close(s);

	dprintf("%s %s\n",
		nvram_safe_get("wan_ipaddr"),
		nvram_safe_get("wan_netmask"));
}

void
start_wan_done(char *wan_ifname)
{
	dprintf("%s %s\n", wan_ifname, nvram_safe_get("wan_proto"));

	/* Delete all default routes */
	while (route_del(wan_ifname, 0, NULL, NULL, NULL) == 0);

	/* Set default route to gateway if specified */
	route_add(wan_ifname, 0, "0.0.0.0", nvram_safe_get("wan_gateway"), "0.0.0.0");

	/* Restart DHCP server */
	stop_dhcpd();
	start_dhcpd();

	/* Restart DNS proxy */
	stop_dns();
	start_dns();

	/* Start firewall */
	start_firewall();

	/* Set additional static routes */
	set_routes();

	/* Sync time */
	start_ntpc();

	/* Report stats */
	if (nvram_invmatch("stats_server", "")) {
		char *stats_argv[] = { "stats", nvram_get("stats_server"), NULL };
		_eval(stats_argv, NULL, 5, NULL);
	}

	dprintf("done\n");
}

void
stop_wan(void)
{
	char *wan_ifname = nvram_safe_get("wan_ifname");

	dprintf("%s %s\n", wan_ifname, nvram_safe_get("wan_proto"));

	/* Stop firewall */
	stop_firewall();

	/* Kill any WAN client daemons or callbacks */
	eval("killall", "ip-up");
	eval("killall", "ip-down");
	eval("killall", "pppoecd");
	eval("killall", "udhcpc");
	eval("killall", "stats");
	eval("killall", "ntpclient");

	/* Bring down WAN interfaces */
	ifconfig(wan_ifname, 0, NULL, NULL);

	dprintf("done\n");
}

int
set_routes(void)
{
	char word[80], *tmp;
	char *ipaddr, *netmask, *gateway, *metric, *ifname;

	foreach(word, nvram_safe_get("static_route"), tmp) {
		netmask = word;
		ipaddr = strsep(&netmask, ":");
		if (!ipaddr || !netmask)
			continue;
		gateway = netmask;
		netmask = strsep(&gateway, ":");
		if (!netmask || !gateway)
			continue;
		metric = gateway;
		gateway = strsep(&metric, ":");
		if (!gateway || !metric)
			continue;
		ifname = metric;
		metric = strsep(&ifname, ":");
		if (!metric || !ifname)
			continue;

		route_add(ifname, atoi(metric) + 1, ipaddr, gateway, netmask);
	}

	return 0;
}

int
hotplug_net(void)
{
	char *interface, *action;

	if (!(interface = getenv("INTERFACE")) ||
	    !(action = getenv("ACTION")))
		return EINVAL;

	/* Bridge WDS interfaces */
	if (!strncmp(interface, "wds", 3)) {
		if (!strcmp(action, "register")) {
			ifconfig(interface, IFUP, NULL, NULL);
			return eval("brctl", "addif", nvram_safe_get("lan_ifname"), interface);
		}
	}

	return 0;
}
