/*
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 *
 */

/*
 * Wireless network adapter utilities
 *
 * Copyright 2003, Broadcom Corporation
 * All Rights Reserved.                
 *                                     
 *
 * $Id: wlacs.c,v 1.4 2003/05/08 18:41:08 noname Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <typedefs.h>
#include <wlutils.h>

/*
* Info used to determine the running channel automatically
*/
typedef struct chan_info
{
	uint8 channel;	/* channel number */
	uint8 aAPs;	/* # of BSS in band A */
	uint8 bAPs;	/* # of BSS in band B */
	uint8 gAPs;	/* # of G BSS in band B */
	int8 noise;
	uint8 flags;
} chan_info_t;

/*
* Channels to be scanned when deciding the channel on which we are
* running should be at least N channels apart to avoid bleeding.
*/
#define WL_MIN_GAP(phy)	((phy) == PHY_TYPE_A ? 4 : 5)

/*
* Check if the channel belongs to band B
*/
#define WL_MAX_BG_CH	14
#define WL_BAND_B(ch)	((ch) <= WL_MAX_BG_CH ? 1 : 0)

/*
* For debugging only
*/
#ifdef BCMDBG
#define WLACSDBG(fmt, arg...)	printf("%s: "fmt, __FUNCTION__, ## arg)
#else
#define WLACSDBG(fmt, arg...)
#endif

#if defined(linux)
#include <unistd.h>
static void
sleep_ms(const unsigned int ms)
{
	usleep(1000*ms);
}
#elif defined(vxworks)
#include <vxWorks.h>
#include <taskLib.h>
IMPORT int sysClkRateGet(void);
static void
sleep_ms(const unsigned int ms)
{
	taskDelay(ms*sysClkRateGet()/1000);
}
#endif

/*
* The following condition(s) must be met when Auto Channel Selection 
* is enabled.
*  - the I/F is up (change radio channel requires it is up?)
*  - the AP must not be associated (setting SSID to empty should 
*    make sure it for us)
*/
uint8
wlacs_auto_channel(char *name)
{
	int chosen = 0;
	wl_uint32_list_t request;
	int phytype;
	/* query the phy type */
	wl_ioctl(name, WLC_GET_PHYTYPE, &phytype, sizeof(phytype));
	request.count = 0;	/* let the ioctl decide */
	if (!wl_ioctl(name, WLC_START_CHANNEL_SEL, &request, sizeof(request))) {
		sleep_ms(phytype == PHY_TYPE_A ? 1000 : 750);
		while (wl_ioctl(name, WLC_GET_CHANNEL_SEL, &chosen, sizeof(chosen)))
			sleep_ms(100);
	}
	WLACSDBG("interface %s: channel selected %d\n", name, chosen);
	return chosen;
}
