/*
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 *
 */

/*
 * Broadcom BCM43XX 802.11 Wireless device driver custom OID/ioctl definitions.
 *
 * THIS IS AN EXPORTED API - 
 * CHANGES SHOULD BE MADE TO RETAIN BINARY COMPATIBILITY WITH PREVIOUS VERSIONS.
 *
 * Copyright 2001 Broadcom Corporation
 * $Id: wlioctl.h,v 1.205.2.4 2003/06/19 00:01:06 noname Exp $
 */

#ifndef _wlioctl_h_
#define	_wlioctl_h_

#include <typedefs.h>
#include <proto/ethernet.h>
#include <proto/802.11.h>

#if defined(__GNUC__)
#define	PACKED	__attribute__((packed))
#else
#define	PACKED
#endif

/*
 * Per-bss information structure.
 */

#define WL_NUMRATES		255	/* max # of rates in a rateset */

typedef struct wl_rateset {
	uint32	count;			/* # rates in this set */
	uint8	rates[WL_NUMRATES];	/* rates in 500kbps units w/hi bit set if basic */
} wl_rateset_t;

#define	WL_LEGACY_BSS_INFO_VERSION	106	/* an older supported version of wl_bss_info struct */
#define	WL_BSS_INFO_VERSION		107	/* current version of wl_bss_info struct */

typedef struct wl_bss_info106 {
	uint		version;	/* version field */
	struct ether_addr BSSID;
	uint8		SSID_len;
	uint8		SSID[32];
	uint8		Privacy;	/* 0=No WEP, 1=Use WEP */
	int16		RSSI;		/* receive signal strength (in dBm) */
	uint16		beacon_period;	/* units are Kusec */
	uint16		atim_window;	/* units are Kusec */
	uint8		channel;	/* Channel no. */
	int8		infra;		/* 0=IBSS, 1=infrastructure, 2=unknown */
	struct {
		uint	count;		/* # rates in this set */
		uint8	rates[12];	/* rates in 500kbps units w/hi bit set if basic */
	} rateset;			/* supported rates */
        uint8           dtim_period;    /* DTIM period */
	int8		phy_noise;	/* noise right after tx (in dBm) */
	uint16		capability;	/* Capability information */
	struct dot11_bcn_prb *prb;	/* probe response frame (ioctl na) */
	uint16		prb_len;	/* probe response frame length (ioctl na) */
	struct {
		uint8 supported;	/* wpa supported */
		uint8 multicast;	/* multicast cipher */
		uint8 ucount;		/* count of unicast ciphers */
		uint8 unicast[4];	/* unicast ciphers */
		uint8 acount;		/* count of auth modes */
		uint8 auth[4];		/* Authentication modes */
	} wpa;
} wl_bss_info106_t;

typedef struct wl_bss_info {
	uint32		version;	/* version field */
	uint32		length;		/* byte length of data in this record, starting at version and including IEs */
	struct ether_addr BSSID;
	uint16		beacon_period;	/* units are Kusec */
	uint16		capability;	/* Capability information */
	uint8		SSID_len;
	uint8		SSID[32];
	struct {
		uint	count;		/* # rates in this set */
		uint8	rates[16];	/* rates in 500kbps units w/hi bit set if basic */
	} rateset;			/* supported rates */
	uint8		channel;	/* Channel no. */
	uint16		atim_window;	/* units are Kusec */
        uint8           dtim_period;    /* DTIM period */
	int16		RSSI;		/* receive signal strength (in dBm) */
	int8		phy_noise;	/* noise (in dBm) */
	uint32		ie_length;	/* byte length of Information Elements */
	/* variable length Information Elements */
} wl_bss_info_t;

typedef struct wl_scan_results {
	uint32 buflen;
	uint32 version;
	uint32 count;
	wl_bss_info_t bss_info[1];
} wl_scan_results_t;
/* size of wl_scan_results not including variable length array */
#define WL_SCAN_RESULTS_FIXED_SIZE 12

/* uint32 list */
typedef struct wl_uint32_list {
	/* in - # of elements, out - # of entries */
	uint32 count;
	/* variable length uint32 list */
	uint32 element[1];
} wl_uint32_list_t;

typedef struct wlc_ssid {
	uint32		SSID_len;
	uchar		SSID[32];
} wlc_ssid_t;

#define WLC_MAX_KEY_SIZE	32	/* max size of any key */
#define WLC_MAX_IV_SIZE		16	/* max size of any IV */
#define WLC_EXT_IV_FLAG		(1<<5)	/* flag to indicate IV is > 4 bytes */
#define WLC_MAX_DEFAULT_KEYS	4	/* # of default WEP keys */
#define WLC_MAX_KEYS		54	/* Max # of WEP keys */
#define WLC_WEP1_KEY_SIZE	5	/* max size of any WEP key */
#define WLC_WEP1_KEY_HEX_SIZE	10	/* size of WEP key in hex. */
#define WLC_WEP128_KEY_SIZE	13	/* max size of any WEP key */
#define WLC_WEP128_KEY_HEX_SIZE	26	/* size of WEP key in hex. */
#define WLC_TKIP_MIC_SIZE	8	/* size of TKIP MIC */
#define WLC_TKIP_EOM_SIZE	7	/* max size of TKIP EOM */
#define WLC_TKIP_EOM_FLAG	0x5a	/* TKIP EOM flag byte */
#define WLC_TKIP_KEY_SIZE	32	/* size of any TKIP key */
#define WLC_TKIP_MIC_AUTH_TX	16	/* offset to Authenticator MIC TX key */
#define WLC_TKIP_MIC_AUTH_RX	24	/* offset to Authenticator MIC RX key */
#define WLC_TKIP_MIC_SUP_RX	16	/* offset to Supplicant MIC RX key */
#define WLC_TKIP_MIC_SUP_TX	24	/* offset to Supplicant MIC TX key */
#define WLC_TKIP_P1_KEY_SIZE	10	/* size of TKHash Phase1 output, in bytes */
#define WLC_TKIP_P2_KEY_SIZE	16	/* size of TKHash Phase2 output */
#define WLC_AES_KEY_SIZE	16	/* size of AES key */

/* Enumerate crypto algorithms */
#define	CRYPTO_ALGO_OFF			0
#define	CRYPTO_ALGO_WEP1		1
#define	CRYPTO_ALGO_TKIP		2
#define	CRYPTO_ALGO_WEP128		3
#define CRYPTO_ALGO_AES_CCM		4
#define CRYPTO_ALGO_AES_OCB_MSDU	5
#define CRYPTO_ALGO_AES_OCB_MPDU	6
#define CRYPTO_ALGO_NALG		7

/* For use with wlc_wep_key.flags */
#define WSEC_PRIMARY_KEY	(1 << 1)	/* Indicates this key is the primary (ie tx) key */
#define WSEC_TKIP_ERROR		(1 << 2)	/* Provoke deliberate MIC error */
#define WSEC_REPLAY_ERROR	(1 << 3)	/* Provoke deliberate replay */

#define WSEC_GEN_MIC_ERROR	0x0001
#define WSEC_GEN_REPLAY		0x0002

typedef struct wlc_tkip_info {
	uint16		phase1[WLC_TKIP_P1_KEY_SIZE/sizeof(uint16)];	/* tkhash phase1 result */
	uint8		phase2[WLC_TKIP_P2_KEY_SIZE];	/* tkhash phase2 result */
	uint32		micl;
	uint32		micr;
} tkip_info_t;

typedef struct _wsec_iv {
	uint32		hi;	/* upper 32 bits of IV */
	uint16		lo;	/* lower 16 bits of IV */
} wsec_iv_t;

typedef struct wsec_key {
	uint32		index;		/* key index */
	uint32		len;		/* key length */
	uint8		data[WLC_MAX_KEY_SIZE];	/* key data */
	tkip_info_t	tkip_tx;	/* tkip transmit state */
	tkip_info_t	tkip_rx;	/* tkip receive state */
	uint32		algo;		/* CRYPTO_ALGO_AES_CCM, CRYPTO_ALGO_WEP128, etc */
	uint32		flags;		/* misc flags */
	uint32 		algo_hw;	/* cache for hw register*/
	uint32 		aes_mode;	/* cache for hw register*/
	int		iv_len;		/* IV length */		
	int		iv_initialized;	/* has IV been initialized already? */		
	int		icv_len;	/* ICV length */
	wsec_iv_t	rxiv;		/* Rx IV */
	wsec_iv_t	txiv;		/* Tx IV */
	struct ether_addr ea;		/* per station */
} wsec_key_t;

/* wireless security bitvec */
#define WEP_ENABLED		1
#define TKIP_ENABLED		2
#define AES_ENABLED		4
#define WSEC_SWFLAG		8

#define WSEC_SW(wsec)		((wsec) & WSEC_SWFLAG)
#define WSEC_HW(wsec)		(!WSEC_SW(wsec))
#define WSEC_WEP_ENABLED(wsec)	((wsec) & WEP_ENABLED)
#define WSEC_TKIP_ENABLED(wsec)	((wsec) & TKIP_ENABLED)
#define WSEC_AES_ENABLED(wsec)	((wsec) & AES_ENABLED)
#define WSEC_ENABLED(wsec)	((wsec) & (WEP_ENABLED | TKIP_ENABLED | AES_ENABLED))

/* wireless authentication bit vector */
#define WPA_ENABLED	1
#define PSK_ENABLED	2

#define WAUTH_WPA_ENABLED(wauth)	((wauth) & WPA_ENABLED)
#define WAUTH_PSK_ENABLED(wauth)	((wauth) & PSK_ENABLED)
#define WAUTH_ENABLED(wauth)		((wauth) & (WPA_ENABLED | PSK_ENABLED))

/* group/mcast cipher */
#define WPA_MCAST_CIPHER(wsec)	(((wsec) & TKIP_ENABLED) ? WPA_CIPHER_TKIP : \
				((wsec) & AES_ENABLED) ? WPA_CIPHER_AES_CCM : \
				WPA_CIPHER_NONE)

typedef struct wl_led_info {
	uint32		index;		/* led index */
	uint32		behavior;
	bool		activehi;
} wl_led_info_t;

/*
 * definitions for 802.2 messages passed from WL to NAS.
 */
/* This seems not to be defined outside the kernel on linux. */
#ifndef ETH_P_802_2
#define ETH_P_802_2		4
#endif

/* Type field values for the 802.2 driver messages for WPA. */
#define WLC_ASSOC_MSG		1
#define WLC_DISASSOC_MSG	2
#define WLC_PTK_MIC_MSG		3
#define WLC_GTK_MIC_MSG		4

typedef struct {
	struct ether_header eth;
	struct dot11_llc_snap_header snap;
	uint8 version;
	uint8 type;
	/* uint8 data[1]; */
} wpa_header_t PACKED;

#define WPA_HEADER_LEN	(ETHER_HDR_LEN + DOT11_LLC_SNAP_HDR_LEN + 2)

/* Use this to recognize 802.2 driver messages. */
static const uint8 wpa_snap_template[] =
	{ 0xaa, 0xaa, 0x03, 0x00, 0x90, 0x4c };

/* WPA driver message ethertype - private between wlc and nas */
#define WL_WPA_ETHER_TYPE	0x9999

/* srom read/write struct passed through ioctl */
typedef struct {
	uint   byteoff;		/* byte offset */
	uint   nbytes;		/* number of bytes */
	uint16 buf[1];
} srom_rw_t;

/* R_REG and W_REG struct passed through ioctl */
typedef struct {
	uint32	byteoff;	/* byte offset of the field in d11regs_t */
	uint32	val;		/* read/write value of the field */
	uint32	size;		/* sizeof the field */
} rw_reg_t;

/* Structure used by GET/SET_ATTEN ioctls */
typedef struct {
	uint16	auto_ctrl;	/* 1: Automatic control, 0: overriden */
	uint16	bb;		/* Baseband attenuation */
	uint16	radio;		/* Radio attenuation */
	uint16	txctl1;		/* Radio TX_CTL1 value */
} atten_t;

/* Used to get specific STA parameters */ 
typedef struct {
	uint32	val;
	struct ether_addr ea;
} scb_val_t;

/*
 * Country locale determines which channels are available to us.
 */
typedef enum _wlc_locale {
	WLC_WW = 0,	/* Worldwide */
	WLC_THA,	/* Thailand */
	WLC_ISR,	/* Israel */
	WLC_JDN,	/* Jordan */
	WLC_PRC,	/* China */
	WLC_JPN,	/* Japan */
	WLC_FCC,	/* USA */
	WLC_EUR,	/* Europe */
	WLC_USL,	/* US Low Band only */
	WLC_JPH,	/* Japan High Band only */
	WLC_ALL,	/* All the channels in this band */
	WLC_11D,	/* Represents locale recieved by 11d beacons */
	WLC_LAST_LOCALE,
	WLC_UNDEFINED_LOCALE = 0xf
} wlc_locale_t;

/* channel encoding */
typedef struct channel_info {
	int hw_channel;
	int target_channel;
	int scan_channel;
} channel_info_t;

/* For ioctls that take a list of MAC addresses */
struct maclist {
	uint count;			/* number of MAC addresses */
	struct ether_addr ea[1];	/* variable length array of MAC addresses */
};

/* get pkt count struct passed through ioctl */
typedef struct get_pktcnt {
	uint rx_good_pkt;
	uint rx_bad_pkt;
	uint tx_good_pkt;
	uint tx_bad_pkt;
} get_pktcnt_t;

/* Linux network driver ioctl encoding */
typedef struct wl_ioctl {
	int cmd;	/* common ioctl definition */
	void *buf;	/* pointer to user buffer */
	int len;	/* length of user buffer */
} wl_ioctl_t;

/* 
 * Structure for passing hardware and software 
 * revision info up from the driver. 
 */
typedef struct wlc_rev_info {
	uint		vendorid;	/* PCI vendor id */
	uint		deviceid;	/* device id of chip */
	uint		radiorev;	/* radio revision */
	uint		chiprev;	/* chip revision */
	uint		corerev;	/* core revision */
	uint		boardid;	/* board identifier (usu. PCI sub-device id) */
	uint		boardvendor;	/* board vendor (usu. PCI sub-vendor id) */
	uint		boardrev;	/* board revision */
	uint		driverrev;	/* driver version */
	uint		ucoderev;	/* microcode version */
	uint		bus;		/* bus type */
} wlc_rev_info_t;

/* check this magic number */
#define WLC_IOCTL_MAGIC		0x14e46c77

/* bump this number if you change the ioctl interface */
#define WLC_IOCTL_VERSION	1

/* maximum length buffer required */
#define WLC_IOCTL_MAXLEN	8192

/* Old ioctls we don't need anymore */
#ifndef	WLC_OBSOLETE
#define	_OBSCONCAT(line)	_WLC_OBSOLETE ## line
#define	_OBSXSTR(line)		_OBSCONCAT(line)
#define	WLC_OBSOLETE		_OBSXSTR(__LINE__)
#endif

/* common ioctl definitions */
enum {
	WLC_GET_MAGIC,
	WLC_GET_VERSION,
	WLC_UP,
	WLC_DOWN,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_DUMP,
	WLC_GET_MSGLEVEL,
	WLC_SET_MSGLEVEL,
	WLC_GET_PROMISC,
	WLC_SET_PROMISC,
	WLC_OBSOLETE,
	WLC_GET_RATE,
	WLC_SET_RATE,
	WLC_GET_INSTANCE,
	WLC_GET_FRAG,
	WLC_SET_FRAG,
	WLC_GET_RTS,
	WLC_SET_RTS,
	WLC_GET_INFRA,
	WLC_SET_INFRA,
	WLC_GET_AUTH,
	WLC_SET_AUTH,
	WLC_GET_BSSID,
	WLC_SET_BSSID,
	WLC_GET_SSID,
	WLC_SET_SSID,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_CHANNEL,
	WLC_SET_CHANNEL,
	WLC_GET_SRL,
	WLC_SET_SRL,
	WLC_GET_LRL,
	WLC_SET_LRL,
	WLC_GET_PLCPHDR,
	WLC_SET_PLCPHDR,
	WLC_GET_RADIO,
	WLC_SET_RADIO,
	WLC_GET_PHYTYPE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_WEP,
	WLC_SET_WEP,
	WLC_GET_KEY,
	WLC_SET_KEY,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_SCAN,
	WLC_SCAN_RESULTS,
	WLC_DISASSOC,
	WLC_REASSOC,
	WLC_GET_ROAM_TRIGGER,
	WLC_SET_ROAM_TRIGGER,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_EVM,			/* diag */
	WLC_GET_TXANT,
	WLC_SET_TXANT,
	WLC_GET_ANTDIV,
	WLC_SET_ANTDIV,
	WLC_GET_TXPWR,
	WLC_SET_TXPWR,
	WLC_GET_CLOSED,
	WLC_SET_CLOSED,
	WLC_GET_MACLIST,
	WLC_SET_MACLIST,
	WLC_GET_RATESET,
	WLC_SET_RATESET,
	WLC_GET_LOCALE,
	WLC_SET_LOCALE,
	WLC_GET_BCNPRD,
	WLC_SET_BCNPRD,
	WLC_GET_DTIMPRD,
	WLC_SET_DTIMPRD,
	WLC_GET_SROM,
	WLC_SET_SROM,
	WLC_GET_WEP_RESTRICT,
	WLC_SET_WEP_RESTRICT,
	WLC_GET_COUNTRY,
	WLC_SET_COUNTRY,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,	
	WLC_OBSOLETE,		
	WLC_FREQ_ACCURACY,		/* diag */
	WLC_CARRIER_SUPPRESS,		/* diag */
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_REVINFO,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,			/* diag */
	WLC_OBSOLETE,			/* diag */
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_MACMODE,
	WLC_SET_MACMODE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_GMODE,
	WLC_SET_GMODE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_CURR_RATESET,		/* current rateset */
	WLC_GET_SCANSUPPRESS,
	WLC_SET_SCANSUPPRESS,
	WLC_GET_AP,
	WLC_SET_AP,
	WLC_GET_EAP_RESTRICT,
	WLC_SET_EAP_RESTRICT,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_WDSLIST,
	WLC_SET_WDSLIST,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_RSSI,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_WSEC,
	WLC_SET_WSEC,
	WLC_OBSOLETE,
	WLC_GET_BSS_INFO,
	WLC_OBSOLETE,
	WLC_GET_LAZYWDS,
	WLC_SET_LAZYWDS,
	WLC_GET_BANDLIST,
	WLC_GET_BAND,
	WLC_SET_BAND,
	WLC_OBSOLETE,
	WLC_GET_SHORTSLOT,
	WLC_GET_SHORTSLOT_OVERRIDE,
	WLC_SET_SHORTSLOT_OVERRIDE,
	WLC_GET_SHORTSLOT_RESTRICT,
	WLC_SET_SHORTSLOT_RESTRICT,
	WLC_GET_GMODE_PROTECTION,
	WLC_GET_GMODE_PROTECTION_OVERRIDE,
	WLC_SET_GMODE_PROTECTION_OVERRIDE,
	WLC_UPGRADE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_ASSOCLIST,
	WLC_GET_CLK,
	WLC_SET_CLK,
	WLC_GET_UP,
	WLC_OUT,
	WLC_GET_WPA_AUTH,
	WLC_SET_WPA_AUTH,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_GMODE_PROTECTION_CONTROL,
	WLC_SET_GMODE_PROTECTION_CONTROL,
	WLC_GET_PHYLIST,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,			/* diag */
	WLC_OBSOLETE,			/* diag */
	WLC_GET_GMODE_PROTECTION_CTS,
	WLC_SET_GMODE_PROTECTION_CTS,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_PIOMODE,
	WLC_SET_PIOMODE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_SET_LED,
	WLC_GET_LED,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_CHANNEL_SEL,
	WLC_START_CHANNEL_SEL,
	WLC_GET_VALID_CHANNELS,
	WLC_GET_FAKEFRAG,
	WLC_SET_FAKEFRAG,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_GET_WET,
	WLC_SET_WET,
	WLC_OBSOLETE,
	WLC_OBSOLETE,
	WLC_LAST
};

#ifndef EPICTRL_COOKIE
#define EPICTRL_COOKIE		0xABADCEDE
#endif

/* vx wlc ioctl's offset */
#define CMN_IOCTL_OFF 0x180

/* begin 0x1f values beyond the start of the ET driver range. */
#define WL_OID_BASE		0xFFE41420

#define WL_DECRYPT_STATUS_SUCCESS	1
#define WL_DECRYPT_STATUS_FAILURE	2
#define WL_DECRYPT_STATUS_UNKNOWN	3

/* Bit masks for radio disabled status - returned by WL_GET_RADIO */
#define WL_RADIO_SW_DISABLE	(1<<0)
#define WL_RADIO_HW_DISABLE	(1<<1)

/* Override bit for WLC_SET_TXPWR.  if set, ignore other level limits */
#define WL_TXPWR_OVERRIDE	(1<<31)

/* Bus types */
#define WL_SB_BUS	0	/* Silicon Backplane */
#define WL_PCI_BUS	1	/* PCI target */
#define WL_PCMCIA_BUS	2	/* PCMCIA target */

/* band types */
#define	WLC_BAND_AUTO		0	/* auto-select */
#define	WLC_BAND_A		1	/* "a" band (5   Ghz) */
#define	WLC_BAND_B		2	/* "b" band (2.4 Ghz) */

/* MAC list modes */
#define WLC_MACMODE_DISABLED	0	/* MAC list disabled */
#define WLC_MACMODE_DENY	1	/* Deny specified (i.e. allow unspecified) */
#define WLC_MACMODE_ALLOW	2	/* Allow specified (i.e. deny unspecified) */	

/* 54g modes (basic bits may still be overridden) */
#define GMODE_LEGACY_B		0
#define GMODE_AUTO		1
#define GMODE_ONLY		2
#define GMODE_B_DEFERRED	3
#define GMODE_PERFORMANCE	4
#define GMODE_LRS		5
#define GMODE_MAX		6

/* values for PLCPHdr_override */
#define WLC_PLCP_AUTO	-1
#define WLC_PLCP_SHORT	0
#define WLC_PLCP_LONG	1

/* values for g_protection_override */
#define WLC_G_PROTECTION_AUTO	-1
#define WLC_G_PROTECTION_OFF	0
#define WLC_G_PROTECTION_ON	1

/* values for g_protection_control */
#define WLC_G_PROTECTION_CTL_OFF	0
#define WLC_G_PROTECTION_CTL_LOCAL	1
#define WLC_G_PROTECTION_CTL_OVERLAP	2

/* led per-pin behaviors */
#define	WL_LED_OFF		0
#define	WL_LED_ON		1
#define	WL_LED_ACTIVITY		2
#define	WL_LED_RADIO		3
#define	WL_LED_ARADIO		4
#define	WL_LED_BRADIO		5
#define	WL_LED_BGMODE		6
#define	WL_LED_WI1		7
#define	WL_LED_WI2		8
#define	WL_LED_WI3		9
#define	WL_LED_ASSOC		10
#define	WL_LED_INACTIVE		11
#define	WL_LED_NUMBEHAVIOR	12

/* led behavior numeric value format */
#define	WL_LED_BEH_MASK		0x7f		/* behavior mask */
#define	WL_LED_AL_MASK		0x80		/* activelow (polarity) bit */

/* rate check */
#define WL_RATE_OFDM(r)		(((r) & 0x7f) == 12 || ((r) & 0x7f) == 18 || \
				 ((r) & 0x7f) == 24 || ((r) & 0x7f) == 36 || \
				 ((r) & 0x7f) == 48 || ((r) & 0x7f) == 72 || \
				 ((r) & 0x7f) == 96 || ((r) & 0x7f) == 108)

#undef PACKED

#endif /* _wlioctl_h_ */
