#ifndef __ETHER00_H
#define __ETHER00_H

/*
 * Register definitions for the Ethernet MAC
 */

/*
 * Copyright (c) Altera Corporation 2000.
 * All rights reserved.
 */

/*
*	Structures for the DMA controller
*/
typedef struct fda_desc
	{
	struct fda_desc *	FDNext;
	long				FDSystem;
	long				FDStat;
	short				FDLength;
	short				FDCtl;
	}FDA_DESC;

typedef struct buf_desc
	{
	char *	BuffData;
	short	BuffLength;
	char	BDStat;
	char	BDCtl;
	}BUF_DESC;

/*
*	Control masks for the DMA controller
*/
#define FDCTL_BDCOUNT_MSK						(0x1F)
#define FDCTL_BDCOUNT_OFST						(0)
#define FDCTL_FRMOPT_MSK						(0x7C00)
#define FDCTL_FRMOPT_OFST						(10)
#define	FDCTL_COWNSFD_MSK						(0x8000)
#define	FDCTL_COWNSFD_OFST						(15)

#define BDCTL_RXBDSEQN_MSK						(0x7F)
#define BDCTL_RXBDSEQN_OFST						(0)
#define	BDCTL_COWNSBD_MSK						(0x80)
#define	BDCTL_COWNSBD_OFST						(7)

#define FDNEXT_EOL_MSK							(0x1)
#define FDNEXT_EOL_OFST							(0)
#define FDNEXT_EOL_POINTER_MSK					(0xFFFFFFF0)
#define FDNEXT_EOL_POINTER_OFST					(4)

#define ETHER_ARC_SIZE         (21)

/*
*	Regsiter definitions and masks
*/
#define ETHER_DMA_CTL(base)							(ETHER00_TYPE (base + 0x100))
#define ETHER_DMA_CTL_DMBURST_OFST				(2)
#define ETHER_DMA_CTL_DMBURST_MSK				(0x1FC)
#define ETHER_DMA_CTL_POWRMGMNT_OFST			(11)
#define ETHER_DMA_CTL_POWRMGMNT_MSK				(0x1000)
#define ETHER_DMA_CTL_TXBIGE_OFST				(14)
#define ETHER_DMA_CTL_TXBIGE_MSK				(0x4000)
#define ETHER_DMA_CTL_RXBIGE_OFST				(15)
#define ETHER_DMA_CTL_RXBIGE_MSK				(0x8000)
#define ETHER_DMA_CTL_TXWAKEUP_OFST				(16)
#define ETHER_DMA_CTL_TXWAKEUP_MSK				(0x10000)
#define ETHER_DMA_CTL_SWINTREQ_OFST				(17)
#define ETHER_DMA_CTL_SWINTREQ_MSK				(0x20000)
#define ETHER_DMA_CTL_INTMASK_OFST				(18)
#define ETHER_DMA_CTL_INTMASK_MSK				(0x40000)
#define ETHER_DMA_CTL_M66ENSTAT_OFST			(19)
#define ETHER_DMA_CTL_M66ENSTAT_MSK				(0x80000)
#define ETHER_DMA_CTL_RMTXINIT_OFST				(20)
#define ETHER_DMA_CTL_RMTXINIT_MSK				(0x100000)
#define ETHER_DMA_CTL_RMRXINIT_OFST				(21)
#define ETHER_DMA_CTL_RMRXINIT_MSK				(0x200000)
#define ETHER_DMA_CTL_RXALIGN_OFST				(22)
#define ETHER_DMA_CTL_RXALIGN_MSK				(0xC00000)
#define ETHER_DMA_CTL_RMSWRQ_OFST				(24)
#define ETHER_DMA_CTL_RMSWRQ_MSK				(0x1000000)
#define ETHER_DMA_CTL_RMEMBANK_OFST				(25)
#define ETHER_DMA_CTL_RMEMBANK_MSK				(0x2000000)

#define ETHER_TXFRMPTR(base)							(ETHER00_TYPE (base + 0x104))

#define ETHER_TXTHRSH(base)							(ETHER00_TYPE (base + 0x308))

#define ETHER_TXPOLLCTR(base)							(ETHER00_TYPE (base + 0x30c))

#define	ETHER_BLFRMPTR(base)							(ETHER00_TYPE (base + 0x110))
#define ETHER_BLFFRMPTR_EOL_OFST				(0)
#define ETHER_BLFFRMPTR_EOL_MSK					(0x1)
#define ETHER_BLFFRMPTR_ADDRESS_OFST			(4)
#define ETHER_BLFFRMPTR_ADDRESS_MSK				(0xFFFFFFF0)

#define ETHER_RXFRAGSIZE(base)						(ETHER00_TYPE (base + 0x114))
#define	ETHER_RXFRAGSIZE_MINFRAG_OFST			(2)
#define	ETHER_RXFRAGSIZE_MINFRAG_MSK			(0xFFC)
#define	ETHER_RXFRAGSIZE_ENPACK_OFST			(15)
#define	ETHER_RXFRAGSIZE_ENPACK_MSK				(0x8000)

#define ETHER_INT_EN(base)							(ETHER00_TYPE (base + 0x118))
#define ETHER_INT_EN_FDAEXEN_OFST				(0)
#define ETHER_INT_EN_FDAEXEN_MSK				(0x1)
#define ETHER_INT_EN_BLEXEN_OFST				(1)
#define ETHER_INT_EN_BLEXN_MSK					(0x2)
#define ETHER_INT_EN_STARGABTEN_OFST			(2)
#define ETHER_INT_EN_STARGABTEN_MSK				(0x4)
#define ETHER_INT_EN_RTARGABTEN_OFST			(3)
#define ETHER_INT_EN_RTARGABTEN_MSK				(0x8)
#define ETHER_INT_EN_RMASABTEN_OFST				(4)
#define ETHER_INT_EN_RMASABTEN_MSK				(0x10)
#define ETHER_INT_EN_SSYSERREN_OFST				(5)
#define ETHER_INT_EN_SSYSERREN_MSK				(0x20)
#define ETHER_INT_EN_DPARERREN_OFST				(6)
#define ETHER_INT_EN_DPARERREN_MSK				(0x40)
#define ETHER_INT_EN_EARNOTEN_OFST				(7)
#define ETHER_INT_EN_EARNOTEN_MSK				(0x80)
#define ETHER_INT_EN_DPARDEN_OFST				(8)
#define ETHER_INT_EN_DPARDEN_MSK				(0x100)
#define ETHER_INT_EN_DMPARERREN_OFST			(9)
#define ETHER_INT_EN_DMPARERREN_MSK				(0x200)
#define ETHER_INT_EN_TXCTLCMPEN_OFST			(10)
#define ETHER_INT_EN_TXCTLCMPEN_MSK				(0x400)
#define ETHER_INT_EN_NRABTEN_OFST				(11)
#define ETHER_INT_EN_NRABTEN_MSK				(0x800)

#define	ETHER_FDA_BAS(base)							(ETHER00_TYPE (base + 0x11C))
#define ETHER_FDA_BAS_ADDRESS_OFST				(4)
#define ETHER_FDA_BAS_ADDRESS_MSK				(0xFFFFFFF0)

#define ETHER_FDA_LIM(base)							(ETHER00_TYPE (base + 0x120))
#define ETHER_FDA_LIM_COUNT_OFST				(4)
#define ETHER_FDA_LIM_COUNT_MSK					(0xFFF0)

#define ETHER_INT_SRC(base)							(ETHER00_TYPE (base + 0x124))
#define ETHER_INT_SRC_INTMACTX_OFST				(0)
#define ETHER_INT_SRC_INTMACTX_MSK				(0x1)
#define ETHER_INT_SRC_INTMACRX_OFST				(1)
#define ETHER_INT_SRC_INTMACRX_MSK				(0x2)
#define ETHER_INT_SRC_INTSBUS_OFST				(2)
#define ETHER_INT_SRC_INTSBUS_MSK				(0x4)
#define ETHER_INT_SRC_INTFDAEX_OFST				(3)
#define ETHER_INT_SRC_INTFDAEX_MSK				(0x8)
#define ETHER_INT_SRC_INTBLEX_OFST				(4)
#define ETHER_INT_SRC_INTBLEX_MSK				(0x10)
#define ETHER_INT_SRC_SWINT_OFST				(5)
#define ETHER_INT_SRC_SWINT_MSK					(0x20)
#define ETHER_INT_SRC_INTEARNOT_OFST			(6)
#define ETHER_INT_SRC_INTEARNOT_MSK				(0x40)
#define ETHER_INT_SRC_DMPARERR_OFST				(7)
#define ETHER_INT_SRC_DMPARERR_MSK				(0x80)
#define ETHER_INT_SRC_INTEXBD_OFST				(8)
#define ETHER_INT_SRC_INTEXBD_MSK				(0x100)
#define ETHER_INT_SRC_INTTXCTLCMP_OFST			(9)
#define ETHER_INT_SRC_INTTXCTLCMP_MSK			(0x200)
#define ETHER_INT_SRC_INTNRABT_OFST				(10)
#define ETHER_INT_SRC_INTNRABT_MSK				(0x400)
#define ETHER_INT_SRC_FDAEX_OFST				(11)
#define ETHER_INT_SRC_FDAEX_MSK					(0x800)
#define ETHER_INT_SRC_BLEX_OFST					(12)
#define ETHER_INT_SRC_BLEX_MSK					(0x1000)
#define ETHER_INT_SRC_DMPARERRSTAT_OFST			(13)
#define ETHER_INT_SRC_DMPARERRSTAT_MSK			(0x2000)
#define ETHER_INT_SRC_NRABT_OFST				(14)
#define ETHER_INT_SRC_NRABT_MSK					(0x4000)
#define ETHER_INT_SRC_INTLINK_OFST				(15)
#define ETHER_INT_SRC_INTLINK_MSK				(0x8000)
#define ETHER_INT_SRC_INTEXDEFER_OFST			(16)
#define ETHER_INT_SRC_INTEXDEFER_MSK			(0x10000)
#define ETHER_INT_SRC_INTRMON_OFST				(17)
#define ETHER_INT_SRC_INTRMON_MSK				(0x20000)
#define ETHER_INT_SRC_IRQ_MSK					(0x83FF)

#define ETHER_PAUSECNT(base)							(ETHER00_TYPE (base + 0x40))
#define ETHER_PAUSECNT_COUNT_OFST				(0)
#define ETHER_PAUSECNT_COUNT_MSK				(0xFFFF)

#define ETHER_REMPAUCNT(base)							(ETHER00_TYPE (base + 0x44))
#define ETHER_REMPAUCNT_COUNT_OFST				(0)
#define ETHER_REMPAUCNT_COUNT_MSK				(0xFFFF)

#define ETHER_TXCONFRMSTAT(base)						(ETHER00_TYPE (base + 0x348))
#define ETHER_TXCONFRMSTAT_TS_STAT_VALUE_OFST	(0)
#define ETHER_TXCONFRMSTAT_TS_STAT_VALUE_MSK	(0x3FFFFF)

#define ETHER_MAC_CTL(base)							(ETHER00_TYPE (base + 0))
#define ETHER_MAC_CTL_HALTREQ_OFST				(0)
#define ETHER_MAC_CTL_HALTREQ_MSK				(0x1)
#define ETHER_MAC_CTL_HALTIMM_OFST				(1)
#define ETHER_MAC_CTL_HALTIMM_MSK				(0x2)
#define ETHER_MAC_CTL_RESET_OFST				(2)
#define ETHER_MAC_CTL_RESET_MSK					(0x4)
#define ETHER_MAC_CTL_FULLDUP_OFST				(3)
#define ETHER_MAC_CTL_FULLDUP_MSK				(0x8)
#define ETHER_MAC_CTL_MACLOOP_OFST				(4)
#define ETHER_MAC_CTL_MACLOOP_MSK				(0x10)
#define ETHER_MAC_CTL_CONN_OFST					(5)
#define ETHER_MAC_CTL_CONN_MSK					(0x60)
#define ETHER_MAC_CTL_LOOP10_OFST				(7)
#define ETHER_MAC_CTL_LOOP10_MSK				(0x80)
#define ETHER_MAC_CTL_LNKCHG_OFST				(8)
#define ETHER_MAC_CTL_LNKCHG_MSK				(0x100)
#define ETHER_MAC_CTL_MISSROLL_OFST				(10)
#define ETHER_MAC_CTL_MISSROLL_MSK				(0x400)
#define ETHER_MAC_CTL_ENMISSROLL_OFST			(13)
#define ETHER_MAC_CTL_ENMISSROLL_MSK			(0x2000)
#define ETHER_MAC_CTL_LINK10_OFST				(15)
#define ETHER_MAC_CTL_LINK10_MSK				(0x8000)

#define ETHER_ARC_CTL(base)							(ETHER00_TYPE (base + 0x4))
#define	ETHER_ARC_CTL_STATIONACC_OFST			(0)
#define	ETHER_ARC_CTL_STATIONACC_MSK			(0x1)
#define	ETHER_ARC_CTL_GROUPACC_OFST				(1)
#define	ETHER_ARC_CTL_GROUPACC_MSK				(0x2)
#define	ETHER_ARC_CTL_BROADACC_OFST				(2)
#define	ETHER_ARC_CTL_BROADACC_MSK				(0x4)
#define	ETHER_ARC_CTL_NEGARC_OFST				(3)
#define	ETHER_ARC_CTL_NEGARC_MSK				(0x8)
#define	ETHER_ARC_CTL_COMPEN_OFST				(4)
#define	ETHER_ARC_CTL_COMPEN_MSK				(0x10)

#define ETHER_TX_CTL(base)							(ETHER00_TYPE (base + 0x8))
#define ETHER_TX_CTL_TXEN_OFST					(0)
#define ETHER_TX_CTL_TXEN_MSK					(0x1)
#define ETHER_TX_CTL_TXHALT_OFST				(1)
#define ETHER_TX_CTL_TXHALT_MSK					(0x2)
#define ETHER_TX_CTL_NOPAD_OFST					(2)
#define ETHER_TX_CTL_NOPAD_MSK					(0x4)
#define ETHER_TX_CTL_NOCRC_OFST					(3)
#define ETHER_TX_CTL_NOCRC_MSK					(0x8)
#define ETHER_TX_CTL_FBACK_OFST					(4)
#define ETHER_TX_CTL_FBACK_MSK					(0x10)
#define ETHER_TX_CTL_NOEXDEF_OFST				(5)
#define ETHER_TX_CTL_NOEXDEF_MSK				(0x20)
#define ETHER_TX_CTL_SDPAUSE_OFST				(6)
#define ETHER_TX_CTL_SDPAUSE_MSK				(0x40)
#define ETHER_TX_CTL_MII10_OFST					(7)
#define ETHER_TX_CTL_MII10_MSK					(0x80)
#define ETHER_TX_CTL_ENUNDER_OFST				(8)
#define ETHER_TX_CTL_ENUNDER_MSK				(0x100)
#define ETHER_TX_CTL_ENEXDEFER_OFST				(9)
#define ETHER_TX_CTL_ENEXDEFER_MSK				(0x200)
#define ETHER_TX_CTL_ENLCARR_OFST				(10)
#define ETHER_TX_CTL_ENLCARR_MSK				(0x400)
#define ETHER_TX_CTL_ENEXCOLL_OFST				(11)
#define ETHER_TX_CTL_ENEXCOLL_MSK				(0x800)
#define ETHER_TX_CTL_ENLATECOLL_OFST				(12)
#define ETHER_TX_CTL_ENLATECOLL_MSK				(0x1000)
#define ETHER_TX_CTL_ENTXPAR_OFST				(13)
#define ETHER_TX_CTL_ENTXPAR_MSK				(0x2000)
#define ETHER_TX_CTL_ENCOMP_OFST				(14)
#define ETHER_TX_CTL_ENCOMP_MSK					(0x4000)

#define ETHER_TX_STAT(base)							(ETHER00_TYPE (base + 0xc))
#define ETHER_TX_STAT_TXCOLL_OFST				(0)
#define ETHER_TX_STAT_TXCOLL_MSK				(0xF)
#define ETHER_TX_STAT_EXCOLL_OFST				(4)
#define ETHER_TX_STAT_EXCOLL_MSK				(0x10)
#define ETHER_TX_STAT_TXDEFER_OFST				(5)
#define ETHER_TX_STAT_TXDEFER_MSK				(0x20)
#define ETHER_TX_STAT_PAUSED_OFST				(6)
#define ETHER_TX_STAT_PAUSED_MSK				(0x40)
#define ETHER_TX_STAT_INTTX_OFST				(7)
#define ETHER_TX_STAT_INTTX_MSK					(0x80)
#define ETHER_TX_STAT_UNDER_OFST				(8)
#define ETHER_TX_STAT_UNDER_MSK					(0x100)
#define ETHER_TX_STAT_EXDEFER_OFST				(9)
#define ETHER_TX_STAT_EXDEFER_MSK				(0x200)
#define ETHER_TX_STAT_LCARR_OFST				(10)
#define ETHER_TX_STAT_LCARR_MSK					(0x400)
#define ETHER_TX_STAT_TX10STAT_OFST				(11)
#define ETHER_TX_STAT_TX10STAT_MSK				(0x800)
#define ETHER_TX_STAT_LATECOLL_OFST				(12)
#define ETHER_TX_STAT_LATECOLL_MSK				(0x1000)
#define ETHER_TX_STAT_TXPAR_OFST				(13)
#define ETHER_TX_STAT_TXPAR_MSK					(0x2000)
#define ETHER_TX_STAT_COMP_OFST					(14)
#define ETHER_TX_STAT_COMP_MSK					(0x4000)
#define ETHER_TX_STAT_TXHALTED_OFST				(15)
#define ETHER_TX_STAT_TXHALTED_MSK				(0x8000)
#define ETHER_TX_STAT_SQERR_OFST				(16)
#define ETHER_TX_STAT_SQERR_MSK					(0x10000)
#define ETHER_TX_STAT_TXMCAST_OFST				(17)
#define ETHER_TX_STAT_TXMCAST_MSK				(0x20000)
#define ETHER_TX_STAT_TXBCAST_OFST				(18)
#define ETHER_TX_STAT_TXBCAST_MSK				(0x40000)
#define ETHER_TX_STAT_VLAN_OFST					(19)
#define ETHER_TX_STAT_VLAN_MSK					(0x80000)
#define ETHER_TX_STAT_MACC_OFST					(20)
#define ETHER_TX_STAT_MACC_MSK					(0x100000)
#define ETHER_TX_STAT_TXPAUSE_OFST				(21)
#define ETHER_TX_STAT_TXPAUSE_MSK				(0x200000)

#define ETHER_RX_CTL(base)							(ETHER00_TYPE (base + 0x10))
#define ETHER_RX_CTL_RXEN_OFST					(0)
#define ETHER_RX_CTL_RXEN_MSK					(0x1)
#define ETHER_RX_CTL_RXHALT_OFST				(1)
#define ETHER_RX_CTL_RXHALT_MSK					(0x2)
#define ETHER_RX_CTL_LONGEN_OFST				(2)
#define ETHER_RX_CTL_LONGEN_MSK					(0x4)
#define ETHER_RX_CTL_SHORTEN_OFST				(3)
#define ETHER_RX_CTL_SHORTEN_MSK				(0x8)
#define ETHER_RX_CTL_STRIPCRC_OFST				(4)
#define ETHER_RX_CTL_STRIPCRC_MSK				(0x10)
#define ETHER_RX_CTL_PASSCTL_OFST				(5)
#define ETHER_RX_CTL_PASSCTL_MSK				(0x20)
#define ETHER_RX_CTL_IGNORECRC_OFST				(6)
#define ETHER_RX_CTL_IGNORECRC_MSK				(0x40)
#define ETHER_RX_CTL_ENALIGN_OFST				(8)
#define ETHER_RX_CTL_ENALIGN_MSK				(0x100)
#define ETHER_RX_CTL_ENCRCERR_OFST				(9)
#define ETHER_RX_CTL_ENCRCERR_MSK				(0x200)
#define ETHER_RX_CTL_ENOVER_OFST				(10)
#define ETHER_RX_CTL_ENOVER_MSK					(0x400)
#define ETHER_RX_CTL_ENLONGERR_OFST				(11)
#define ETHER_RX_CTL_ENLONGERR_MSK				(0x800)
#define ETHER_RX_CTL_ENRXPAR_OFST				(13)
#define ETHER_RX_CTL_ENRXPAR_MSK				(0x2000)
#define ETHER_RX_CTL_ENGOOD_OFST				(14)
#define ETHER_RX_CTL_ENGOOD_MSK					(0x4000)

#define ETHER_RX_STAT(base)							(ETHER00_TYPE (base + 0x14))
#define ETHER_RX_STAT_LENERR_OFST				(4)
#define ETHER_RX_STAT_LENERR_MSK				(0x10)
#define ETHER_RX_STAT_CTLRECD_OFST				(5)
#define ETHER_RX_STAT_CTLRECD_MSK				(0x20)
#define ETHER_RX_STAT_INTRX_OFST				(6)
#define ETHER_RX_STAT_INTRX_MSK					(0x40)
#define ETHER_RX_STAT_RX10STAT_OFST				(7)
#define ETHER_RX_STAT_RX10STAT_MSK				(0x80)
#define ETHER_RX_STAT_ALIGNERR_OFST				(8)
#define ETHER_RX_STAT_ALIGNERR_MSK				(0x100)
#define ETHER_RX_STAT_CRCERR_OFST				(9)
#define ETHER_RX_STAT_CRCERR_MSK				(0x200)
#define ETHER_RX_STAT_OVERFLOW_OFST				(10)
#define ETHER_RX_STAT_OVERFLOW_MSK				(0x400)
#define ETHER_RX_STAT_LONGERR_OFST				(11)
#define ETHER_RX_STAT_LONGERR_MSK				(0x800)
#define ETHER_RX_STAT_RXPAR_OFST				(13)
#define ETHER_RX_STAT_RXPAR_MSK					(0x2000)
#define ETHER_RX_STAT_GOOD_OFST					(14)
#define ETHER_RX_STAT_GOOD_MSK					(0x4000)
#define ETHER_RX_STAT_RXHALTED_OFST				(15)
#define ETHER_RX_STAT_RXHALTED_MSK				(0x8000)
#define ETHER_RX_STAT_RXMCAST_OFST				(17)
#define ETHER_RX_STAT_RXMCAST_MSK				(0x10000)
#define ETHER_RX_STAT_RXBCAST_OFST				(18)
#define ETHER_RX_STAT_RXBCAST_MSK				(0x20000)
#define ETHER_RX_STAT_RXVLAN_OFST				(19)
#define ETHER_RX_STAT_RXVLAN_MSK				(0x40000)
#define ETHER_RX_STAT_RXPAUSE_OFST				(20)
#define ETHER_RX_STAT_RXPAUSE_MSK				(0x80000)
#define ETHER_RX_STAT_ARCSTATUS_OFST				(21)
#define ETHER_RX_STAT_ARCSTATUS_MSK				(0xF00000)
#define ETHER_RX_STAT_ARCENT_OFST				(25)
#define ETHER_RX_STAT_ARCENT_MSK				(0x1F000000)

#define ETHER_MD_DATA(base)							(ETHER00_TYPE (base + 0x18))

#define ETHER_MD_CA(base)								(ETHER00_TYPE (base + 0x1c))
#define ETHER_MD_CA_ADDR_OFST					(0)
#define ETHER_MD_CA_ADDR_MSK					(0x1F)
#define ETHER_MD_CA_PHY_OFST					(5)
#define ETHER_MD_CA_PHY_MSK					(0x3E0)
#define ETHER_MD_CA_WR_OFST					(10)
#define ETHER_MD_CA_WR_MSK					(0x400)
#define ETHER_MD_CA_BUSY_OFST					(11)
#define ETHER_MD_CA_BUSY_MSK					(0x800)
#define ETHER_MD_CA_PRESUPP_OFST				(12)
#define ETHER_MD_CA_PRESUPP_MSK					(0x1000)

#define ETHER_ARC_ADR(base)	      (ETHER00_TYPE (base + 0x160))
#define ETHER_ARC_ADR_ARC_LOC_OFST				(2)
#define ETHER_ARC_ADR_ARC_LOC_MSK				(0xFFC)

#define ETHER_ARC_DATA(base)  (ETHER00_TYPE (base + 0x364))

#define ETHER_ARC_ENA(base)   (ETHER00_TYPE (base + 0x28))
#define ETHER_ARC_ENA_MSK					(0x1FFFFF)

#define ETHER_PROM_CTL(base)							(ETHER00_TYPE (base + 0x2c))
#define ETHER_PROM_CTL_PROM_ADDR_OFST			(0)
#define ETHER_PROM_CTL_PROM_ADDR_MSK			(0x3F)
#define ETHER_PROM_CTL_OPCODE_OFST				(13)
#define ETHER_PROM_CTL_OPCODE_MSK				(0x6000)
#define ETHER_PROM_CTL_OPCODE_READ_MSK			(0x4000)
#define ETHER_PROM_CTL_OPCODE_WRITE_MSK			(0x2000)
#define ETHER_PROM_CTL_OPCODE_ERASE_MSK			(0x6000)
#define ETHER_PROM_CTL_ENABLE_MSK				(0x0030)
#define ETHER_PROM_CTL_DISABLE_MSK				(0x0000)
#define ETHER_PROM_CTL_BUSY_OFST				(15)
#define ETHER_PROM_CTL_BUSY_MSK					(0x8000)

#define ETHER_PROM_DATA(base)							(ETHER00_TYPE (base + 0x30))

#define ETHER_MISS_CNT(base)							(ETHER00_TYPE (base + 0x3c))
#define ETHER_MISS_CNT_COUNT_OFST				(0)
#define ETHER_MISS_CNT_COUNT_MSK				(0xFFFF)

#define ETHER_CNTDATA(base)							(ETHER00_TYPE (base + 0x80))

#define ETHER_CNTACC(base)							(ETHER00_TYPE (base + 0x84))
#define ETHER_CNTACC_ADDR_OFST					(0)
#define ETHER_CNTACC_ADDR_MSK					(0xFF)
#define ETHER_CNTACC_WRRDN_OFST					(8)
#define ETHER_CNTACC_WRRDN_MSK					(0x100)
#define ETHER_CNTACC_CLEAR_OFST					(9)
#define ETHER_CNTACC_CLEAR_MSK					(0x200)

#define ETHER_TXRMINTEN(base)							(ETHER00_TYPE (base + 0x88))
#define ETHER_TXRMINTEN_MSK						(0x3FFFFFFF)

#define ETHER_RXRMINTEN(base)							(ETHER00_TYPE (base + 0x8C))
#define ETHER_RXRMINTEN_MSK						(0xFFFFFF)

/*
*	RMON Registers
*/
#define		RMON_COLLISION0						0x0
#define		RMON_COLLISION1						0x1
#define		RMON_COLLISION2						0x2
#define		RMON_COLLISION3						0x3
#define		RMON_COLLISION4						0x4
#define		RMON_COLLISION5						0x5
#define		RMON_COLLISION6						0x6
#define		RMON_COLLISION7						0x7
#define		RMON_COLLISION8						0x8
#define		RMON_COLLISION9						0x9
#define		RMON_COLLISION10					0xa
#define		RMON_COLLISION11					0xb
#define		RMON_COLLISION12					0xc
#define		RMON_COLLISION13					0xd
#define		RMON_COLLISION14					0xe
#define		RMON_COLLISION15					0xf
#define		RMON_COLLISION16					0x10
#define		RMON_FRAMES_WITH_DEFERRED_XMISSIONS	0x11
#define		RMON_LATE_COLLISIONS				0x12
#define		RMON_FRAMES_LOST_DUE_TO_MAC_XMIT	0x13
#define		RMON_CARRIER_SENSE_ERRORS			0x14
#define		RMON_FRAMES_WITH_EXCESSIVE_DEFERAL	0x15
#define		RMON_UNICAST_FRAMES_TRANSMITTED_OK	0x16
#define		RMON_MULTICAST_FRAMES_XMITTED_OK	0x17
#define		RMON_BROADCAST_FRAMES_XMITTED_OK	0x18
#define		RMON_SQE_TEST_ERRORS				0x19
#define		RMON_PAUSE_MACCTRL_FRAMES_XMITTED	0x1A
#define		RMON_MACCTRL_FRAMES_XMITTED			0x1B
#define		RMON_VLAN_FRAMES_XMITTED			0x1C
#define		RMON_OCTETS_XMITTED_OK				0x1D
#define		RMON_OCTETS_XMITTED_OK_HI			0x1E

#define		RMON_RX_PACKET_SIZES0				0x40
#define		RMON_RX_PACKET_SIZES1				0x41
#define		RMON_RX_PACKET_SIZES2				0x42
#define		RMON_RX_PACKET_SIZES3				0x43
#define		RMON_RX_PACKET_SIZES4				0x44
#define		RMON_RX_PACKET_SIZES5				0x45
#define		RMON_RX_PACKET_SIZES6				0x46
#define		RMON_RX_PACKET_SIZES7				0x47
#define		RMON_FRAME_CHECK_SEQUENCE_ERRORS	0x48
#define		RMON_ALIGNMENT_ERRORS				0x49
#define		RMON_FRAGMENTS						0x4A
#define		RMON_JABBERS						0x4B
#define		RMON_FRAMES_LOST_TO_INTMACRCVERR	0x4C
#define		RMON_UNICAST_FRAMES_RCVD_OK			0x4D
#define		RMON_MULTICAST_FRAMES_RCVD_OK		0x4E
#define		RMON_BROADCAST_FRAMES_RCVD_OK		0x4F
#define		RMON_IN_RANGE_LENGTH_ERRORS			0x50
#define		RMON_OUT_OF_RANGE_LENGTH_ERRORS		0x51
#define		RMON_VLAN_FRAMES_RCVD				0x52
#define		RMON_PAUSE_MAC_CTRL_FRAMES_RCVD		0x53
#define		RMON_MAC_CTRL_FRAMES_RCVD			0x54
#define		RMON_OCTETS_RCVD_OK					0x55
#define		RMON_OCTETS_RCVD_OK_HI				0x56
#define		RMON_OCTETS_RCVD_OTHER				0x57
#define		RMON_OCTETS_RCVD_OTHER_HI			0x58

#endif /* __ETHER00_H */
