/*
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
 *
 */

/*
 * udhcpc scripts
 *
 * Copyright 2003, Broadcom Corporation
 * All Rights Reserved.                
 *                                     
 *
 * $Id: udhcpc.c,v 1.17 2003/02/19 02:13:01 noname Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <net/route.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <rc.h>

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)

static int
expires(unsigned int in)
{
	time_t now;
	FILE *fp;

	time(&now);
	if (!(fp = fopen("/tmp/udhcpc.expires", "w"))) {
		perror("/tmp/udhcpd.expires");
		return errno;
	}
	fprintf(fp, "%d", (unsigned int) now + in);
	fclose(fp);
	return 0;
}	

/* 
 * deconfig: This argument is used when udhcpc starts, and when a
 * leases is lost. The script should put the interface in an up, but
 * deconfigured state.
*/
static int
deconfig(void)
{
	char *wan_ifname = safe_getenv("interface");

	ifconfig(wan_ifname, IFUP,
		 "0.0.0.0", NULL);
	expires(0);

	dprintf("done\n");
	return 0;
}

/*
 * bound: This argument is used when udhcpc moves from an unbound, to
 * a bound state. All of the paramaters are set in enviromental
 * variables, The script should configure the interface, and set any
 * other relavent parameters (default gateway, dns server, etc).
*/
static int
bound(void)
{
	char *wan_ifname = safe_getenv("interface");
	char *value;

	if ((value = getenv("ip")))
		nvram_set("wan_ipaddr", value);
	if ((value = getenv("subnet")))
		nvram_set("wan_netmask", value);
        if ((value = getenv("router")))
		nvram_set("wan_gateway", value);
	if ((value = getenv("dns")))
		nvram_set("wan_dns", value);
	if ((value = getenv("wins")))
		nvram_set("wan_wins", value);
	if ((value = getenv("hostname")))
		sethostname(value, strlen(value) + 1);
	if ((value = getenv("domain")))
		nvram_set("wan_domain", value);
	if ((value = getenv("lease"))) {
		nvram_set("wan_lease", value);
		expires(atoi(value));
	}

	ifconfig(wan_ifname, IFUP,
		 nvram_safe_get("wan_ipaddr"), nvram_safe_get("wan_netmask"));
	start_wan_done(wan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * renew: This argument is used when a DHCP lease is renewed. All of
 * the paramaters are set in enviromental variables. This argument is
 * used when the interface is already configured, so the IP address,
 * will not change, however, the other DHCP paramaters, such as the
 * default gateway, subnet mask, and dns server may change.
 */
static int
renew(void)
{
	stop_firewall();
	bound();

	dprintf("done\n");
	return 0;
}

int
udhcpc_main(int argc, char **argv)
{
	if (!argv[1])
		return EINVAL;
	else if (strstr(argv[1], "deconfig"))
		return deconfig();
	else if (strstr(argv[1], "bound"))
		return bound();
	else if (strstr(argv[1], "renew"))
		return renew();
	else
		return EINVAL;
}
