/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : arch/mips/am5120/prom.c
;	 Date    : 2003.3.4
;    Abstract: 
;
;Modification History:
;
;*****************************************************************************/

#include <linux/init.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/bootmem.h>

#include <asm/bootinfo.h>
#include <asm/addrspace.h>


#define prom_envp(index) ((char *)(((int *)(int)_prom_envp)[(index)]))

extern void am5120_serial_console_init(void);

int prom_argc;
int *_prom_argv, *_prom_envp;

/* am5120 platform arguments */
#define AM5120_ARGC		3
#define AM5120_ENVC		2

int am5120_argc = AM5120_ARGC;
char *am5120_argv[AM5120_ARGC] = {"load_ramdisk=/dev/ram0",
								  "root=/dev/ram0",
								  "console=ttyS0"};


char *am5120_envp[AM5120_ENVC] = {"memsize",
								  "0x001000000"};


char *prom_getenv(char *envname)
{
	/*
	 * Return a pointer to the given environment variable.
	 * In 64-bit mode: we're using 64-bit pointers, but all pointers 
	 * in the PROM structures are only 32-bit, so we need some 
	 * workarounds, if we are running in 64-bit mode.
	 */
	int i, index=0;

	if (_prom_envp == NULL)
		return (NULL);

	i = strlen(envname);

	while(prom_envp(index)) {
		if(strncmp(envname, prom_envp(index), i) == 0) {
			return(prom_envp(index+1));
		}
		index += 2;
	}

	return(NULL);
}

/*
 * initialize the prom module.
 */
int __init prom_init(int argc, char **argv, char **envp)
{
	prom_argc = am5120_argc;
	_prom_argv = (int *)am5120_argv;
	_prom_envp = (int *)am5120_envp;

	/* you should these macros defined in include/asm/bootinfo.h */
    mips_machgroup = MACH_GROUP_ADM_GW;
    mips_machtype = MACH_ADM_GW_5120;

	/* set IO port base to zero */ 
	mips_io_port_base = 0;

	/* init print from uart0 */
	setup_prom_printf(0);

	prom_printf("\nLINUX started...\nADM5120 Demo board\n");
	
	/* init command line */
	prom_init_cmdline();
	
	/* init memory map */
	prom_meminit();

	/* init serial console */
	am5120_serial_console_init();
}


