/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 * ########################################################################
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ########################################################################
 *
 * Setting up the clock on the MIPS boards.
 *
 */

#include <linux/types.h>
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/sched.h>
#include <linux/spinlock.h>

#include <asm/mipsregs.h>
#include <asm/ptrace.h>
#include <asm/hardirq.h>
#include <asm/div64.h>
#include <asm/cpu.h>

#include <linux/interrupt.h>
#include <linux/timex.h>


static unsigned int r4k_offset; /* Amount to increment compare reg each time */
static unsigned int r4k_cur;    /* What counter should be at next timer irq */

extern unsigned int mips_counter_frequency;

#define ALLINTS (IE_IRQ0 | IE_IRQ5 | STATUS_IE)


#define MIPS_CPU_TIMER_IRQ 7


void mips_timer_interrupt(struct pt_regs *regs)
{
	int cpu = smp_processor_id();
	int irq = MIPS_CPU_TIMER_IRQ;

	irq_enter(cpu, irq);
	kstat.irqs[cpu][irq]++;
	timer_interrupt(irq, NULL, regs);

	irq_exit(cpu, irq);

	if (softirq_pending(cpu))
		do_softirq();
}


void __init mips_time_init(void)
{
	mips_counter_frequency = 0xa00000;
}


void __init mips_timer_setup(struct irqaction *irq)
{
    /* to generate the first timer interrupt */
	write_32bit_cp0_register(CP0_COMPARE, mips_counter_frequency);	
	write_32bit_cp0_register(CP0_COUNT, 0);
	clear_cp0_status(ST0_BEV);
	set_cp0_status(ALLINTS);
}
