/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : daniell@admtek.com.tw
;    File    : arch/mips/am5120/irq.c
;	 Date    : 2003.3.4
;    Abstract: 
;
;Modification History:
;

;*****************************************************************************/

#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/malloc.h>
#include <linux/random.h>
#include <linux/pm.h>

#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/gdb-stub.h>

#include <asm/am5120/adm5120.h>


extern void breakpoint(void);
extern int setup_irq(unsigned int irq, struct irqaction *irqaction);
extern irq_desc_t irq_desc[];
extern asmlinkage void mipsIRQ(void);


static __inline void _irq_enable(int irql)
{
	ADM5120_INTC_REG(IRQ_ENABLE_REG) = (1 << irql);
}


static __inline void _irq_disable(int irql)
{
	ADM5120_INTC_REG(IRQ_DISABLE_REG) = (1<<irql);
}


unsigned int startup_am5120_irq(unsigned int irq)
{
	enable_am5120_irq(irq);

	return 0;
}

	
void shutdown_am5120_irq(unsigned int irq)
{
	disable_am5120_irq(irq);
}
	

void enable_am5120_irq(unsigned int irq)
{
	int s;

	// Disable all interrupts (FIQ/IRQ) 
	s = mips_int_lock();

	if ((irq < 0) || (irq > INT_LVL_MAX)) 
		goto err_exit;

	_irq_enable(irq);

err_exit:

	// Restore the interrupts states 
	mips_int_unlock(s);
}


void disable_am5120_irq(unsigned int irq)
{
	int s;

	// Disable all interrupts (FIQ/IRQ) 
	s = mips_int_lock();

	if ((irq < 0) || (irq > INT_LVL_MAX)) 
		goto err_exit;

	_irq_disable(irq);

err_exit:
	// Restore the interrupts states 
	mips_int_unlock(s);
}


static inline void ack_am5120_irq(unsigned int irq_nr)
{
	ADM5120_INTC_REG(IRQ_DISABLE_REG) = (1 << irq_nr);
}


static void end_am5120_irq(unsigned int irq_nr)
{
	ADM5120_INTC_REG(IRQ_ENABLE_REG) = (1 << irq_nr);
}


void set_affinity_am5120_irq(unsigned int irq, unsigned long mask)
{
	return;
}

	
static hw_irq_controller am5120_irq_type = {
	"ADM5120 INTC",
	startup_am5120_irq,
	shutdown_am5120_irq,
	enable_am5120_irq,
	disable_am5120_irq,
	ack_am5120_irq,
	end_am5120_irq,
	set_affinity_am5120_irq
};


void __init init_am5120_irqs (void)
{
	int i;

	for (i = 0; i <= INT_LVL_MAX; i++) 
	{
		irq_desc[i].status = IRQ_DISABLED;
		irq_desc[i].action = 0;
		irq_desc[i].depth = 1;
		irq_desc[i].handler = &am5120_irq_type;
	}
}


void __init init_IRQ(void)
{
	set_except_vector(0, mipsIRQ);
	
	init_generic_irq();
	
	init_am5120_irqs();

#ifdef CONFIG_REMOTE_DEBUG
 	printk("Setting debug traps - please connect the remote debugger.\n");

	set_debug_traps();

	breakpoint();
#endif
}

