/*****************************************************************************
;
;   (C) Unpublished Work of ADMtek Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF ADMTEK INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) ADMTEK EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN ADMTEK WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF ADMTEK.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ADM5120
;    Creator : 
;    File    : 
;    Abstract: 
;
;Modification History:
; 
;
;*****************************************************************************/
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/types.h>
#include <asm/byteorder.h>
#include <asm/pci_channel.h>
#include <asm/am5120/adm5120.h>

#ifdef CONFIG_PCI

volatile u32* pci_config_address_reg = (volatile u32*)KSEG1ADDR(0x115ffff0);
volatile u32* pci_config_data_reg = (volatile u32*)KSEG1ADDR(0x115ffff8);

#define PCI_ENABLE 0x80000000
#define PCI_CMM_IOACC_EN		0x1
#define PCI_CMM_MEMACC_EN		0x2
#define PCI_CMM_MASTER_EN		0x4
#define PCI_CMM_DEF				(PCI_CMM_IOACC_EN | PCI_CMM_MEMACC_EN | PCI_CMM_MASTER_EN)

#define PCI_DEF_CACHE_LINE_SZ	4
#define PCI_DEF_LATENCY_TIMER	0x20
#define PCI_DEF_CACHE_LATENCY	((PCI_DEF_LATENCY_TIMER << 8) | PCI_DEF_CACHE_LINE_SZ)


/*#define cfgaddr(dev, where) (((dev->bus->number & 0xff) << 0x10) |  \
                             ((dev->devfn & 0xff) << 0x08) |        \
                             (where & 0xfc))*/
                             
#define cfgaddr(dev, where) (((dev->bus->number & 0xff) << 0x10) |  \
                             ((dev->devfn & 0xff) << 0x08) |        \
                             (where & 0xfc)) | PCI_ENABLE
/*
 * We can't address 8 and 16 bit words directly.  Instead we have to
 * read/write a 32bit word and mask/modify the data we actually want.
 */
static int am5120_read_config_byte (struct pci_dev *dev,
                                   int where, unsigned char *val)
{
    *pci_config_address_reg = cfgaddr(dev, where);
    *val = ((*pci_config_data_reg) >> ((where&3)<<3)) & 0xff;
	printk("pci_read_byte 0x%x == 0x%x\n", where, *val);
	return PCIBIOS_SUCCESSFUL;
}

static int am5120_read_config_word (struct pci_dev *dev,
                                   int where, unsigned short *val)
{
	if (where & 1)
		return PCIBIOS_BAD_REGISTER_NUMBER;
	*pci_config_address_reg = cfgaddr(dev, where);
	*val = ((*pci_config_data_reg) >> ((where&3)<<3)) & 0xffff;
	printk("pci_read_word 0x%x == 0x%x\n", where, *val);
	return PCIBIOS_SUCCESSFUL;
}

int am5120_read_config_dword (struct pci_dev *dev,
                                    int where, unsigned int *val)
{
	if (where & 3)
		return PCIBIOS_BAD_REGISTER_NUMBER;
	*pci_config_address_reg = cfgaddr(dev, where);
	*val = (*pci_config_data_reg);
	printk("pci_read_dword 0x%x == 0x%x\n", where, *val);
	return PCIBIOS_SUCCESSFUL;
}

static int am5120_write_config_byte (struct pci_dev *dev,
                                    int where, unsigned char val)
{
	*pci_config_address_reg = cfgaddr(dev, where);
	*(volatile u8 *)(((int)pci_config_data_reg) + (where & 3)) = val;
	printk("pci_write_byte 0x%x = 0x%x\n", where, val);
	return PCIBIOS_SUCCESSFUL;
}

static int am5120_write_config_word (struct pci_dev *dev,
                                    int where, unsigned short val)
{
	if (where & 1)
		return PCIBIOS_BAD_REGISTER_NUMBER;
	*pci_config_address_reg = cfgaddr(dev, where);
	*(volatile u16 *)(((int)pci_config_data_reg) + (where & 2)) = le16_to_cpu(val);
	printk("pci_write_word 0x%x = 0x%x\n", where, val);
	return PCIBIOS_SUCCESSFUL;
}

int am5120_write_config_dword (struct pci_dev *dev,
                                     int where, unsigned int val)
{
	if (where & 3)
		return PCIBIOS_BAD_REGISTER_NUMBER;
	*pci_config_address_reg = cfgaddr(dev, where);
	*pci_config_data_reg = le32_to_cpu(val);
	printk("pci_write_dword 0x%x = 0x%x\n", where, val);
	return PCIBIOS_SUCCESSFUL;
}



struct pci_ops am5120_pci_ops = {
	am5120_read_config_byte,
	am5120_read_config_word,
	am5120_read_config_dword,
	am5120_write_config_byte,
	am5120_write_config_word,
	am5120_write_config_dword
};
/*struct resource pciioport_resource = {
	"pci IO space", 
	0x11500000,  
	0x115ffff0 -1,
	IORESOURCE_IO
};

struct resource pciiomem_resource = {
	"pci memory space", 
	0x11400000,
	0x11500000 -1,
	IORESOURCE_MEM
};
*/
static void am5120_pcibios_fixup(struct pci_dev *dev)
{
	printk("am5120 fix up\n");
	pci_write_config_word(dev, PCI_COMMAND, PCI_CMM_DEF);
	pci_write_config_byte(dev, PCI_CACHE_LINE_SIZE, PCI_DEF_CACHE_LATENCY);
	pci_write_config_dword(dev, PCI_BASE_ADDRESS_0, 0);
	pci_write_config_dword(dev, PCI_BASE_ADDRESS_1, 0);

}


struct pci_fixup pcibios_fixups[] = {
	{ PCI_FIXUP_HEADER, 0x1317, 0x5120, am5120_pcibios_fixup }
};


/*struct pci_channel mips_pci_channels[] = {
	{ &am5120_pci_ops, &pciioport_resource, &pciiomem_resource },
	{ NULL, NULL, NULL }
};
*/


unsigned __init int pcibios_assign_all_busses(void)
{
        return 1;
}

void __init pcibios_fixup(void)
{
}

void __init pcibios_align_resource(void* A, struct resource *B, unsigned long C)
{
}

void __init pcibios_fixup_bus(struct pci_bus *C)
{
}
void __init pcibios_init(void)
{
	 struct pci_dev *dev;	
	printk("PCI: Probing PCI hardware\n");

/*	ioport_resource.start = 0x11500000;
	ioport_resource.end = 0x115ffff0-1;

	iomem_resource.start = 0x11400000;
	iomem_resource.end = 0x11500000-1;
*/	
/*	ioport_resource.start = 0x00000000;
	ioport_resource.end = 0x0fffffff;
    iomem_resource.start = 0x01000000;
    iomem_resource.end = 0xffffffff;
*/
	pci_scan_bus(0, &am5120_pci_ops, NULL);
	pcibios_fixup_irqs();
/*	dev = pci_dev_g(0);
	pci_write_config_word(dev, PCI_COMMAND, PCI_CMM_DEF);
	pci_write_config_byte(dev, PCI_CACHE_LINE_SIZE, PCI_DEF_CACHE_LATENCY);
	pci_write_config_dword(dev, PCI_BASE_ADDRESS_0, 0);
	pci_write_config_dword(dev, PCI_BASE_ADDRESS_1, 0);
*/
}
char *pcibios_setup(char *str)
{
	        return str;
}
int pcibios_enable_device(struct pci_dev *dev)
{
        u16 cmd, status;
        pci_read_config_word(dev, PCI_COMMAND, &cmd);
        pci_read_config_word(dev, PCI_STATUS, &status);
        printk("PCI: Enabling device %s (%04x  %04x)\n", dev->slot_name, cmd, status);
       /* We'll sort this out when we know it isn't enabled ;) */

        return 0;
}
void pcibios_update_resource(struct pci_dev *dev, struct resource *root,
		                struct resource *res, int resource)
{
	panic("pcibios_update_resource\n");
}

void __init pcibios_fixup_irqs(void)
{
   struct pci_dev *dev;
   int slot_num;

   printk("fixup IRQ\n");	
   pci_for_each_dev(dev) {
      slot_num = PCI_SLOT(dev->devfn);
      switch(slot_num) {
         case 2: dev->irq = 6;  break;
         case 3: dev->irq = 7;  break;
         case 4: dev->irq = 8;  break;
         default: break;
      }
   }
}


#endif /* CONFIG_PCI */
